/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.aop;

import com.intellij.aop.IntroductionManipulator;
import com.intellij.aop.LocalAopModel;
import com.intellij.aop.psi.AopPointcutExpressionLanguage;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.DomElementPattern;
import com.intellij.patterns.DomPatterns;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.XmlAttributeValuePattern;
import com.intellij.patterns.XmlPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.spring.aop.SpringAdviceLocalAopModel;
import com.intellij.spring.aop.SpringLocalAopModel;
import com.intellij.spring.aop.model.xml.Advisor;
import com.intellij.spring.aop.model.xml.BasicAdvice;
import com.intellij.spring.aop.model.xml.DeclareParents;
import com.intellij.spring.aop.model.xml.PointcutType;
import com.intellij.spring.aop.model.xml.SpringAspect;
import com.intellij.spring.aop.model.xml.SpringPointcut;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import com.intellij.xml.util.XmlTagUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringAopInjector
implements MultiHostInjector {
    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement host) {
        PsiFile containingFile;
        if (registrar == null) {
            SpringAopInjector.$$$reportNull$$$0(0);
        }
        if (host == null) {
            SpringAopInjector.$$$reportNull$$$0(1);
        }
        if (!JamCommonUtil.isPlainXmlFile((PsiElement)(containingFile = host.getContainingFile()))) {
            return;
        }
        XmlFile xmlFile = (XmlFile)containingFile;
        if (!SpringDomUtils.isSpringXml((XmlFile)xmlFile)) {
            return;
        }
        ProcessingContext context = new ProcessingContext();
        if (SpringAopPatterns.SPRING_AOP_INJECTION_PATTERN.accepts((Object)host, context)) {
            host.putUserData(LocalAopModel.KEY, (Object)new SpringAdviceLocalAopModel(host, (BasicAdvice)context.get(SpringAopPatterns.SPRING_ADVICE_KEY)));
            registrar.startInjecting((Language)AopPointcutExpressionLanguage.getInstance());
            registrar.addPlace(null, null, (PsiLanguageInjectionHost)host, TextRange.from((int)1, (int)(host.getTextLength() - 2)));
            registrar.doneInjecting();
        } else if (SpringAopPatterns.INTRO_PATTERN.accepts((Object)host, context)) {
            host.putUserData(LocalAopModel.KEY, (Object)new SpringIntroductionAopModel(host, context));
            registrar.startInjecting((Language)AopPointcutExpressionLanguage.getInstance());
            registrar.addPlace("target(", ")", (PsiLanguageInjectionHost)host, TextRange.from((int)1, (int)(host.getTextLength() - 2)));
            registrar.doneInjecting();
        }
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class<XmlAttributeValue>> list = Collections.singletonList(XmlAttributeValue.class);
        if (list == null) {
            SpringAopInjector.$$$reportNull$$$0(2);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/aop/SpringAopInjector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/aop/SpringAopInjector";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "elementsToInjectIn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagesToInject";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private static class SpringAopPatterns {
        private static final Key<BasicAdvice> SPRING_ADVICE_KEY = Key.create((String)"SpringAdviceKey");
        private static final Key<SpringAspect> SPRING_ASPECT_KEY = Key.create((String)"SpringAspectKey");
        private static final Key<DeclareParents> SPRING_INTRO_KEY = Key.create((String)"SPRING_INTRO_KEY");
        private static final XmlAttributeValuePattern SPRING_AOP_INJECTION_PATTERN = (XmlAttributeValuePattern)((XmlAttributeValuePattern)XmlPatterns.xmlAttributeValue().withTextLengthLongerThan(1)).withParent(StandardPatterns.or((ElementPattern[])new ElementPattern[]{DomPatterns.attributeWithDom((String)"expression", (ElementPattern)DomPatterns.domElement().withParent((ElementPattern)((DomElementPattern.Capture)DomPatterns.domElement(SpringPointcut.class).and((ElementPattern)StandardPatterns.not((ElementPattern)DomPatterns.domElement().withChild("type", (ElementPattern)DomPatterns.genericDomValue(PointcutType.class).withValue((Object)PointcutType.REGEX))))).and((ElementPattern)StandardPatterns.optional((ElementPattern)DomPatterns.domElement().inside((ElementPattern)DomPatterns.domElement(DomSpringBean.class)))))), DomPatterns.attributeWithDom((String)"pointcut", (ElementPattern)DomPatterns.domElement().withParent(StandardPatterns.or((ElementPattern[])new ElementPattern[]{DomPatterns.domElement(Advisor.class), ((DomElementPattern.Capture)DomPatterns.domElement(BasicAdvice.class).save(SPRING_ADVICE_KEY)).withParent((ElementPattern)DomPatterns.domElement(SpringAspect.class).save(SPRING_ASPECT_KEY))})))}));
        private static final XmlAttributeValuePattern INTRO_PATTERN = (XmlAttributeValuePattern)((XmlAttributeValuePattern)XmlPatterns.xmlAttributeValue().withTextLengthLongerThan(1)).withParent((ElementPattern)DomPatterns.attributeWithDom((String)"types-matching", (ElementPattern)DomPatterns.domElement().withParent((ElementPattern)((DomElementPattern.Capture)DomPatterns.domElement(DeclareParents.class).save(SPRING_INTRO_KEY)).withParent((ElementPattern)DomPatterns.domElement(SpringAspect.class).save(SPRING_ASPECT_KEY)))));

        private SpringAopPatterns() {
        }
    }

    private static class SpringIntroductionAopModel
    extends SpringLocalAopModel {
        private final ProcessingContext myContext;

        SpringIntroductionAopModel(PsiElement host, ProcessingContext context) {
            super(host, (BasicAdvice)context.get(SpringAopPatterns.SPRING_ADVICE_KEY));
            this.myContext = context;
        }

        @Nullable
        public IntroductionManipulator getIntroductionManipulator() {
            return new IntroductionManipulator(){

                @NotNull
                public PsiElement getCommonProblemElement() {
                    XmlToken xmlToken = XmlTagUtil.getStartTagNameElement((XmlTag)this.getIntroduction().getXmlTag());
                    if (xmlToken == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return xmlToken;
                }

                @NotNull
                public DeclareParents getIntroduction() {
                    DeclareParents declareParents = (DeclareParents)myContext.get(SpringAopPatterns.SPRING_INTRO_KEY);
                    if (declareParents == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return declareParents;
                }

                public void defineDefaultImpl(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
                }

                @NonNls
                public String getDefaultImplAttributeName() {
                    return this.getIntroduction().getDefaultImpl().getXmlElementName();
                }

                @NotNull
                public PsiElement getInterfaceElement() {
                    XmlAttributeValue xmlAttributeValue = this.getIntroduction().getImplementInterface().getXmlAttributeValue();
                    if (xmlAttributeValue == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return xmlAttributeValue;
                }

                @Nullable
                public PsiElement getDefaultImplElement() {
                    return this.getIntroduction().getDefaultImpl().getXmlAttributeValue();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "com/intellij/spring/aop/SpringAopInjector$SpringIntroductionAopModel$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getCommonProblemElement";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getIntroduction";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getInterfaceElement";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            };
        }
    }
}

