/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleTypeWithWebFeatures;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u00a8\u0006\u0006"}, d2={"findByRelativePath", "Lcom/intellij/openapi/vfs/VirtualFile;", "path", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.javascript.debugger.backend"})
@SourceDebugExtension(value={"SMAP\nLocalFileSystemFileFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalFileSystemFileFinder.kt\ncom/intellij/javascript/debugger/LocalFileSystemFileFinderKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,67:1\n1#2:68\n*E\n"})
public final class LocalFileSystemFileFinderKt {
    @Nullable
    public static final VirtualFile findByRelativePath(@NotNull String path, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        SmartList contentRoots = new SmartList();
        SmartList webContentRoots = new SmartList();
        for (Module module : ModuleManager.Companion.getInstance(project).getModules()) {
            Collection collection = (Collection)(ModuleTypeWithWebFeatures.isAvailable((Module)module) ? webContentRoots : contentRoots);
            VirtualFile[] virtualFileArray = ModuleRootManager.getInstance((Module)module).getContentRoots();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getContentRoots(...)");
            CollectionsKt.addAll((Collection)collection, (Object[])virtualFileArray);
        }
        int i = StringsKt.indexOf$default((CharSequence)path, (char)'/', (int)0, (boolean)false, (int)6, null);
        while (i != -1) {
            VirtualFile file;
            VirtualFile virtualFile;
            Object v2;
            VirtualFile it;
            Sequence sequence;
            String subPath;
            block6: {
                Intrinsics.checkNotNullExpressionValue((Object)path.substring(i + 1, path.length()), (String)"substring(...)");
                sequence = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)webContentRoots)), arg_0 -> LocalFileSystemFileFinderKt.findByRelativePath$lambda$0(subPath, arg_0));
                for (Object e : sequence) {
                    it = (VirtualFile)e;
                    boolean bl = false;
                    if (!(it != null)) continue;
                    v2 = e;
                    break block6;
                }
                v2 = null;
            }
            if ((virtualFile = (VirtualFile)v2) == null) {
                Object v4;
                block7: {
                    sequence = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)contentRoots)), arg_0 -> LocalFileSystemFileFinderKt.findByRelativePath$lambda$2(subPath, arg_0));
                    for (Object e : sequence) {
                        it = (VirtualFile)e;
                        boolean bl = false;
                        if (!(it != null)) continue;
                        v4 = e;
                        break block7;
                    }
                    v4 = null;
                }
                virtualFile = v4;
            }
            if ((file = virtualFile) != null) {
                return file;
            }
            i = StringsKt.indexOf$default((CharSequence)path, (char)'/', (int)(i + 2), (boolean)false, (int)4, null);
        }
        return null;
    }

    private static final VirtualFile findByRelativePath$lambda$0(String $subPath, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.findFileByRelativePath($subPath);
    }

    private static final VirtualFile findByRelativePath$lambda$2(String $subPath, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.findFileByRelativePath($subPath);
    }
}

