/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.triangulate.quadedge;

import java.util.Collection;
import java.util.LinkedList;
import org.locationtech.jts.triangulate.quadedge.QuadEdgeTriangle;
import org.locationtech.jts.triangulate.quadedge.TraversalVisitor;

public class EdgeConnectedTriangleTraversal {
    private LinkedList triQueue = new LinkedList();

    public void init(QuadEdgeTriangle tri) {
        this.triQueue.addLast(tri);
    }

    public void init(Collection tris) {
        this.triQueue.addAll(tris);
    }

    public void visitAll(TraversalVisitor visitor) {
        while (!this.triQueue.isEmpty()) {
            QuadEdgeTriangle tri = (QuadEdgeTriangle)this.triQueue.removeFirst();
            this.process(tri, visitor);
        }
    }

    private void process(QuadEdgeTriangle currTri, TraversalVisitor visitor) {
        currTri.getNeighbours();
        for (int i2 = 0; i2 < 3; ++i2) {
            QuadEdgeTriangle neighTri = (QuadEdgeTriangle)currTri.getEdge(i2).sym().getData();
            if (neighTri == null || !visitor.visit(currTri, i2, neighTri)) continue;
            this.triQueue.addLast(neighTri);
        }
    }
}

