/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.noding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.noding.BasicSegmentString;
import org.locationtech.jts.noding.Noder;
import org.locationtech.jts.noding.SegmentString;

public class SegmentExtractingNoder
implements Noder {
    private List segList;

    @Override
    public void computeNodes(Collection segStrings) {
        this.segList = SegmentExtractingNoder.extractSegments(segStrings);
    }

    private static List<SegmentString> extractSegments(Collection<SegmentString> segStrings) {
        ArrayList<SegmentString> segList = new ArrayList<SegmentString>();
        for (SegmentString ss : segStrings) {
            SegmentExtractingNoder.extractSegments(ss, segList);
        }
        return segList;
    }

    private static void extractSegments(SegmentString ss, List<SegmentString> segList) {
        for (int i2 = 0; i2 < ss.size() - 1; ++i2) {
            Coordinate p0 = ss.getCoordinate(i2);
            Coordinate p1 = ss.getCoordinate(i2 + 1);
            BasicSegmentString seg = new BasicSegmentString(new Coordinate[]{p0, p1}, ss.getData());
            segList.add(seg);
        }
    }

    @Override
    public Collection getNodedSubstrings() {
        return this.segList;
    }
}

