/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystemCore;
import com.intellij.database.dataSource.srcStorage.PersistentMarkup;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFilePathWrapper;
import com.intellij.openapi.vfs.limits.FileSizeLimit;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbSrcUtilsCore {
    private static final Logger LOG = Logger.getInstance(DbSrcUtilsCore.class);
    protected static final String EMPTY = "&empty;";
    protected static final List<List<String>> ESCAPES = Arrays.asList(Arrays.asList("/", "\\", "&", "@"), Arrays.asList("&eslash;", "&slash;", "&amp;", "&at;"));

    protected DbSrcUtilsCore() {
    }

    public static boolean isDbSrcFile(@Nullable VirtualFile file) {
        return file != null && file.getFileSystem() instanceof DbSrcFileSystemCore;
    }

    @Nullable
    public static String getDataSource(@NotNull VirtualFile file) {
        if (file == null) {
            DbSrcUtilsCore.$$$reportNull$$$0(0);
        }
        return DbSrcFileSystemCore.processPath(file, new DbSrcFileSystemCore.ItemProcessor<String>(){

            @Override
            public String processDataSource(@Nullable Project project, @NotNull String dataSourceId) {
                if (dataSourceId == null) {
                    1.$$$reportNull$$$0(0);
                }
                return dataSourceId;
            }

            @Override
            public String processFolder(@Nullable Project project, @NotNull String dataSourceId, @Nullable ObjectPath path, @Nullable ObjectKind group) {
                if (dataSourceId == null) {
                    1.$$$reportNull$$$0(1);
                }
                return dataSourceId;
            }

            @Override
            public String processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull ObjectPath path, @NotNull DbSrcFileSystemCore.ItemType type) {
                if (dataSourceId == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (path == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (type == null) {
                    1.$$$reportNull$$$0(4);
                }
                return dataSourceId;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataSourceId";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "path";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcUtilsCore$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processDataSource";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processFolder";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processFile";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Nullable
    public static ObjectPath getFullPath(@NotNull String path) {
        if (path == null) {
            DbSrcUtilsCore.$$$reportNull$$$0(1);
        }
        return DbSrcFileSystemCore.processPath(path, new DbSrcFileSystemCore.ItemProcessor<ObjectPath>(){

            @Override
            public ObjectPath processFolder(@Nullable Project project, @NotNull String dataSourceId, @Nullable ObjectPath path, ObjectKind group) {
                if (dataSourceId == null) {
                    2.$$$reportNull$$$0(0);
                }
                return group == null ? path : null;
            }

            @Override
            public ObjectPath processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull ObjectPath path, @NotNull DbSrcFileSystemCore.ItemType type) {
                if (dataSourceId == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (path == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (type == null) {
                    2.$$$reportNull$$$0(3);
                }
                return path;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataSourceId";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "path";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcUtilsCore$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processFolder";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processFile";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public static Iterable<String> splitPath(@NotNull String path) {
        if (path == null) {
            DbSrcUtilsCore.$$$reportNull$$$0(2);
        }
        return StringUtil.tokenize((String)path, (String)"/");
    }

    public static String unescapeChars(String s) {
        if (s == null) {
            return null;
        }
        if (s.equals(EMPTY)) {
            return "";
        }
        return StringUtil.replace((String)s, ESCAPES.get(1), ESCAPES.get(0));
    }

    @Nullable
    public static ObjectKind findKind(@Nullable String code) {
        return code == null ? null : ObjectKind.getKind((String)code);
    }

    @Nullable
    public static LocalDataSource findDataSource(@Nullable Project project, @NotNull String id) {
        if (id == null) {
            DbSrcUtilsCore.$$$reportNull$$$0(3);
        }
        List<? extends LocalDataSource> sources = DbSrcUtilsCore.getDataSources(project);
        for (LocalDataSource localDataSource : sources) {
            if (localDataSource.isGlobal() != (project == null) || !id.equals(localDataSource.getUniqueId())) continue;
            return localDataSource;
        }
        return null;
    }

    @Nullable
    public static LocalDataSource findDataSource(@Nullable VirtualFile file) {
        if (file == null) {
            return null;
        }
        return DbSrcFileSystemCore.processPath(file, new DbSrcFileSystemCore.ItemProcessor<LocalDataSource>(){

            @Override
            public LocalDataSource processDataSource(@Nullable Project project, @NotNull String dataSourceId) {
                if (dataSourceId == null) {
                    3.$$$reportNull$$$0(0);
                }
                return DbSrcUtilsCore.findDataSource(project, dataSourceId);
            }

            @Override
            public LocalDataSource processFolder(@Nullable Project project, @NotNull String dataSourceId, @Nullable ObjectPath path, @Nullable ObjectKind group) {
                if (dataSourceId == null) {
                    3.$$$reportNull$$$0(1);
                }
                return DbSrcUtilsCore.findDataSource(project, dataSourceId);
            }

            @Override
            public LocalDataSource processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull ObjectPath path, @NotNull DbSrcFileSystemCore.ItemType type) {
                if (dataSourceId == null) {
                    3.$$$reportNull$$$0(2);
                }
                if (path == null) {
                    3.$$$reportNull$$$0(3);
                }
                if (type == null) {
                    3.$$$reportNull$$$0(4);
                }
                return DbSrcUtilsCore.findDataSource(project, dataSourceId);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataSourceId";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "path";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcUtilsCore$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processDataSource";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processFolder";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processFile";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    public static List<? extends LocalDataSource> getDataSources(@Nullable Project project) {
        List<LocalDataSource> list = project == null ? DataSourceStorage.getStorage().getDataSources() : DataSourceStorage.getProjectStorage(project).getDataSources();
        if (list == null) {
            DbSrcUtilsCore.$$$reportNull$$$0(4);
        }
        return list;
    }

    public static int hashCode(CharSequence cs) {
        int res = 0;
        if (cs != null) {
            for (int i2 = 0; i2 < cs.length(); ++i2) {
                res = StringHashBuilder.hashStep(res, cs.charAt(i2));
            }
        }
        return res;
    }

    public static String escapeChars(String s) {
        if (s == null) {
            return null;
        }
        if (s.isEmpty()) {
            return EMPTY;
        }
        return StringUtil.replace((String)s, ESCAPES.get(0), ESCAPES.get(1));
    }

    @Nullable
    public static <T extends DbElement> T findDbElement(final @NotNull Project project, @NotNull String file, final @NotNull Class<T> clazz) {
        if (project == null) {
            DbSrcUtilsCore.$$$reportNull$$$0(5);
        }
        if (file == null) {
            DbSrcUtilsCore.$$$reportNull$$$0(6);
        }
        if (clazz == null) {
            DbSrcUtilsCore.$$$reportNull$$$0(7);
        }
        return (T)((DbElement)DbSrcFileSystemCore.processPath(file, new DbSrcFileSystemCore.ItemProcessor<T>(){

            @Override
            public T processFile(@Nullable Project p, @NotNull String dataSourceId, @NotNull ObjectPath path, @NotNull DbSrcFileSystemCore.ItemType type) {
                if (dataSourceId == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (path == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (type == null) {
                    4.$$$reportNull$$$0(2);
                }
                return this.findElement(p, dataSourceId, path);
            }

            @Override
            public T processFolder(@Nullable Project p, @NotNull String dataSourceId, @Nullable ObjectPath path, @Nullable ObjectKind group) {
                if (dataSourceId == null) {
                    4.$$$reportNull$$$0(3);
                }
                if (group != null) {
                    return null;
                }
                return this.findElement(p, dataSourceId, path);
            }

            @Nullable
            private T findElement(@Nullable Project p, @NotNull String dataSourceId, @Nullable ObjectPath path) {
                if (dataSourceId == null) {
                    4.$$$reportNull$$$0(4);
                }
                if (p != null && p != project) {
                    return null;
                }
                DbDataSource dataSource = DbPsiFacade.getInstance((Project)project).findDataSource(dataSourceId);
                if (dataSource == null) {
                    return null;
                }
                DbDataSource result = path == null ? dataSource : DbSqlUtilCore.findElement(dataSource, path);
                return (DbElement)ObjectUtils.tryCast((Object)result, (Class)clazz);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataSourceId";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "path";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcUtilsCore$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processFile";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processFolder";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "findElement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }));
    }

    @NotNull
    public static CompositeText formatCompositeTextSafe(@NotNull Project project, @NotNull SqlLanguageDialect dialect, @Nullable String target, @NotNull CompositeText text2, @Nullable CodeStyleSettings settings) {
        if (project == null) {
            DbSrcUtilsCore.$$$reportNull$$$0(8);
        }
        if (dialect == null) {
            DbSrcUtilsCore.$$$reportNull$$$0(9);
        }
        if (text2 == null) {
            DbSrcUtilsCore.$$$reportNull$$$0(10);
        }
        try {
            return DbSrcUtilsCore.formatCompositeText(project, dialect, target, text2, settings);
        }
        catch (ProcessCanceledException pce) {
            throw pce;
        }
        catch (Throwable th) {
            LOG.warn(th);
            CompositeText compositeText = text2;
            if (compositeText == null) {
                DbSrcUtilsCore.$$$reportNull$$$0(11);
            }
            return compositeText;
        }
    }

    @NotNull
    public static PersistentMarkup formatCompositeText(@NotNull Project project, @NotNull SqlLanguageDialect dialect, @Nullable String target, @NotNull CompositeText text2, @Nullable CodeStyleSettings settings) {
        if (project == null) {
            DbSrcUtilsCore.$$$reportNull$$$0(12);
        }
        if (dialect == null) {
            DbSrcUtilsCore.$$$reportNull$$$0(13);
        }
        if (text2 == null) {
            DbSrcUtilsCore.$$$reportNull$$$0(14);
        }
        if (text2.getLength() > FileSizeLimit.getIntellisenseLimit()) {
            PersistentMarkup persistentMarkup = PersistentMarkup.asPersistent(text2);
            if (persistentMarkup == null) {
                DbSrcUtilsCore.$$$reportNull$$$0(15);
            }
            return persistentMarkup;
        }
        DocumentImpl document = new DocumentImpl((CharSequence)"", true);
        ArrayList<Trinity> ranges = new ArrayList<Trinity>();
        CompositeText.Kind prev = CompositeText.Kind.FIXED_TEXT;
        for (CompositeText.Fragment fragment : text2.getFragments()) {
            boolean doNotFormat;
            int start2 = document.getTextLength();
            document.insertString(start2, (CharSequence)StringUtil.convertLineSeparators((String)fragment.getText().toString()));
            int end = document.getTextLength();
            CompositeText.Kind kind = fragment.getKind();
            if (kind == CompositeText.Kind.COMPACT_DEFINITION) {
                kind = prev.getContent() ? prev : CompositeText.Kind.ORIGINAL_TEXT;
            }
            boolean bl = doNotFormat = kind == CompositeText.Kind.FIXED_TEXT || kind == CompositeText.Kind.ORIGINAL_TEXT || kind == CompositeText.Kind.SPECIFICATION_TEXT;
            RangeMarker marker = start2 == end ? null : (doNotFormat ? document.createGuardedBlock(start2, end) : document.createRangeMarker(start2, end));
            ranges.add(Trinity.create((Object)marker, (Object)fragment, (Object)doNotFormat));
        }
        SqlPsiFacade.getInstance((Project)project).format(project, dialect, (Document)document, settings);
        for (int i2 = 0; i2 < ranges.size(); ++i2) {
            Trinity range = (Trinity)ranges.get(i2);
            if (range.first != null) continue;
            int offset = -1;
            if (((Boolean)range.third).booleanValue()) {
                for (int k = i2 + 1; k < ranges.size() && ((Boolean)((Trinity)ranges.get((int)k)).third).booleanValue(); ++k) {
                    Segment seg = (Segment)((Trinity)ranges.get((int)k)).first;
                    if (seg == null) continue;
                    offset = seg.getStartOffset();
                }
            }
            if (offset == -1) {
                offset = i2 == 0 ? 0 : ((Segment)((Trinity)ranges.get((int)(i2 - 1))).first).getEndOffset();
            }
            ranges.set(i2, Trinity.create((Object)TextRange.create((int)offset, (int)offset), (Object)((CompositeText.Fragment)range.second), (Object)((Boolean)range.third)));
        }
        PersistentMarkup.Builder builder = new PersistentMarkup.Builder();
        for (Trinity range : ranges) {
            Segment marker = (Segment)range.first;
            CompositeText.Fragment fragment = (CompositeText.Fragment)range.second;
            if (marker instanceof RangeMarker && !((RangeMarker)marker).isValid()) {
                LOG.warn("Range marker died during formatting" + (String)(target == null ? "" : " of " + target));
                continue;
            }
            builder.add(fragment.getKind(), marker.getStartOffset(), marker.getEndOffset(), fragment.getError());
        }
        PersistentMarkup persistentMarkup = builder.build(document.getText());
        if (persistentMarkup == null) {
            DbSrcUtilsCore.$$$reportNull$$$0(16);
        }
        return persistentMarkup;
    }

    @NlsContexts.TabTitle
    @Nullable
    public static String getEditorTabTitle(@NotNull Project project, @NotNull VirtualFile file, boolean appendDataSource, boolean shorten) {
        ObjectPath path;
        if (project == null) {
            DbSrcUtilsCore.$$$reportNull$$$0(17);
        }
        if (file == null) {
            DbSrcUtilsCore.$$$reportNull$$$0(18);
        }
        if ((path = DbSrcUtilsCore.getFullPath(file.getPath())) == null) {
            return null;
        }
        String dataSourceId = DbSrcUtilsCore.getDataSource(file);
        DbDataSource dataSource = DbPsiFacade.getInstance((Project)project).findDataSource(dataSourceId);
        return DatabaseElementVirtualFileImpl.getEditorTabTitleImpl(project, file, path, dataSource, appendDataSource, shorten);
    }

    @NotNull
    public static String getPresentablePath(@NotNull VirtualFile file) {
        if (file == null) {
            DbSrcUtilsCore.$$$reportNull$$$0(19);
        }
        String string = file instanceof VirtualFilePathWrapper ? ((VirtualFilePathWrapper)file).getPresentablePath() : file.getPath();
        if (string == null) {
            DbSrcUtilsCore.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    public static String getRelativePresentablePath(@NotNull VirtualFile file, @Nullable VirtualFile root) {
        if (file == null) {
            DbSrcUtilsCore.$$$reportNull$$$0(21);
        }
        if (root == null) {
            return DbSrcUtilsCore.getPresentablePath(file);
        }
        if (file instanceof VirtualFilePathWrapper) {
            String path = DbSrcUtilsCore.getPresentablePath(file);
            String rootPath = DbSrcUtilsCore.getPresentablePath(root);
            String string = StringUtil.trimStart((String)path, (String)rootPath);
            if (string == null) {
                DbSrcUtilsCore.$$$reportNull$$$0(22);
            }
            return string;
        }
        String rel = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)root);
        String string = rel == null ? DbSrcUtilsCore.getPresentablePath(file) : rel;
        if (string == null) {
            DbSrcUtilsCore.$$$reportNull$$$0(23);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 11, 15, 16, 20, 22, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 4: 
            case 11: 
            case 15: 
            case 16: 
            case 20: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/srcStorage/DbSrcUtilsCore";
                break;
            }
            case 5: 
            case 8: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcUtilsCore";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSources";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "formatCompositeTextSafe";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "formatCompositeText";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentablePath";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativePresentablePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDataSource";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getFullPath";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "splitPath";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findDataSource";
                break;
            }
            case 4: 
            case 11: 
            case 15: 
            case 16: 
            case 20: 
            case 22: 
            case 23: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findDbElement";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "formatCompositeTextSafe";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "formatCompositeText";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getEditorTabTitle";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getPresentablePath";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePresentablePath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 11, 15, 16, 20, 22, 23 -> new IllegalStateException(string);
        };
    }

    public static class StringHashBuilder {
        private int h = 0;

        public void consume(int c2) {
            this.h = StringHashBuilder.hashStep(this.h, c2);
        }

        public void consume(byte[] a, int s, int f) {
            while (s < f) {
                this.consume(a[s]);
                ++s;
            }
        }

        public void consume(byte[] a) {
            this.consume(a, 0, a.length);
        }

        public static int hashStep(int h, int c2) {
            return 31 * h + c2;
        }

        public static int hashStep(int h, byte[] a, int s, int f) {
            if (a == null) {
                return h;
            }
            while (s < f) {
                h = StringHashBuilder.hashStep(h, a[s]);
                ++s;
            }
            return h;
        }

        public static int hashStep(int h, byte[] a) {
            return a == null ? h : StringHashBuilder.hashStep(h, a, 0, a.length);
        }

        public int get() {
            return this.h;
        }
    }
}

