/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.httpClient.execution.common.CommonClientResponse;
import com.intellij.httpClient.execution.common.CommonClientResponseBody;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpClientRequestProcessHandler
extends ProcessHandler {
    public static final int SUCCEED = 0;
    public static final int INTERRUPTED = 1;
    public static final int INTERRUPTED_POST_PROCESSING = 2;
    private static final long MINIMAL_PROCESS_DURATION_MILLIS = 300L;
    private Disposable myConnectionDisposable = null;
    private final HttpClientTestsProcessHandler myPostProcessorHandler;
    private CommonClientResponse myResponse;
    private final AtomicLong myProcessStartedMillis = new AtomicLong(-1L);
    private Job myUrlAccessingJob;
    private CoroutineScope myCoroutineScope;
    private final CompletableDeferred<Unit> myStartDeferred = CompletableDeferredKt.CompletableDeferred(null);
    private final AtomicBoolean myResponseHandlerExecuting = new AtomicBoolean(false);

    public HttpClientRequestProcessHandler(boolean withPostProcessor) {
        this.myPostProcessorHandler = withPostProcessor ? new HttpClientTestsProcessHandler() : null;
    }

    public void setCoroutineScope(@NotNull CoroutineScope scope) {
        if (scope == null) {
            HttpClientRequestProcessHandler.$$$reportNull$$$0(0);
        }
        this.myCoroutineScope = scope;
        this.myUrlAccessingJob = (Job)scope.getCoroutineContext().get((CoroutineContext.Key)Job.Key);
    }

    @Nullable
    public Job getUrlAccessingJob() {
        return this.myUrlAccessingJob;
    }

    @Nullable
    public CoroutineScope getCoroutineScope() {
        return this.myCoroutineScope;
    }

    public void setConnectionDisposable(Disposable connectionDisposable) {
        this.myConnectionDisposable = connectionDisposable;
    }

    @NotNull
    public Deferred<Unit> getStartDeferred() {
        CompletableDeferred<Unit> completableDeferred = this.myStartDeferred;
        if (completableDeferred == null) {
            HttpClientRequestProcessHandler.$$$reportNull$$$0(1);
        }
        return completableDeferred;
    }

    @Nullable
    public ProcessHandler getPostProcessorHandler() {
        return this.myPostProcessorHandler;
    }

    public void startNotify() {
        super.startNotify();
        this.myStartDeferred.complete((Object)Unit.INSTANCE);
        this.myProcessStartedMillis.compareAndSet(-1L, System.currentTimeMillis());
        if (this.myPostProcessorHandler != null) {
            this.myPostProcessorHandler.startNotify();
        }
    }

    public void onRunFinished() {
        if (this.isProcessTerminating() || this.isProcessTerminated()) {
            return;
        }
        this.handleTooFastProcessAndFinish(() -> {
            this.notifyProcessTerminated(0);
            if (this.myPostProcessorHandler != null && !this.myPostProcessorHandler.isProcessTerminating() && !this.myPostProcessorHandler.isProcessTerminated()) {
                this.myPostProcessorHandler.notifyProcessTerminated(0);
            }
        });
    }

    private void handleTooFastProcessAndFinish(@NotNull Runnable finishRunnable) {
        long processWorkedMillis;
        if (finishRunnable == null) {
            HttpClientRequestProcessHandler.$$$reportNull$$$0(2);
        }
        if ((processWorkedMillis = System.currentTimeMillis() - this.myProcessStartedMillis.get()) < 300L) {
            AppExecutorUtil.getAppScheduledExecutorService().schedule(finishRunnable, 300L, TimeUnit.MILLISECONDS);
        } else {
            finishRunnable.run();
        }
    }

    public boolean isProcessTerminated() {
        return super.isProcessTerminated() && (this.myPostProcessorHandler == null || this.myPostProcessorHandler.isProcessTerminated());
    }

    public boolean isProcessTerminating() {
        return super.isProcessTerminating() && (this.myPostProcessorHandler == null || this.myPostProcessorHandler.isProcessTerminating());
    }

    protected void destroyProcessImpl() {
        boolean onPostProcessing = this.myResponseHandlerExecuting.get();
        if (this.myResponse != null && (this.myResponse.getBody() instanceof CommonClientResponseBody.TextStream || this.myResponse.getBody() instanceof CommonClientResponseBody.Binary)) {
            this.notifyProcessTerminated(0);
        } else {
            this.notifyProcessTerminated(onPostProcessing ? 2 : 1);
        }
        if (this.myPostProcessorHandler != null) {
            this.myPostProcessorHandler.destroyProcess();
        }
        if (this.myUrlAccessingJob != null && !this.myUrlAccessingJob.isCompleted()) {
            this.myUrlAccessingJob.cancel(null);
        }
        if (this.myConnectionDisposable != null) {
            Disposer.dispose((Disposable)this.myConnectionDisposable);
        }
    }

    protected void detachProcessImpl() {
        this.notifyProcessDetached();
        if (this.myPostProcessorHandler != null) {
            this.myPostProcessorHandler.detachProcess();
        }
    }

    public boolean detachIsDefault() {
        return false;
    }

    public OutputStream getProcessInput() {
        return null;
    }

    @Nullable
    public CommonClientResponse getResponse() {
        return this.myResponse;
    }

    public void setResponse(@Nullable CommonClientResponse response2) {
        this.myResponse = response2;
    }

    public void responseHandlerStarted() {
        this.myResponseHandlerExecuting.compareAndSet(false, true);
    }

    public void responseHandlerFinished() {
        if (this.myPostProcessorHandler != null) {
            this.myPostProcessorHandler.notifyProcessTerminated(0);
        }
        this.myResponseHandlerExecuting.compareAndSet(true, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/http/request/run/HttpClientRequestProcessHandler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finishRunnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/http/request/run/HttpClientRequestProcessHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStartDeferred";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setCoroutineScope";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "handleTooFastProcessAndFinish";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static class HttpClientTestsProcessHandler
    extends ProcessHandler {
        private HttpClientTestsProcessHandler() {
        }

        public void notifyProcessTerminated(int exitCode) {
            super.notifyProcessTerminated(exitCode);
        }

        protected void destroyProcessImpl() {
            this.notifyProcessTerminated(2);
        }

        protected void detachProcessImpl() {
            this.notifyProcessTerminated(2);
        }

        public boolean detachIsDefault() {
            return false;
        }

        @Nullable
        public OutputStream getProcessInput() {
            return null;
        }
    }
}

