/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.performanceTesting;

import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.lang.javascript.performanceTesting.VirtualFilesVisitorCommand;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationLogger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J&\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J.\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\u0010\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u0003H&J\b\u0010\u001d\u001a\u00020\u0017H\u0016R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000e\u00a8\u0006\u001e"}, d2={"Lcom/intellij/lang/javascript/performanceTesting/JSFindElementsCommand;", "Lcom/intellij/lang/javascript/performanceTesting/VirtualFilesVisitorCommand;", "", "Lcom/intellij/psi/PsiElement;", "text", "", "line", "", "<init>", "(Ljava/lang/String;I)V", "allResults", "", "isContentOnly", "", "()Z", "isAcceptable", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "visitFile", "root", "project", "Lcom/intellij/openapi/project/Project;", "processResult", "", "result", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "isElementAcceptable", "element", "onCompleted", "intellij.javascript.performanceTesting"})
@SourceDebugExtension(value={"SMAP\nJSFindElementsCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSFindElementsCommand.kt\ncom/intellij/lang/javascript/performanceTesting/JSFindElementsCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,66:1\n1869#2,2:67\n*S KotlinDebug\n*F\n+ 1 JSFindElementsCommand.kt\ncom/intellij/lang/javascript/performanceTesting/JSFindElementsCommand\n*L\n57#1:67,2\n*E\n"})
public abstract class JSFindElementsCommand
extends VirtualFilesVisitorCommand<List<? extends PsiElement>> {
    @NotNull
    private final List<PsiElement> allResults;

    public JSFindElementsCommand(@NotNull String text, int line) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(text, line);
        List list = Collections.synchronizedList(new ArrayList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"synchronizedList(...)");
        this.allResults = list;
    }

    @Override
    protected boolean isContentOnly() {
        return true;
    }

    @Override
    protected boolean isAcceptable(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return JavaScriptIndex.isAcceptableFile(file);
    }

    @Override
    @NotNull
    protected List<PsiElement> visitFile(@NotNull VirtualFile file, @NotNull VirtualFile root, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile == null) {
            return CollectionsKt.emptyList();
        }
        PsiFile psiFile2 = psiFile;
        PsiElement[] psiElementArray = PsiTreeUtil.collectElements((PsiElement)((PsiElement)psiFile2), this::isElementAcceptable);
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"collectElements(...)");
        return ArraysKt.toList((Object[])psiElementArray);
    }

    @Override
    protected void processResult(@NotNull VirtualFile file, @NotNull VirtualFile root, @NotNull List<? extends PsiElement> result2, @NotNull PlaybackContext context2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.allResults.addAll((Collection<PsiElement>)result2);
    }

    public abstract boolean isElementAcceptable(@NotNull PsiElement var1);

    @Override
    public void onCompleted() {
        PsiElement psiElement = (PsiElement)CollectionsKt.firstOrNull(this.allResults);
        if (psiElement == null || (psiElement = psiElement.getProject()) == null) {
            return;
        }
        PsiElement project = psiElement;
        ConsoleViewImpl console = new ConsoleViewImpl((Project)project, true);
        RunContentDescriptor descriptor = new RunContentDescriptor((ExecutionConsole)console, null, console.getComponent(), Reflection.getOrCreateKotlinClass(((Object)((Object)this)).getClass()).getSimpleName());
        RunContentManager.getInstance((Project)project).showRunContent(DefaultRunExecutor.getRunExecutorInstance(), descriptor);
        Comparator comparator = new Comparator(){

            public final int compare(T a, T b) {
                PsiElement it = (PsiElement)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getContainingFile().getVirtualFile().getPath());
                it = (PsiElement)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getContainingFile().getVirtualFile().getPath())));
            }
        };
        Comparator comparator2 = new Comparator(comparator){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    PsiElement it = (PsiElement)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getTextOffset());
                    it = (PsiElement)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getTextOffset()));
                }
                return n;
            }
        };
        String string = project.getBasePath();
        if (string == null) {
            return;
        }
        String projectPathString = string;
        Path projectPath = Paths.get(projectPathString, new String[0]);
        Iterable $this$forEach$iv = CollectionsKt.sortedWith((Iterable)this.allResults, (Comparator)comparator2);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Path filePath;
            PsiElement element2 = (PsiElement)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)Paths.get(element2.getContainingFile().getVirtualFile().getPath(), new String[0]), (String)"get(...)");
            console.printHyperlink(projectPath.relativize(filePath) + ":" + JSEvaluationLogger.getLineNumber((PsiElement)element2), arg_0 -> JSFindElementsCommand.onCompleted$lambda$2$0(element2, arg_0));
            String string2 = " " + JSEvaluationLogger.getShortenedText((PsiElement)element2) + "\n";
            ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.NORMAL_OUTPUT;
            Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"NORMAL_OUTPUT");
            console.print(string2, consoleViewContentType);
        }
    }

    private static final void onCompleted$lambda$2$0(PsiElement $element, Project it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Navigatable navigatable = EditSourceUtil.getDescriptor((PsiElement)$element);
            if (navigatable == null) break block0;
            navigatable.navigate(true);
        }
    }
}

