/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.performanceTesting;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.lang.javascript.performanceTesting.VirtualFilesVisitorCommand;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtil;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSCheckParseErrorsCommand
extends VirtualFilesVisitorCommand<String> {
    @NonNls
    public static final String PREFIX = "%jsCheckParseErrors";

    public JSCheckParseErrorsCommand(@NotNull String text, int line) {
        if (text == null) {
            JSCheckParseErrorsCommand.$$$reportNull$$$0(0);
        }
        super(text, line);
    }

    @Override
    protected boolean isAcceptable(@NotNull VirtualFile file) {
        if (file == null) {
            JSCheckParseErrorsCommand.$$$reportNull$$$0(1);
        }
        return JavaScriptIndex.isAcceptableFile(file) && DialectDetector.JAVASCRIPT_FILE_TYPES.contains(file.getFileType());
    }

    @Override
    @Nullable
    protected String visitFile(@NotNull VirtualFile file, @NotNull VirtualFile root, @NotNull Project project) {
        if (file == null) {
            JSCheckParseErrorsCommand.$$$reportNull$$$0(2);
        }
        if (root == null) {
            JSCheckParseErrorsCommand.$$$reportNull$$$0(3);
        }
        if (project == null) {
            JSCheckParseErrorsCommand.$$$reportNull$$$0(4);
        }
        return JSCheckParseErrorsCommand.getParseErrorCountMessage(file, root, project);
    }

    @Override
    protected void processResult(@NotNull VirtualFile file, @NotNull VirtualFile root, @Nullable String result2, @NotNull PlaybackContext context2) {
        if (file == null) {
            JSCheckParseErrorsCommand.$$$reportNull$$$0(5);
        }
        if (root == null) {
            JSCheckParseErrorsCommand.$$$reportNull$$$0(6);
        }
        if (context2 == null) {
            JSCheckParseErrorsCommand.$$$reportNull$$$0(7);
        }
        if (result2 != null) {
            context2.message(result2, -1);
        }
    }

    @Nullable
    private static String getParseErrorCountMessage(@NotNull VirtualFile file, @NotNull VirtualFile root, @NotNull Project project) {
        String code;
        String path2;
        if (file == null) {
            JSCheckParseErrorsCommand.$$$reportNull$$$0(8);
        }
        if (root == null) {
            JSCheckParseErrorsCommand.$$$reportNull$$$0(9);
        }
        if (project == null) {
            JSCheckParseErrorsCommand.$$$reportNull$$$0(10);
        }
        if ((path2 = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)root, (char)'/')) == null) {
            return null;
        }
        try {
            code = VfsUtilCore.loadText((VirtualFile)file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JSLanguageDialect dialect = DialectDetector.getLanguageDialect((VirtualFile)file, (Project)project);
        if (dialect == null) {
            dialect = JSLanguageLevel.DEFAULT.getDialect();
        }
        PsiFileFactory fileFactory = PsiFileFactory.getInstance((Project)project);
        PsiFile psiFile = fileFactory.createFileFromText("js.js", (Language)dialect, (CharSequence)code, false, false);
        int errors = PsiTreeUtil.collectElementsOfType((PsiElement)psiFile, (Class[])new Class[]{PsiErrorElement.class}).size();
        if (errors > 0) {
            return String.format("js-parse-errors: %s -> %d", path2, errors);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/performanceTesting/JSCheckParseErrorsCommand";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isAcceptable";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitFile";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "processResult";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getParseErrorCountMessage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

