/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library;

import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.css.reference.CssDownloadedLibraryReference;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSLibReferenceResolver {
    private JSLibReferenceResolver() {
    }

    @Nullable
    public static PsiReference getLibReference(XmlAttributeValue attributeValue) {
        PsiReference[] refs;
        for (PsiReference ref2 : refs = attributeValue.getReferences()) {
            if (!(ref2 instanceof JSLibReference)) continue;
            return ref2;
        }
        return null;
    }

    public static JSLibReference createReference(XmlAttributeValue attributeValue) {
        return new JSLibReference(attributeValue);
    }

    public static final class JSLibReference
    implements PsiReference,
    CssDownloadedLibraryReference {
        private final XmlAttributeValue myAttributeValue;
        private final Project myProject;

        public JSLibReference(XmlAttributeValue attributeValue) {
            this.myProject = attributeValue.getProject();
            this.myAttributeValue = attributeValue;
        }

        @NotNull
        public PsiElement getElement() {
            XmlAttributeValue xmlAttributeValue = this.myAttributeValue;
            if (xmlAttributeValue == null) {
                JSLibReference.$$$reportNull$$$0(0);
            }
            return xmlAttributeValue;
        }

        @NotNull
        public TextRange getRangeInElement() {
            TextRange absValueRange = this.myAttributeValue.getValueTextRange();
            int offset = this.myAttributeValue.getTextRange().getStartOffset();
            return new TextRange(absValueRange.getStartOffset() - offset, absValueRange.getEndOffset() - offset);
        }

        public PsiElement resolve() {
            return JSLibReference.resolveToLibrary(this.myAttributeValue.getValue(), this.myProject);
        }

        @Nullable
        public static PsiElement resolveToLibrary(String libName, Project project) {
            JSLibraryManager libraryManager = JSLibraryManager.getInstance(project);
            VirtualFile vf = libraryManager.getMatchingFile(JSLibraryUtil.makeUniqueFileName((String)libName, (boolean)true));
            if (vf == null) {
                vf = libraryManager.getMatchingFile(JSLibraryUtil.makeUniqueFileName((String)libName, (boolean)false));
            }
            if (vf != null && !vf.isValid()) {
                vf = JSLibReference.findNewVirtualFile(vf);
            }
            if (vf != null) {
                PsiManager psiManager = PsiManager.getInstance((Project)project);
                return psiManager.findFile(vf);
            }
            return null;
        }

        @Nullable
        private static VirtualFile findNewVirtualFile(@NotNull VirtualFile vf) {
            if (vf == null) {
                JSLibReference.$$$reportNull$$$0(1);
            }
            return (VirtualFile)ReadAction.compute(() -> {
                VirtualFileSystem fileSystem = vf.getFileSystem();
                VirtualFile newVf = fileSystem.findFileByPath(vf.getPath());
                if (newVf != null && newVf.isValid()) {
                    return newVf;
                }
                return null;
            });
        }

        @NotNull
        public String getCanonicalText() {
            String string = this.myAttributeValue.getValue();
            if (string == null) {
                JSLibReference.$$$reportNull$$$0(2);
            }
            return string;
        }

        public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
            if (newElementName == null) {
                JSLibReference.$$$reportNull$$$0(3);
            }
            throw new IncorrectOperationException();
        }

        public PsiElement bindToElement(@NotNull PsiElement element2) throws IncorrectOperationException {
            if (element2 == null) {
                JSLibReference.$$$reportNull$$$0(4);
            }
            throw new IncorrectOperationException();
        }

        public boolean isReferenceTo(@NotNull PsiElement element2) {
            if (element2 == null) {
                JSLibReference.$$$reportNull$$$0(5);
            }
            return false;
        }

        public boolean isSoft() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 3, 4, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/library/JSLibReferenceResolver$JSLibReference";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "vf";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElementName";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElement";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/library/JSLibReferenceResolver$JSLibReference";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCanonicalText";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "findNewVirtualFile";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "handleElementRename";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "bindToElement";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isReferenceTo";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 3, 4, 5 -> new IllegalArgumentException(string);
            };
        }
    }
}

