/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library;

import com.intellij.codeWithMe.ClientId;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.RootsChangeRescanningInfo;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0002)*B8\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u0012\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0006H\u0002J\"\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00032\b\u0010\u0018\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0019\u001a\u00020\u0012H\u0002J\u0012\u0010\u001a\u001a\u00020\u00032\b\u0010\u001b\u001a\u0004\u0018\u00010\u000fH\u0002J\u0016\u0010\u001c\u001a\u00020\u00162\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\u0006H\u0002J\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\tH\u0002J\u001e\u0010 \u001a\u00020\u00162\u0006\u0010!\u001a\u00020\"2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\u0006H\u0002J\u001c\u0010#\u001a\u00020\u00162\u0006\u0010$\u001a\u00020\u00032\n\b\u0002\u0010%\u001a\u0004\u0018\u00010&H\u0002J\u0010\u0010'\u001a\u00020\u00162\u0006\u0010$\u001a\u00020\u0003H\u0002J\u0010\u0010(\u001a\u00020\u00162\u0006\u0010$\u001a\u00020\u0003H\u0002R\u0013\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/intellij/lang/javascript/library/JSBundledLibraryUrls;", "", "debugName", "", "Lorg/jetbrains/annotations/NonNls;", "relativePaths", "", "urlProvider", "Lkotlin/Function1;", "Ljava/net/URL;", "<init>", "(Ljava/lang/String;Ljava/util/List;Lkotlin/jvm/functions/Function1;)V", "files", "Lcom/intellij/openapi/util/ClearableLazyValue;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "refreshStatus", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/lang/javascript/library/JSBundledLibraryUrls$RefreshStatus;", "getFiles", "findFiles", "logMissingFileInVFS", "", "relativePath", "virtualFile", "beforeVfsAccessRefreshStatus", "virtualFileStatus", "file", "scheduleVfsRefresh", "urlsToRefresh", "refresh", "url", "rescanDependencies", "project", "Lcom/intellij/openapi/project/Project;", "logError", "message", "e", "", "logWarn", "logInfo", "RefreshStatus", "JSApplicationScopeProvider", "intellij.javascript.analysis.impl"})
@SourceDebugExtension(value={"SMAP\nJSBundledLibraryUrls.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSBundledLibraryUrls.kt\ncom/intellij/lang/javascript/library/JSBundledLibraryUrls\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,115:1\n1#2:116\n42#3,3:117\n23#4:120\n23#4:121\n23#4:122\n*S KotlinDebug\n*F\n+ 1 JSBundledLibraryUrls.kt\ncom/intellij/lang/javascript/library/JSBundledLibraryUrls\n*L\n78#1:117,3\n106#1:120\n107#1:121\n108#1:122\n*E\n"})
public final class JSBundledLibraryUrls {
    @NotNull
    private final String debugName;
    @NotNull
    private final List<String> relativePaths;
    @NotNull
    private final Function1<String, URL> urlProvider;
    @NotNull
    private final ClearableLazyValue<Set<VirtualFile>> files;
    @NotNull
    private final AtomicReference<RefreshStatus> refreshStatus;

    public JSBundledLibraryUrls(@NotNull String debugName, @NotNull List<String> relativePaths, @NotNull Function1<? super String, URL> urlProvider) {
        Intrinsics.checkNotNullParameter((Object)debugName, (String)"debugName");
        Intrinsics.checkNotNullParameter(relativePaths, (String)"relativePaths");
        Intrinsics.checkNotNullParameter(urlProvider, (String)"urlProvider");
        this.debugName = debugName;
        this.relativePaths = relativePaths;
        this.urlProvider = urlProvider;
        ClearableLazyValue clearableLazyValue = ClearableLazyValue.createAtomic(() -> JSBundledLibraryUrls.files$lambda$0(this));
        Intrinsics.checkNotNullExpressionValue((Object)clearableLazyValue, (String)"createAtomic(...)");
        this.files = clearableLazyValue;
        this.refreshStatus = new AtomicReference<RefreshStatus>(RefreshStatus.BEFORE);
    }

    @NotNull
    public final Set<VirtualFile> getFiles() {
        Object object = this.files.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (Set)object;
    }

    private final List<VirtualFile> findFiles() {
        List urlsToRefresh = new ArrayList();
        List files = new ArrayList();
        RefreshStatus beforeVfsAccessRefreshStatus = this.refreshStatus.get();
        for (String relativePath : this.relativePaths) {
            Object $this$findFiles_u24lambda_u240;
            JSBundledLibraryUrls jSBundledLibraryUrls = this;
            try {
                $this$findFiles_u24lambda_u240 = jSBundledLibraryUrls;
                boolean bl = false;
                $this$findFiles_u24lambda_u240 = Result.constructor-impl((Object)((URL)((JSBundledLibraryUrls)$this$findFiles_u24lambda_u240).urlProvider.invoke((Object)relativePath)));
            }
            catch (Throwable throwable) {
                $this$findFiles_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            Object urlResult = $this$findFiles_u24lambda_u240;
            URL url = (URL)(Result.isFailure-impl((Object)urlResult) ? null : urlResult);
            if (url == null) {
                this.logError("Installation is possibly broken. Cannot find URL for " + relativePath, Result.exceptionOrNull-impl((Object)urlResult));
                continue;
            }
            VirtualFile file = VfsUtil.findFileByURL((URL)url);
            if (file != null && file.isValid()) {
                files.add(file);
                continue;
            }
            urlsToRefresh.add(url);
            Intrinsics.checkNotNull((Object)((Object)beforeVfsAccessRefreshStatus));
            this.logMissingFileInVFS(relativePath, file, beforeVfsAccessRefreshStatus);
        }
        if (!urlsToRefresh.isEmpty()) {
            this.scheduleVfsRefresh(urlsToRefresh);
        }
        return files;
    }

    private final void logMissingFileInVFS(String relativePath, VirtualFile virtualFile, RefreshStatus beforeVfsAccessRefreshStatus) {
        String message = "Cannot find '" + relativePath + "' in VFS, file: " + this.virtualFileStatus(virtualFile) + ", refresh: " + beforeVfsAccessRefreshStatus;
        if (beforeVfsAccessRefreshStatus == RefreshStatus.AFTER) {
            JSBundledLibraryUrls.logError$default(this, message, null, 2, null);
        } else {
            this.logWarn(message);
        }
    }

    private final String virtualFileStatus(VirtualFile file) {
        VirtualFile virtualFile = file;
        return virtualFile != null ? "not-null, isValid:" + virtualFile.isValid() : "null";
    }

    private final void scheduleVfsRefresh(List<URL> urlsToRefresh) {
        if (this.refreshStatus.compareAndSet(RefreshStatus.BEFORE, RefreshStatus.IN_PROGRESS)) {
            boolean $i$f$service = false;
            Class<JSApplicationScopeProvider> serviceClass$iv = JSApplicationScopeProvider.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            BuildersKt.launch$default((CoroutineScope)((JSApplicationScopeProvider)object).getCoroutineScope(), (CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(urlsToRefresh, this, null){
                int label;
                final /* synthetic */ List<URL> $urlsToRefresh;
                final /* synthetic */ JSBundledLibraryUrls this$0;
                {
                    this.$urlsToRefresh = $urlsToRefresh;
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            for (URL url : this.$urlsToRefresh) {
                                JSBundledLibraryUrls.access$refresh(this.this$0, url);
                            }
                            JSBundledLibraryUrls.access$getRefreshStatus$p(this.this$0).set(RefreshStatus.AFTER);
                            JSBundledLibraryUrls.access$getFiles$p(this.this$0).drop();
                            Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
                            Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
                            for (Project project : projectArray) {
                                Intrinsics.checkNotNull((Object)project);
                                Project project2 = project;
                                JSBundledLibraryUrls.access$rescanDependencies(this.this$0, project2, this.$urlsToRefresh);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
    }

    private final void refresh(URL url) {
        String string = VfsUtilCore.convertFromUrl((URL)url);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"convertFromUrl(...)");
        String vfsUrl = string;
        VirtualFile file = VirtualFileManager.getInstance().refreshAndFindFileByUrl(vfsUrl);
        this.logInfo("Refreshed " + url.toExternalForm() + ": " + this.virtualFileStatus(file));
        if (file == null || !file.isValid()) {
            JSBundledLibraryUrls.logError$default(this, "Installation is possibly broken. Cannot find virtual file by url: " + url.toExternalForm() + ", file: " + this.virtualFileStatus(file), null, 2, null);
        }
    }

    private final void rescanDependencies(Project project, List<URL> urlsToRefresh) {
        JSLibraryManager.getInstance(project).commitChangesWithReason(RootsChangeRescanningInfo.RESCAN_DEPENDENCIES_IF_NEEDED, "[" + this.debugName + "] bundled library URLs refreshed " + urlsToRefresh);
    }

    private final void logError(String message, Throwable e) {
        JSBundledLibraryUrls $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(JSBundledLibraryUrls.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.error("[" + this.debugName + "] " + message, e);
    }

    static /* synthetic */ void logError$default(JSBundledLibraryUrls jSBundledLibraryUrls, String string, Throwable throwable, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        jSBundledLibraryUrls.logError(string, throwable);
    }

    private final void logWarn(String message) {
        JSBundledLibraryUrls $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(JSBundledLibraryUrls.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.warn("[" + this.debugName + "] " + message);
    }

    private final void logInfo(String message) {
        JSBundledLibraryUrls $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(JSBundledLibraryUrls.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info("[" + this.debugName + "] " + message);
    }

    private static final Set files$lambda$0(JSBundledLibraryUrls this$0) {
        return Collections.unmodifiableSet(CollectionsKt.toSet((Iterable)this$0.findFiles()));
    }

    public static final /* synthetic */ void access$refresh(JSBundledLibraryUrls $this, URL url) {
        $this.refresh(url);
    }

    public static final /* synthetic */ AtomicReference access$getRefreshStatus$p(JSBundledLibraryUrls $this) {
        return $this.refreshStatus;
    }

    public static final /* synthetic */ ClearableLazyValue access$getFiles$p(JSBundledLibraryUrls $this) {
        return $this.files;
    }

    public static final /* synthetic */ void access$rescanDependencies(JSBundledLibraryUrls $this, Project project, List urlsToRefresh) {
        $this.rescanDependencies(project, urlsToRefresh);
    }

    @Service(value={Service.Level.APP})
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/lang/javascript/library/JSBundledLibraryUrls$JSApplicationScopeProvider;", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "intellij.javascript.analysis.impl"})
    private static final class JSApplicationScopeProvider {
        @NotNull
        private final CoroutineScope coroutineScope;

        public JSApplicationScopeProvider(@NotNull CoroutineScope coroutineScope) {
            Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
            this.coroutineScope = coroutineScope;
        }

        @NotNull
        public final CoroutineScope getCoroutineScope() {
            return this.coroutineScope;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/lang/javascript/library/JSBundledLibraryUrls$RefreshStatus;", "", "<init>", "(Ljava/lang/String;I)V", "BEFORE", "IN_PROGRESS", "AFTER", "intellij.javascript.analysis.impl"})
    private static final class RefreshStatus
    extends Enum<RefreshStatus> {
        public static final /* enum */ RefreshStatus BEFORE = new RefreshStatus();
        public static final /* enum */ RefreshStatus IN_PROGRESS = new RefreshStatus();
        public static final /* enum */ RefreshStatus AFTER = new RefreshStatus();
        private static final /* synthetic */ RefreshStatus[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static RefreshStatus[] values() {
            return (RefreshStatus[])$VALUES.clone();
        }

        public static RefreshStatus valueOf(String value) {
            return Enum.valueOf(RefreshStatus.class, value);
        }

        @NotNull
        public static EnumEntries<RefreshStatus> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = refreshStatusArray = new RefreshStatus[]{RefreshStatus.BEFORE, RefreshStatus.IN_PROGRESS, RefreshStatus.AFTER};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

