/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ecmascript6.psi.impl.ES6FieldStatementImpl;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.inspections.JSRecursiveWalkingElementSkippingNestedFunctionsVisitor;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ClassMemberInitializationOrderInspection
extends JSInspection {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            ES6ClassMemberInitializationOrderInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            ES6ClassMemberInitializationOrderInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(this){

            public void visitJSClass(@NotNull JSClass aClass) {
                if (aClass == null) {
                    1.$$$reportNull$$$0(0);
                }
                MultiMap referenced = MultiMap.createLinked();
                MultiMap nodes = MultiMap.createLinked();
                String className = aClass.getName();
                ArrayList<String> allVarNames = new ArrayList<String>();
                HashSet<String> statics = new HashSet<String>();
                for (PsiElement child : aClass.getChildren()) {
                    JSExpression initializer;
                    Object object;
                    JSVariable[] allVars;
                    if (!(child instanceof ES6FieldStatementImpl) || (allVars = ((ES6FieldStatementImpl)child).getVariables()).length != 1 || !((object = allVars[0]) instanceof JSField)) continue;
                    JSField element2 = (JSField)object;
                    String fieldName = element2.getName();
                    allVarNames.add(fieldName);
                    boolean isStatic = JSPsiImplUtils.hasModifier((JSAttributeListOwner)element2, (JSAttributeList.ModifierType)JSAttributeList.ModifierType.STATIC);
                    if (isStatic) {
                        statics.add(fieldName);
                    }
                    if ((initializer = element2.getInitializer()) == null) continue;
                    JSFieldUsagesCollector collector = new JSFieldUsagesCollector(fieldName, className, (MultiMap<Pair<String, String>, PsiElement>)nodes, isStatic);
                    initializer.accept((PsiElementVisitor)collector);
                    referenced.put((Object)fieldName, collector.referencedFields);
                }
                for (int i = 0; i < allVarNames.size(); ++i) {
                    String key = (String)allVarNames.get(i);
                    if (!referenced.containsKey((Object)key)) continue;
                    Collection strings = referenced.get((Object)key);
                    for (int j = i; j < allVarNames.size(); ++j) {
                        String otherVar = (String)allVarNames.get(j);
                        if (statics.contains(key) && !statics.contains(otherVar) || !strings.contains(otherVar)) continue;
                        Collection elements = nodes.get((Object)Pair.create((Object)key, (Object)otherVar));
                        for (PsiElement element3 : elements) {
                            holder.registerProblem(element3, i == j ? JavaScriptBundle.message((String)"js.class.member.initialization.inspection.text.id", (Object[])new Object[]{key}) : JavaScriptBundle.message((String)"js.class.member.initialization.inspection.text", (Object[])new Object[]{key, otherVar}), new LocalQuickFix[0]);
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/lang/javascript/inspections/ES6ClassMemberInitializationOrderInspection$1", "visitJSClass"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/inspections/ES6ClassMemberInitializationOrderInspection";
        objectArray[2] = "createVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class JSFieldUsagesCollector
    extends JSRecursiveWalkingElementSkippingNestedFunctionsVisitor {
        private final String myName;
        @Nullable
        private final String myClassName;
        private final MultiMap<Pair<String, String>, PsiElement> myNodes;
        private final boolean myIsStatic;
        private final Set<String> referencedFields = new HashSet<String>();

        JSFieldUsagesCollector(String name, @Nullable String className, MultiMap<Pair<String, String>, PsiElement> nodes, boolean isStatic) {
            this.myName = name;
            this.myClassName = className;
            this.myNodes = nodes;
            this.myIsStatic = isStatic;
        }

        public void visitJSReferenceExpression(@NotNull JSReferenceExpression node) {
            JSExpression qualifier;
            if (node == null) {
                JSFieldUsagesCollector.$$$reportNull$$$0(0);
            }
            if ((qualifier = node.getQualifier()) instanceof JSThisExpression) {
                String referenceName = node.getReferenceName();
                this.referencedFields.add(referenceName);
                this.myNodes.putValue((Object)Pair.create((Object)this.myName, (Object)referenceName), (Object)node);
            } else if (this.myIsStatic && this.myClassName != null) {
                if (!(qualifier instanceof JSReferenceExpression) || ((JSReferenceExpression)qualifier).getQualifier() != null) {
                    return;
                }
                String qualifierName = ((JSReferenceExpression)qualifier).getReferenceName();
                if (this.myClassName.equals(qualifierName)) {
                    String referenceName = node.getReferenceName();
                    this.referencedFields.add(referenceName);
                    this.myNodes.putValue((Object)Pair.create((Object)this.myName, (Object)referenceName), (Object)node);
                }
            }
        }

        @Override
        protected boolean skipLambdas() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/inspections/ES6ClassMemberInitializationOrderInspection$JSFieldUsagesCollector", "visitJSReferenceExpression"));
        }
    }
}

