/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.css.util.CssClassUtil;
import com.intellij.lang.javascript.ecmascript6.CssResolveSupport;
import com.intellij.lang.javascript.psi.resolve.processors.JSResolveProcessor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.css.CssClass;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.css.StylesheetFileMarker;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class BackendCssResolveSupport
implements CssResolveSupport {
    public void processCssClasses(@NotNull StylesheetFileMarker stylesheetFile, @NotNull JSResolveProcessor processor) {
        if (stylesheetFile == null) {
            BackendCssResolveSupport.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            BackendCssResolveSupport.$$$reportNull$$$0(1);
        }
        CssStylesheet stylesheet = ((StylesheetFile)stylesheetFile).getStylesheet();
        MultiMap stylesheetClasses = (MultiMap)CachedValuesManager.getCachedValue((PsiElement)stylesheet, () -> {
            MultiMap classes = new MultiMap();
            for (CssRuleset cssRuleset : stylesheet.getRulesets()) {
                BackendCssResolveSupport.collectCssClasses(cssRuleset, (MultiMap<String, CssClass>)classes);
            }
            return CachedValueProvider.Result.create((Object)classes, (Object[])new Object[]{stylesheet.getContainingFile()});
        });
        Collection classes = processor.getName() != null ? stylesheetClasses.get((Object)processor.getName()) : stylesheetClasses.values();
        for (CssClass cssClass : classes) {
            ProgressManager.checkCanceled();
            processor.execute((PsiElement)cssClass, ResolveState.initial());
        }
    }

    private static void collectCssClasses(@NotNull CssRuleset cssRuleset, @NotNull MultiMap<String, CssClass> classes) {
        if (cssRuleset == null) {
            BackendCssResolveSupport.$$$reportNull$$$0(2);
        }
        if (classes == null) {
            BackendCssResolveSupport.$$$reportNull$$$0(3);
        }
        for (CssSelector cssSelector : cssRuleset.getSelectors()) {
            if (cssSelector.isAmpersandSelector()) {
                cssSelector.processAmpersandEvaluatedSelectors(effectiveSelector -> {
                    BackendCssResolveSupport.collectCssClasses(effectiveSelector, classes);
                    return true;
                });
                continue;
            }
            BackendCssResolveSupport.collectCssClasses(cssSelector, classes);
        }
        for (CssSelector cssSelector : cssRuleset.getNestedRulesets()) {
            BackendCssResolveSupport.collectCssClasses((CssRuleset)cssSelector, classes);
        }
    }

    private static void collectCssClasses(@NotNull CssSelector selector, @NotNull MultiMap<String, CssClass> classes) {
        if (selector == null) {
            BackendCssResolveSupport.$$$reportNull$$$0(4);
        }
        if (classes == null) {
            BackendCssResolveSupport.$$$reportNull$$$0(5);
        }
        ProgressManager.checkCanceled();
        for (CssSimpleSelector simpleSelector : selector.getSimpleSelectors()) {
            for (CssSelectorSuffix selectorSuffix : simpleSelector.getSelectorSuffixes()) {
                if (!(selectorSuffix instanceof CssClass)) continue;
                String name = selectorSuffix.getName();
                if (name != null) {
                    name = CssClassUtil.kebabToCamelCase((String)name);
                }
                if (name == null) continue;
                classes.putValue((Object)name, (Object)((CssClass)selectorSuffix));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stylesheetFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cssRuleset";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/BackendCssResolveSupport";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processCssClasses";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "collectCssClasses";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

