/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.npm;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.execution.wsl.WslPath;
import com.intellij.ide.trustedProjects.TrustedProjects;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.interpreter.NodeCommandLineConfigurator;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.interpreter.remote.NodeJsRemoteInterpreter;
import com.intellij.javascript.nodejs.interpreter.wsl.WslNodeInterpreter;
import com.intellij.javascript.nodejs.npm.NpmManager;
import com.intellij.javascript.nodejs.npm.NpmNodePackage;
import com.intellij.javascript.nodejs.npm.NpmPackageDescriptor;
import com.intellij.javascript.nodejs.npm.NpmPackageRefResolver;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.javascript.nodejs.util.NodePackageRefResolver;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NpmUtil {
    @NlsSafe
    public static final String NPM_PACKAGE_NAME = "npm";
    @NlsSafe
    public static final String YARN_PACKAGE_NAME = "yarn";
    @NlsSafe
    public static final String PNPM_PACKAGE_NAME = "pnpm";
    @NlsSafe
    public static final String BUN_PACKAGE_NAME = "bun";
    public static final String PACKAGE_LOCK_JSON_FILENAME = "package-lock.json";
    public static final String PNPM_LOCK_FILENAME = "pnpm-lock.yaml";
    public static final String BUN_LOCK_FILENAME = "bun.lock";
    public static final String BUN_LOCKB_FILENAME = "bun.lockb";
    public static final String PROJECT_PACKAGE_MANAGER_REFERENCE_NAME = "Project";
    public static final NodePackageDescriptor DESCRIPTOR = new NpmPackageDescriptor(false);
    private static final String NPM_CLI_JS_RELATIVE_PATH = "bin" + File.separator + "npm-cli.js";
    private static final String YARN_CLI_JS_RELATIVE_PATH = "bin" + File.separator + "yarn.js";
    private static final String PNPM_CLI_JS_RELATIVE_PATH = "bin" + File.separator + "pnpm.cjs";
    private static final NpmPackageRefResolver RESOLVER = new NpmPackageRefResolver(null, DESCRIPTOR, null);

    private NpmUtil() {
    }

    @NotNull
    public static NodePackageRef createProjectPackageManagerPackageRef() {
        NodePackageRef nodePackageRef = NodePackageRef.create(PROJECT_PACKAGE_MANAGER_REFERENCE_NAME);
        if (nodePackageRef == null) {
            NpmUtil.$$$reportNull$$$0(0);
        }
        return nodePackageRef;
    }

    public static boolean isProjectPackageManagerPackageRef(@NotNull NodePackageRef packageRef) {
        if (packageRef == null) {
            NpmUtil.$$$reportNull$$$0(1);
        }
        return PROJECT_PACKAGE_MANAGER_REFERENCE_NAME.equals(packageRef.getReferenceName());
    }

    @NlsContexts.Label
    @NotNull
    public static String getPackageManagerPackageFieldLabelText() {
        String string = JavaScriptBundle.message((String)"node.package.manager.label", (Object[])new Object[0]);
        if (string == null) {
            NpmUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static NodePackageField createPackageManagerPackageField(@NotNull NodeJsInterpreterField interpreterField2, boolean projectField) {
        if (interpreterField2 == null) {
            NpmUtil.$$$reportNull$$$0(3);
        }
        NpmPackageDescriptor descriptor = new NpmPackageDescriptor(projectField);
        NpmPackageRefResolver resolver = new NpmPackageRefResolver(interpreterField2.getProject(), descriptor, interpreterField2::getInterpreter);
        return new NodePackageField(interpreterField2, (NodePackageDescriptor)descriptor, null, (NodePackageRefResolver)resolver);
    }

    @Deprecated
    @NotNull
    public static String getValidNpmCliJsFilePath(@NotNull NodePackage packageManagerPkg) throws ExecutionException {
        if (packageManagerPkg == null) {
            NpmUtil.$$$reportNull$$$0(4);
        }
        return NpmUtil.getValidNpmCliJsFilePath(packageManagerPkg, null);
    }

    @NotNull
    public static String getValidNpmCliJsFilePath(@NotNull NodePackage packageManagerPkg, @Nullable NodeJsInterpreter interpreter2) throws ExecutionException {
        if (packageManagerPkg == null) {
            NpmUtil.$$$reportNull$$$0(5);
        }
        if (packageManagerPkg.isEmptyPath()) {
            throw new ExecutionException(JavaScriptBundle.message((String)"node.npm.specify_npm_or_yarn_package.dialog.message", (Object[])new Object[0]));
        }
        if (interpreter2 instanceof WslNodeInterpreter) {
            String string = NpmUtil.getWslLinuxPath((WslNodeInterpreter)interpreter2, packageManagerPkg) + "/" + FileUtil.toSystemIndependentName((String)NpmUtil.getStaticMainJsRelativePath(packageManagerPkg));
            if (string == null) {
                NpmUtil.$$$reportNull$$$0(6);
            }
            return string;
        }
        if (interpreter2 instanceof NodeJsRemoteInterpreter) {
            String string = packageManagerPkg.getSystemIndependentPath() + "/" + FileUtil.toSystemIndependentName((String)NpmUtil.getStaticMainJsRelativePath(packageManagerPkg));
            if (string == null) {
                NpmUtil.$$$reportNull$$$0(7);
            }
            return string;
        }
        if (!packageManagerPkg.isValid(null, interpreter2)) {
            throw new ExecutionException(JavaScriptBundle.message((String)"node.npm.correct_path_to_npm_or_yarn_package.dialog.message", (Object[])new Object[]{packageManagerPkg.getSystemDependentPath()}));
        }
        return NpmUtil.findBinCliFile(packageManagerPkg, interpreter2);
    }

    @NotNull
    public static String getWslLinuxPath(@NotNull WslNodeInterpreter interpreter2, @NotNull NodePackage pkg) {
        String linuxPath;
        WslPath wslPath;
        if (interpreter2 == null) {
            NpmUtil.$$$reportNull$$$0(8);
        }
        if (pkg == null) {
            NpmUtil.$$$reportNull$$$0(9);
        }
        if ((wslPath = WslPath.parseWindowsUncPath((String)(linuxPath = pkg.getSystemIndependentPath()))) != null && wslPath.getDistribution().equals((Object)interpreter2.getDistribution())) {
            linuxPath = wslPath.getLinuxPath();
        }
        String string = linuxPath;
        if (string == null) {
            NpmUtil.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    private static String getStaticMainJsRelativePath(@NotNull NodePackage npmPkg) {
        if (npmPkg == null) {
            NpmUtil.$$$reportNull$$$0(11);
        }
        if (NpmUtil.isYarnAlikePackage(npmPkg)) {
            String string = YARN_CLI_JS_RELATIVE_PATH;
            if (string == null) {
                NpmUtil.$$$reportNull$$$0(12);
            }
            return string;
        }
        if (NpmUtil.isPnpmPackage(npmPkg)) {
            String string = PNPM_CLI_JS_RELATIVE_PATH;
            if (string == null) {
                NpmUtil.$$$reportNull$$$0(13);
            }
            return string;
        }
        String string = NPM_CLI_JS_RELATIVE_PATH;
        if (string == null) {
            NpmUtil.$$$reportNull$$$0(14);
        }
        return string;
    }

    public static boolean isYarnAlikePackageRef(@NotNull NodePackageRef packageManagerPkgRef) {
        NodePackage pkg;
        if (packageManagerPkgRef == null) {
            NpmUtil.$$$reportNull$$$0(15);
        }
        if ((pkg = packageManagerPkgRef.getConstantPackage()) != null) {
            return NpmUtil.isYarnAlikePackage(pkg);
        }
        return StringUtil.containsIgnoreCase((String)Objects.requireNonNull(packageManagerPkgRef.getReferenceName()), (String)YARN_PACKAGE_NAME);
    }

    public static boolean isPnpmPackageRef(@NotNull NodePackageRef packageManagerPkgRef) {
        NodePackage pkg;
        if (packageManagerPkgRef == null) {
            NpmUtil.$$$reportNull$$$0(16);
        }
        if ((pkg = packageManagerPkgRef.getConstantPackage()) != null) {
            return PNPM_PACKAGE_NAME.equals(pkg.getName());
        }
        return PNPM_PACKAGE_NAME.equals(packageManagerPkgRef.getReferenceName());
    }

    public static boolean isBunPackageRef(@NotNull NodePackageRef packageManagerPkgRef) {
        NodePackage pkg;
        if (packageManagerPkgRef == null) {
            NpmUtil.$$$reportNull$$$0(17);
        }
        if ((pkg = packageManagerPkgRef.getConstantPackage()) != null) {
            return BUN_PACKAGE_NAME.equals(pkg.getName());
        }
        return BUN_PACKAGE_NAME.equals(packageManagerPkgRef.getReferenceName());
    }

    public static boolean isBunPackage(@NotNull NodePackage packageManagerPkg) {
        if (packageManagerPkg == null) {
            NpmUtil.$$$reportNull$$$0(18);
        }
        return packageManagerPkg instanceof NpmNodePackage && BUN_PACKAGE_NAME.equals(packageManagerPkg.getName());
    }

    @ApiStatus.Internal
    @Nullable
    public static NodeJsLocalInterpreter createNodeInterpreterForBun(@NotNull NodePackage bunPkg) {
        if (bunPkg == null) {
            NpmUtil.$$$reportNull$$$0(19);
        }
        if (NpmUtil.isBunPackage(bunPkg)) {
            return new NodeJsLocalInterpreter(bunPkg.getSystemDependentPath());
        }
        return null;
    }

    public static boolean isYarnAlikePackage(@NotNull NodePackage packageManagerPkg) {
        String packageName;
        if (packageManagerPkg == null) {
            NpmUtil.$$$reportNull$$$0(20);
        }
        if (StringUtil.containsIgnoreCase((String)(packageName = packageManagerPkg.getName()), (String)YARN_PACKAGE_NAME)) {
            return true;
        }
        String path2 = packageManagerPkg.getSystemIndependentPath();
        if (!packageName.contains(NPM_PACKAGE_NAME) && path2.contains("/yarn/")) {
            return true;
        }
        return (path2.contains("/.yvm/") || path2.contains("/yvm/")) && !packageName.contains(NPM_PACKAGE_NAME);
    }

    public static boolean isPnpmPackage(@NotNull NodePackage pkg) {
        String packageName;
        if (pkg == null) {
            NpmUtil.$$$reportNull$$$0(21);
        }
        if (StringUtil.containsIgnoreCase((String)(packageName = pkg.getName()), (String)PNPM_PACKAGE_NAME)) {
            return true;
        }
        String path2 = pkg.getSystemIndependentPath();
        return path2.contains("/pnpm/");
    }

    @NotNull
    private static String findBinCliFile(@NotNull NodePackage pkg, @Nullable NodeJsInterpreter interpreter2) throws ExecutionException {
        Path binFile;
        if (pkg == null) {
            NpmUtil.$$$reportNull$$$0(22);
        }
        if ((binFile = pkg.findBinFilePath(pkg.getName(), NpmUtil.getStaticMainJsRelativePath(pkg), interpreter2)) == null) {
            throw new ExecutionException(JavaScriptBundle.message((String)"node.npm.invalid_package_manager.binary_file_not_found.dialog.message", (Object[])new Object[]{pkg.getSystemDependentPath()}));
        }
        String string = binFile.toString();
        if (string == null) {
            NpmUtil.$$$reportNull$$$0(23);
        }
        return string;
    }

    @Nullable
    public static NodePackage resolveRef(@NotNull NodePackageRef ref2, @NotNull Project project, @Nullable NodeJsInterpreter interpreter2) {
        if (ref2 == null) {
            NpmUtil.$$$reportNull$$$0(24);
        }
        if (project == null) {
            NpmUtil.$$$reportNull$$$0(25);
        }
        return RESOLVER.resolve(DESCRIPTOR.dereferenceIfProjectRef(project, ref2), interpreter2);
    }

    @NotNull
    public static NodePackage resolvePackageRefOrThrow(@NotNull NodePackageRef packageRef, @Nullable Project project, @Nullable NodeJsInterpreter interpreter2) throws ExecutionException {
        if (packageRef == null) {
            NpmUtil.$$$reportNull$$$0(26);
        }
        if (project != null) {
            packageRef = DESCRIPTOR.dereferenceIfProjectRef(project, packageRef);
        } else if (NpmUtil.isProjectPackageManagerPackageRef(packageRef)) {
            throw new ExecutionException(JavaScriptBundle.message((String)"node.npm.project_package_manager_disallowed_here.dialog.message", (Object[])new Object[0]));
        }
        if (StringUtil.isEmptyOrSpaces((String)packageRef.getIdentifier())) {
            throw new ExecutionException(JavaScriptBundle.message((String)"node.npm.unspecified_package_manager.dialog.message", (Object[])new Object[0]));
        }
        NodePackage npmPkg = RESOLVER.resolve(packageRef, interpreter2);
        if (npmPkg == null) {
            throw new ExecutionException(JavaScriptBundle.message((String)"node.npm.cannot_resolve_package_manager.dialog.message", (Object[])new Object[]{packageRef.getIdentifier()}));
        }
        NodePackage nodePackage = npmPkg;
        if (nodePackage == null) {
            NpmUtil.$$$reportNull$$$0(27);
        }
        return nodePackage;
    }

    @NotNull
    public static GeneralCommandLine createNpmCommandLine(@NotNull Project project, @Nullable Path workingDir, @NotNull NodeJsInterpreter interpreter2, @NotNull NpmCommand command, @NotNull List<String> arguments) throws ExecutionException {
        if (project == null) {
            NpmUtil.$$$reportNull$$$0(28);
        }
        if (interpreter2 == null) {
            NpmUtil.$$$reportNull$$$0(29);
        }
        if (command == null) {
            NpmUtil.$$$reportNull$$$0(30);
        }
        if (arguments == null) {
            NpmUtil.$$$reportNull$$$0(31);
        }
        NodePackage pkg = NpmManager.getInstance(project).getPackageOrThrow(interpreter2);
        return NpmUtil.createNpmCommandLine(workingDir, interpreter2, pkg, command, arguments);
    }

    @NotNull
    public static GeneralCommandLine createNpmCommandLine(@Nullable Path workingDir, @NotNull NodeJsInterpreter interpreter2, @NotNull NodePackage npmPackage, @Nullable NpmCommand command, @NotNull List<String> arguments) throws ExecutionException {
        if (interpreter2 == null) {
            NpmUtil.$$$reportNull$$$0(32);
        }
        if (npmPackage == null) {
            NpmUtil.$$$reportNull$$$0(33);
        }
        if (arguments == null) {
            NpmUtil.$$$reportNull$$$0(34);
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        NpmUtil.configureNpmCommandLine(commandLine, workingDir, interpreter2, npmPackage, command, arguments);
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            NpmUtil.$$$reportNull$$$0(35);
        }
        return generalCommandLine;
    }

    public static void configureNpmCommandLine(@NotNull GeneralCommandLine commandLine, @Nullable Path workingDir, @NotNull NodeJsInterpreter interpreter2, @NotNull NodePackage npmPackage, @Nullable NpmCommand command, @NotNull List<String> arguments) throws ExecutionException {
        if (commandLine == null) {
            NpmUtil.$$$reportNull$$$0(36);
        }
        if (interpreter2 == null) {
            NpmUtil.$$$reportNull$$$0(37);
        }
        if (npmPackage == null) {
            NpmUtil.$$$reportNull$$$0(38);
        }
        if (arguments == null) {
            NpmUtil.$$$reportNull$$$0(39);
        }
        commandLine.withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE);
        NodeCommandLineUtil.configureUsefulEnvironment(commandLine);
        commandLine.withCharset(StandardCharsets.UTF_8);
        if (workingDir != null) {
            commandLine.withWorkingDirectory(workingDir);
        }
        String cliJsFilePath = NpmUtil.getValidNpmCliJsFilePath(npmPackage, interpreter2);
        commandLine.addParameter(cliJsFilePath);
        if (command != null) {
            boolean yarn = NpmUtil.isYarnAlikePackage(npmPackage);
            commandLine.addParameter(command.getCliOption(yarn));
            if ((command == NpmCommand.RUN_SCRIPT || command == NpmCommand.TEST || command == NpmCommand.INSTALL || command == NpmCommand.UPDATE) && npmPackage.getName().equals(NPM_PACKAGE_NAME)) {
                commandLine.addParameter("--scripts-prepend-node-path=auto");
            }
            NodeCommandLineUtil.prependNodeDirToPATH(commandLine, interpreter2);
        }
        commandLine.addParameters(arguments);
        NodeCommandLineConfigurator.find(interpreter2).configure(commandLine);
    }

    @Nullable
    @NlsSafe
    public static String getInstallSaveOption(@NotNull NodePackageRef packageRef, boolean asDevDependency) {
        if (packageRef == null) {
            NpmUtil.$$$reportNull$$$0(40);
        }
        boolean yarn = NpmUtil.isYarnAlikePackageRef(packageRef);
        if (asDevDependency) {
            return yarn ? "--dev" : "--save-dev";
        }
        return yarn ? null : "--save";
    }

    public static void configureNpmCommand(@NotNull NodeTargetRun targetRun, @NotNull NodePackageRef npmPackageRef, @Nullable Path workingDirectory, @Nullable NpmCommand command, @NotNull List<String> arguments, @Nullable Runnable onNpmPackageRefResolved) throws ExecutionException {
        NodePackage npmPkg;
        if (targetRun == null) {
            NpmUtil.$$$reportNull$$$0(41);
        }
        if (npmPackageRef == null) {
            NpmUtil.$$$reportNull$$$0(42);
        }
        if (arguments == null) {
            NpmUtil.$$$reportNull$$$0(43);
        }
        if ((npmPkg = NpmUtil.resolveRef(npmPackageRef, targetRun.getProject(), targetRun.getInterpreter())) == null) {
            if (NpmUtil.isProjectPackageManagerPackageRef(npmPackageRef)) {
                String message = JavaScriptBundle.message((String)"npm.dialog.message.cannot.resolve.package.manager", (Object[])new Object[]{NpmManager.getInstance(targetRun.getProject()).getPackageRef().getIdentifier()});
                throw new NpmManager.InvalidNpmPackageException(targetRun.getProject(), new HtmlBuilder().append(message).append((HtmlChunk)HtmlChunk.br()).appendRaw(JavaScriptBundle.message((String)"please.specify.package.manager", (Object[])new Object[0])).toString(), onNpmPackageRefResolved);
            }
            throw new ExecutionException(JavaScriptBundle.message((String)"npm.dialog.message.cannot.resolve.package.manager", (Object[])new Object[]{npmPackageRef.getIdentifier()}));
        }
        NpmUtil.configureNpmCommand(targetRun, npmPkg, workingDirectory, command, arguments);
    }

    public static void configureNpmCommand(@NotNull NodeTargetRun targetRun, @NotNull NodePackage npmPackage, @Nullable Path workingDirectory, @Nullable NpmCommand command, @NotNull List<String> arguments) throws ExecutionException {
        if (targetRun == null) {
            NpmUtil.$$$reportNull$$$0(44);
        }
        if (npmPackage == null) {
            NpmUtil.$$$reportNull$$$0(45);
        }
        if (arguments == null) {
            NpmUtil.$$$reportNull$$$0(46);
        }
        TargetedCommandLineBuilder commandLineBuilder = targetRun.getCommandLineBuilder();
        if (workingDirectory != null) {
            commandLineBuilder.setWorkingDirectory(targetRun.path(workingDirectory.toString()));
        }
        targetRun.setEnableWrappingWithYarnNode(false);
        NpmNodePackage.configureNpmPackage(targetRun, npmPackage, new String[0]);
        if (command != null) {
            boolean yarn = NpmUtil.isYarnAlikePackage(npmPackage);
            if (command == NpmCommand.PUBLISH && yarn) {
                commandLineBuilder.addParameters(new String[]{NPM_PACKAGE_NAME, "publish"});
            } else {
                commandLineBuilder.addParameter(command.getCliOption(yarn));
            }
        }
        commandLineBuilder.addParameters(arguments);
    }

    @ApiStatus.Experimental
    public static void prepareImplicitPackageManagerRun(@NotNull NodeTargetRun targetRun, @NotNull NodePackage npmPkg) throws ExecutionException {
        if (targetRun == null) {
            NpmUtil.$$$reportNull$$$0(47);
        }
        if (npmPkg == null) {
            NpmUtil.$$$reportNull$$$0(48);
        }
        if (!TrustedProjects.isProjectTrusted((Project)targetRun.getProject())) {
            throw new ExecutionException("Cannot execute package manager '" + npmPkg.getName() + "' in the untrusted project");
        }
        NpmUtil.silenceCorepack(targetRun);
    }

    private static void silenceCorepack(@NotNull NodeTargetRun targetRun) {
        if (targetRun == null) {
            NpmUtil.$$$reportNull$$$0(49);
        }
        targetRun.getCommandLineBuilder().addEnvironmentVariable("COREPACK_ENABLE_AUTO_PIN", "0");
        targetRun.getCommandLineBuilder().addEnvironmentVariable("COREPACK_ENABLE_STRICT", "0");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 4, 5, 8, 9, 11, 15, 16, 17, 18, 19, 20, 21, 22, 24, 25, 26, 28, 29, 30, 31, 32, 33, 34, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/npm/NpmUtil";
                break;
            }
            case 1: 
            case 26: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageRef";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterField";
                break;
            }
            case 4: 
            case 5: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageManagerPkg";
                break;
            }
            case 8: 
            case 29: 
            case 32: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 9: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 11: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "npmPkg";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageManagerPkgRef";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bunPkg";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 31: 
            case 34: 
            case 39: 
            case 43: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 33: 
            case 38: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "npmPackage";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 41: 
            case 44: 
            case 47: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetRun";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "npmPackageRef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createProjectPackageManagerPackageRef";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/npm/NpmUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageManagerPackageFieldLabelText";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidNpmCliJsFilePath";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getWslLinuxPath";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getStaticMainJsRelativePath";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "findBinCliFile";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "resolvePackageRefOrThrow";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "createNpmCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isProjectPackageManagerPackageRef";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createPackageManagerPackageField";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getValidNpmCliJsFilePath";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getWslLinuxPath";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getStaticMainJsRelativePath";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isYarnAlikePackageRef";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isPnpmPackageRef";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isBunPackageRef";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isBunPackage";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createNodeInterpreterForBun";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isYarnAlikePackage";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isPnpmPackage";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findBinCliFile";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "resolveRef";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "resolvePackageRefOrThrow";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createNpmCommandLine";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "configureNpmCommandLine";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getInstallSaveOption";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "configureNpmCommand";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "prepareImplicitPackageManagerRun";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "silenceCorepack";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 4, 5, 8, 9, 11, 15, 16, 17, 18, 19, 20, 21, 22, 24, 25, 26, 28, 29, 30, 31, 32, 33, 34, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49 -> new IllegalArgumentException(string);
        };
    }
}

