/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.el.util;

import com.intellij.javaee.el.ELBinaryExpression;
import com.intellij.javaee.el.ELElementProcessor;
import com.intellij.javaee.el.ELExpressionHolder;
import com.intellij.javaee.el.ElMethodSignatureFilter;
import com.intellij.javaee.el.ImplicitVariableWithCustomResolve;
import com.intellij.javaee.el.TypedELExpression;
import com.intellij.javaee.el.impl.ELExpressionBase;
import com.intellij.javaee.el.providers.ELContextProvider;
import com.intellij.javaee.el.providers.ElContextProviderEx;
import com.intellij.javaee.el.providers.ElMetaDataTypeProvider;
import com.intellij.javaee.el.providers.ElVariablesProvider;
import com.intellij.javaee.el.psi.ELExpression;
import com.intellij.javaee.el.psi.ELFunctionCallExpression;
import com.intellij.javaee.el.psi.ELLambdaExpression;
import com.intellij.javaee.el.psi.ELLiteralExpression;
import com.intellij.javaee.el.psi.ELMethodCallExpression;
import com.intellij.javaee.el.psi.ELSelectExpression;
import com.intellij.javaee.el.psi.ELSliceExpression;
import com.intellij.javaee.el.psi.ELUnaryExpression;
import com.intellij.javaee.el.psi.ELVariable;
import com.intellij.javaee.el.util.ElComponentTypeUtil;
import com.intellij.javaee.el.util.PropertyAccessorMethodSignatureFilter;
import com.intellij.javaee.el.util.processors.ELElementResolveProcessor;
import com.intellij.javaee.el.util.processors.PsiTypeELElementProcessor;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.PropertiesReferenceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.scope.processor.MethodResolveProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ELResolveUtil {
    public static final Key<PsiType> EL_VARS_TYPE = Key.create((String)"el var type");
    public static final Key<PsiSubstitutor> SUBSTITUTOR = Key.create((String)"substitutor");
    public static final Logger LOG = Logger.getInstance(ELResolveUtil.class);
    @NonNls
    private static final String SERVLET_PACKAGE_JAVAX = "javax.servlet";
    @NonNls
    private static final String SERVLET_PACKAGE_JAKARTA = "jakarta.servlet";
    @NonNls
    private static final String WRAPPER_CLASS_SUFFIX = "Wrapper";
    @NonNls
    private static final String SERVLET_HTTP_PACKAGE_JAVAX = "javax.servlet.http.";
    @NonNls
    private static final String SERVLET_HTTP_PACKAGE_JAKARTA = "jakarta.servlet.http.";
    private static final Key<Boolean> STATIC_CONTEXT = Key.create((String)"el.static.context");

    @Nullable
    public static ELExpression getContext(PsiElement element) {
        PsiElement parent = element.getParent();
        if (parent instanceof ELSelectExpression && ((ELSelectExpression)parent).getField() == element) {
            return ((ELSelectExpression)parent).getFrom();
        }
        if (parent instanceof ELSliceExpression && ((ELSliceExpression)parent).getIndex() == element) {
            return ((ELSliceExpression)parent).getFrom();
        }
        if (parent instanceof ELMethodCallExpression && ((ELMethodCallExpression)parent).getMethod() == element) {
            return ((ELMethodCallExpression)parent).getQualifier();
        }
        if (parent instanceof ELBinaryExpression) {
            return ELResolveUtil.getContext(parent);
        }
        return null;
    }

    public static void evaluate(PsiType type, ELElementProcessor processor, @NotNull ElMethodSignatureFilter methodSignature) {
        String qualifiedName;
        if (methodSignature == null) {
            ELResolveUtil.$$$reportNull$$$0(0);
        }
        if (!(type instanceof PsiClassType) || !type.isValid()) {
            return;
        }
        PsiClassType.ClassResolveResult classResolveResult = ((PsiClassType)type).resolveGenerics();
        PsiClass psiClass = classResolveResult.getElement();
        if (psiClass == null) {
            return;
        }
        PsiElement parent = psiClass.getParent();
        if (parent instanceof PsiJavaFile && (SERVLET_PACKAGE_JAVAX.equals(qualifiedName = ((PsiJavaFile)parent).getPackageName()) || SERVLET_PACKAGE_JAKARTA.equals(qualifiedName))) {
            for (PsiClass inheritor : ClassInheritorsSearch.search((PsiClass)psiClass, (boolean)false).asIterable()) {
                if (inheritor.getName() == null || inheritor.getQualifiedName() == null || inheritor.getName().endsWith(WRAPPER_CLASS_SUFFIX) || !inheritor.getQualifiedName().startsWith(SERVLET_HTTP_PACKAGE_JAVAX) && !inheritor.getQualifiedName().startsWith(SERVLET_HTTP_PACKAGE_JAKARTA)) continue;
                psiClass = inheritor;
                break;
            }
        }
        PsiSubstitutor mySubstitutor = classResolveResult.getSubstitutor();
        mySubstitutor = ElComponentTypeUtil.fillSubstitutionMapFromSupers(psiClass, mySubstitutor);
        processor.setSubstitutor(mySubstitutor);
        ELResolveUtil.iterateClassProperties(psiClass, processor, methodSignature);
    }

    public static boolean iterateClassProperties(PsiClass psiClass, ELElementProcessor processor, @NotNull ElMethodSignatureFilter signature) {
        PsiMethod[] methods;
        PsiModifierList modifierList;
        if (signature == null) {
            ELResolveUtil.$$$reportNull$$$0(1);
        }
        boolean myClassIsAbstract = psiClass.isInterface() || (modifierList = psiClass.getModifierList()) != null && modifierList.hasModifierProperty("abstract");
        for (PsiMethod method : methods = MethodResolveProcessor.getAllMethods((PsiClass)psiClass)) {
            if (!method.hasModifierProperty("public") || method.isConstructor() || !myClassIsAbstract && method.hasModifierProperty("abstract") || !signature.isAcceptable(method) || processor.processMethod(method)) continue;
            return false;
        }
        if (signature.shouldProcessFields()) {
            HashSet<String> processedFields = new HashSet<String>();
            for (PsiField field : psiClass.getAllFields()) {
                if (!field.hasModifierProperty("public") || !processedFields.add(field.getName()) || processor.processField(field)) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    private static PsiType getContextType(@Nullable PsiElement resolvedContext) {
        if (resolvedContext == null) {
            return null;
        }
        if (resolvedContext instanceof PsiExpression && !(resolvedContext instanceof PsiLiteralExpression)) {
            return ((PsiExpression)resolvedContext).getType();
        }
        if (resolvedContext instanceof PsiMethod) {
            PsiMethod psiMethod = (PsiMethod)resolvedContext;
            PsiType type = psiMethod.getReturnType();
            PsiSubstitutor psiSubstitutor = (PsiSubstitutor)psiMethod.getUserData(SUBSTITUTOR);
            if (psiSubstitutor != null) {
                while (type instanceof PsiClassReferenceType) {
                    PsiType originalType = type;
                    PsiClassType.ClassResolveResult classResolveResult = ((PsiClassReferenceType)originalType).resolveGenerics();
                    PsiClass returnedPsiClass = classResolveResult.getElement();
                    if (!(returnedPsiClass instanceof PsiTypeParameter)) {
                        PsiTypeParameter[] returnedClassTypeParameters;
                        if (returnedPsiClass == null || (returnedClassTypeParameters = returnedPsiClass.getTypeParameters()).length == 0) break;
                        String qName = returnedPsiClass.getQualifiedName();
                        StringBuilder builder = new StringBuilder();
                        builder.append(qName).append('<');
                        int builderLengthBeforeAppendingTypeParameters = builder.length();
                        LinkedHashSet<PsiTypeParameter> paramsUsedInMethodReturnType = new LinkedHashSet<PsiTypeParameter>();
                        for (PsiType substitutionType : classResolveResult.getSubstitutor().getSubstitutionMap().values()) {
                            PsiClass psiClass;
                            if (!(substitutionType instanceof PsiClassType) || !((psiClass = ((PsiClassType)substitutionType).resolve()) instanceof PsiTypeParameter)) continue;
                            paramsUsedInMethodReturnType.add((PsiTypeParameter)psiClass);
                        }
                        if (paramsUsedInMethodReturnType.isEmpty()) break;
                        for (PsiTypeParameter containingClassTypeParameter : paramsUsedInMethodReturnType) {
                            PsiType psiType;
                            if (builderLengthBeforeAppendingTypeParameters != builder.length()) {
                                builder.append(',');
                            }
                            builder.append((psiType = psiSubstitutor.substitute(containingClassTypeParameter)) != null ? psiType.getCanonicalText() : "java.lang.Object");
                        }
                        builder.append('>');
                        try {
                            return JavaPsiFacade.getInstance((Project)returnedPsiClass.getProject()).getElementFactory().createTypeFromText(builder.toString(), null);
                        }
                        catch (IncorrectOperationException e) {
                            LOG.warn((Throwable)e);
                            return null;
                        }
                    }
                    type = psiSubstitutor.substitute((PsiTypeParameter)returnedPsiClass);
                    if (type != null) continue;
                    type = psiSubstitutor.substitute(originalType);
                }
            }
            return type;
        }
        if (resolvedContext instanceof PsiVariable) {
            return (PsiType)RecursionManager.doPreventingRecursion((Object)resolvedContext, (boolean)true, () -> ((PsiVariable)resolvedContext).getType());
        }
        return (PsiType)resolvedContext.getUserData(EL_VARS_TYPE);
    }

    @Nullable
    public static PsiType resolveContextAsType(ELExpression context) {
        if (context instanceof ELSelectExpression) {
            PsiType fromResolved;
            PsiType componentType;
            PsiType type;
            ELSelectExpression expression = (ELSelectExpression)context;
            ELVariable field = expression.getField();
            PsiType psiType = type = field != null ? ELResolveUtil.getContextType(field.getReferences()[0].resolve()) : null;
            if (type == null && field != null && (componentType = ElComponentTypeUtil.evaluateComponentType(fromResolved = ELResolveUtil.resolveContextAsType(expression.getFrom()), (PsiElement)context)) != null) {
                return componentType;
            }
            return type;
        }
        if (context instanceof ELMethodCallExpression) {
            ELVariable field = ((ELMethodCallExpression)context).getMethod();
            return field != null ? ELResolveUtil.getContextType(field.getReferences()[0].resolve()) : null;
        }
        if (context instanceof ELVariable) {
            PsiElement resolve = context.getReferences()[0].resolve();
            if (resolve instanceof PsiClass) {
                context.putUserData(STATIC_CONTEXT, Boolean.TRUE);
                return PsiTypesUtil.getClassType((PsiClass)((PsiClass)resolve));
            }
            context.putUserData(STATIC_CONTEXT, null);
            return ELResolveUtil.getContextType(resolve);
        }
        if (context instanceof ELSliceExpression) {
            PsiType fromResolved = ELResolveUtil.resolveContextAsType(((ELSliceExpression)context).getFrom());
            ELExpression index = ((ELSliceExpression)context).getIndex();
            if (fromResolved != null) {
                PsiType componentType = ElComponentTypeUtil.evaluateComponentType(fromResolved, (PsiElement)context);
                if (componentType != null) {
                    return componentType;
                }
                if (index instanceof ELLiteralExpression) {
                    String text = index.getText();
                    PsiTypeELElementProcessor processor = new PsiTypeELElementProcessor(text);
                    ELResolveUtil.evaluate(fromResolved, processor, new PropertyAccessorMethodSignatureFilter(true));
                    return processor.getResult();
                }
            }
        } else if (context instanceof ELFunctionCallExpression) {
            ELVariable method = ((ELFunctionCallExpression)context).getMethod();
            if (method == null) {
                return null;
            }
            PsiElement psiElement = method.getReferences()[0].resolve();
            if (psiElement instanceof PsiMetaData) {
                for (ElMetaDataTypeProvider metaDataTypeProvider : ElMetaDataTypeProvider.EL_PSI_META_DATA_TYPE_PROVIDER.getExtensionList()) {
                    PsiType providerType = metaDataTypeProvider.getType((PsiMetaData)psiElement);
                    if (providerType == null) continue;
                    return providerType;
                }
            }
        } else {
            Class typeClass;
            if (context instanceof TypedELExpression) {
                return ((TypedELExpression)((Object)context)).getType();
            }
            if (context instanceof ELExpressionBase && (typeClass = ((ELExpressionBase)context).getTypeClass()) != null) {
                return PsiType.getTypeByName((String)typeClass.getName(), (Project)context.getProject(), (GlobalSearchScope)GlobalSearchScope.allScope((Project)context.getProject()));
            }
        }
        return null;
    }

    private static boolean isSpecialType(PsiClass psiClass, PsiFile psiFile, String clazzName) {
        String qualifiedName = psiClass.getQualifiedName();
        if (clazzName.equals(qualifiedName)) {
            return true;
        }
        PsiClass listClass = ElComponentTypeUtil.getCachedClass(psiFile, clazzName);
        return listClass != null && psiClass.isInheritor(listClass, true);
    }

    public static boolean isMapOrListSpecialType(PsiClass psiClass, PsiFile psiFile) {
        return ELResolveUtil.isSpecialType(psiClass, psiFile, "java.util.List") || !ELResolveUtil.isSpecialType(psiClass, psiFile, "java.util.Properties") && ELResolveUtil.isSpecialType(psiClass, psiFile, "java.util.Map");
    }

    public static boolean isJspContext(PsiElement element) {
        PsiElement parent = element.getParent();
        ELExpressionHolder expressionHolder = (ELExpressionHolder)PsiTreeUtil.getParentOfType((PsiElement)parent, ELExpressionHolder.class);
        return expressionHolder != null && !expressionHolder.isJSFELHolder();
    }

    public static void process(PsiElement element, ELElementProcessor processor) {
        ELExpression context = ELResolveUtil.getContext(element);
        if (context == null) {
            ELLambdaExpression lambdaExpression = (ELLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)element, ELLambdaExpression.class);
            if (lambdaExpression != null) {
                for (ELVariable variable : lambdaExpression.getVariables()) {
                    processor.processVariable(variable);
                }
            }
            ELResolveUtil.processEmptyContext(element, processor);
        } else {
            boolean b;
            PsiElement contextResolve;
            ELVariable field;
            PsiReference[] references = context.getReferences();
            if (context instanceof ELSelectExpression && (field = ((ELSelectExpression)context).getField()) != null) {
                references = field.getReferences();
            }
            PsiElement psiElement = contextResolve = references.length > 0 ? references[0].resolve() : null;
            if (contextResolve instanceof ImplicitVariableWithCustomResolve && (b = ((ImplicitVariableWithCustomResolve)contextResolve).process((ELExpression)element, processor))) {
                return;
            }
            PsiType resolvedContext = ELResolveUtil.resolveContextAsType(context);
            if (resolvedContext != null) {
                if (resolvedContext instanceof PsiClassType && resolvedContext.isValid()) {
                    String qName;
                    PsiTypeParameter tp;
                    PsiClassType[] classTypes;
                    PsiClass psiClass;
                    PsiClassType.ClassResolveResult classResolveResult = ((PsiClassType)resolvedContext).resolveGenerics();
                    PsiClass psiClass2 = psiClass = classResolveResult.isValidResult() ? classResolveResult.getElement() : null;
                    if (psiClass instanceof PsiTypeParameter && (classTypes = (tp = (PsiTypeParameter)psiClass).getExtendsList().getReferencedTypes()).length > 0) {
                        resolvedContext = classTypes[0];
                        psiClass = classTypes[0].resolve();
                    }
                    String string = qName = psiClass != null ? psiClass.getQualifiedName() : null;
                    if ("java.util.PropertyResourceBundle".equals(qName) || "java.util.Properties".equals(qName)) {
                        ELResolveUtil.processProperties(element, processor);
                    } else if (element.getParent() instanceof ELSliceExpression && psiClass != null && ELResolveUtil.isMapOrListSpecialType(psiClass, element.getContainingFile())) {
                        ELResolveUtil.processEmptyContext(element, processor);
                    } else if (!(element.getParent() instanceof ELSliceExpression) || !(element instanceof ELVariable)) {
                        ElMethodSignatureFilter signature = ELResolveUtil.getMethodSignatureFilter(element, context);
                        ELResolveUtil.evaluate(resolvedContext, processor, signature);
                        if (element instanceof ELLiteralExpression) {
                            ELResolveUtil.processProperties(element, processor);
                        }
                    }
                } else if (resolvedContext instanceof PsiArrayType) {
                    ELResolveUtil.processEmptyContext(element, processor);
                }
            } else if (element instanceof ELLiteralExpression) {
                ELResolveUtil.processProperties(element, processor);
            }
        }
    }

    private static void processProperties(PsiElement element, ELElementProcessor processor) {
        PsiManager psiManager = element.getManager();
        String key = processor.getNameHint();
        if (key != null) {
            IProperty property;
            Iterator iterator = PropertiesImplUtil.findPropertiesByKey((Project)psiManager.getProject(), (String)key).iterator();
            while (iterator.hasNext() && processor.processProperty(property = (IProperty)iterator.next())) {
            }
            return;
        }
        PropertiesReferenceManager.getInstance((Project)element.getProject()).processAllPropertiesFiles((baseName, propertiesFile) -> {
            for (IProperty property : propertiesFile.getProperties()) {
                if (processor.processProperty(property)) continue;
                return false;
            }
            return true;
        });
    }

    private static ElMethodSignatureFilter getMethodSignatureFilter(final PsiElement element, final @NotNull ELExpression context) {
        if (context == null) {
            ELResolveUtil.$$$reportNull$$$0(2);
        }
        ELExpressionHolder holder = (ELExpressionHolder)PsiTreeUtil.getParentOfType((PsiElement)element, ELExpressionHolder.class);
        assert (holder != null);
        final ELContextProvider contextProvider = ELResolveUtil.getELContextData(holder);
        if (contextProvider != null) {
            return new ElMethodSignatureFilter(){

                @Override
                public boolean isAcceptable(PsiMethod method) {
                    if (!contextProvider.acceptMethod(method, context, element)) {
                        return false;
                    }
                    boolean propertyGetter = PropertyUtilBase.isSimplePropertyGetter((PsiMethod)method);
                    if (contextProvider.acceptsGetMethodForLastReference(method) && propertyGetter) {
                        return true;
                    }
                    boolean propertySetter = PropertyUtilBase.isSimplePropertySetter((PsiMethod)method);
                    if (contextProvider.acceptsSetMethodForLastReference(method) && propertySetter) {
                        return true;
                    }
                    return contextProvider.acceptsNonPropertyMethodForLastReference(method) && !propertyGetter && !propertySetter;
                }

                @Override
                public boolean shouldProcessFields() {
                    return contextProvider instanceof ElContextProviderEx ? ((ElContextProviderEx)contextProvider).shouldProcessFields() : super.shouldProcessFields();
                }
            };
        }
        Boolean staticContext = (Boolean)context.getUserData(STATIC_CONTEXT);
        if (staticContext != null) {
            return new ElMethodSignatureFilter(){

                @Override
                public boolean isAcceptable(PsiMethod method) {
                    return method.hasModifierProperty("static");
                }

                @Override
                public boolean shouldProcessFields() {
                    return true;
                }
            };
        }
        return ELResolveUtil.isJspContext(element) ? new ElMethodSignatureFilter(){

            @Override
            public boolean isAcceptable(PsiMethod method) {
                if (method.hasModifierProperty("static")) {
                    return false;
                }
                return !PropertyUtilBase.isSimplePropertySetter((PsiMethod)method);
            }

            @Override
            @Nullable
            public String getSignature() {
                return null;
            }
        } : ElMethodSignatureFilter.ANY;
    }

    private static void processEmptyContext(PsiElement element, ELElementProcessor processor) {
        ELExpressionHolder expressionHolder = (ELExpressionHolder)PsiTreeUtil.getParentOfType((PsiElement)element, ELExpressionHolder.class);
        assert (expressionHolder != null);
        if (!ELResolveUtil.processJavaClasses(processor, expressionHolder)) {
            return;
        }
        ELContextProvider data = ELResolveUtil.getELContextData(expressionHolder);
        if (data != null) {
            String nameHint = processor.getNameHint();
            Iterator<? extends PsiVariable> iterator = data.getTopLevelElVariables(nameHint);
            if (iterator != null) {
                while (iterator.hasNext() && processor.processVariable(iterator.next())) {
                }
            }
            Collection<PsiMethod> methods = data.getRootMethods(nameHint);
            for (PsiMethod method : methods) {
                if (!processor.processMethod(method)) break;
            }
            if (iterator != null || !methods.isEmpty()) {
                return;
            }
        }
        List list = ElVariablesProvider.EL_IMPLICIT_VARIABLES_PROVIDER.getExtensionList().stream().sorted((o1, o2) -> Byte.compare(o2.getPriority(), o1.getPriority())).toList();
        for (ElVariablesProvider provider : list) {
            if (provider.processImplicitVariables(element, expressionHolder, processor)) continue;
            return;
        }
    }

    private static boolean processJavaClasses(ELElementProcessor processor, ELExpressionHolder expressionHolder) {
        PsiImportList importList;
        PsiFile file = expressionHolder.getContainingFile();
        PsiJavaFile javaFile = (PsiJavaFile)file.getViewProvider().getPsi((Language)JavaLanguage.INSTANCE);
        if (javaFile != null && (importList = javaFile.getImportList()) != null) {
            PsiImportStatement[] statements;
            for (PsiImportStatement statement : statements = importList.getImportStatements()) {
                PsiElement resolve = statement.resolve();
                if (!(resolve instanceof PsiClass) || processor.processClass((PsiClass)resolve, statement)) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    public static ELContextProvider getELContextData(@NotNull ELExpressionHolder expressionHolder) {
        if (expressionHolder == null) {
            ELResolveUtil.$$$reportNull$$$0(3);
        }
        ELContextProvider data = (ELContextProvider)expressionHolder.getUserData(ELContextProvider.ourContextProviderKey);
        PsiElement expressionHolderParent = expressionHolder.getParent();
        if (data == null && expressionHolderParent instanceof ELExpressionHolder) {
            expressionHolder = (ELExpressionHolder)expressionHolderParent;
            expressionHolderParent = expressionHolder.getParent();
        }
        if (data == null && expressionHolderParent instanceof PsiFile) {
            PsiElement context = expressionHolderParent.getContext();
            ELContextProvider eLContextProvider = data = context != null ? (ELContextProvider)context.getUserData(ELContextProvider.ourContextProviderKey) : null;
            if (data == null) {
                data = (ELContextProvider)expressionHolderParent.getUserData(ELContextProvider.ourContextProviderKey);
            }
        }
        if (data == null) {
            for (ElContextProviderEx contextProvider : ElContextProviderEx.EXTENSION_POINT.getExtensionList()) {
                if (!contextProvider.accept(expressionHolder)) continue;
                return contextProvider;
            }
        }
        return data;
    }

    public static boolean allowPropertyMethodName(PsiElement psiElement) {
        String text;
        PsiElement parent = psiElement.getParent();
        if (ELResolveUtil.canBeRootMethodExpression(parent)) {
            return true;
        }
        ELExpressionHolder expressionHolder = (ELExpressionHolder)PsiTreeUtil.getParentOfType((PsiElement)parent, ELExpressionHolder.class);
        if (expressionHolder != null && !expressionHolder.isJSFELHolder()) {
            return false;
        }
        return parent instanceof ELSelectExpression && ((text = psiElement.getText()).startsWith("get") || text.startsWith("set") || text.startsWith("is"));
    }

    private static boolean canBeRootMethodExpression(PsiElement parent) {
        if (parent instanceof ELExpressionHolder) {
            return true;
        }
        if (parent instanceof ELUnaryExpression && parent.getParent() instanceof ELMethodCallExpression) {
            return true;
        }
        return parent instanceof ELBinaryExpression && parent.getParent() instanceof ELExpressionHolder;
    }

    public static ResolveResult @NotNull [] resolveElement(PsiElement element, Class<? extends PsiElement> targetClass) {
        String text = StringUtil.unquoteString((String)element.getText());
        ELElementResolveProcessor resolveProcessor = new ELElementResolveProcessor(element, text, targetClass);
        ELResolveUtil.process(element, resolveProcessor);
        ResolveResult[] resolveResultArray = resolveProcessor.getResult().toArray(ResolveResult.EMPTY_ARRAY);
        if (resolveResultArray == null) {
            ELResolveUtil.$$$reportNull$$$0(4);
        }
        return resolveResultArray;
    }

    public static boolean isSoftContext(ELExpression context, PsiFile psiFile) {
        PsiClassType.ClassResolveResult resolveResult;
        PsiClass psiClass;
        PsiElement contextResolve;
        if (context == null) {
            return false;
        }
        PsiReference[] references = context.getReferences();
        PsiElement psiElement = contextResolve = references.length > 0 ? references[0].resolve() : null;
        if (contextResolve instanceof ImplicitVariableWithCustomResolve) {
            return false;
        }
        PsiType psiType = ELResolveUtil.resolveContextAsType(context);
        if (psiType instanceof PsiArrayType) {
            return true;
        }
        if (psiType instanceof PsiClassType && (psiClass = (resolveResult = psiType.isValid() ? ((PsiClassType)psiType).resolveGenerics() : PsiClassType.ClassResolveResult.EMPTY).getElement()) != null) {
            String qualifiedName = psiClass.getQualifiedName();
            if (ELResolveUtil.isMapOrListSpecialType(psiClass, psiFile)) {
                return true;
            }
            if (!"java.lang.Object".equals(qualifiedName)) {
                return false;
            }
        }
        return true;
    }

    public static boolean isFromInjectedEL(ELExpression variable) {
        ELExpressionHolder expressionHolder = (ELExpressionHolder)PsiTreeUtil.getParentOfType((PsiElement)variable, ELExpressionHolder.class);
        assert (expressionHolder != null);
        PsiElement parent = expressionHolder.getParent();
        if (parent instanceof PsiFile) {
            return true;
        }
        return parent.getParent() instanceof PsiFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodSignature";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionHolder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/el/util/ELResolveUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/el/util/ELResolveUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "evaluate";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "iterateClassProperties";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getMethodSignatureFilter";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getELContextData";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

