/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.util;

import com.intellij.dupLocator.AbstractMatchingVisitor;
import com.intellij.dupLocator.DefaultDuplocatorState;
import com.intellij.dupLocator.DuplicatesProfile;
import com.intellij.dupLocator.DuplocatorState;
import com.intellij.dupLocator.ExternalizableDuplocatorState;
import com.intellij.dupLocator.MultilanguageDuplocatorSettings;
import com.intellij.dupLocator.PsiElementRole;
import com.intellij.dupLocator.equivalence.EquivalenceDescriptor;
import com.intellij.dupLocator.equivalence.EquivalenceDescriptorProvider;
import com.intellij.dupLocator.equivalence.MultiChildDescriptor;
import com.intellij.dupLocator.equivalence.SingleChildDescriptor;
import com.intellij.dupLocator.iterators.FilteringNodeIterator;
import com.intellij.dupLocator.iterators.SiblingNodeIterator;
import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.lang.Language;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CharArrayUtil;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DuplocatorUtil {
    private DuplocatorUtil() {
    }

    public static boolean isIgnoredNode(PsiElement element) {
        if (element instanceof PsiWhiteSpace || element instanceof PsiErrorElement || element instanceof PsiComment) {
            return true;
        }
        if (!(element instanceof LeafElement)) {
            return false;
        }
        if (CharArrayUtil.containsOnlyWhiteSpaces((CharSequence)element.getText())) {
            return true;
        }
        EquivalenceDescriptorProvider descriptorProvider = EquivalenceDescriptorProvider.getInstance(element);
        if (descriptorProvider == null) {
            return false;
        }
        IElementType elementType = ((LeafElement)element).getElementType();
        return descriptorProvider.getIgnoredTokens().contains(elementType);
    }

    public static PsiElement getOnlyChild(PsiElement element, @NotNull NodeFilter filter) {
        FilteringNodeIterator it;
        PsiElement child;
        if (filter == null) {
            DuplocatorUtil.$$$reportNull$$$0(0);
        }
        if ((child = (it = new FilteringNodeIterator(SiblingNodeIterator.create(element.getFirstChild()), filter)).current()) != null) {
            it.advance();
            if (!it.hasNext()) {
                return child;
            }
        }
        return element;
    }

    public static boolean shouldSkip(PsiElement element, PsiElement elementToMatchWith) {
        if (element == null || elementToMatchWith == null) {
            return false;
        }
        if (element.getClass() == elementToMatchWith.getClass()) {
            return false;
        }
        return element.getFirstChild() == null && element.getTextLength() == 0 && !(element instanceof LeafElement);
    }

    @Contract(value="null, _, _ -> null;!null, _, _ -> !null;")
    @Nullable
    public static PsiElement skipNodeIfNecessary(PsiElement element, EquivalenceDescriptor descriptor, NodeFilter filter) {
        EquivalenceDescriptorProvider provider;
        if (element == null) {
            return null;
        }
        if (descriptor == null && (provider = EquivalenceDescriptorProvider.getInstance(element)) != null) {
            descriptor = provider.buildDescriptor(element);
        }
        if (descriptor != null) {
            PsiElement onlyChild = DuplocatorUtil.getOnlyChildFromDescriptor(descriptor, filter);
            return onlyChild != null ? onlyChild : element;
        }
        return DuplocatorUtil.getOnlyChild(element, filter);
    }

    @Nullable
    private static PsiElement getOnlyChildFromDescriptor(EquivalenceDescriptor equivalenceDescriptor, NodeFilter filter) {
        PsiElement[] codeBlock;
        if (!equivalenceDescriptor.getConstants().isEmpty()) {
            return null;
        }
        List<SingleChildDescriptor> singleChildren = equivalenceDescriptor.getSingleChildDescriptors();
        List<MultiChildDescriptor> multiChildren = equivalenceDescriptor.getMultiChildDescriptors();
        List<PsiElement[]> codeBlocks = equivalenceDescriptor.getCodeBlocks();
        if (singleChildren.size() + multiChildren.size() + codeBlocks.size() != 1) {
            return null;
        }
        if (!singleChildren.isEmpty()) {
            SingleChildDescriptor descriptor = singleChildren.get(0);
            PsiElement child = descriptor.getElement();
            if (child != null) {
                SingleChildDescriptor.MyType type = descriptor.getType();
                if (type == SingleChildDescriptor.MyType.DEFAULT) {
                    return child;
                }
                if (type == SingleChildDescriptor.MyType.CHILDREN || type == SingleChildDescriptor.MyType.CHILDREN_IN_ANY_ORDER) {
                    return DuplocatorUtil.getOnlyChild(child, filter);
                }
            }
        } else if (!multiChildren.isEmpty()) {
            MultiChildDescriptor descriptor = multiChildren.get(0);
            PsiElement[] children = descriptor.getElements();
            if (children.length == 1 && descriptor.getType() != MultiChildDescriptor.MyType.OPTIONALLY) {
                return children[0];
            }
        } else if (!codeBlocks.isEmpty() && (codeBlock = codeBlocks.get(0)) != null && codeBlock.length == 1) {
            return codeBlock[0];
        }
        return null;
    }

    public static boolean match(@NotNull EquivalenceDescriptor descriptor1, @NotNull EquivalenceDescriptor descriptor2, @NotNull AbstractMatchingVisitor g, @NotNull Set<PsiElementRole> skippedRoles, @Nullable DuplicatesProfile profile) {
        Object childDescriptor2;
        Object childDescriptor1;
        int i;
        if (descriptor1 == null) {
            DuplocatorUtil.$$$reportNull$$$0(1);
        }
        if (descriptor2 == null) {
            DuplocatorUtil.$$$reportNull$$$0(2);
        }
        if (g == null) {
            DuplocatorUtil.$$$reportNull$$$0(3);
        }
        if (skippedRoles == null) {
            DuplocatorUtil.$$$reportNull$$$0(4);
        }
        if (descriptor1.getSingleChildDescriptors().size() != descriptor2.getSingleChildDescriptors().size()) {
            return false;
        }
        if (descriptor1.getMultiChildDescriptors().size() != descriptor2.getMultiChildDescriptors().size()) {
            return false;
        }
        if (descriptor1.getCodeBlocks().size() != descriptor2.getCodeBlocks().size()) {
            return false;
        }
        if (descriptor1.getConstants().size() != descriptor2.getConstants().size()) {
            return false;
        }
        int n = descriptor1.getConstants().size();
        for (i = 0; i < n; ++i) {
            childDescriptor1 = descriptor1.getConstants().get(i);
            if (Comparing.equal((Object)childDescriptor1, (Object)(childDescriptor2 = descriptor2.getConstants().get(i)))) continue;
            return false;
        }
        n = descriptor1.getSingleChildDescriptors().size();
        for (i = 0; i < n; ++i) {
            childDescriptor1 = descriptor1.getSingleChildDescriptors().get(i);
            if (DuplocatorUtil.match((SingleChildDescriptor)childDescriptor1, (SingleChildDescriptor)(childDescriptor2 = descriptor2.getSingleChildDescriptors().get(i)), g, skippedRoles, profile)) continue;
            return false;
        }
        n = descriptor1.getMultiChildDescriptors().size();
        for (i = 0; i < n; ++i) {
            childDescriptor1 = descriptor1.getMultiChildDescriptors().get(i);
            if (DuplocatorUtil.match((MultiChildDescriptor)childDescriptor1, (MultiChildDescriptor)(childDescriptor2 = descriptor2.getMultiChildDescriptors().get(i)), g)) continue;
            return false;
        }
        n = descriptor1.getCodeBlocks().size();
        for (i = 0; i < n; ++i) {
            PsiElement[] codeBlock2;
            PsiElement[] codeBlock1 = descriptor1.getCodeBlocks().get(i);
            if (g.matchSequentially(codeBlock1, codeBlock2 = descriptor2.getCodeBlocks().get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean match(@NotNull SingleChildDescriptor childDescriptor1, @NotNull SingleChildDescriptor childDescriptor2, @NotNull AbstractMatchingVisitor g, @NotNull Set<PsiElementRole> skippedRoles, @Nullable DuplicatesProfile duplicatesProfile) {
        if (childDescriptor1 == null) {
            DuplocatorUtil.$$$reportNull$$$0(5);
        }
        if (childDescriptor2 == null) {
            DuplocatorUtil.$$$reportNull$$$0(6);
        }
        if (g == null) {
            DuplocatorUtil.$$$reportNull$$$0(7);
        }
        if (skippedRoles == null) {
            DuplocatorUtil.$$$reportNull$$$0(8);
        }
        if (childDescriptor1.getType() != childDescriptor2.getType()) {
            return false;
        }
        PsiElement element1 = childDescriptor1.getElement();
        PsiElement element2 = childDescriptor2.getElement();
        if (duplicatesProfile != null) {
            PsiElementRole role2;
            PsiElementRole role1 = element1 != null ? duplicatesProfile.getRole(element1) : null;
            PsiElementRole psiElementRole = role2 = element2 != null ? duplicatesProfile.getRole(element2) : null;
            if (role1 == role2 && skippedRoles.contains((Object)role1)) {
                return true;
            }
        }
        return switch (childDescriptor1.getType()) {
            default -> throw new MatchException(null, null);
            case SingleChildDescriptor.MyType.DEFAULT -> g.match(element1, element2);
            case SingleChildDescriptor.MyType.OPTIONALLY_IN_PATTERN, SingleChildDescriptor.MyType.OPTIONALLY -> g.matchOptionally(element1, element2);
            case SingleChildDescriptor.MyType.CHILDREN -> g.matchSons(element1, element2);
            case SingleChildDescriptor.MyType.CHILDREN_OPTIONALLY_IN_PATTERN, SingleChildDescriptor.MyType.CHILDREN_OPTIONALLY -> g.matchSonsOptionally(element1, element2);
            case SingleChildDescriptor.MyType.CHILDREN_IN_ANY_ORDER -> g.matchSonsInAnyOrder(element1, element2);
        };
    }

    private static boolean match(@NotNull MultiChildDescriptor childDescriptor1, @NotNull MultiChildDescriptor childDescriptor2, @NotNull AbstractMatchingVisitor g) {
        if (childDescriptor1 == null) {
            DuplocatorUtil.$$$reportNull$$$0(9);
        }
        if (childDescriptor2 == null) {
            DuplocatorUtil.$$$reportNull$$$0(10);
        }
        if (g == null) {
            DuplocatorUtil.$$$reportNull$$$0(11);
        }
        if (childDescriptor1.getType() != childDescriptor2.getType()) {
            return false;
        }
        PsiElement[] elements1 = childDescriptor1.getElements();
        PsiElement[] elements2 = childDescriptor2.getElements();
        return switch (childDescriptor1.getType()) {
            default -> throw new MatchException(null, null);
            case MultiChildDescriptor.MyType.DEFAULT -> g.matchSequentially(elements1, elements2);
            case MultiChildDescriptor.MyType.OPTIONALLY_IN_PATTERN, MultiChildDescriptor.MyType.OPTIONALLY -> g.matchOptionally(elements1, elements2);
            case MultiChildDescriptor.MyType.IN_ANY_ORDER -> g.matchInAnyOrder(elements1, elements2);
        };
    }

    @Contract(value="null -> null")
    @Nullable
    public static DuplocatorState getDuplocatorState(PsiFragment frag) {
        if (frag == null) {
            return null;
        }
        Language language = frag.getLanguage();
        if (language == null) {
            return null;
        }
        DuplicatesProfile profile = DuplicatesProfile.findProfileForLanguage(language);
        return profile != null ? profile.getDuplocatorState(language) : null;
    }

    @NotNull
    public static ExternalizableDuplocatorState registerAndGetState(@NotNull Language language) {
        MultilanguageDuplocatorSettings settings;
        DefaultDuplocatorState state;
        if (language == null) {
            DuplocatorUtil.$$$reportNull$$$0(12);
        }
        if ((state = (settings = MultilanguageDuplocatorSettings.getInstance()).getState(language)) == null) {
            state = new DefaultDuplocatorState();
            settings.registerState(language, state);
        }
        DefaultDuplocatorState defaultDuplocatorState = state;
        if (defaultDuplocatorState == null) {
            DuplocatorUtil.$$$reportNull$$$0(13);
        }
        return defaultDuplocatorState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor1";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor2";
                break;
            }
            case 3: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skippedRoles";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childDescriptor1";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childDescriptor2";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dupLocator/util/DuplocatorUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dupLocator/util/DuplocatorUtil";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "registerAndGetState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOnlyChild";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "match";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "registerAndGetState";
                break;
            }
            case 13: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13 -> new IllegalStateException(string);
        };
    }
}

