/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.utils;

import com.intellij.cdi.beans.AbstractCdiBeanDescriptor;
import com.intellij.cdi.beans.CdiBeanDescriptor;
import com.intellij.cdi.beans.CdiBeanPsiClassDescriptor;
import com.intellij.cdi.beans.CdiCustomizationManager;
import com.intellij.cdi.beans.CdiCustomizationProvider;
import com.intellij.cdi.beans.CdiExtensionBeanDescriptor;
import com.intellij.cdi.beans.CdiImplicitBeansProvider;
import com.intellij.cdi.beans.ImplicitBeanDescriptor;
import com.intellij.cdi.beans.InjectionPointDescriptor;
import com.intellij.cdi.jam.CdiJamModel;
import com.intellij.cdi.jam.events.CdiObserves;
import com.intellij.cdi.jam.inject.CdiInject;
import com.intellij.cdi.jam.lifecycle.CdiDispose;
import com.intellij.cdi.jam.priority.Priority;
import com.intellij.cdi.jam.producers.CdiProduces;
import com.intellij.cdi.manager.CdiDescriptorsFactory;
import com.intellij.cdi.manager.CdiManager;
import com.intellij.cdi.model.xml.AlternativeClass;
import com.intellij.cdi.model.xml.Alternatives;
import com.intellij.cdi.model.xml.BeanDiscoveryMode;
import com.intellij.cdi.model.xml.Beans;
import com.intellij.cdi.model.xml.Exclude;
import com.intellij.cdi.model.xml.Scan;
import com.intellij.cdi.model.xml.StereotypeClass;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.cdi.utils.CdiManagedBeanValidationUtils;
import com.intellij.cdi.utils.CdiVersion;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.jam.JamService;
import com.intellij.java.analysis.OuterModelsModificationTrackerManager;
import com.intellij.java.library.JavaLibraryModificationTracker;
import com.intellij.javaee.constants.CdiAnnoConstants;
import com.intellij.microservices.jvm.cache.ScopedCacheValueHolder;
import com.intellij.microservices.jvm.cache.ScopedCacheValueHolders;
import com.intellij.microservices.jvm.cache.SourceLibSearchProvider;
import com.intellij.microservices.jvm.cache.UastCachedSearchUtils;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedMembersSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.DomUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UMethod;

public final class CdiInjectionUtils {
    private static final SourceLibSearchProvider<List<CdiBeanDescriptor<? extends PsiElement>>, Module> ANNOTATED_BEANS_CACHE_KEY = new SourceLibSearchProvider("ANNOTATED_CDI_BEANS_CACHE", (project, module, scope) -> CdiInjectionUtils.getAnnotatedBeans(module, scope));
    private static final SourceLibSearchProvider<List<CdiBeanDescriptor<?>>, Module> INJECTED_BEANS_CACHE_KEY = new SourceLibSearchProvider("ANNOTATED_CDI_BEANS_CACHE", (project, module, scope) -> CdiInjectionUtils.getInjectedBeans(module, scope));
    private static final List<String> INJECTION_ANNOTATIONS_BLACKLIST = Arrays.asList(CdiAnnoConstants.OBSERVES_ANNOTATION.jakarta(), CdiAnnoConstants.OBSERVES_ANNOTATION.javax(), CdiAnnoConstants.OBSERVES_ASYNC_ANNOTATION.jakarta(), CdiAnnoConstants.OBSERVES_ASYNC_ANNOTATION.javax(), CdiAnnoConstants.DISPOSES_ANNOTATION.jakarta(), CdiAnnoConstants.DISPOSES_ANNOTATION.javax(), CdiAnnoConstants.DELEGATE_ANNOTATION.jakarta(), CdiAnnoConstants.DELEGATE_ANNOTATION.javax());

    private CdiInjectionUtils() {
    }

    @NotNull
    public static Set<InjectionPointDescriptor> getInjectionPointOfType(@NotNull PsiType psiType, @NotNull CdiInject<?> inject) {
        if (psiType == null) {
            CdiInjectionUtils.$$$reportNull$$$0(0);
        }
        if (inject == null) {
            CdiInjectionUtils.$$$reportNull$$$0(1);
        }
        HashSet<InjectionPointDescriptor> ipsByType = new HashSet<InjectionPointDescriptor>();
        List<InjectionPointDescriptor> injectionPoints = inject.getInjectionPoints();
        for (InjectionPointDescriptor descriptor : injectionPoints) {
            PsiType injectionPointType = descriptor.getType();
            if (injectionPointType == null || !injectionPointType.isAssignableFrom(psiType)) continue;
            ipsByType.add(descriptor);
        }
        HashSet<InjectionPointDescriptor> hashSet = ipsByType;
        if (hashSet == null) {
            CdiInjectionUtils.$$$reportNull$$$0(2);
        }
        return hashSet;
    }

    public static List<InjectionPointDescriptor> getInjectionPoints(@NotNull PsiMethod method) {
        if (method == null) {
            CdiInjectionUtils.$$$reportNull$$$0(3);
        }
        SmartList ips = new SmartList();
        for (PsiParameter psiParameter : method.getParameterList().getParameters()) {
            InjectionPointDescriptor descriptor;
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiParameter, INJECTION_ANNOTATIONS_BLACKLIST, (int)0) || (descriptor = InjectionPointDescriptor.of((PsiModifierListOwner)psiParameter)) == null) continue;
            ips.add(descriptor);
        }
        return ips;
    }

    public static boolean isInjectedMember(PsiClass psiClass, PsiModifierListOwner member) {
        CdiCustomizationProvider customization;
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)member, INJECTION_ANNOTATIONS_BLACKLIST, (int)0)) {
            return false;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)member, (String)CdiAnnoConstants.INJECT_ANNOTATION.fqn((PsiElement)psiClass), (int)1)) {
            return true;
        }
        if ((member instanceof PsiField || member instanceof PsiParameter) && (customization = CdiCustomizationManager.getCustomization((PsiElement)psiClass)) != null && customization.isInjectByQualifierEnabled()) {
            PsiAnnotation[] qualifierAnnotations = CdiCommonUtils.getQualifierAnnotations(member);
            return qualifierAnnotations.length > 0;
        }
        return false;
    }

    @NotNull
    public static Set<InjectionPointDescriptor> getInjectionPoints(@NotNull Module module) {
        if (module == null) {
            CdiInjectionUtils.$$$reportNull$$$0(4);
        }
        Set set = (Set)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            GlobalSearchScope searchScope = GlobalSearchScope.moduleWithDependentsScope((Module)module).union((SearchScope)GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
            Set<InjectionPointDescriptor> ips = CdiInjectionUtils.getInjectionPoints(module, searchScope);
            HashSet<Object> dependencies = new HashSet<Object>();
            for (InjectionPointDescriptor ip : ips) {
                PsiFile file = ip.getOwner().getContainingFile();
                if (file == null) continue;
                dependencies.add(file);
            }
            dependencies.add(OuterModelsModificationTrackerManager.getTracker((Project)module.getProject()));
            dependencies.add(JavaLibraryModificationTracker.getInstance((Project)module.getProject()));
            return CachedValueProvider.Result.create(ips, dependencies);
        });
        if (set == null) {
            CdiInjectionUtils.$$$reportNull$$$0(5);
        }
        return set;
    }

    public static Set<InjectionPointDescriptor> getInjectionPoints(@NotNull Module module, @NotNull GlobalSearchScope scope) {
        PsiMethod method;
        if (module == null) {
            CdiInjectionUtils.$$$reportNull$$$0(6);
        }
        if (scope == null) {
            CdiInjectionUtils.$$$reportNull$$$0(7);
        }
        HashSet<InjectionPointDescriptor> ips = new HashSet<InjectionPointDescriptor>();
        CdiJamModel model = CdiJamModel.getModel(module);
        CdiCustomizationProvider customization = CdiCustomizationManager.getCustomization(module);
        if (customization != null && customization.isImplicitInjectionToConstructorEnabled()) {
            CdiInjectionUtils.findInjectNonAnnotatedConstructors(model, scope).forEach(psiMethod -> ips.addAll(CdiInjectionUtils.getInjectionPoints(psiMethod)));
        }
        for (CdiInject<?> cdiInject : model.getInjects(scope)) {
            ips.addAll(cdiInject.getInjectionPoints());
        }
        for (CdiProduces cdiProduces : model.getProduces(scope)) {
            ips.addAll(cdiProduces.getInjectionPoints());
        }
        for (CdiObserves cdiObserves : model.getObserves(scope)) {
            method = cdiObserves.getPsiMethod();
            if (method == null) continue;
            ips.addAll(CdiInjectionUtils.getInjectionPoints(method));
        }
        for (CdiDispose cdiDispose : model.getDisposes(scope)) {
            method = cdiDispose.getPsiMethod();
            if (method == null) continue;
            ips.addAll(CdiInjectionUtils.getInjectionPoints(method));
        }
        return ips;
    }

    private static Stream<PsiMethod> findInjectNonAnnotatedConstructors(@NotNull CdiJamModel model, @NotNull GlobalSearchScope scope) {
        if (model == null) {
            CdiInjectionUtils.$$$reportNull$$$0(8);
        }
        if (scope == null) {
            CdiInjectionUtils.$$$reportNull$$$0(9);
        }
        return model.findAnnotatedBeanClasses(scope).flatMap(psiClass -> {
            if (!CdiCommonUtils.isManagedBean(psiClass)) {
                return Stream.empty();
            }
            Object[] constructors = psiClass.getConstructors();
            if (constructors.length == 0 || ContainerUtil.exists((Object[])constructors, CdiInjectionUtils::isTargetConstructor)) {
                return Stream.empty();
            }
            return Stream.of(constructors[0]);
        });
    }

    public static Set<InjectionPointDescriptor> getInjectionPoints(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            CdiInjectionUtils.$$$reportNull$$$0(10);
        }
        return (Set)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> {
            Object constructors;
            HashSet<InjectionPointDescriptor> ips = new HashSet<InjectionPointDescriptor>();
            for (CdiInject<?> cdiInject : CdiInjectionUtils.geInjectMembers(psiClass)) {
                ips.addAll(cdiInject.getInjectionPoints());
            }
            for (CdiProduces cdiProduces : CdiInjectionUtils.getProduces(psiClass)) {
                ips.addAll(cdiProduces.getInjectionPoints());
            }
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
            CdiCustomizationProvider cdiCustomizationProvider = CdiCustomizationManager.getCustomization(module);
            if (cdiCustomizationProvider != null && cdiCustomizationProvider.isImplicitInjectionToConstructorEnabled() && ((PsiMethod[])(constructors = psiClass.getConstructors())).length > 0 && !ContainerUtil.exists((Object[])constructors, CdiInjectionUtils::isTargetConstructor) && CdiInjectionUtils.getBeanDiscoveryMode(module) == BeanDiscoveryMode.ANNOTATED) {
                boolean isBeanAnnotated;
                boolean bl = isBeanAnnotated = AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, CdiCommonUtils.getBeanDefiningAnnotations(module), (int)0) || AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, CdiCustomizationManager.getCustomBeanAnnotations(module), (int)0);
                if (isBeanAnnotated) {
                    ips.addAll(CdiInjectionUtils.getInjectionPoints((PsiMethod)constructors[0]));
                }
            }
            for (PsiMethod observesMethod : CdiCommonUtils.getObservesMethods(psiClass)) {
                ips.addAll(CdiInjectionUtils.getInjectionPoints(observesMethod));
            }
            for (PsiMethod disposerMethod : CdiCommonUtils.getDisposerMethods(psiClass)) {
                ips.addAll(CdiInjectionUtils.getInjectionPoints(disposerMethod));
            }
            Set psiFiles = ContainerUtil.map2SetNotNull(ips, ip -> ip.getOwner().getContainingFile());
            ArrayList<Object> dependencies = new ArrayList<Object>();
            if (psiFiles.isEmpty()) {
                dependencies.add(psiClass.getContainingFile());
            } else {
                dependencies.addAll(psiFiles);
            }
            dependencies.add(JavaLibraryModificationTracker.getInstance((Project)psiClass.getProject()));
            dependencies.add(OuterModelsModificationTrackerManager.getTracker((Project)psiClass.getProject()));
            return CachedValueProvider.Result.create(Collections.unmodifiableSet(ips), List.copyOf(dependencies));
        });
    }

    @NotNull
    public static List<CdiProduces<?>> getProduces(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            CdiInjectionUtils.$$$reportNull$$$0(11);
        }
        List list = JamService.getJamService((Project)psiClass.getProject()).getAnnotatedMembersList(psiClass, CdiProduces.SEM_KEY, 15);
        if (list == null) {
            CdiInjectionUtils.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NotNull
    public static List<CdiInject<?>> geInjectMembers(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            CdiInjectionUtils.$$$reportNull$$$0(13);
        }
        List list = JamService.getJamService((Project)psiClass.getProject()).getAnnotatedMembersList(psiClass, CdiInject.INJECT_JAM_KEY, 15);
        if (list == null) {
            CdiInjectionUtils.$$$reportNull$$$0(14);
        }
        return list;
    }

    private static boolean isTargetConstructor(PsiMethod constructorMethod) {
        return constructorMethod.getParameterList().isEmpty() || AnnotationUtil.isAnnotated((PsiModifierListOwner)constructorMethod, (String)CdiAnnoConstants.INJECT_ANNOTATION.fqn((PsiElement)constructorMethod), (int)0);
    }

    public static Set<InjectionPointDescriptor> getInjectionPoints(@NotNull PsiType psiType, @NotNull Set<? extends InjectionPointDescriptor> ipd) {
        if (psiType == null) {
            CdiInjectionUtils.$$$reportNull$$$0(15);
        }
        if (ipd == null) {
            CdiInjectionUtils.$$$reportNull$$$0(16);
        }
        HashSet<InjectionPointDescriptor> result = new HashSet<InjectionPointDescriptor>();
        for (InjectionPointDescriptor injectionPointDescriptor : ipd) {
            PsiType injectionPointType = injectionPointDescriptor.getType();
            if (injectionPointType == null || !injectionPointType.isAssignableFrom(psiType)) continue;
            result.add(injectionPointDescriptor);
        }
        return result;
    }

    @NotNull
    public static Collection<CdiBeanDescriptor<?>> getInjectedBeans(@NotNull InjectionPointDescriptor ipd) {
        if (ipd == null) {
            CdiInjectionUtils.$$$reportNull$$$0(17);
        }
        return CdiInjectionUtils.getInjectedBeans(ipd, true, true, true);
    }

    @NotNull
    public static Collection<CdiBeanDescriptor<?>> getInjectedBeans(@NotNull InjectionPointDescriptor ipd, boolean checkVetoed, boolean checkDiscoveryMode, boolean checkExcludeFilters) {
        if (ipd == null) {
            CdiInjectionUtils.$$$reportNull$$$0(18);
        }
        return CdiInjectionUtils.getInjectedBeans(ipd.getOwner(), ipd.getType(), checkVetoed, checkDiscoveryMode, checkExcludeFilters);
    }

    public static @Unmodifiable Collection<CdiBeanDescriptor<?>> filterVetoedBeans(@NotNull Collection<? extends CdiBeanDescriptor<?>> allBeans, @NotNull Module module) {
        if (allBeans == null) {
            CdiInjectionUtils.$$$reportNull$$$0(19);
        }
        if (module == null) {
            CdiInjectionUtils.$$$reportNull$$$0(20);
        }
        return ContainerUtil.filter(allBeans, descriptor -> {
            if (descriptor instanceof CdiExtensionBeanDescriptor) {
                return true;
            }
            PsiClass psiClass = CdiInjectionUtils.getContainingClass(descriptor);
            return psiClass != null && !CdiInjectionUtils.isVetoedClass(module, psiClass);
        });
    }

    @NotNull
    public static Collection<CdiBeanDescriptor<?>> filterBeanDiscoveryMode(@NotNull Collection<? extends CdiBeanDescriptor<?>> allBeans, @NotNull Module module) {
        if (allBeans == null) {
            CdiInjectionUtils.$$$reportNull$$$0(21);
        }
        if (module == null) {
            CdiInjectionUtils.$$$reportNull$$$0(22);
        }
        ArrayList productionDescriptors = new ArrayList();
        ArrayList jarDescriptors = new ArrayList();
        for (CdiBeanDescriptor<?> bean : allBeans) {
            if (CdiInjectionUtils.isJarDescriptor(bean)) {
                jarDescriptors.add(bean);
                continue;
            }
            productionDescriptors.add(bean);
        }
        ArrayList<String> cdiBeansAnnotations = new ArrayList<String>(CdiCommonUtils.collectCdiBeansAnnotations(module));
        cdiBeansAnnotations.removeAll(CdiInjectionUtils.getNonScannedBeanDiscoveryModeAnnos(module));
        ArrayList filtered = new ArrayList();
        filtered.addAll(CdiInjectionUtils.filterProductionBeanDescriptors(productionDescriptors, module, cdiBeansAnnotations));
        filtered.addAll(CdiInjectionUtils.filterJarBeanDescriptors(jarDescriptors, cdiBeansAnnotations));
        ArrayList arrayList = filtered;
        if (arrayList == null) {
            CdiInjectionUtils.$$$reportNull$$$0(23);
        }
        return arrayList;
    }

    private static Collection<CdiBeanDescriptor<?>> filterJarBeanDescriptors(@NotNull Collection<? extends CdiBeanDescriptor<?>> jarBeans, @NotNull Collection<String> cdiBeansAnnotations) {
        if (jarBeans == null) {
            CdiInjectionUtils.$$$reportNull$$$0(24);
        }
        if (cdiBeansAnnotations == null) {
            CdiInjectionUtils.$$$reportNull$$$0(25);
        }
        ArrayList filtered = new ArrayList();
        for (CdiBeanDescriptor<?> jarBean : jarBeans) {
            if (jarBean instanceof ImplicitBeanDescriptor) {
                filtered.add(jarBean);
                continue;
            }
            BeanDiscoveryMode discoveryMode = CdiInjectionUtils.getJarBeansDiscoveryMode(jarBean.getIdentifyingElement().getContainingFile());
            if (discoveryMode == BeanDiscoveryMode.NONE) continue;
            if (discoveryMode == BeanDiscoveryMode.ALL) {
                filtered.add(jarBean);
                continue;
            }
            if (discoveryMode != BeanDiscoveryMode.ANNOTATED || !CdiInjectionUtils.isAnnotatedToBeDiscovered(cdiBeansAnnotations, jarBean)) continue;
            filtered.add(jarBean);
        }
        return filtered;
    }

    @NotNull
    private static BeanDiscoveryMode getJarBeansDiscoveryMode(@Nullable PsiFile containingFile) {
        PsiFile file;
        VirtualFile root;
        VirtualFile beansXmlVF;
        VirtualFileSystem fileFileSystem;
        VirtualFile virtualFile;
        if (containingFile != null && (virtualFile = containingFile.getVirtualFile()) != null && (fileFileSystem = virtualFile.getFileSystem()) instanceof JarFileSystem && (beansXmlVF = (root = VfsUtilCore.getRootFile((VirtualFile)virtualFile)).findFileByRelativePath("META-INF/beans.xml")) != null && (file = containingFile.getManager().findFile(beansXmlVF)) instanceof XmlFile) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
            return CdiInjectionUtils.getBeansDiscoveryMode(CdiInjectionUtils.getBeans((XmlFile)file), module);
        }
        BeanDiscoveryMode beanDiscoveryMode = BeanDiscoveryMode.ANNOTATED;
        if (beanDiscoveryMode == null) {
            CdiInjectionUtils.$$$reportNull$$$0(26);
        }
        return beanDiscoveryMode;
    }

    @Nullable
    public static Beans getBeans(@Nullable XmlFile file) {
        if (file == null) {
            return null;
        }
        DomFileElement fileElement = DomManager.getDomManager((Project)file.getProject()).getFileElement(file, Beans.class);
        return fileElement != null && fileElement.isValid() ? (Beans)fileElement.getRootElement() : null;
    }

    @NotNull
    public static Collection<CdiBeanDescriptor<?>> filterProductionBeanDescriptors(@NotNull Collection<CdiBeanDescriptor<?>> allBeans, @NotNull Module module, @NotNull Collection<String> cdiBeansAnnotations) {
        if (allBeans == null) {
            CdiInjectionUtils.$$$reportNull$$$0(27);
        }
        if (module == null) {
            CdiInjectionUtils.$$$reportNull$$$0(28);
        }
        if (cdiBeansAnnotations == null) {
            CdiInjectionUtils.$$$reportNull$$$0(29);
        }
        if (allBeans.isEmpty()) {
            Collection<CdiBeanDescriptor<?>> collection = allBeans;
            if (collection == null) {
                CdiInjectionUtils.$$$reportNull$$$0(30);
            }
            return collection;
        }
        BeanDiscoveryMode value = CdiInjectionUtils.getBeanDiscoveryMode(module);
        if (value == BeanDiscoveryMode.NONE) {
            Set<CdiBeanDescriptor<?>> set = Collections.emptySet();
            if (set == null) {
                CdiInjectionUtils.$$$reportNull$$$0(31);
            }
            return set;
        }
        if (value == BeanDiscoveryMode.ALL) {
            Collection<CdiBeanDescriptor<?>> collection = allBeans;
            if (collection == null) {
                CdiInjectionUtils.$$$reportNull$$$0(32);
            }
            return collection;
        }
        ArrayList filtered = new ArrayList();
        for (CdiBeanDescriptor<?> beanDescriptor : allBeans) {
            if (!CdiInjectionUtils.isAnnotatedToBeDiscovered(cdiBeansAnnotations, beanDescriptor)) continue;
            filtered.add(beanDescriptor);
        }
        ArrayList arrayList = filtered;
        if (arrayList == null) {
            CdiInjectionUtils.$$$reportNull$$$0(33);
        }
        return arrayList;
    }

    public static boolean isAnnotatedToBeDiscovered(@NotNull Collection<String> cdiBeansAnnotations, CdiBeanDescriptor<?> beanDescriptor) {
        Object identifyingElement;
        if (cdiBeansAnnotations == null) {
            CdiInjectionUtils.$$$reportNull$$$0(34);
        }
        if ((identifyingElement = beanDescriptor.getIdentifyingElement()) instanceof PsiMember && AnnotationUtil.findAnnotations((PsiModifierListOwner)((PsiModifierListOwner)identifyingElement), cdiBeansAnnotations).length > 0) {
            return true;
        }
        return identifyingElement instanceof PsiClass && (CdiManagedBeanValidationUtils.isEjbBean((PsiClass)identifyingElement) || CdiManagedBeanValidationUtils.isJpaEntity((PsiClass)identifyingElement));
    }

    private static boolean isJarDescriptor(CdiBeanDescriptor<?> bean) {
        PsiFile file = bean.getIdentifyingElement().getContainingFile();
        if (file == null) {
            return false;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        return virtualFile != null && virtualFile.getFileSystem() instanceof JarFileSystem;
    }

    private static Collection<String> getNonScannedBeanDiscoveryModeAnnos(@NotNull Module module) {
        if (module == null) {
            CdiInjectionUtils.$$$reportNull$$$0(35);
        }
        return Collections.singleton(CdiAnnoConstants.NAMED_ANNOTATION.fqn(module));
    }

    @NotNull
    public static BeanDiscoveryMode getBeanDiscoveryMode(@NotNull Module module) {
        if (module == null) {
            CdiInjectionUtils.$$$reportNull$$$0(36);
        }
        BeanDiscoveryMode beanDiscoveryMode = (BeanDiscoveryMode)((Object)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            Beans xml = CdiInjectionUtils.getBeansXml(module);
            return CachedValueProvider.Result.create((Object)((Object)CdiInjectionUtils.getBeansDiscoveryMode(xml, module)), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        }));
        if (beanDiscoveryMode == null) {
            CdiInjectionUtils.$$$reportNull$$$0(37);
        }
        return beanDiscoveryMode;
    }

    @NotNull
    public static BeanDiscoveryMode getBeansDiscoveryMode(@Nullable Beans beans, @Nullable Module module) {
        CdiCustomizationProvider cdiCustomizationProvider;
        if (beans != null) {
            if (DomUtil.hasXml(beans.getBeanDiscoveryMode())) {
                BeanDiscoveryMode discoveryMode = (BeanDiscoveryMode)((Object)beans.getBeanDiscoveryMode().getValue());
                if (discoveryMode != null) {
                    BeanDiscoveryMode beanDiscoveryMode = discoveryMode;
                    if (beanDiscoveryMode == null) {
                        CdiInjectionUtils.$$$reportNull$$$0(38);
                    }
                    return beanDiscoveryMode;
                }
                BeanDiscoveryMode beanDiscoveryMode = BeanDiscoveryMode.ANNOTATED;
                if (beanDiscoveryMode == null) {
                    CdiInjectionUtils.$$$reportNull$$$0(39);
                }
                return beanDiscoveryMode;
            }
            if (CdiCommonUtils.isCdiInstalled(module, CdiVersion.CDI_4_0)) {
                BeanDiscoveryMode beanDiscoveryMode = BeanDiscoveryMode.ANNOTATED;
                if (beanDiscoveryMode == null) {
                    CdiInjectionUtils.$$$reportNull$$$0(40);
                }
                return beanDiscoveryMode;
            }
            if (!DomUtil.hasXml(beans.getVersion())) {
                BeanDiscoveryMode beanDiscoveryMode = BeanDiscoveryMode.ALL;
                if (beanDiscoveryMode == null) {
                    CdiInjectionUtils.$$$reportNull$$$0(41);
                }
                return beanDiscoveryMode;
            }
        }
        if ((cdiCustomizationProvider = CdiCustomizationManager.getCustomization(module)) == null) {
            BeanDiscoveryMode beanDiscoveryMode = BeanDiscoveryMode.ALL;
            if (beanDiscoveryMode == null) {
                CdiInjectionUtils.$$$reportNull$$$0(42);
            }
            return beanDiscoveryMode;
        }
        BeanDiscoveryMode beanDiscoveryMode = cdiCustomizationProvider.getDefaultBeanDiscoveryMode();
        if (beanDiscoveryMode == null) {
            CdiInjectionUtils.$$$reportNull$$$0(43);
        }
        return beanDiscoveryMode;
    }

    @NotNull
    public static Collection<CdiBeanDescriptor<?>> filterScanExcludedBeans(@NotNull Collection<CdiBeanDescriptor<?>> allBeans, @NotNull Module module) {
        Beans beans;
        if (allBeans == null) {
            CdiInjectionUtils.$$$reportNull$$$0(44);
        }
        if (module == null) {
            CdiInjectionUtils.$$$reportNull$$$0(45);
        }
        if ((beans = CdiInjectionUtils.getBeansXml(module)) != null) {
            HashSet<Pattern> patterns = new HashSet<Pattern>();
            for (Scan scan : beans.getScans()) {
                for (Exclude exclude : scan.getExcludes()) {
                    String text = exclude.getName().getRawText();
                    if (text == null) continue;
                    try {
                        String regexp = FileUtil.convertAntToRegexp((String)text);
                        patterns.add(Pattern.compile(regexp));
                    }
                    catch (PatternSyntaxException patternSyntaxException) {}
                }
            }
            if (!patterns.isEmpty()) {
                ArrayList filtered = new ArrayList();
                for (CdiBeanDescriptor<?> descriptor : allBeans) {
                    PsiClass psiClass = CdiInjectionUtils.getContainingClass(descriptor);
                    if (psiClass == null || CdiInjectionUtils.isExcludeClass(patterns, psiClass)) continue;
                    filtered.add(descriptor);
                }
                ArrayList arrayList = filtered;
                if (arrayList == null) {
                    CdiInjectionUtils.$$$reportNull$$$0(46);
                }
                return arrayList;
            }
        }
        Collection<CdiBeanDescriptor<?>> collection = allBeans;
        if (collection == null) {
            CdiInjectionUtils.$$$reportNull$$$0(47);
        }
        return collection;
    }

    @Nullable
    private static PsiClass getContainingClass(CdiBeanDescriptor<?> descriptor) {
        Object identifyingElement = descriptor.getIdentifyingElement();
        if (identifyingElement instanceof PsiClass) {
            return (PsiClass)identifyingElement;
        }
        return identifyingElement instanceof PsiMember ? ((PsiMember)identifyingElement).getContainingClass() : null;
    }

    private static boolean isExcludeClass(Set<Pattern> patterns, PsiClass psiClass) {
        String qualifiedName = psiClass.getQualifiedName();
        if (qualifiedName != null) {
            for (Pattern pattern : patterns) {
                if (!pattern.matcher(qualifiedName).matches()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean canBeInjected(@NotNull PsiClass psiClass, @NotNull Module module) {
        if (psiClass == null) {
            CdiInjectionUtils.$$$reportNull$$$0(48);
        }
        if (module == null) {
            CdiInjectionUtils.$$$reportNull$$$0(49);
        }
        if (!CdiInjectionUtils.isManagedBean(psiClass)) {
            return false;
        }
        if (CdiInjectionUtils.isVetoedClass(module, psiClass)) {
            return false;
        }
        Set<CdiBeanDescriptor<?>> descriptors = Collections.singleton(CdiDescriptorsFactory.createCdiBeanDescriptor(psiClass));
        return !CdiInjectionUtils.filterDescriptors(module, descriptors, true, true, true).isEmpty();
    }

    public static boolean isManagedBean(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            CdiInjectionUtils.$$$reportNull$$$0(50);
        }
        return !CdiManagedBeanValidationUtils.isParameterizedType(psiClass) && (CdiManagedBeanValidationUtils.isConcreteClass(psiClass) || CdiManagedBeanValidationUtils.isDecoratorClass(psiClass) || CdiManagedBeanValidationUtils.isAnnotatedAsCustomBean(psiClass)) && !CdiManagedBeanValidationUtils.isNonStaticInner(psiClass);
    }

    @Nullable
    private static Beans getBeansXml(@NotNull Module module) {
        List models;
        if (module == null) {
            CdiInjectionUtils.$$$reportNull$$$0(51);
        }
        if ((models = DomService.getInstance().getFileElements(Beans.class, module.getProject(), module.getModuleContentScope())).size() == 1) {
            return (Beans)((DomFileElement)models.iterator().next()).getRootElement();
        }
        HashSet<DomFileElement> beansXmlModelsInTests = new HashSet<DomFileElement>();
        for (DomFileElement model : models) {
            XmlFile file = model.getFile();
            if (!"beans.xml".equals(file.getName())) continue;
            if (!ProjectRootsUtil.isInTestSource((PsiFile)file)) {
                return (Beans)model.getRootElement();
            }
            beansXmlModelsInTests.add(model);
        }
        return beansXmlModelsInTests.size() == 1 ? (Beans)((DomFileElement)beansXmlModelsInTests.iterator().next()).getRootElement() : null;
    }

    public static boolean isVetoedClass(@NotNull Module module, @NotNull PsiClass psiClass) {
        if (module == null) {
            CdiInjectionUtils.$$$reportNull$$$0(52);
        }
        if (psiClass == null) {
            CdiInjectionUtils.$$$reportNull$$$0(53);
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)CdiAnnoConstants.VETOED_ANNOTATION.fqn(module), (int)1)) {
            return true;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)module.getProject());
        for (PsiPackage vetoedPackage : CdiCommonUtils.getVetoedPackages(module)) {
            if (!facade.isInPackage((PsiElement)psiClass, vetoedPackage)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static Collection<CdiBeanDescriptor<?>> getInjectedBeans(@NotNull PsiModifierListOwner owner, PsiType type, boolean checkVetoed, boolean checkDiscoveryMode, boolean checkExcludeFilters) {
        Module module;
        if (owner == null) {
            CdiInjectionUtils.$$$reportNull$$$0(54);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)owner)) == null) {
            Set<CdiBeanDescriptor<?>> set = Collections.emptySet();
            if (set == null) {
                CdiInjectionUtils.$$$reportNull$$$0(55);
            }
            return set;
        }
        Collection<CdiBeanDescriptor<?>> collection = CdiInjectionUtils.filterDescriptors(module, CdiInjectionUtils.getInjectedBeans(owner, module, type), checkVetoed, checkDiscoveryMode, checkExcludeFilters);
        if (collection == null) {
            CdiInjectionUtils.$$$reportNull$$$0(56);
        }
        return collection;
    }

    private static Collection<CdiBeanDescriptor<?>> filterDescriptors(Module module, Collection<CdiBeanDescriptor<?>> allBeans, boolean checkVetoed, boolean checkDiscoveryMode, boolean checkExcludeFilters) {
        Collection<CdiBeanDescriptor<?>> filtered = CdiInjectionUtils.filterGenerated(allBeans);
        filtered = CdiInjectionUtils.filterUnsatisfiedDescriptors(filtered);
        filtered = CdiInjectionUtils.excludeMocks(filtered);
        filtered = CdiInjectionUtils.chooseAlternatives(filtered, module);
        if (checkVetoed) {
            filtered = CdiInjectionUtils.filterVetoedBeans(filtered, module);
        }
        if (checkDiscoveryMode) {
            filtered = CdiInjectionUtils.filterBeanDiscoveryMode(filtered, module);
        }
        if (checkExcludeFilters) {
            filtered = CdiInjectionUtils.filterScanExcludedBeans(filtered, module);
        }
        filtered = CdiInjectionUtils.resolveDefaultBeans(filtered);
        return filtered;
    }

    private static @Unmodifiable List<CdiBeanDescriptor<?>> filterGenerated(@NotNull Collection<? extends CdiBeanDescriptor<?>> beans) {
        if (beans == null) {
            CdiInjectionUtils.$$$reportNull$$$0(57);
        }
        return ContainerUtil.filter(beans, bd -> {
            PsiClass psiClass = CdiInjectionUtils.getContainingClass(bd);
            if (psiClass == null) {
                return true;
            }
            return !AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)"jakarta.annotation.Generated", (int)0);
        });
    }

    private static @Unmodifiable Collection<CdiBeanDescriptor<?>> filterUnsatisfiedDescriptors(@NotNull Collection<? extends CdiBeanDescriptor<?>> beans) {
        if (beans == null) {
            CdiInjectionUtils.$$$reportNull$$$0(58);
        }
        return ContainerUtil.filter(beans, CdiInjectionUtils::isLoadedInContainer);
    }

    private static boolean isLoadedInContainer(@NotNull CdiBeanDescriptor<?> descriptor) {
        Module module;
        Object identifyingElement;
        if (descriptor == null) {
            CdiInjectionUtils.$$$reportNull$$$0(59);
        }
        if ((identifyingElement = descriptor.getIdentifyingElement()) != null && (module = ModuleUtilCore.findModuleForPsiElement(identifyingElement)) != null && CdiCommonUtils.isCdiInstalled(module, CdiVersion.CDI_1_1) && DomService.getInstance().getFileElements(Beans.class, module.getProject(), module.getModuleContentScope()).isEmpty()) {
            return CdiCommonUtils.hasImplicitArchive(module);
        }
        return true;
    }

    private static Collection<CdiBeanDescriptor<?>> resolveDefaultBeans(@NotNull Collection<CdiBeanDescriptor<?>> beans) {
        if (beans == null) {
            CdiInjectionUtils.$$$reportNull$$$0(60);
        }
        if (!ContainerUtil.exists(beans, CdiBeanDescriptor::isDefault)) {
            return beans;
        }
        Collection nonDefaultBeans = beans.stream().filter(it -> !it.isDefault()).collect(Collectors.toSet());
        if (nonDefaultBeans.isEmpty()) {
            return beans;
        }
        return nonDefaultBeans;
    }

    private static Collection<CdiBeanDescriptor<?>> excludeMocks(@NotNull Collection<CdiBeanDescriptor<?>> beans) {
        if (beans == null) {
            CdiInjectionUtils.$$$reportNull$$$0(61);
        }
        if (!ContainerUtil.exists(beans, CdiBeanDescriptor::isMock)) {
            return beans;
        }
        return beans.stream().filter(it -> !it.isMock()).collect(Collectors.toSet());
    }

    private static Collection<CdiBeanDescriptor<?>> chooseAlternatives(@NotNull Collection<? extends CdiBeanDescriptor<?>> allBeans, @NotNull Module module) {
        boolean alternativesRequireBeansXml;
        if (allBeans == null) {
            CdiInjectionUtils.$$$reportNull$$$0(62);
        }
        if (module == null) {
            CdiInjectionUtils.$$$reportNull$$$0(63);
        }
        HashSet alternatives = new HashSet();
        HashSet nonAlternatives = new HashSet();
        for (CdiBeanDescriptor<?> descriptor : allBeans) {
            Object annotatedItem;
            if (descriptor instanceof AbstractCdiBeanDescriptor && CdiCommonUtils.isAlternativeAnnotated(annotatedItem = ((AbstractCdiBeanDescriptor)descriptor).getAnnotatedItem())) {
                alternatives.add((AbstractCdiBeanDescriptor)descriptor);
                continue;
            }
            nonAlternatives.add(descriptor);
        }
        if (alternatives.isEmpty()) {
            return nonAlternatives;
        }
        CdiCustomizationProvider customization = CdiCustomizationManager.getCustomization(module);
        boolean bl = alternativesRequireBeansXml = customization == null || customization.isAlternativeRequiresBeansXml();
        if (alternativesRequireBeansXml) {
            Collection<CdiBeanDescriptor<?>> result = CdiInjectionUtils.collectAlternativesRegisteredInXml(module, alternatives);
            if (!result.isEmpty()) {
                return result;
            }
        } else {
            if (alternatives.size() == 1) {
                return Collections.singleton((CdiBeanDescriptor)alternatives.iterator().next());
            }
            JamService jamService = JamService.getJamService((Project)module.getProject());
            List prioritizedAlternatives = alternatives.stream().map(alternative -> new Pair(alternative, (Object)CdiInjectionUtils.getAlternativePriority(jamService, alternative))).sorted((c1, c2) -> Integer.compare((Integer)c2.getSecond(), (Integer)c1.getSecond())).collect(Collectors.toList());
            int topPriority = (Integer)((Pair)prioritizedAlternatives.get(0)).getSecond();
            if (Objects.equals(topPriority, ((Pair)prioritizedAlternatives.get(1)).getSecond())) {
                return prioritizedAlternatives.stream().filter(p -> (Integer)p.getSecond() == topPriority).map(p -> (AbstractCdiBeanDescriptor)p.getFirst()).collect(Collectors.toList());
            }
            return Collections.singleton((CdiBeanDescriptor)((Pair)prioritizedAlternatives.get(0)).getFirst());
        }
        return nonAlternatives;
    }

    private static int getAlternativePriority(JamService jamService, AbstractCdiBeanDescriptor<?> alternative) {
        Object item = alternative.getAnnotatedItem();
        Priority priority = (Priority)jamService.getJamElement(Priority.JAM_KEY, item);
        if (priority == null) {
            return 0;
        }
        return priority.getPriority();
    }

    private static Collection<CdiBeanDescriptor<?>> collectAlternativesRegisteredInXml(@NotNull Module module, @NotNull Collection<AbstractCdiBeanDescriptor<?>> alternatives) {
        Beans beans;
        if (module == null) {
            CdiInjectionUtils.$$$reportNull$$$0(64);
        }
        if (alternatives == null) {
            CdiInjectionUtils.$$$reportNull$$$0(65);
        }
        if ((beans = CdiInjectionUtils.getBeansXml(module)) != null) {
            HashSet result = new HashSet();
            for (Alternatives definedAlternatives : beans.getAlternativeses()) {
                for (AlternativeClass alternativeClass : definedAlternatives.getClasses()) {
                    String alternativeClassFQN = alternativeClass.getStringValue();
                    if (StringUtil.isEmptyOrSpaces((String)alternativeClassFQN)) continue;
                    for (AbstractCdiBeanDescriptor<?> beanDescriptor : alternatives) {
                        PsiClass psiClass;
                        if (beanDescriptor instanceof CdiExtensionBeanDescriptor || (psiClass = beanDescriptor instanceof CdiBeanPsiClassDescriptor ? ((CdiBeanPsiClassDescriptor)beanDescriptor).getAnnotatedItem() : beanDescriptor.getAnnotatedItem().getContainingClass()) == null || !alternativeClassFQN.equals(psiClass.getQualifiedName())) continue;
                        result.add(beanDescriptor);
                    }
                }
                for (StereotypeClass stereotypeClass : definedAlternatives.getStereotypes()) {
                    String stereotypeClassValue = stereotypeClass.getStringValue();
                    if (stereotypeClassValue == null) continue;
                    for (AbstractCdiBeanDescriptor<?> beanDescriptor : alternatives) {
                        Object psiMember = beanDescriptor.getAnnotatedItem();
                        if (!AnnotationUtil.isAnnotated(psiMember, (String)stereotypeClassValue, (int)0)) continue;
                        result.add(beanDescriptor);
                    }
                }
            }
            if (!result.isEmpty()) {
                return result;
            }
        }
        return Collections.emptyList();
    }

    public static Set<CdiBeanDescriptor<?>> getInjectedBeans(@NotNull PsiModifierListOwner psiMember, @NotNull Module module, PsiType type) {
        Set<CdiBeanDescriptor<?>> resolvedBeanDescriptors;
        if (psiMember == null) {
            CdiInjectionUtils.$$$reportNull$$$0(66);
        }
        if (module == null) {
            CdiInjectionUtils.$$$reportNull$$$0(67);
        }
        Set<CdiBeanDescriptor<?>> beanDescriptors = !(resolvedBeanDescriptors = CdiManager.resolveBeanByType(psiMember, module, type)).isEmpty() ? resolvedBeanDescriptors : CdiImplicitBeansProvider.getImplicitBeans(type, module);
        return CdiInjectionUtils.isInTestSources((PsiElement)psiMember) ? beanDescriptors : CdiInjectionUtils.filterNonTestsDescriptors(beanDescriptors);
    }

    @NotNull
    private static Set<CdiBeanDescriptor<?>> filterNonTestsDescriptors(@NotNull Collection<CdiBeanDescriptor<?>> injectedBeans) {
        if (injectedBeans == null) {
            CdiInjectionUtils.$$$reportNull$$$0(68);
        }
        Set<CdiBeanDescriptor<?>> set = injectedBeans.stream().filter(descriptor -> !CdiInjectionUtils.isInTestSources(descriptor.getIdentifyingElement())).collect(Collectors.toSet());
        if (set == null) {
            CdiInjectionUtils.$$$reportNull$$$0(69);
        }
        return set;
    }

    private static boolean isInTestSources(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            CdiInjectionUtils.$$$reportNull$$$0(70);
        }
        VirtualFile file = psiElement.getContainingFile().getVirtualFile();
        return TestSourcesFilter.isTestSources((VirtualFile)file, (Project)psiElement.getProject());
    }

    public static boolean isImplicitProducerMethod(PsiMethod psiMethod) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiMethod);
        CdiCustomizationProvider cdiCustomizationProvider = CdiCustomizationManager.getCustomization(module);
        if (cdiCustomizationProvider == null || !cdiCustomizationProvider.isImplicitProducesEnabled()) {
            return false;
        }
        return ContainerUtil.exists(CdiManager.IMPLICIT_PRODUCES_ANNOTATIONS, anno -> anno.isAnnotated((PsiModifierListOwner)psiMethod, 0));
    }

    public static boolean isProducer(@NotNull UDeclaration uDeclaration) {
        if (uDeclaration == null) {
            CdiInjectionUtils.$$$reportNull$$$0(71);
        }
        return ContainerUtil.exists((Iterable)uDeclaration.getUAnnotations(), uAnno -> Objects.equals(uAnno.getQualifiedName(), CdiAnnoConstants.PRODUCES_ANNOTATION.javax()) || Objects.equals(uAnno.getQualifiedName(), CdiAnnoConstants.PRODUCES_ANNOTATION.jakarta()));
    }

    public static boolean isImplicitProducerMethod(@NotNull UMethod uMethod, @NotNull Module module) {
        CdiCustomizationProvider cdiCustomizationProvider;
        if (uMethod == null) {
            CdiInjectionUtils.$$$reportNull$$$0(72);
        }
        if (module == null) {
            CdiInjectionUtils.$$$reportNull$$$0(73);
        }
        if ((cdiCustomizationProvider = CdiCustomizationManager.getCustomization(module)) == null || !cdiCustomizationProvider.isImplicitProducesEnabled()) {
            return false;
        }
        return ContainerUtil.exists((Iterable)uMethod.getUAnnotations(), uAnno -> ContainerUtil.exists(CdiManager.IMPLICIT_PRODUCES_ANNOTATIONS, anno -> Objects.equals(anno.javax(), uAnno.getQualifiedName()) || Objects.equals(anno.jakarta(), uAnno.getQualifiedName())));
    }

    public static Set<CdiBeanDescriptor<? extends PsiElement>> getAllBeans(@NotNull Module module) {
        if (module == null) {
            CdiInjectionUtils.$$$reportNull$$$0(74);
        }
        HashSet<CdiBeanDescriptor<? extends PsiElement>> beans = new HashSet<CdiBeanDescriptor<? extends PsiElement>>();
        beans.addAll(UastCachedSearchUtils.computeWithCache((ScopedCacheValueHolder)ScopedCacheValueHolders.asCacheValueHolder((Module)module), INJECTED_BEANS_CACHE_KEY));
        beans.addAll(CdiInjectionUtils.getAnnotatedBeans(module));
        return beans;
    }

    public static List<CdiBeanDescriptor<? extends PsiElement>> getAnnotatedBeans(@NotNull Module module) {
        if (module == null) {
            CdiInjectionUtils.$$$reportNull$$$0(75);
        }
        return UastCachedSearchUtils.computeWithCache((ScopedCacheValueHolder)ScopedCacheValueHolders.asCacheValueHolder((Module)module), ANNOTATED_BEANS_CACHE_KEY);
    }

    private static List<CdiBeanDescriptor<?>> getInjectedBeans(@NotNull Module module, @NotNull GlobalSearchScope scope) {
        if (module == null) {
            CdiInjectionUtils.$$$reportNull$$$0(76);
        }
        if (scope == null) {
            CdiInjectionUtils.$$$reportNull$$$0(77);
        }
        ArrayList injectedBeans = new ArrayList();
        for (InjectionPointDescriptor injectionPoint : CdiInjectionUtils.getInjectionPoints(module, scope)) {
            injectedBeans.addAll(CdiInjectionUtils.getInjectedBeans(injectionPoint));
        }
        return injectedBeans;
    }

    private static List<CdiBeanDescriptor<? extends PsiElement>> getAnnotatedBeans(@NotNull Module module, @NotNull GlobalSearchScope scope) {
        List<PsiClass> beanDefiningAnnotations;
        if (module == null) {
            CdiInjectionUtils.$$$reportNull$$$0(78);
        }
        if (scope == null) {
            CdiInjectionUtils.$$$reportNull$$$0(79);
        }
        if ((beanDefiningAnnotations = CdiCommonUtils.collectBeanDefiningAnnotations(module)).isEmpty()) {
            return Collections.emptyList();
        }
        List beanDescriptors = ContainerUtil.flatMap(beanDefiningAnnotations, annoPsiClass -> {
            Collection annotatedPsiMembers = AnnotatedMembersSearch.search((PsiClass)annoPsiClass, (SearchScope)scope).findAll();
            return ContainerUtil.mapNotNull((Collection)annotatedPsiMembers, CdiInjectionUtils::createBeanDescriptor);
        });
        return CdiInjectionUtils.filterGenerated(beanDescriptors);
    }

    private static CdiBeanDescriptor<? extends PsiElement> createBeanDescriptor(@NotNull PsiMember psiMember) {
        if (psiMember == null) {
            CdiInjectionUtils.$$$reportNull$$$0(80);
        }
        if (psiMember instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)psiMember;
            return CdiDescriptorsFactory.createCdiBeanDescriptor(psiClass);
        }
        return CdiDescriptorsFactory.createProducerCdiBeanDescriptor(psiMember);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 12, 14, 23, 26, 30, 31, 32, 33, 37, 38, 39, 40, 41, 42, 43, 46, 47, 55, 56, 69 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inject";
                break;
            }
            case 2: 
            case 5: 
            case 12: 
            case 14: 
            case 23: 
            case 26: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 46: 
            case 47: 
            case 55: 
            case 56: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cdi/utils/CdiInjectionUtils";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 4: 
            case 6: 
            case 20: 
            case 22: 
            case 28: 
            case 35: 
            case 36: 
            case 45: 
            case 49: 
            case 51: 
            case 52: 
            case 63: 
            case 64: 
            case 67: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: 
            case 9: 
            case 77: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 48: 
            case 50: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ipd";
                break;
            }
            case 19: 
            case 21: 
            case 27: 
            case 44: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allBeans";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarBeans";
                break;
            }
            case 25: 
            case 29: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cdiBeansAnnotations";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 57: 
            case 58: 
            case 60: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beans";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alternatives";
                break;
            }
            case 66: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMember";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedBeans";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uDeclaration";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cdi/utils/CdiInjectionUtils";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInjectionPointOfType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInjectionPoints";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getProduces";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "geInjectMembers";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "filterBeanDiscoveryMode";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getJarBeansDiscoveryMode";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "filterProductionBeanDescriptors";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getBeanDiscoveryMode";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getBeansDiscoveryMode";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "filterScanExcludedBeans";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getInjectedBeans";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "filterNonTestsDescriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInjectionPointOfType";
                break;
            }
            case 2: 
            case 5: 
            case 12: 
            case 14: 
            case 23: 
            case 26: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 46: 
            case 47: 
            case 55: 
            case 56: 
            case 69: {
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getInjectionPoints";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findInjectNonAnnotatedConstructors";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getProduces";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "geInjectMembers";
                break;
            }
            case 17: 
            case 18: 
            case 54: 
            case 66: 
            case 67: 
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "getInjectedBeans";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "filterVetoedBeans";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "filterBeanDiscoveryMode";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "filterJarBeanDescriptors";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "filterProductionBeanDescriptors";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isAnnotatedToBeDiscovered";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getNonScannedBeanDiscoveryModeAnnos";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getBeanDiscoveryMode";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "filterScanExcludedBeans";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "canBeInjected";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "isManagedBean";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getBeansXml";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "isVetoedClass";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "filterGenerated";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "filterUnsatisfiedDescriptors";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "isLoadedInContainer";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "resolveDefaultBeans";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "excludeMocks";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "chooseAlternatives";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "collectAlternativesRegisteredInXml";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "filterNonTestsDescriptors";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "isInTestSources";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "isProducer";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "isImplicitProducerMethod";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "getAllBeans";
                break;
            }
            case 75: 
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotatedBeans";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "createBeanDescriptor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 12, 14, 23, 26, 30, 31, 32, 33, 37, 38, 39, 40, 41, 42, 43, 46, 47, 55, 56, 69 -> new IllegalStateException(string);
        };
    }
}

