/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.stat;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.RoundedIntEventField;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.staticAnalysis.stat.QodanaEventLogGroup;
import org.jetbrains.qodana.staticAnalysis.stat.QodanaVarargEventId;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0016J@\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u0019H\u0007J\u0010\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0018\u0010 \u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/stat/QodanaProjectInfoCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "<init>", "()V", "GROUP", "Lorg/jetbrains/qodana/staticAnalysis/stat/QodanaEventLogGroup;", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "authors30Field", "Lcom/intellij/internal/statistic/eventLog/events/RoundedIntEventField;", "authors60Field", "authors90Field", "commits30Field", "commits60Field", "commits90Field", "commitsSummaryEvent", "Lorg/jetbrains/qodana/staticAnalysis/stat/QodanaVarargEventId;", "ossLicenseField", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "doesHaveOssLicenseEvent", "logCommitsSummary", "", "project", "Lcom/intellij/openapi/project/Project;", "authors30", "", "authors60", "authors90", "commits30", "commits60", "commits90", "logAbsentHistorySummary", "logOssLicense", "hasOssLicense", "", "intellij.qodana"})
@ApiStatus.Internal
public final class QodanaProjectInfoCollector
extends CounterUsagesCollector {
    @NotNull
    public static final QodanaProjectInfoCollector INSTANCE = new QodanaProjectInfoCollector();
    @NotNull
    private static final QodanaEventLogGroup GROUP = new QodanaEventLogGroup("qodana.project.info", 3);
    @NotNull
    private static final RoundedIntEventField authors30Field = EventFields.RoundedInt((String)"authors30");
    @NotNull
    private static final RoundedIntEventField authors60Field = EventFields.RoundedInt((String)"authors60");
    @NotNull
    private static final RoundedIntEventField authors90Field = EventFields.RoundedInt((String)"authors90");
    @NotNull
    private static final RoundedIntEventField commits30Field = EventFields.RoundedInt((String)"commits30");
    @NotNull
    private static final RoundedIntEventField commits60Field = EventFields.RoundedInt((String)"commits60");
    @NotNull
    private static final RoundedIntEventField commits90Field = EventFields.RoundedInt((String)"commits90");
    @NotNull
    private static final QodanaVarargEventId commitsSummaryEvent;
    @NotNull
    private static final BooleanEventField ossLicenseField;
    @NotNull
    private static final QodanaVarargEventId doesHaveOssLicenseEvent;

    private QodanaProjectInfoCollector() {
    }

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP.getEventLogGroup();
    }

    @JvmStatic
    public static final void logCommitsSummary(@NotNull Project project, int authors30, int authors60, int authors90, int commits30, int commits60, int commits90) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object[] objectArray = new EventPair[]{authors30Field.with((Object)authors30), authors60Field.with((Object)authors60), authors90Field.with((Object)authors90), commits30Field.with((Object)commits30), commits60Field.with((Object)commits60), commits90Field.with((Object)commits90)};
        List pairs = CollectionsKt.listOf((Object[])objectArray);
        commitsSummaryEvent.log(project, pairs);
    }

    @JvmStatic
    public static final void logAbsentHistorySummary(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        commitsSummaryEvent.log(project, new EventPair[0]);
    }

    @JvmStatic
    public static final void logOssLicense(@NotNull Project project, boolean hasOssLicense) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        EventPair[] eventPairArray = new EventPair[]{ossLicenseField.with((Object)hasOssLicense)};
        doesHaveOssLicenseEvent.log(project, eventPairArray);
    }

    static {
        EventField[] eventFieldArray = new EventField[]{authors30Field, authors60Field, authors90Field, commits30Field, commits60Field, commits90Field};
        commitsSummaryEvent = GROUP.registerVarargEvent("vcs.commits.summary", eventFieldArray);
        ossLicenseField = EventFields.Boolean((String)"oss_license");
        eventFieldArray = new EventField[]{ossLicenseField};
        doesHaveOssLicenseEvent = GROUP.registerVarargEvent("does.have.oss.license", eventFieldArray);
    }
}

