/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.utils;

import com.intellij.rml.dfa.impl.ui.Messages;
import com.intellij.util.ObjectUtils;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;

public final class SortedArrayHelper {
    public static int getPosition(Comparable[] array, Comparable element) {
        int i = ObjectUtils.binarySearch((int)0, (int)array.length, mid -> array[mid].compareTo(element));
        return i < 0 ? -1 : i;
    }

    public static Comparable[] deleteElement(Comparable[] array, Comparable element, Class type) {
        Comparable[] result = (Comparable[])Array.newInstance(type, array.length - 1);
        int index = SortedArrayHelper.getPosition(array, element);
        if (index == -1) {
            throw new IllegalArgumentException(Messages.getString(SortedArrayHelper.class.getName() + "-0"));
        }
        System.arraycopy(array, 0, result, 0, index);
        System.arraycopy(array, index + 1, result, index, array.length - index - 1);
        return result;
    }

    public static void sortAscending(Object[] array, Comparator comparator2) {
        for (int i = 1; i < array.length; ++i) {
            if (comparator2.compare(array[i - 1], array[i]) <= 0) continue;
            Arrays.sort(array, comparator2);
            break;
        }
    }

    public static int[] getAscendingPermutation(Comparable[] array) {
        Object[] indices = new Integer[array.length];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = i;
        }
        SortedArrayHelper.sortAscending(indices, (arg0, arg1) -> {
            int ind1 = (Integer)arg0;
            int ind2 = (Integer)arg1;
            return array[ind1].compareTo(array[ind2]);
        });
        int[] result = new int[indices.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Integer)indices[i];
        }
        return result;
    }

    public static void applyPerm(Object[] array, int[] perm) {
        Object[] clone2 = (Object[])array.clone();
        for (int i = 0; i < perm.length; ++i) {
            array[i] = clone2[perm[i]];
        }
    }

    public static void applyPerm(int[] array, int[] perm) {
        int[] clone2 = (int[])array.clone();
        for (int i = 0; i < perm.length; ++i) {
            array[i] = clone2[perm[i]];
        }
    }

    public static void applyInversePerm(int[] array, int[] perm) {
        int[] clone2 = (int[])array.clone();
        for (int i = 0; i < perm.length; ++i) {
            array[perm[i]] = clone2[i];
        }
    }

    public static int[] getIDPerm(int length) {
        int[] perm = new int[length];
        for (int i = 0; i < length; ++i) {
            perm[i] = i;
        }
        return perm;
    }
}

