/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.git.branch.tree;

import com.intellij.openapi.project.Project;
import com.intellij.platform.vcs.impl.shared.rpc.RepositoryId;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.ui.SeparatorWithText;
import com.intellij.vcs.git.branch.popup.GitBranchesPopupBase;
import com.intellij.vcs.git.branch.tree.GitBranchesTreeModel;
import com.intellij.vcs.git.branch.tree.GitBranchesTreeModelUtilKt;
import com.intellij.vcs.git.branch.tree.LazyRefsSubtreeHolder;
import com.intellij.vcs.git.branch.tree.LazyRepositoryHolder;
import com.intellij.vcs.git.ref.GitRefUtil;
import com.intellij.vcs.git.repo.GitRepositoryModel;
import git4idea.GitReference;
import git4idea.GitStandardLocalBranch;
import git4idea.GitStandardRemoteBranch;
import git4idea.GitTag;
import git4idea.branch.GitBranchType;
import git4idea.branch.GitRefType;
import git4idea.branch.GitTagType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.TreePath;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u000212B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0014J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0014J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0017H\u0014J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0017H\u0014J\u0012\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\bH\u0016J\f\u0010 \u001a\u00020\u001e*\u00020!H\u0002J\u0018\u0010\"\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\b\u0010#\u001a\u0004\u0018\u00010\bH\u0014J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\b0\u0005H\u0002J0\u0010%\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u00052\n\b\u0002\u0010*\u001a\u0004\u0018\u00010\u0006H\u0002J\n\u0010+\u001a\u0004\u0018\u00010,H\u0016J\n\u0010-\u001a\u0004\u0018\u00010\bH\u0002J\n\u0010.\u001a\u0004\u0018\u00010/H\u0002J\b\u00100\u001a\u00020\u001eH\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00060\u0011R\u00020\u0000X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/intellij/vcs/git/branch/tree/GitBranchesTreeMultiRepoFilteringModel;", "Lcom/intellij/vcs/git/branch/tree/GitBranchesTreeModel;", "project", "Lcom/intellij/openapi/project/Project;", "repositories", "", "Lcom/intellij/vcs/git/repo/GitRepositoryModel;", "topLevelActions", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Ljava/util/List;)V", "actionsSeparator", "Lcom/intellij/ui/SeparatorWithText;", "repositoriesSeparator", "repositoriesTree", "Lcom/intellij/vcs/git/branch/tree/LazyRepositoryHolder;", "repositoriesWithBranchesTree", "Lcom/intellij/vcs/git/branch/tree/GitBranchesTreeMultiRepoFilteringModel$LazyRepositoryBranchesHolder;", "rebuild", "", "matcher", "Lcom/intellij/psi/codeStyle/MinusculeMatcher;", "getLocalBranches", "", "Lgit4idea/GitStandardLocalBranch;", "getRemoteBranches", "Lgit4idea/GitStandardRemoteBranch;", "getTags", "Lgit4idea/GitTag;", "isLeaf", "", "node", "isEmpty", "Lcom/intellij/vcs/git/branch/tree/GitBranchesTreeModel$RefTypeUnderRepository;", "getChildren", "parent", "getTopLevelNodes", "getTreeNodes", "branchType", "Lgit4idea/branch/GitRefType;", "path", "", "repository", "getPreferredSelection", "Ljavax/swing/tree/TreePath;", "getPreferredBranch", "getPreferredRefUnderFirstNonEmptyRepo", "Lcom/intellij/vcs/git/branch/tree/GitBranchesTreeModel$RefUnderRepository;", "haveFilteredBranches", "LazyRepositoryBranchesHolder", "LazyRepositoryBranchesSubtreeHolder", "intellij.vcs.git.shared"})
@SourceDebugExtension(value={"SMAP\nGitBranchesTreeMultiRepoFilteringModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitBranchesTreeMultiRepoFilteringModel.kt\ncom/intellij/vcs/git/branch/tree/GitBranchesTreeMultiRepoFilteringModel\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,177:1\n382#2,7:178\n382#2,7:185\n382#2,7:192\n382#2,7:199\n1#3:206\n295#4,2:207\n*S KotlinDebug\n*F\n+ 1 GitBranchesTreeMultiRepoFilteringModel.kt\ncom/intellij/vcs/git/branch/tree/GitBranchesTreeMultiRepoFilteringModel\n*L\n48#1:178,7\n51#1:185,7\n57#1:192,7\n60#1:199,7\n117#1:207,2\n*E\n"})
public final class GitBranchesTreeMultiRepoFilteringModel
extends GitBranchesTreeModel {
    @NotNull
    private final SeparatorWithText actionsSeparator;
    @NotNull
    private final SeparatorWithText repositoriesSeparator;
    private LazyRepositoryHolder repositoriesTree;
    private LazyRepositoryBranchesHolder repositoriesWithBranchesTree;

    public GitBranchesTreeMultiRepoFilteringModel(@NotNull Project project, @NotNull List<? extends GitRepositoryModel> repositories, @NotNull List<? extends Object> topLevelActions) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        Intrinsics.checkNotNullParameter(topLevelActions, (String)"topLevelActions");
        super(project, topLevelActions, repositories);
        this.actionsSeparator = GitBranchesPopupBase.Companion.createTreeSeparator$intellij_vcs_git_shared$default(GitBranchesPopupBase.Companion, null, 1, null);
        this.repositoriesSeparator = GitBranchesPopupBase.Companion.createTreeSeparator$intellij_vcs_git_shared$default(GitBranchesPopupBase.Companion, null, 1, null);
    }

    public /* synthetic */ GitBranchesTreeMultiRepoFilteringModel(Project project, List list, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        this(project, list, list2);
    }

    @Override
    protected void rebuild(@Nullable MinusculeMatcher matcher) {
        super.rebuild(matcher);
        this.repositoriesTree = new LazyRepositoryHolder(this.getProject(), this.getRepositories(), matcher, false);
        this.repositoriesWithBranchesTree = new LazyRepositoryBranchesHolder();
    }

    @Override
    @NotNull
    protected Collection<GitStandardLocalBranch> getLocalBranches() {
        return GitRefUtil.INSTANCE.getCommonLocalBranches((Collection<? extends GitRepositoryModel>)this.getRepositories());
    }

    @NotNull
    protected Collection<GitStandardRemoteBranch> getRemoteBranches() {
        return GitRefUtil.INSTANCE.getCommonRemoteBranches((Collection<? extends GitRepositoryModel>)this.getRepositories());
    }

    @Override
    @NotNull
    protected Collection<GitTag> getTags() {
        return GitRefUtil.INSTANCE.getCommonTags((Collection<? extends GitRepositoryModel>)this.getRepositories());
    }

    @Override
    public boolean isLeaf(@Nullable Object node) {
        return super.isLeaf(node) || node instanceof GitBranchesTreeModel.RefTypeUnderRepository && this.isEmpty((GitBranchesTreeModel.RefTypeUnderRepository)node);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isEmpty(GitBranchesTreeModel.RefTypeUnderRepository $this$isEmpty) {
        if ($this$isEmpty.getType() == GitBranchType.LOCAL) {
            LazyRepositoryBranchesHolder lazyRepositoryBranchesHolder = this.repositoriesWithBranchesTree;
            if (lazyRepositoryBranchesHolder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"repositoriesWithBranchesTree");
                lazyRepositoryBranchesHolder = null;
            }
            if (lazyRepositoryBranchesHolder.isLocalBranchesEmpty($this$isEmpty.getRepository().getRepositoryId())) return true;
        }
        if ($this$isEmpty.getType() != GitBranchType.REMOTE) return false;
        LazyRepositoryBranchesHolder lazyRepositoryBranchesHolder = this.repositoriesWithBranchesTree;
        if (lazyRepositoryBranchesHolder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repositoriesWithBranchesTree");
            lazyRepositoryBranchesHolder = null;
        }
        if (!lazyRepositoryBranchesHolder.isRemoteBranchesEmpty($this$isEmpty.getRepository().getRepositoryId())) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected List<Object> getChildren(@Nullable Object parent) {
        List list;
        if (parent == null || !this.haveFilteredBranches()) {
            return CollectionsKt.emptyList();
        }
        Object object = parent;
        if (Intrinsics.areEqual((Object)object, (Object)GitBranchesTreeModel.TreeRoot.INSTANCE)) {
            list = this.getTopLevelNodes();
        } else if (object instanceof GitBranchType) {
            Object object2;
            void $this$getOrPut$iv;
            Map<Object, List<Object>> map = this.getBranchesTreeCache();
            Object key$iv = parent;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                List answer$iv = GitBranchesTreeMultiRepoFilteringModel.getTreeNodes$default(this, (GitRefType)parent, CollectionsKt.emptyList(), null, 4, null);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object2 = answer$iv;
            } else {
                object2 = value$iv;
            }
            list = (List)object2;
        } else if (object instanceof GitBranchesTreeModel.BranchesPrefixGroup) {
            List list2;
            Map<Object, List<Object>> $this$getOrPut$iv = this.getBranchesTreeCache();
            Object key$iv = parent;
            boolean $i$f$getOrPut = false;
            List value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                List answer$iv = CollectionsKt.sortedWith((Iterable)this.getTreeNodes(((GitBranchesTreeModel.BranchesPrefixGroup)parent).getType(), ((GitBranchesTreeModel.BranchesPrefixGroup)parent).getPrefix(), ((GitBranchesTreeModel.BranchesPrefixGroup)parent).getRepository()), this.getSubTreeComparator());
                $this$getOrPut$iv.put(key$iv, answer$iv);
                list2 = answer$iv;
            } else {
                list2 = value$iv;
            }
            list = list2;
        } else if (object instanceof GitBranchesTreeModel.RefTypeUnderRepository) {
            List<Object> list3;
            Map<Object, List<Object>> $this$getOrPut$iv = this.getBranchesTreeCache();
            Object key$iv = parent;
            boolean $i$f$getOrPut = false;
            List<Object> value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                List<Object> answer$iv = this.getTreeNodes(((GitBranchesTreeModel.RefTypeUnderRepository)parent).getType(), CollectionsKt.emptyList(), ((GitBranchesTreeModel.RefTypeUnderRepository)parent).getRepository());
                $this$getOrPut$iv.put(key$iv, answer$iv);
                list3 = answer$iv;
            } else {
                list3 = value$iv;
            }
            list = list3;
        } else if (object instanceof GitBranchesTreeModel.RepositoryNode) {
            if (((GitBranchesTreeModel.RepositoryNode)parent).isLeaf()) {
                list = CollectionsKt.emptyList();
            } else {
                List list4;
                Map<Object, List<Object>> $this$getOrPut$iv = this.getBranchesTreeCache();
                Object key$iv = parent;
                boolean $i$f$getOrPut = false;
                List value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    LazyRepositoryBranchesHolder lazyRepositoryBranchesHolder;
                    LazyRepositoryBranchesHolder lazyRepositoryBranchesHolder2;
                    List list5;
                    boolean bl = false;
                    GitRepositoryModel repository = ((GitBranchesTreeModel.RepositoryNode)parent).getRepository();
                    List $this$getChildren_u24lambda_u243_u240 = list5 = CollectionsKt.createListBuilder();
                    boolean bl2 = false;
                    LazyRepositoryBranchesHolder lazyRepositoryBranchesHolder3 = this.repositoriesWithBranchesTree;
                    if (lazyRepositoryBranchesHolder3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"repositoriesWithBranchesTree");
                        lazyRepositoryBranchesHolder3 = null;
                    }
                    if (!lazyRepositoryBranchesHolder3.isLocalBranchesEmpty(repository.getRepositoryId())) {
                        $this$getChildren_u24lambda_u243_u240.add(new GitBranchesTreeModel.RefTypeUnderRepository(repository, GitBranchType.LOCAL));
                    }
                    if ((lazyRepositoryBranchesHolder2 = this.repositoriesWithBranchesTree) == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"repositoriesWithBranchesTree");
                        lazyRepositoryBranchesHolder2 = null;
                    }
                    if (!lazyRepositoryBranchesHolder2.isRemoteBranchesEmpty(repository.getRepositoryId())) {
                        $this$getChildren_u24lambda_u243_u240.add(new GitBranchesTreeModel.RefTypeUnderRepository(repository, GitBranchType.REMOTE));
                    }
                    if ((lazyRepositoryBranchesHolder = this.repositoriesWithBranchesTree) == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"repositoriesWithBranchesTree");
                        lazyRepositoryBranchesHolder = null;
                    }
                    if (!lazyRepositoryBranchesHolder.isTagsEmpty(repository.getRepositoryId())) {
                        $this$getChildren_u24lambda_u243_u240.add(new GitBranchesTreeModel.RefTypeUnderRepository(repository, GitTagType.INSTANCE));
                    }
                    List answer$iv = CollectionsKt.build((List)list5);
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    list4 = answer$iv;
                } else {
                    list4 = value$iv;
                }
                list = list4;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final List<Object> getTopLevelNodes() {
        Collection matchedRepos;
        Collection matchedActions = this.getActionsTree().getMatch();
        LazyRepositoryHolder lazyRepositoryHolder = this.repositoriesTree;
        if (lazyRepositoryHolder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repositoriesTree");
            lazyRepositoryHolder = null;
        }
        if (!(matchedRepos = lazyRepositoryHolder.getMatch()).isEmpty()) {
            GitBranchesTreeModelUtilKt.addSeparatorIfNeeded(matchedActions, this.actionsSeparator);
        }
        List topNodes = CollectionsKt.plus(matchedActions, (Iterable)matchedRepos);
        List localAndRemoteNodes = GitBranchesTreeModelUtilKt.getLocalAndRemoteTopLevelNodes$default(this.getLocalBranchesTree(), this.getRemoteBranchesTree(), this.getTagsTree(), null, 8, null);
        LazyRepositoryBranchesHolder lazyRepositoryBranchesHolder = this.repositoriesWithBranchesTree;
        if (lazyRepositoryBranchesHolder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repositoriesWithBranchesTree");
            lazyRepositoryBranchesHolder = null;
        }
        List<GitBranchesTreeModel.RepositoryNode> notEmptyRepositories = lazyRepositoryBranchesHolder.getRepoNodes();
        if (!((Collection)localAndRemoteNodes).isEmpty() || !((Collection)notEmptyRepositories).isEmpty()) {
            GitBranchesTreeModelUtilKt.addSeparatorIfNeeded(topNodes, this.repositoriesSeparator);
        }
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)topNodes, (Iterable)localAndRemoteNodes), (Iterable)notEmptyRepositories);
    }

    private final List<Object> getTreeNodes(GitRefType branchType, List<String> path, GitRepositoryModel repository) {
        Map<String, Object> map;
        if (GitBranchType.LOCAL == branchType && repository == null) {
            map = this.getLocalBranchesTree().getTree();
        } else if (GitBranchType.LOCAL == branchType && repository != null) {
            LazyRepositoryBranchesHolder lazyRepositoryBranchesHolder = this.repositoriesWithBranchesTree;
            if (lazyRepositoryBranchesHolder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"repositoriesWithBranchesTree");
                lazyRepositoryBranchesHolder = null;
            }
            map = lazyRepositoryBranchesHolder.get(repository.getRepositoryId()).getLocalBranches().getTree();
        } else if (GitBranchType.REMOTE == branchType && repository == null) {
            map = this.getRemoteBranchesTree().getTree();
        } else if (GitBranchType.REMOTE == branchType && repository != null) {
            LazyRepositoryBranchesHolder lazyRepositoryBranchesHolder = this.repositoriesWithBranchesTree;
            if (lazyRepositoryBranchesHolder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"repositoriesWithBranchesTree");
                lazyRepositoryBranchesHolder = null;
            }
            map = lazyRepositoryBranchesHolder.get(repository.getRepositoryId()).getRemoteBranches().getTree();
        } else if (Intrinsics.areEqual((Object)GitTagType.INSTANCE, (Object)branchType) && repository == null) {
            map = this.getTagsTree().getTree();
        } else if (Intrinsics.areEqual((Object)GitTagType.INSTANCE, (Object)branchType) && repository != null) {
            LazyRepositoryBranchesHolder lazyRepositoryBranchesHolder = this.repositoriesWithBranchesTree;
            if (lazyRepositoryBranchesHolder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"repositoriesWithBranchesTree");
                lazyRepositoryBranchesHolder = null;
            }
            map = lazyRepositoryBranchesHolder.get(repository.getRepositoryId()).getTags().getTree();
        } else {
            map = MapsKt.emptyMap();
        }
        Map<String, Object> branchesMap = map;
        return GitBranchesTreeModelUtilKt.buildBranchTreeNodes(branchType, branchesMap, path, repository);
    }

    static /* synthetic */ List getTreeNodes$default(GitBranchesTreeMultiRepoFilteringModel gitBranchesTreeMultiRepoFilteringModel, GitRefType gitRefType, List list, GitRepositoryModel gitRepositoryModel, int n, Object object) {
        if ((n & 4) != 0) {
            gitRepositoryModel = null;
        }
        return gitBranchesTreeMultiRepoFilteringModel.getTreeNodes(gitRefType, list, gitRepositoryModel);
    }

    @Override
    @Nullable
    public TreePath getPreferredSelection() {
        TreePath treePath;
        Object object = this.getActionsTree().getTopMatch();
        if (object == null) {
            LazyRepositoryHolder lazyRepositoryHolder = this.repositoriesTree;
            if (lazyRepositoryHolder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"repositoriesTree");
                lazyRepositoryHolder = null;
            }
            if ((object = (GitBranchesTreeModel.RepositoryNode)lazyRepositoryHolder.getTopMatch()) == null) {
                object = this.getPreferredBranch();
            }
        }
        if (object != null) {
            Object it = object;
            boolean bl = false;
            treePath = GitBranchesTreeModelUtilKt.createTreePathFor(this, it);
        } else {
            treePath = null;
        }
        return treePath;
    }

    private final Object getPreferredBranch() {
        Object object = GitBranchesTreeModelUtilKt.getPreferredBranch$default(this.getProject(), this.getRepositories(), this.getNameMatcher(), this.getLocalBranchesTree(), this.getRemoteBranchesTree(), this.getTagsTree(), null, 64, null);
        if (object == null) {
            object = this.getPreferredRefUnderFirstNonEmptyRepo();
        }
        return object;
    }

    private final GitBranchesTreeModel.RefUnderRepository getPreferredRefUnderFirstNonEmptyRepo() {
        GitBranchesTreeModel.RefUnderRepository refUnderRepository;
        Object v1;
        block6: {
            Iterable $this$firstOrNull$iv = this.getRepositories();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                GitRepositoryModel it = (GitRepositoryModel)element$iv;
                boolean bl = false;
                LazyRepositoryBranchesHolder lazyRepositoryBranchesHolder = this.repositoriesWithBranchesTree;
                if (lazyRepositoryBranchesHolder == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"repositoriesWithBranchesTree");
                    lazyRepositoryBranchesHolder = null;
                }
                if (!lazyRepositoryBranchesHolder.isNotEmpty(it.getRepositoryId())) continue;
                v1 = element$iv;
                break block6;
            }
            v1 = null;
        }
        GitRepositoryModel gitRepositoryModel = v1;
        if (gitRepositoryModel == null) {
            return null;
        }
        GitRepositoryModel nonEmptyRepo = gitRepositoryModel;
        LazyRepositoryBranchesHolder lazyRepositoryBranchesHolder = this.repositoriesWithBranchesTree;
        if (lazyRepositoryBranchesHolder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repositoriesWithBranchesTree");
            lazyRepositoryBranchesHolder = null;
        }
        LazyRepositoryBranchesSubtreeHolder subtreeHolder = lazyRepositoryBranchesHolder.get(nonEmptyRepo.getRepositoryId());
        GitReference gitReference = GitBranchesTreeModelUtilKt.getPreferredBranch$default(this.getProject(), CollectionsKt.listOf((Object)nonEmptyRepo), this.getNameMatcher(), subtreeHolder.getLocalBranches(), subtreeHolder.getRemoteBranches(), subtreeHolder.getTags(), null, 64, null);
        if (gitReference != null) {
            GitReference it = gitReference;
            boolean bl = false;
            refUnderRepository = new GitBranchesTreeModel.RefUnderRepository(nonEmptyRepo, it);
        } else {
            refUnderRepository = null;
        }
        return refUnderRepository;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean haveFilteredBranches() {
        if (!this.getActionsTree().isEmpty()) return true;
        LazyRepositoryHolder lazyRepositoryHolder = this.repositoriesTree;
        if (lazyRepositoryHolder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repositoriesTree");
            lazyRepositoryHolder = null;
        }
        if (!lazyRepositoryHolder.isEmpty()) return true;
        if (!this.areRefTreesEmpty()) return true;
        LazyRepositoryBranchesHolder lazyRepositoryBranchesHolder = this.repositoriesWithBranchesTree;
        if (lazyRepositoryBranchesHolder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repositoriesWithBranchesTree");
            lazyRepositoryBranchesHolder = null;
        }
        if (!lazyRepositoryBranchesHolder.isLocalBranchesEmpty()) return true;
        LazyRepositoryBranchesHolder lazyRepositoryBranchesHolder2 = this.repositoriesWithBranchesTree;
        if (lazyRepositoryBranchesHolder2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repositoriesWithBranchesTree");
            lazyRepositoryBranchesHolder2 = null;
        }
        if (lazyRepositoryBranchesHolder2.isRemoteBranchesEmpty()) return false;
        return true;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\f\u001a\u00060\nR\u00020\u000b2\u0006\u0010\r\u001a\u00020\tH\u0086\u0002J\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\tJ\u0006\u0010\u0010\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\tJ\u0006\u0010\u0011\u001a\u00020\u000fJ\u000e\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\tJ\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\tJ\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\b\u0012\u00060\nR\u00020\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/vcs/git/branch/tree/GitBranchesTreeMultiRepoFilteringModel$LazyRepositoryBranchesHolder;", "", "<init>", "(Lcom/intellij/vcs/git/branch/tree/GitBranchesTreeMultiRepoFilteringModel;)V", "repositoryNodes", "", "Lcom/intellij/vcs/git/branch/tree/GitBranchesTreeModel$RepositoryNode;", "tree", "", "Lcom/intellij/platform/vcs/impl/shared/rpc/RepositoryId;", "Lcom/intellij/vcs/git/branch/tree/GitBranchesTreeMultiRepoFilteringModel$LazyRepositoryBranchesSubtreeHolder;", "Lcom/intellij/vcs/git/branch/tree/GitBranchesTreeMultiRepoFilteringModel;", "get", "repositoryId", "isLocalBranchesEmpty", "", "isRemoteBranchesEmpty", "isTagsEmpty", "isNotEmpty", "getRepoNodes", "intellij.vcs.git.shared"})
    @SourceDebugExtension(value={"SMAP\nGitBranchesTreeMultiRepoFilteringModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitBranchesTreeMultiRepoFilteringModel.kt\ncom/intellij/vcs/git/branch/tree/GitBranchesTreeMultiRepoFilteringModel$LazyRepositoryBranchesHolder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,177:1\n1563#2:178\n1634#2,3:179\n1193#2,2:182\n1267#2,4:184\n1740#2,3:188\n1740#2,3:191\n1740#2,3:194\n774#2:197\n865#2,2:198\n*S KotlinDebug\n*F\n+ 1 GitBranchesTreeMultiRepoFilteringModel.kt\ncom/intellij/vcs/git/branch/tree/GitBranchesTreeMultiRepoFilteringModel$LazyRepositoryBranchesHolder\n*L\n132#1:178\n132#1:179,3\n135#1:182,2\n135#1:184,4\n139#1:188,3\n141#1:191,3\n143#1:194,3\n147#1:197\n147#1:198,2\n*E\n"})
    private final class LazyRepositoryBranchesHolder {
        @NotNull
        private final List<GitBranchesTreeModel.RepositoryNode> repositoryNodes;
        @NotNull
        private final Map<RepositoryId, LazyRepositoryBranchesSubtreeHolder> tree;

        /*
         * WARNING - void declaration
         */
        public LazyRepositoryBranchesHolder() {
            void $this$associateTo$iv$iv;
            void $this$associate$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Iterable iterable = GitBranchesTreeMultiRepoFilteringModel.this.getRepositories();
            LazyRepositoryBranchesHolder lazyRepositoryBranchesHolder = this;
            boolean $i$f$map = false;
            void var4_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo22 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                GitRepositoryModel gitRepositoryModel = (GitRepositoryModel)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new GitBranchesTreeModel.RepositoryNode((GitRepositoryModel)it, false));
            }
            lazyRepositoryBranchesHolder.repositoryNodes = (List)destination$iv$iv;
            $this$map$iv = GitBranchesTreeMultiRepoFilteringModel.this.getRepositories();
            GitBranchesTreeMultiRepoFilteringModel gitBranchesTreeMultiRepoFilteringModel = GitBranchesTreeMultiRepoFilteringModel.this;
            lazyRepositoryBranchesHolder = this;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            void $i$f$mapTo22 = $this$associate$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv2;
                GitRepositoryModel it = (GitRepositoryModel)element$iv$iv;
                boolean bl = false;
                Pair pair = TuplesKt.to((Object)it.getRepositoryId(), (Object)gitBranchesTreeMultiRepoFilteringModel.new LazyRepositoryBranchesSubtreeHolder(it));
                map.put(pair.getFirst(), pair.getSecond());
            }
            lazyRepositoryBranchesHolder.tree = destination$iv$iv2;
        }

        @NotNull
        public final LazyRepositoryBranchesSubtreeHolder get(@NotNull RepositoryId repositoryId) {
            Intrinsics.checkNotNullParameter((Object)repositoryId, (String)"repositoryId");
            LazyRepositoryBranchesSubtreeHolder lazyRepositoryBranchesSubtreeHolder = this.tree.get(repositoryId);
            if (lazyRepositoryBranchesSubtreeHolder == null) {
                throw new IllegalStateException(("Repository " + repositoryId + " is not present in the model").toString());
            }
            return lazyRepositoryBranchesSubtreeHolder;
        }

        public final boolean isLocalBranchesEmpty() {
            boolean bl;
            block3: {
                Iterable $this$all$iv = this.tree.values();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        LazyRepositoryBranchesSubtreeHolder it = (LazyRepositoryBranchesSubtreeHolder)element$iv;
                        boolean bl2 = false;
                        if (it.getLocalBranches().isEmpty()) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        public final boolean isLocalBranchesEmpty(@NotNull RepositoryId repositoryId) {
            Intrinsics.checkNotNullParameter((Object)repositoryId, (String)"repositoryId");
            Object object = this.tree.get(repositoryId);
            return object != null && (object = ((LazyRepositoryBranchesSubtreeHolder)object).getLocalBranches()) != null ? ((LazyRefsSubtreeHolder)object).isEmpty() : true;
        }

        public final boolean isRemoteBranchesEmpty() {
            boolean bl;
            block3: {
                Iterable $this$all$iv = this.tree.values();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        LazyRepositoryBranchesSubtreeHolder it = (LazyRepositoryBranchesSubtreeHolder)element$iv;
                        boolean bl2 = false;
                        if (it.getRemoteBranches().isEmpty()) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        public final boolean isRemoteBranchesEmpty(@NotNull RepositoryId repositoryId) {
            Intrinsics.checkNotNullParameter((Object)repositoryId, (String)"repositoryId");
            Object object = this.tree.get(repositoryId);
            return object != null && (object = ((LazyRepositoryBranchesSubtreeHolder)object).getRemoteBranches()) != null ? ((LazyRefsSubtreeHolder)object).isEmpty() : true;
        }

        public final boolean isTagsEmpty() {
            boolean bl;
            block3: {
                Iterable $this$all$iv = this.tree.values();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        LazyRepositoryBranchesSubtreeHolder it = (LazyRepositoryBranchesSubtreeHolder)element$iv;
                        boolean bl2 = false;
                        if (it.getTags().isEmpty()) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        public final boolean isTagsEmpty(@NotNull RepositoryId repositoryId) {
            Intrinsics.checkNotNullParameter((Object)repositoryId, (String)"repositoryId");
            Object object = this.tree.get(repositoryId);
            return object != null && (object = ((LazyRepositoryBranchesSubtreeHolder)object).getTags()) != null ? ((LazyRefsSubtreeHolder)object).isEmpty() : true;
        }

        public final boolean isNotEmpty(@NotNull RepositoryId repositoryId) {
            Intrinsics.checkNotNullParameter((Object)repositoryId, (String)"repositoryId");
            return !this.isLocalBranchesEmpty(repositoryId) || !this.isRemoteBranchesEmpty(repositoryId) || !this.isTagsEmpty(repositoryId);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<GitBranchesTreeModel.RepositoryNode> getRepoNodes() {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.repositoryNodes;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                GitBranchesTreeModel.RepositoryNode it = (GitBranchesTreeModel.RepositoryNode)element$iv$iv;
                boolean bl = false;
                if (!this.isNotEmpty(it.getRepository().getRepositoryId())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR!\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\f\u001a\u0004\b\u000f\u0010\nR!\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\f\u001a\u0004\b\u0013\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/intellij/vcs/git/branch/tree/GitBranchesTreeMultiRepoFilteringModel$LazyRepositoryBranchesSubtreeHolder;", "", "repository", "Lcom/intellij/vcs/git/repo/GitRepositoryModel;", "<init>", "(Lcom/intellij/vcs/git/branch/tree/GitBranchesTreeMultiRepoFilteringModel;Lcom/intellij/vcs/git/repo/GitRepositoryModel;)V", "localBranches", "Lcom/intellij/vcs/git/branch/tree/LazyRefsSubtreeHolder;", "Lgit4idea/GitStandardLocalBranch;", "getLocalBranches", "()Lcom/intellij/vcs/git/branch/tree/LazyRefsSubtreeHolder;", "localBranches$delegate", "Lkotlin/Lazy;", "remoteBranches", "Lgit4idea/GitStandardRemoteBranch;", "getRemoteBranches", "remoteBranches$delegate", "tags", "Lgit4idea/GitTag;", "getTags", "tags$delegate", "intellij.vcs.git.shared"})
    private final class LazyRepositoryBranchesSubtreeHolder {
        @NotNull
        private final GitRepositoryModel repository;
        @NotNull
        private final Lazy localBranches$delegate;
        @NotNull
        private final Lazy remoteBranches$delegate;
        @NotNull
        private final Lazy tags$delegate;

        public LazyRepositoryBranchesSubtreeHolder(GitRepositoryModel repository) {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            this.repository = repository;
            this.localBranches$delegate = LazyKt.lazy(() -> LazyRepositoryBranchesSubtreeHolder.localBranches_delegate$lambda$0(this, GitBranchesTreeMultiRepoFilteringModel.this));
            this.remoteBranches$delegate = LazyKt.lazy(() -> LazyRepositoryBranchesSubtreeHolder.remoteBranches_delegate$lambda$0(this, GitBranchesTreeMultiRepoFilteringModel.this));
            this.tags$delegate = LazyKt.lazy(() -> LazyRepositoryBranchesSubtreeHolder.tags_delegate$lambda$0(this, GitBranchesTreeMultiRepoFilteringModel.this));
        }

        @NotNull
        public final LazyRefsSubtreeHolder<GitStandardLocalBranch> getLocalBranches() {
            Lazy lazy = this.localBranches$delegate;
            return (LazyRefsSubtreeHolder)lazy.getValue();
        }

        @NotNull
        public final LazyRefsSubtreeHolder<GitStandardRemoteBranch> getRemoteBranches() {
            Lazy lazy = this.remoteBranches$delegate;
            return (LazyRefsSubtreeHolder)lazy.getValue();
        }

        @NotNull
        public final LazyRefsSubtreeHolder<GitTag> getTags() {
            Lazy lazy = this.tags$delegate;
            return (LazyRefsSubtreeHolder)lazy.getValue();
        }

        private static final LazyRefsSubtreeHolder localBranches_delegate$lambda$0(LazyRepositoryBranchesSubtreeHolder this$0, GitBranchesTreeMultiRepoFilteringModel this$1) {
            return new LazyRefsSubtreeHolder(this$0.repository.getState().getLocalBranchesOrCurrent(), this$1.getNameMatcher(), (Function0)new MutablePropertyReference0Impl((Object)this$1){

                public Object get() {
                    return ((GitBranchesTreeMultiRepoFilteringModel)((Object)this.receiver)).isPrefixGrouping();
                }

                public void set(Object value) {
                    ((GitBranchesTreeMultiRepoFilteringModel)((Object)this.receiver)).setPrefixGrouping((Boolean)value);
                }
            }, null, () -> LazyRepositoryBranchesSubtreeHolder.localBranches_delegate$lambda$0$0(this$1, this$0), 8, null);
        }

        private static final Comparator localBranches_delegate$lambda$0$0(GitBranchesTreeMultiRepoFilteringModel this$0, LazyRepositoryBranchesSubtreeHolder this$1) {
            return this$0.getRefComparator(CollectionsKt.listOf((Object)this$1.repository));
        }

        private static final LazyRefsSubtreeHolder remoteBranches_delegate$lambda$0(LazyRepositoryBranchesSubtreeHolder this$0, GitBranchesTreeMultiRepoFilteringModel this$1) {
            return new LazyRefsSubtreeHolder(this$0.repository.getState().getRemoteBranches(), this$1.getNameMatcher(), (Function0)new MutablePropertyReference0Impl((Object)this$1){

                public Object get() {
                    return ((GitBranchesTreeMultiRepoFilteringModel)((Object)this.receiver)).isPrefixGrouping();
                }

                public void set(Object value) {
                    ((GitBranchesTreeMultiRepoFilteringModel)((Object)this.receiver)).setPrefixGrouping((Boolean)value);
                }
            }, null, () -> LazyRepositoryBranchesSubtreeHolder.remoteBranches_delegate$lambda$0$0(this$1, this$0), 8, null);
        }

        private static final Comparator remoteBranches_delegate$lambda$0$0(GitBranchesTreeMultiRepoFilteringModel this$0, LazyRepositoryBranchesSubtreeHolder this$1) {
            return this$0.getRefComparator(CollectionsKt.listOf((Object)this$1.repository));
        }

        private static final LazyRefsSubtreeHolder tags_delegate$lambda$0(LazyRepositoryBranchesSubtreeHolder this$0, GitBranchesTreeMultiRepoFilteringModel this$1) {
            return new LazyRefsSubtreeHolder(this$0.repository.getState().getTags(), this$1.getNameMatcher(), (Function0)new MutablePropertyReference0Impl((Object)this$1){

                public Object get() {
                    return ((GitBranchesTreeMultiRepoFilteringModel)((Object)this.receiver)).isPrefixGrouping();
                }

                public void set(Object value) {
                    ((GitBranchesTreeMultiRepoFilteringModel)((Object)this.receiver)).setPrefixGrouping((Boolean)value);
                }
            }, null, () -> LazyRepositoryBranchesSubtreeHolder.tags_delegate$lambda$0$0(this$1, this$0), 8, null);
        }

        private static final Comparator tags_delegate$lambda$0$0(GitBranchesTreeMultiRepoFilteringModel this$0, LazyRepositoryBranchesSubtreeHolder this$1) {
            return this$0.getRefComparator(CollectionsKt.listOf((Object)this$1.repository));
        }
    }
}

