/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgres;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.base.TypeHelper;
import com.intellij.database.dialects.postgres.model.PgDefType;
import com.intellij.database.dialects.postgresbase.PgDialectBase;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.DdlBuilder;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PgDialect
extends PgDialectBase
implements DatabaseDialect {
    private final Dbms myDbms;

    public PgDialect(@NotNull Dbms dbms) {
        if (dbms == null) {
            PgDialect.$$$reportNull$$$0(0);
        }
        super((TypeHelper)new TypeHelper.PgTypeHelper());
        this.myDbms = dbms;
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = this.myDbms;
        if (dbms == null) {
            PgDialect.$$$reportNull$$$0(1);
        }
        return dbms;
    }

    @NotNull
    public String getDisplayName() {
        String string = this.myDbms.getDisplayName();
        if (string == null) {
            PgDialect.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean canUnquoteAlias(@NotNull String alias, @Nullable ObjectKind kind, boolean afterAS) {
        if (alias == null) {
            PgDialect.$$$reportNull$$$0(3);
        }
        if (!this.isValidPlainIdentifier(alias)) {
            return false;
        }
        if (afterAS) {
            return true;
        }
        return !DbSqlUtilCore.getSqlDialect((Dbms)this.getDbms()).getKeywords().contains(alias);
    }

    @NotNull
    public DdlBuilder qualifiedIdentifier(@NotNull DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (builder == null) {
            PgDialect.$$$reportNull$$$0(4);
        }
        if (identifier == null) {
            PgDialect.$$$reportNull$$$0(5);
        }
        if (qualifier == null) {
            PgDialect.$$$reportNull$$$0(6);
        }
        DasObject schema = DasUtil.getSchemaObject((DasObject)qualifier);
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, schema, DasUtil.getName((DasObject)schema), null, null, null, null);
        if (ddlBuilder == null) {
            PgDialect.$$$reportNull$$$0(7);
        }
        return ddlBuilder;
    }

    @Nullable
    public DataType convertUDTToDataType(@NotNull DasUserDefinedType type) {
        Object delegate;
        if (type == null) {
            PgDialect.$$$reportNull$$$0(8);
        }
        if (!((delegate = DbImplUtilCore.unwrap((DasObject)type)) instanceof PgDefType)) {
            return null;
        }
        List labels = ((PgDefType)delegate).getLabels();
        if (labels.isEmpty()) {
            return null;
        }
        return DataTypeFactory.ofValues(null, null, (String)type.getName(), (List)labels, (boolean)false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/postgres/PgDialect";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/postgres/PgDialect";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "canUnquoteAlias";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "convertUDTToDataType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 7 -> new IllegalStateException(string);
        };
    }
}

