/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.code.provenance.dev.view.presenter;

import com.intellij.code.provenance.core.ProvenanceEntry;
import com.intellij.code.provenance.core.events.utils.UtilsKt;
import com.intellij.code.provenance.dev.ProvenanceDevBundle;
import com.intellij.code.provenance.dev.view.presenter.ChangeDetails;
import com.intellij.code.provenance.dev.view.presenter.ChangeKind;
import com.intellij.code.provenance.dev.view.presenter.ChangePresenterWithDetails;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.project.Project;
import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.Date;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001a"}, d2={"Lcom/intellij/code/provenance/dev/view/presenter/ChangePresenter;", "Lcom/intellij/code/provenance/dev/view/presenter/ChangeDetails;", "id", "", "caption", "", "kind", "Lcom/intellij/code/provenance/dev/view/presenter/ChangeKind;", "timestamp", "", "<init>", "(ILjava/lang/String;Lcom/intellij/code/provenance/dev/view/presenter/ChangeKind;J)V", "getId", "()I", "getCaption", "()Ljava/lang/String;", "getKind", "()Lcom/intellij/code/provenance/dev/view/presenter/ChangeKind;", "getTimestamp", "()J", "getDetails", "Ljava/awt/Component;", "project", "Lcom/intellij/openapi/project/Project;", "toString", "Companion", "intellij.code.provenance.dev"})
public class ChangePresenter
implements ChangeDetails {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int id;
    @NotNull
    private final String caption;
    @NotNull
    private final ChangeKind kind;
    private final long timestamp;

    public ChangePresenter(int id, @NotNull String caption, @NotNull ChangeKind kind, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)caption, (String)"caption");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        this.id = id;
        this.caption = caption;
        this.kind = kind;
        this.timestamp = timestamp;
    }

    public final int getId() {
        return this.id;
    }

    @NotNull
    public final String getCaption() {
        return this.caption;
    }

    @NotNull
    public final ChangeKind getKind() {
        return this.kind;
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    @Override
    @Nullable
    public Component getDetails(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return null;
    }

    @NotNull
    public String toString() {
        Object[] objectArray = new Object[]{this.id, this.caption, Companion.formatEntryDateTime(this.timestamp)};
        return ProvenanceDevBundle.INSTANCE.message("provenance.dev.presenter.llm.entry.description", objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001d\u0010\u0010\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0005H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/code/provenance/dev/view/presenter/ChangePresenter$Companion;", "", "<init>", "()V", "formatEntryDateTime", "", "timestamp", "", "fromEvent", "Lcom/intellij/code/provenance/dev/view/presenter/ChangePresenter;", "id", "", "event", "Lcom/intellij/code/provenance/core/ProvenanceEntry;", "project", "Lcom/intellij/openapi/project/Project;", "getPresentableFilePath", "Lcom/intellij/openapi/util/NlsSafe;", "filePath", "intellij.code.provenance.dev"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String formatEntryDateTime(long timestamp) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss - dd-MM-yyyy");
            String string = dateFormat.format(new Date(timestamp));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            return string;
        }

        @NotNull
        public final ChangePresenter fromEvent(int id, @NotNull ProvenanceEntry event, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ProvenanceEntry provenanceEntry = event;
            if (!(provenanceEntry instanceof ProvenanceEntry.Idle)) {
                if (provenanceEntry instanceof ProvenanceEntry.DocumentChange) {
                    Object[] objectArray = new Object[]{((ProvenanceEntry.DocumentChange)event).getKind(), this.getPresentableFilePath(project, ((ProvenanceEntry.DocumentChange)event).getDocumentPath()), ((ProvenanceEntry.DocumentChange)event).getDurationMs()};
                    String caption = ProvenanceDevBundle.INSTANCE.message("provenance.dev.presenter.document.change", objectArray);
                    return new ChangePresenterWithDetails(id, ((ProvenanceEntry.DocumentChange)event).getOldContentHash() + "->" + ((ProvenanceEntry.DocumentChange)event).getNewContentHash() + "|" + ((ProvenanceEntry.DocumentChange)event).getKind().name() + "|" + ((ProvenanceEntry.DocumentChange)event).getDiff(), caption, ChangeKind.CodeChanges, ((ProvenanceEntry.DocumentChange)event).getTimestamp());
                }
                if (provenanceEntry instanceof ProvenanceEntry.ExternalDocumentChange) {
                    Object[] objectArray = new Object[]{((ProvenanceEntry.ExternalDocumentChange)event).getKind(), this.getPresentableFilePath(project, ((ProvenanceEntry.ExternalDocumentChange)event).getDocumentPath())};
                    String caption = ProvenanceDevBundle.INSTANCE.message("provenance.dev.presenter.external.document.change", objectArray);
                    return new ChangePresenterWithDetails(id, ((ProvenanceEntry.ExternalDocumentChange)event).getOldContentHash() + "->" + ((ProvenanceEntry.ExternalDocumentChange)event).getNewContentHash() + "|" + ((ProvenanceEntry.ExternalDocumentChange)event).getKind().name(), caption, ChangeKind.CodeChanges, ((ProvenanceEntry.ExternalDocumentChange)event).getTimestamp());
                }
                if (provenanceEntry instanceof ProvenanceEntry.ContentChangeByLocalHistory) {
                    String string;
                    String caption;
                    Object[] objectArray = new Object[]{this.getPresentableFilePath(project, ((ProvenanceEntry.ContentChangeByLocalHistory)event).getDocumentPath())};
                    String contentChangeMessage = ProvenanceDevBundle.INSTANCE.message("provenance.dev.presenter.content.change", objectArray);
                    if (((CharSequence)((ProvenanceEntry.ContentChangeByLocalHistory)event).getChangeSetName()).length() > 0) {
                        Object[] objectArray2 = new Object[]{this.getPresentableFilePath(project, ((ProvenanceEntry.ContentChangeByLocalHistory)event).getDocumentPath()), ((ProvenanceEntry.ContentChangeByLocalHistory)event).getChangeSetName()};
                        v0 = ProvenanceDevBundle.INSTANCE.message("provenance.dev.presenter.content.change.with.changeset", objectArray2);
                    } else {
                        v0 = caption = contentChangeMessage;
                    }
                    if ((string = UtilsKt.getContent$default((ProvenanceEntry.ContentChangeByLocalHistory)((ProvenanceEntry.ContentChangeByLocalHistory)event), null, (int)1, null)) == null) {
                        string = ProvenanceDevBundle.INSTANCE.message("provenance.dev.presenter.content.not.found", new Object[0]);
                    }
                    String content = string;
                    return new ChangePresenterWithDetails(id, content, caption, ChangeKind.CodeChanges, ((ProvenanceEntry.ContentChangeByLocalHistory)event).getTimestamp());
                }
                if (provenanceEntry instanceof ProvenanceEntry.MetadataEntryOfDocumentChange) {
                    Object[] objectArray = new Object[]{((ProvenanceEntry.MetadataEntryOfDocumentChange)event).getKind(), this.getPresentableFilePath(project, ((ProvenanceEntry.MetadataEntryOfDocumentChange)event).getDocumentPath()), ((ProvenanceEntry.MetadataEntryOfDocumentChange)event).getDurationMs()};
                    String caption = ProvenanceDevBundle.INSTANCE.message("provenance.dev.presenter.metadata", objectArray);
                    return new ChangePresenterWithDetails(id, ((ProvenanceEntry.MetadataEntryOfDocumentChange)event).getOldContentHash() + "->" + ((ProvenanceEntry.MetadataEntryOfDocumentChange)event).getNewContentHash() + "|" + ((ProvenanceEntry.MetadataEntryOfDocumentChange)event).getKind().name(), caption, ChangeKind.CodeChanges, ((ProvenanceEntry.MetadataEntryOfDocumentChange)event).getTimestamp());
                }
                if (provenanceEntry instanceof ProvenanceEntry.DocumentRename) {
                    Object[] objectArray = new Object[]{this.getPresentableFilePath(project, ((ProvenanceEntry.DocumentRename)event).getOldPath()), this.getPresentableFilePath(project, ((ProvenanceEntry.DocumentRename)event).getNewPath())};
                    String caption = ProvenanceDevBundle.INSTANCE.message("provenance.dev.presenter.document.rename", objectArray);
                    return new ChangePresenter(id, caption, ChangeKind.FileTreeChanges, ((ProvenanceEntry.DocumentRename)event).getTimestamp());
                }
                if (provenanceEntry instanceof ProvenanceEntry.None) {
                    throw new IllegalArgumentException("None entry cannot be converted to presenter");
                }
                throw new NoWhenBranchMatchedException();
            }
            Pair pair = TuplesKt.to((Object)ProvenanceDevBundle.INSTANCE.message("provenance.dev.presenter.idle", new Object[0]), (Object)((Object)ChangeKind.Idle));
            String caption = (String)pair.component1();
            ChangeKind kind = (ChangeKind)((Object)pair.component2());
            return new ChangePresenter(id, caption, kind, ((ProvenanceEntry.Idle)event).getTimestamp());
        }

        private final String getPresentableFilePath(Project project, String filePath) {
            String string = PathMacroManager.getInstance((ComponentManager)((ComponentManager)project)).collapsePath(filePath);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"collapsePath(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

