/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.util.annotation;

import com.intellij.jpa.jpb.model.util.annotation.Annotation;
import java.util.Objects;

public class JoinColumn
implements Annotation {
    public static JoinColumn NULL_ANNOTATION = new JoinColumn("NULL", "NULL");
    private String name;
    private String referencedColumnName;
    private boolean isNullable = true;

    public JoinColumn() {
    }

    public JoinColumn(String name, String referencedColumnName) {
        this.name = name;
        this.referencedColumnName = referencedColumnName;
    }

    public JoinColumn copy() {
        if (this == NULL_ANNOTATION) {
            return this;
        }
        return new JoinColumn(this.name, this.referencedColumnName);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (!Objects.equals(this.name, name)) {
            this.checkAvailableEditing();
            this.name = name;
        }
    }

    public String getReferencedColumnName() {
        return this.referencedColumnName;
    }

    public void setReferencedColumnName(String referencedColumnName) {
        if (!Objects.equals(this.referencedColumnName, referencedColumnName)) {
            this.checkAvailableEditing();
            this.referencedColumnName = referencedColumnName;
        }
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public void setNullable(boolean nullable) {
        if (this.isNullable != nullable) {
            this.checkAvailableEditing();
            this.isNullable = nullable;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JoinColumn that = (JoinColumn)o;
        return this.isNullable == that.isNullable && Objects.equals(this.name, that.name) && Objects.equals(this.referencedColumnName, that.referencedColumnName);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.referencedColumnName, this.isNullable);
    }

    public String toString() {
        return String.format("%s[%s, %s]", this.getClassName(), this.name, this.referencedColumnName);
    }

    @Override
    public String getClassName() {
        return "JoinColumn";
    }

    private void checkAvailableEditing() {
        if (this == NULL_ANNOTATION) {
            throw new UnsupportedOperationException("Unavailable edit JoinColumn#NULL_ANNOTATION");
        }
    }
}

