/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.linemarker;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.codeInsight.daemon.impl.GutterTooltipHelper;
import com.intellij.jpa.jpb.model.util.JpaUtils;
import com.intellij.jpa.jpb.model.util.PsiUtilsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u001f\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J,\u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u000b2\u0012\u0010\f\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\u00050\rH\u0016J\u001e\u0010\u000e\u001a\u00020\u000f2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u00102\u0006\u0010\u0011\u001a\u00020\u000fH\u0005J\u001a\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0014J4\u0010\u0018\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u000b2\u0012\u0010\f\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\u00050\r2\u0006\u0010\u0014\u001a\u00020\u0015H&\u00a8\u0006\u0019"}, d2={"Lcom/intellij/jpa/jpb/model/linemarker/JpaLineMarkerProvider;", "Lcom/intellij/codeInsight/daemon/LineMarkerProvider;", "<init>", "()V", "getLineMarkerInfo", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "element", "Lcom/intellij/psi/PsiElement;", "collectSlowLineMarkers", "", "elements", "", "result", "", "getClassesTooltip", "", "", "prefix", "isVisibleByProjectDependency", "", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "doCollectSlowLineMarkers", "intellij.javaee.jpa.jpb.model"})
public abstract class JpaLineMarkerProvider
implements LineMarkerProvider {
    @Nullable
    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        PsiElement psiElement = (PsiElement)CollectionsKt.firstOrNull(elements);
        if (psiElement == null) {
            return;
        }
        PsiElement psiElement2 = psiElement;
        Project project = psiElement2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (this.isVisibleByProjectDependency(project, PsiUtilsKt.module(psiElement2))) {
            Project project2 = psiElement2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            this.doCollectSlowLineMarkers(elements, result, project2);
        }
    }

    @NlsContexts.Tooltip
    @NotNull
    protected final String getClassesTooltip(@NotNull List<? extends PsiElement> elements, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        String string = GutterTooltipHelper.getTooltipText((Collection)elements, (String)prefix, (boolean)true, (String)"GotoImplementation");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTooltipText(...)");
        return string;
    }

    protected boolean isVisibleByProjectDependency(@NotNull Project project, @Nullable Module module) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return JpaUtils.isJpaProject(project, module);
    }

    public abstract void doCollectSlowLineMarkers(@NotNull List<? extends PsiElement> var1, @NotNull Collection<? super LineMarkerInfo<?>> var2, @NotNull Project var3);
}

