/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.core.es;

import com.intellij.jpa.jpb.model.core.pg.PgKeepClassMembers;
import com.intellij.util.text.SemVer;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0010\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\rR\u0013\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\r\u00a8\u0006\u0015"}, d2={"Lcom/intellij/jpa/jpb/model/core/es/BuildVersion;", "Lcom/intellij/jpa/jpb/model/core/pg/PgKeepClassMembers;", "rawVersion", "", "major", "", "minor", "patch", "preRelease", "metadata", "<init>", "(Ljava/lang/String;IIILjava/lang/String;Ljava/lang/String;)V", "getRawVersion", "()Ljava/lang/String;", "getMajor", "()I", "getMinor", "getPatch", "getPreRelease", "getMetadata", "Companion", "intellij.javaee.jpa.jpb.model.core"})
public final class BuildVersion
implements PgKeepClassMembers {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String rawVersion;
    private final int major;
    private final int minor;
    private final int patch;
    @Nullable
    private final String preRelease;
    @Nullable
    private final String metadata;

    public BuildVersion(@NotNull String rawVersion, int major, int minor, int patch, @Nullable String preRelease, @Nullable String metadata) {
        Intrinsics.checkNotNullParameter((Object)rawVersion, (String)"rawVersion");
        this.rawVersion = rawVersion;
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.preRelease = preRelease;
        this.metadata = metadata;
    }

    public /* synthetic */ BuildVersion(String string, int n, int n2, int n3, String string2, String string3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 0x10) != 0) {
            string2 = null;
        }
        if ((n4 & 0x20) != 0) {
            string3 = null;
        }
        this(string, n, n2, n3, string2, string3);
    }

    @NotNull
    public final String getRawVersion() {
        return this.rawVersion;
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final int getPatch() {
        return this.patch;
    }

    @Nullable
    public final String getPreRelease() {
        return this.preRelease;
    }

    @Nullable
    public final String getMetadata() {
        return this.metadata;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/intellij/jpa/jpb/model/core/es/BuildVersion$Companion;", "", "<init>", "()V", "create", "Lcom/intellij/jpa/jpb/model/core/es/BuildVersion;", "version", "", "convertVersionToValidSem", "intellij.javaee.jpa.jpb.model.core"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final BuildVersion create(@NotNull String version) {
            String rawPreRelease;
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            SemVer semVer = SemVer.parseFromText((String)this.convertVersionToValidSem(version));
            if (semVer == null) {
                return null;
            }
            SemVer semVer2 = semVer;
            String string = rawPreRelease = semVer2.getPreRelease();
            String preRelease = string != null ? StringsKt.substringBefore$default((String)string, (String)"+", null, (int)2, null) : null;
            String string2 = rawPreRelease;
            String metadata = string2 != null ? StringsKt.substringAfter$default((String)string2, (String)"+", null, (int)2, null) : null;
            String string3 = semVer2.getRawVersion();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getRawVersion(...)");
            return new BuildVersion(string3, semVer2.getMajor(), semVer2.getMinor(), semVer2.getPatch(), preRelease, metadata);
        }

        private final String convertVersionToValidSem(String version) {
            char[] cArray = new char[]{'.'};
            List splitVersions = StringsKt.split$default((CharSequence)version, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            if (splitVersions.size() == 1) {
                return version + ".0.0";
            }
            if (splitVersions.size() == 2) {
                return version + ".0";
            }
            return version;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

