/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.action.creation.entity;

import com.intellij.jpa.jpb.model.backend.ed.EntityDesignHelper;
import com.intellij.jpa.jpb.model.model.Entity;
import com.intellij.jpa.jpb.model.model.EntityModel;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface EntityInfo {
    @NotNull
    public String getClassName();

    @NotNull
    public String getPackageName();

    @Nullable
    public Entity getParentEntity();

    @NotNull
    public Entity.EntityType getEntityType();

    @NotNull
    default public EntityModel toEntityModel(@NotNull Project project) {
        if (project == null) {
            EntityInfo.$$$reportNull$$$0(0);
        }
        String className = this.getClassName();
        EntityModel entityModel = new EntityModel();
        entityModel.setPackageName(this.getPackageName());
        entityModel.setClassName(className);
        entityModel.setPersistentEntity(true);
        Entity parentEntity = this.getParentEntity();
        entityModel.setParent(parentEntity);
        Entity.EntityType entityType = this.getEntityType();
        if (entityType == Entity.EntityType.PERSISTENT) {
            EntityDesignHelper entityDesignHelper = EntityDesignHelper.getInstance(project);
            entityModel.setName(entityDesignHelper.generateEntityName(className));
            entityModel.setTable(entityDesignHelper.generateTableName(className));
            entityModel.setPersistentEntity(true);
            if (parentEntity != null && EntityDesignHelper.getInheritanceType(parentEntity) == Entity.InheritanceType.SINGLE_TABLE && EntityDesignHelper.getPersistentParent(entityModel) != null && !parentEntity.isMappedSuperclass()) {
                entityModel.setTable(null);
            }
        } else if (entityType == Entity.EntityType.MAPPED_SUPERCLASS) {
            entityModel.setMappedSuperclass(true);
            entityModel.setPersistentEntity(false);
        } else if (entityType == Entity.EntityType.EMBEDDABLE) {
            entityModel.setEmbeddable(true);
            entityModel.setPersistentEntity(false);
        }
        EntityModel entityModel2 = entityModel;
        if (entityModel2 == null) {
            EntityInfo.$$$reportNull$$$0(1);
        }
        return entityModel2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/jpb/model/action/creation/entity/EntityInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/jpb/model/action/creation/entity/EntityInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "toEntityModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "toEntityModel";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

