/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.connections.managed.server.listener;

import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.connections.managed.state.JupyterServerFinished;
import com.intellij.jupyter.core.jupyter.connections.managed.state.JupyterServerPackageInstalling;
import com.intellij.jupyter.core.jupyter.connections.managed.state.JupyterServerStartError;
import com.intellij.jupyter.core.jupyter.connections.managed.state.JupyterServerStarted;
import com.intellij.jupyter.core.jupyter.connections.managed.state.JupyterServerStarting;
import com.intellij.jupyter.core.jupyter.connections.managed.state.JupyterServerState;
import com.intellij.jupyter.core.jupyter.connections.managed.state.JupyterServerStopped;
import com.intellij.jupyter.core.jupyter.notification.JupyterNotification;
import com.intellij.jupyter.core.jupyter.server.common.JupyterServerController;
import com.intellij.jupyter.py.connections.managed.server.JupyterServerProcessListener;
import com.intellij.notification.BrowseNotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.HtmlChunk;
import java.net.URI;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/jupyter/py/connections/managed/server/listener/JupyterServerStateChangeUserNotifier;", "Lcom/intellij/jupyter/py/connections/managed/server/JupyterServerProcessListener;", "<init>", "()V", "serverStateChanged", "", "jupyterServerController", "Lcom/intellij/jupyter/core/jupyter/server/common/JupyterServerController;", "newState", "Lcom/intellij/jupyter/core/jupyter/connections/managed/state/JupyterServerState;", "onError", "project", "Lcom/intellij/openapi/project/Project;", "onFinished", "Lcom/intellij/jupyter/core/jupyter/connections/managed/state/JupyterServerFinished;", "onStarted", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nJupyterServerStateChangeUserNotifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterServerStateChangeUserNotifier.kt\ncom/intellij/jupyter/py/connections/managed/server/listener/JupyterServerStateChangeUserNotifier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n1869#2,2:70\n*S KotlinDebug\n*F\n+ 1 JupyterServerStateChangeUserNotifier.kt\ncom/intellij/jupyter/py/connections/managed/server/listener/JupyterServerStateChangeUserNotifier\n*L\n47#1:70,2\n*E\n"})
public final class JupyterServerStateChangeUserNotifier
implements JupyterServerProcessListener {
    @Override
    public void serverStateChanged(@NotNull JupyterServerController jupyterServerController, @NotNull JupyterServerState newState) {
        Intrinsics.checkNotNullParameter((Object)jupyterServerController, (String)"jupyterServerController");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        Project project = jupyterServerController.getServerInfo().getModule().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        JupyterServerState jupyterServerState = newState;
        if (jupyterServerState instanceof JupyterServerFinished) {
            this.onFinished(project2, (JupyterServerFinished)newState);
        } else if (jupyterServerState instanceof JupyterServerStartError) {
            this.onError(project2);
        } else if (jupyterServerState instanceof JupyterServerStarted) {
            this.onStarted(project2, jupyterServerController);
        } else if (!(Intrinsics.areEqual((Object)jupyterServerState, (Object)JupyterServerPackageInstalling.INSTANCE) || jupyterServerState instanceof JupyterServerStarting || Intrinsics.areEqual((Object)jupyterServerState, (Object)JupyterServerStopped.INSTANCE))) {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void onError(Project project) {
        String content = JupyterBundle.message((String)"jupyter.server.start.error", (Object[])new Object[0]);
        JupyterNotification.INSTANCE.getJUPYTER_NOTIFICATION_GROUP().createNotification(content, NotificationType.ERROR).setDisplayId("jupyter.server.start.error").notify(project);
    }

    private final void onFinished(Project project, JupyterServerFinished newState) {
        Pair pair = newState.getDestroyed() ? TuplesKt.to((Object)JupyterBundle.message((String)"jupyter.server.stopped", (Object[])new Object[0]), (Object)"jupyter.server.started") : TuplesKt.to((Object)JupyterBundle.message((String)"jupyter.server.detached", (Object[])new Object[0]), (Object)"jupyter.server.detached");
        String message2 = (String)pair.component1();
        String displayId = (String)pair.component2();
        Object[] objectArray = new NotificationGroup[]{JupyterNotification.INSTANCE.getJUPYTER_NOTIFICATION_GROUP(), JupyterNotification.INSTANCE.getEVENT_LOG_NOTIFICATION_GROUP()};
        Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NotificationGroup it = (NotificationGroup)element$iv;
            boolean bl = false;
            it.createNotification(message2, NotificationType.INFORMATION).setDisplayId(displayId).notify(project);
        }
    }

    private final void onStarted(Project project, JupyterServerController jupyterServerController) {
        Object object = jupyterServerController.getConnectionHandler();
        if (object == null || (object = object.getLocation()) == null || (object = ((URI)object).toASCIIString()) == null) {
            throw new IllegalStateException("Connection handler is null".toString());
        }
        Object uri = object;
        Object[] objectArray = new Object[]{uri};
        String message2 = JupyterBundle.message((String)"jupyter.server.started.at", (Object[])objectArray);
        Object[] objectArray2 = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)HtmlChunk.tag((String)"a").attr("href", (String)uri).addText((String)uri).toString(), (String)"toString(...)");
        String messageWithURL = JupyterBundle.message((String)"jupyter.server.started.at", (Object[])objectArray2);
        JupyterNotification.INSTANCE.getJUPYTER_NOTIFICATION_GROUP().createNotification(messageWithURL, NotificationType.INFORMATION).setDisplayId("jupyter.server.started").setListener(NotificationListener.URL_OPENING_LISTENER).notify(project);
        JupyterNotification.INSTANCE.getEVENT_LOG_NOTIFICATION_GROUP().createNotification(message2, NotificationType.INFORMATION).setDisplayId("jupyter.server.started").addAction((AnAction)new BrowseNotificationAction(JupyterBundle.message((String)"Jupyter.open.in.browser", (Object[])new Object[0]), (String)uri)).notify(project);
    }
}

