/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.sockets;

import com.intellij.ssh.ForceDisconnectListener;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;

public abstract class ItemHolder<T>
implements ForceDisconnectListener {
    private final Collection<T> myItems = new ArrayList<T>();
    private boolean myClosed;

    @Override
    public synchronized void forceDisconnect() {
        this.myClosed = true;
        for (T t : this.myItems) {
            this.close(t);
        }
    }

    protected abstract void close(T var1);

    public synchronized void add(T item) throws IOException {
        if (this.myClosed) {
            this.close(item);
            throw new IOException("Connection closed");
        }
        this.myItems.add(item);
    }

    public static ItemHolder<Socket> createDefaultSocketHolder() {
        return new ItemHolder<Socket>(){

            @Override
            protected void close(Socket socket) {
                if (!socket.isClosed()) {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        };
    }

    public static ItemHolder<ServerSocket> createDefaultServerSocketHolder() {
        return new ItemHolder<ServerSocket>(){

            @Override
            protected void close(ServerSocket socket) {
                if (!socket.isClosed()) {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        };
    }
}

