/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.util.pngj;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.util.pngj.ArrayUtilsKt;
import org.jetbrains.letsPlot.util.pngj.ErrorBehaviour;
import org.jetbrains.letsPlot.util.pngj.IBytesConsumer;
import org.jetbrains.letsPlot.util.pngj.PngjException;
import org.jetbrains.letsPlot.util.pngj.PngjInputException;
import org.jetbrains.letsPlot.util.pngj.chunks.ChunkRaw;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\b\b \u0018\u00002\u00020\u0001:\u00012B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\"\u001a\u00020#H$J \u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u0003H\u0016J\u0013\u0010)\u001a\u00020\u00102\b\u0010*\u001a\u0004\u0018\u00010+H\u0096\u0002J\b\u0010,\u001a\u00020\u0003H\u0016J(\u0010-\u001a\u00020#2\u0006\u0010.\u001a\u00020\u00032\u0006\u0010%\u001a\u00020&2\u0006\u0010/\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u0003H$J\u000e\u00100\u001a\u00020#2\u0006\u0010\u000f\u001a\u00020\u0010J\b\u00101\u001a\u00020\u0005H\u0016R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\u0013X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0019R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u0003X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!\u00a8\u00063"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/ChunkReader;", "Lorg/jetbrains/letsPlot/util/pngj/IBytesConsumer;", "clen", "", "id", "", "offsetInPng", "", "mode", "Lorg/jetbrains/letsPlot/util/pngj/ChunkReader$ChunkReaderMode;", "(ILjava/lang/String;JLorg/jetbrains/letsPlot/util/pngj/ChunkReader$ChunkReaderMode;)V", "chunkRaw", "Lorg/jetbrains/letsPlot/util/pngj/chunks/ChunkRaw;", "getChunkRaw", "()Lorg/jetbrains/letsPlot/util/pngj/chunks/ChunkRaw;", "crcCheck", "", "crcn", "errorBehav", "Lorg/jetbrains/letsPlot/util/pngj/ErrorBehaviour;", "getErrorBehav", "()Lorg/jetbrains/letsPlot/util/pngj/ErrorBehaviour;", "setErrorBehav", "(Lorg/jetbrains/letsPlot/util/pngj/ErrorBehaviour;)V", "isDone", "()Z", "isFromDeflatedSet", "getMode", "()Lorg/jetbrains/letsPlot/util/pngj/ChunkReader$ChunkReaderMode;", "read", "getRead", "()I", "setRead", "(I)V", "chunkDone", "", "consume", "buf", "", "offset", "len", "equals", "other", "", "hashCode", "processData", "offsetInchunk", "off", "setCrcCheck", "toString", "ChunkReaderMode", "plot-api"})
public abstract class ChunkReader
implements IBytesConsumer {
    @NotNull
    private final ChunkReaderMode mode;
    @NotNull
    private final ChunkRaw chunkRaw;
    private int read;
    private int crcn;
    private boolean crcCheck;
    @NotNull
    private ErrorBehaviour errorBehav;

    public ChunkReader(int clen, @NotNull String id, long offsetInPng, @Nullable ChunkReaderMode mode) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.errorBehav = ErrorBehaviour.STRICT;
        if (mode == null || id.length() != 4 || clen < 0) {
            throw new PngjInputException("Bad chunk paramenters: " + (Object)((Object)mode));
        }
        this.mode = mode;
        this.chunkRaw = new ChunkRaw(clen, id, mode == ChunkReaderMode.BUFFER);
        this.chunkRaw.setOffset(offsetInPng);
        this.crcCheck = mode != ChunkReaderMode.SKIP;
    }

    @NotNull
    public final ChunkReaderMode getMode() {
        return this.mode;
    }

    @NotNull
    public final ChunkRaw getChunkRaw() {
        return this.chunkRaw;
    }

    protected final int getRead() {
        return this.read;
    }

    protected final void setRead(int n) {
        this.read = n;
    }

    @NotNull
    protected final ErrorBehaviour getErrorBehav() {
        return this.errorBehav;
    }

    protected final void setErrorBehav(@NotNull ErrorBehaviour errorBehaviour) {
        Intrinsics.checkNotNullParameter((Object)((Object)errorBehaviour), (String)"<set-?>");
        this.errorBehav = errorBehaviour;
    }

    @Override
    public int consume(@NotNull byte[] buf, int offset, int len) {
        int bytesForData;
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        int off = offset;
        int len2 = len;
        if (len2 == 0) {
            return 0;
        }
        if (len2 < 0) {
            throw new PngjException("negative length??");
        }
        if (this.read == 0 && this.crcn == 0 && this.crcCheck) {
            this.chunkRaw.updateCrc(this.chunkRaw.getIdbytes(), 0, 4);
        }
        if ((bytesForData = this.chunkRaw.getLen() - this.read) > len2) {
            bytesForData = len2;
        }
        if (bytesForData > 0 || this.crcn == 0) {
            if (this.crcCheck && this.mode != ChunkReaderMode.BUFFER && bytesForData > 0) {
                this.chunkRaw.updateCrc(buf, off, bytesForData);
            }
            if (this.mode == ChunkReaderMode.BUFFER) {
                if (!Arrays.equals(this.chunkRaw.getData(), buf) && bytesForData > 0) {
                    byte[] byArray = this.chunkRaw.getData();
                    Intrinsics.checkNotNull((Object)byArray);
                    ArrayUtilsKt.arraycopy(buf, off, byArray, this.read, bytesForData);
                }
            } else if (this.mode == ChunkReaderMode.PROCESS) {
                this.processData(this.read, buf, off, bytesForData);
            }
            this.read += bytesForData;
            off += bytesForData;
            len2 -= bytesForData;
        }
        int crcRead = 0;
        if (this.read == this.chunkRaw.getLen()) {
            crcRead = 4 - this.crcn;
            if (crcRead > len2) {
                crcRead = len2;
            }
            if (crcRead > 0) {
                if (!Arrays.equals(buf, this.chunkRaw.getCrcval())) {
                    ArrayUtilsKt.arraycopy(buf, off, this.chunkRaw.getCrcval(), this.crcn, crcRead);
                }
                this.crcn += crcRead;
                if (this.crcn == 4) {
                    if (this.crcCheck) {
                        if (this.mode == ChunkReaderMode.BUFFER) {
                            byte[] byArray = this.chunkRaw.getData();
                            Intrinsics.checkNotNull((Object)byArray);
                            this.chunkRaw.updateCrc(byArray, 0, this.chunkRaw.getLen());
                        }
                        this.chunkRaw.checkCrc(this.errorBehav == ErrorBehaviour.STRICT);
                    }
                    System.out.println((Object)"Chunk done");
                    this.chunkDone();
                }
            }
        }
        return bytesForData > 0 || crcRead > 0 ? bytesForData + crcRead : -1;
    }

    @Override
    public boolean isDone() {
        return this.crcn == 4;
    }

    public final void setCrcCheck(boolean crcCheck) {
        if (this.read != 0 && crcCheck && !this.crcCheck) {
            throw new PngjException("too late!");
        }
        this.crcCheck = crcCheck;
    }

    protected abstract void processData(int var1, @NotNull byte[] var2, int var3, int var4);

    protected abstract void chunkDone();

    public boolean isFromDeflatedSet() {
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = prime * result2 + this.chunkRaw.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        ChunkReader cfr_ignored_0 = (ChunkReader)other;
        return Intrinsics.areEqual((Object)this.chunkRaw, (Object)((ChunkReader)other).chunkRaw);
    }

    @NotNull
    public String toString() {
        return this.chunkRaw.toString();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/ChunkReader$ChunkReaderMode;", "", "(Ljava/lang/String;I)V", "BUFFER", "PROCESS", "SKIP", "plot-api"})
    public static final class ChunkReaderMode
    extends Enum<ChunkReaderMode> {
        public static final /* enum */ ChunkReaderMode BUFFER = new ChunkReaderMode();
        public static final /* enum */ ChunkReaderMode PROCESS = new ChunkReaderMode();
        public static final /* enum */ ChunkReaderMode SKIP = new ChunkReaderMode();
        private static final /* synthetic */ ChunkReaderMode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ChunkReaderMode[] values() {
            return (ChunkReaderMode[])$VALUES.clone();
        }

        public static ChunkReaderMode valueOf(String value) {
            return Enum.valueOf(ChunkReaderMode.class, value);
        }

        @NotNull
        public static EnumEntries<ChunkReaderMode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = chunkReaderModeArray = new ChunkReaderMode[]{ChunkReaderMode.BUFFER, ChunkReaderMode.PROCESS, ChunkReaderMode.SKIP};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

