/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.intern.datetime;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0015\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 .2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001.B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u0000J\u0011\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010#\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020\u0000H\u0086\u0002J\u0013\u0010%\u001a\u00020\u000b2\b\u0010\"\u001a\u0004\u0018\u00010&H\u0096\u0002J\b\u0010'\u001a\u00020!H\u0016J\u000e\u0010(\u001a\u00020\u00002\u0006\u0010)\u001a\u00020*J\u000e\u0010+\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u0000J\b\u0010,\u001a\u00020-H\u0016R\u0011\u0010\u0005\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u0011\u0010\r\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0007R\u0011\u0010\u000f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0007R\u0011\u0010\u0011\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0007R\u0011\u0010\u0013\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0007R\u0011\u0010\u0015\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0007R\u0011\u0010\u0018\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0007R\u0011\u0010\u001a\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0007R\u0011\u0010\u001c\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0007\u00a8\u0006/"}, d2={"Lorg/jetbrains/letsPlot/commons/intern/datetime/Duration;", "", "totalMillis", "", "(J)V", "day", "getDay", "()J", "hour", "getHour", "isPositive", "", "()Z", "millis", "getMillis", "minute", "getMinute", "second", "getSecond", "totalDays", "getTotalDays", "totalHours", "getTotalHours", "getTotalMillis", "totalMinutes", "getTotalMinutes", "totalWeeks", "getTotalWeeks", "week", "getWeek", "add", "duration", "compareTo", "", "other", "div", "", "equals", "", "hashCode", "mul", "times", "", "sub", "toString", "", "Companion", "commons"})
public final class Duration
implements Comparable<Duration> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long totalMillis;
    @NotNull
    private static final Duration MS = new Duration(1L);
    @NotNull
    private static final Duration SECOND = MS.mul(1000);
    @NotNull
    private static final Duration MINUTE = SECOND.mul(60);
    @NotNull
    private static final Duration HOUR = MINUTE.mul(60);
    @NotNull
    private static final Duration DAY = HOUR.mul(24);
    @NotNull
    private static final Duration WEEK = DAY.mul(7);

    public Duration(long totalMillis) {
        this.totalMillis = totalMillis;
    }

    public final long getTotalMillis() {
        return this.totalMillis;
    }

    public final long getTotalWeeks() {
        return this.totalMillis / Duration.WEEK.totalMillis;
    }

    public final long getTotalDays() {
        return this.totalMillis / Duration.DAY.totalMillis;
    }

    public final long getTotalHours() {
        return this.totalMillis / Duration.DAY.totalMillis;
    }

    public final long getTotalMinutes() {
        return this.totalMillis / Duration.MINUTE.totalMillis;
    }

    public final long getWeek() {
        return this.totalMillis / Duration.WEEK.totalMillis;
    }

    public final long getDay() {
        return this.totalMillis % Duration.WEEK.totalMillis / Duration.DAY.totalMillis;
    }

    public final long getHour() {
        return this.totalMillis % Duration.DAY.totalMillis / Duration.HOUR.totalMillis;
    }

    public final long getMinute() {
        return this.totalMillis % Duration.HOUR.totalMillis / Duration.MINUTE.totalMillis;
    }

    public final long getSecond() {
        return this.totalMillis % Duration.MINUTE.totalMillis / Duration.SECOND.totalMillis;
    }

    public final long getMillis() {
        return this.totalMillis % Duration.SECOND.totalMillis / Duration.MS.totalMillis;
    }

    public final boolean isPositive() {
        return this.totalMillis > 0L;
    }

    @NotNull
    public final Duration mul(@NotNull Number times) {
        Intrinsics.checkNotNullParameter((Object)times, (String)"times");
        return new Duration(this.totalMillis * times.longValue());
    }

    @NotNull
    public final Duration add(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        return new Duration(this.totalMillis + duration.totalMillis);
    }

    @NotNull
    public final Duration sub(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        return new Duration(this.totalMillis - duration.totalMillis);
    }

    public final double div(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        return (double)this.totalMillis / (double)duration.totalMillis;
    }

    @Override
    public int compareTo(@NotNull Duration other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Intrinsics.compare((long)this.totalMillis, (long)other.totalMillis);
    }

    public int hashCode() {
        return Long.hashCode(this.totalMillis);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Duration)) {
            return false;
        }
        return this.totalMillis == ((Duration)other).totalMillis;
    }

    @NotNull
    public String toString() {
        return "Duration : " + this.totalMillis + "ms";
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/letsPlot/commons/intern/datetime/Duration$Companion;", "", "()V", "DAY", "Lorg/jetbrains/letsPlot/commons/intern/datetime/Duration;", "getDAY", "()Lorg/jetbrains/letsPlot/commons/intern/datetime/Duration;", "HOUR", "getHOUR", "MINUTE", "getMINUTE", "MS", "getMS", "SECOND", "getSECOND", "WEEK", "getWEEK", "commons"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Duration getMS() {
            return MS;
        }

        @NotNull
        public final Duration getSECOND() {
            return SECOND;
        }

        @NotNull
        public final Duration getMINUTE() {
            return MINUTE;
        }

        @NotNull
        public final Duration getHOUR() {
            return HOUR;
        }

        @NotNull
        public final Duration getDAY() {
            return DAY;
        }

        @NotNull
        public final Duration getWEEK() {
            return WEEK;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

