/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.factories.resolvers;

import com.intellij.codeInspection.dataFlow.StringExpressionHelper;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.factories.ObjectTypeResolver;
import com.intellij.spring.factories.SpringFactoryBeansManager;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanEffectiveTypeProvider;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.jam.javaConfig.SpringJavaBean;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.SpringModelElement;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringElementsHolder;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.converters.values.BooleanValueConverter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class AbstractTypeResolver
implements ObjectTypeResolver {
    @NonNls
    private static final String CLASS_ARRAY_EDITOR_SEPARATOR = ",";

    @Nullable
    protected String getPropertyValue(@Nullable CommonSpringBean bean, @NotNull String propertyName) {
        if (propertyName == null) {
            AbstractTypeResolver.$$$reportNull$$$0(0);
        }
        if (bean instanceof SpringBean) {
            SpringPropertyDefinition property = SpringPropertyUtils.findPropertyByName((CommonSpringBean)bean, (String)propertyName);
            if (property != null) {
                return property.getValueAsString();
            }
        } else if (bean instanceof SpringJavaBean) {
            return AbstractTypeResolver.getJavaBeanPropertyValue(propertyName, (SpringJavaBean)bean);
        }
        return null;
    }

    @Nullable
    private static String getJavaBeanPropertyValue(@NotNull String propertyName, @NotNull SpringJavaBean javaBean) {
        PsiMethod setter;
        if (propertyName == null) {
            AbstractTypeResolver.$$$reportNull$$$0(1);
        }
        if (javaBean == null) {
            AbstractTypeResolver.$$$reportNull$$$0(2);
        }
        if ((setter = AbstractTypeResolver.findSetterMethod(javaBean, propertyName)) != null) {
            Pair pair;
            PsiExpression expression = AbstractTypeResolver.getSetterParamExpression(new LocalSearchScope((PsiElement)javaBean.getPsiElement()), setter);
            if (expression == null) {
                return null;
            }
            if (expression instanceof PsiClassObjectAccessExpression) {
                return AbstractTypeResolver.evaluatePsiClassObjectAccess((PsiClassObjectAccessExpression)expression);
            }
            if (AbstractTypeResolver.isStringValueSetter(setter) && (pair = StringExpressionHelper.evaluateExpression((PsiElement)expression)) != null) {
                return (String)pair.getSecond();
            }
        }
        return null;
    }

    @Nullable
    private static String evaluatePsiClassObjectAccess(PsiClassObjectAccessExpression expression) {
        PsiType type = expression.getOperand().getType();
        if (type instanceof PsiClassType) {
            PsiClass resolvedClass = ((PsiClassType)type).resolve();
            return resolvedClass != null ? resolvedClass.getQualifiedName() : null;
        }
        return null;
    }

    private static boolean isStringValueSetter(@NotNull PsiMethod setter) {
        PsiType setterType;
        if (setter == null) {
            AbstractTypeResolver.$$$reportNull$$$0(3);
        }
        if ((setterType = setter.getParameterList().getParameters()[0].getType()) instanceof PsiClassType) {
            PsiClass psiClass = ((PsiClassType)setterType).resolve();
            return psiClass != null && "java.lang.String".equals(psiClass.getQualifiedName());
        }
        return false;
    }

    @Nullable
    private static PsiExpression getSetterParamExpression(@NotNull LocalSearchScope configurationMethodScope, @NotNull PsiMethod setter) {
        if (configurationMethodScope == null) {
            AbstractTypeResolver.$$$reportNull$$$0(4);
        }
        if (setter == null) {
            AbstractTypeResolver.$$$reportNull$$$0(5);
        }
        Set methodCallExpressions = StringExpressionHelper.searchMethodCalls((PsiMethod)setter, (SearchScope)configurationMethodScope);
        for (PsiCall methodCallExpression : methodCallExpressions) {
            PsiExpression[] expressions;
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            if (argumentList == null || (expressions = argumentList.getExpressions()).length != 1) continue;
            return expressions[0];
        }
        return null;
    }

    @Nullable
    private static PsiMethod findSetterMethod(@NotNull SpringJavaBean javaBean, @NotNull String propertyName) {
        PsiType returnType;
        if (javaBean == null) {
            AbstractTypeResolver.$$$reportNull$$$0(6);
        }
        if (propertyName == null) {
            AbstractTypeResolver.$$$reportNull$$$0(7);
        }
        if ((returnType = javaBean.getPsiElement().getReturnType()) instanceof PsiClassType) {
            return PropertyUtilBase.findPropertySetter((PsiClass)((PsiClassType)returnType).resolve(), (String)propertyName, (boolean)false, (boolean)true);
        }
        return null;
    }

    @NotNull
    protected static Set<String> getListOrSetValues(@NotNull SpringBean bean, @NotNull String propertyName) {
        SpringPropertyDefinition property;
        if (bean == null) {
            AbstractTypeResolver.$$$reportNull$$$0(8);
        }
        if (propertyName == null) {
            AbstractTypeResolver.$$$reportNull$$$0(9);
        }
        if ((property = SpringPropertyUtils.findPropertyByName((CommonSpringBean)bean, (String)propertyName)) instanceof SpringProperty) {
            Set set = SpringPropertyUtils.getListOrSetValues((SpringElementsHolder)((SpringProperty)property));
            if (set == null) {
                AbstractTypeResolver.$$$reportNull$$$0(10);
            }
            return set;
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            AbstractTypeResolver.$$$reportNull$$$0(11);
        }
        return set;
    }

    @NotNull
    protected static Set<String> getTypesFromClassArrayProperty(@NotNull SpringBean context, String propertyName) {
        SpringPropertyDefinition property;
        if (context == null) {
            AbstractTypeResolver.$$$reportNull$$$0(12);
        }
        if ((property = SpringPropertyUtils.findPropertyByName((CommonSpringBean)context, (String)propertyName)) != null) {
            String stringValue = property.getValueAsString();
            if (stringValue != null) {
                return AbstractTypeResolver.splitAndTrim(stringValue, CLASS_ARRAY_EDITOR_SEPARATOR);
            }
            if (property instanceof SpringProperty) {
                Set set = SpringPropertyUtils.getListOrSetValues((SpringElementsHolder)((SpringProperty)property));
                if (set == null) {
                    AbstractTypeResolver.$$$reportNull$$$0(13);
                }
                return set;
            }
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            AbstractTypeResolver.$$$reportNull$$$0(14);
        }
        return set;
    }

    @NotNull
    private static Set<String> splitAndTrim(@NotNull String value, @NotNull String separator) {
        if (value == null) {
            AbstractTypeResolver.$$$reportNull$$$0(15);
        }
        if (separator == null) {
            AbstractTypeResolver.$$$reportNull$$$0(16);
        }
        List parts = StringUtil.split((String)value, (String)separator);
        HashSet<String> trimmedParts = new HashSet<String>(parts.size());
        for (String part : parts) {
            trimmedParts.add(part.trim());
        }
        HashSet<String> hashSet = trimmedParts;
        if (hashSet == null) {
            AbstractTypeResolver.$$$reportNull$$$0(17);
        }
        return hashSet;
    }

    protected boolean isBooleanPropertySetAndTrue(@NotNull SpringBean context, @NotNull String propertyName) {
        String value;
        if (context == null) {
            AbstractTypeResolver.$$$reportNull$$$0(18);
        }
        if (propertyName == null) {
            AbstractTypeResolver.$$$reportNull$$$0(19);
        }
        return (value = this.getPropertyValue((CommonSpringBean)context, propertyName)) != null && BooleanValueConverter.getInstance((boolean)true).isTrue(value);
    }

    protected boolean isBooleanPropertySetAndFalse(@NotNull SpringBean context, @NotNull String propertyName) {
        String value;
        if (context == null) {
            AbstractTypeResolver.$$$reportNull$$$0(20);
        }
        if (propertyName == null) {
            AbstractTypeResolver.$$$reportNull$$$0(21);
        }
        return (value = this.getPropertyValue((CommonSpringBean)context, propertyName)) != null && !BooleanValueConverter.getInstance((boolean)true).isTrue(value);
    }

    @Nullable
    protected static PsiType getTypeFromProperty(@NotNull SpringBean context, @NotNull String propertyName) {
        SpringPropertyDefinition targetProperty;
        if (context == null) {
            AbstractTypeResolver.$$$reportNull$$$0(22);
        }
        if (propertyName == null) {
            AbstractTypeResolver.$$$reportNull$$$0(23);
        }
        if ((targetProperty = SpringPropertyUtils.findPropertyByName((CommonSpringBean)context, (String)propertyName)) != null) {
            SpringProperty property;
            SpringBean bean;
            if (targetProperty instanceof SpringProperty && DomUtil.hasXml((DomElement)(bean = (property = (SpringProperty)targetProperty).getBean()))) {
                PsiType[] classes = AbstractTypeResolver.getEffectiveTypes((CommonSpringBean)bean);
                PsiManager psiManager = bean.getPsiManager();
                if (classes.length > 0 && psiManager != null) {
                    return classes[0];
                }
            }
            return AbstractTypeResolver.getTypeFromNonFactoryBean(SpringPropertyUtils.findReferencedBean((SpringPropertyDefinition)targetProperty));
        }
        return null;
    }

    public static PsiType @NotNull [] getEffectiveTypes(@NotNull CommonSpringBean bean) {
        PsiType[] psiTypeArray;
        if (bean == null) {
            AbstractTypeResolver.$$$reportNull$$$0(24);
        }
        CommonProcessors.CollectProcessor collectProcessor = new CommonProcessors.CollectProcessor();
        for (SpringBeanEffectiveTypeProvider provider : (SpringBeanEffectiveTypeProvider[])SpringBeanEffectiveTypeProvider.EP_NAME.getExtensions()) {
            if (!provider.processEffectiveTypes(bean, (Processor)collectProcessor)) break;
        }
        Collection results = collectProcessor.getResults();
        if (!results.isEmpty()) {
            psiTypeArray = results.toArray(PsiType.EMPTY_ARRAY);
        } else {
            PsiType[] psiTypeArray2 = new PsiType[1];
            psiTypeArray = psiTypeArray2;
            psiTypeArray2[0] = bean.getBeanType();
        }
        if (psiTypeArray == null) {
            AbstractTypeResolver.$$$reportNull$$$0(25);
        }
        return psiTypeArray;
    }

    @Nullable
    protected static PsiClassType getTypeFromBeanName(@NotNull SpringBean context, @NotNull String beanName) {
        if (context == null) {
            AbstractTypeResolver.$$$reportNull$$$0(26);
        }
        if (beanName == null) {
            AbstractTypeResolver.$$$reportNull$$$0(27);
        }
        CommonSpringModel model = SpringModelUtils.getInstance().getSpringModel((SpringModelElement)context);
        return AbstractTypeResolver.getTypeFromNonFactoryBean(SpringModelSearchers.findBean((CommonSpringModel)model, (String)beanName));
    }

    @Nullable
    private static PsiClassType getTypeFromNonFactoryBean(@Nullable SpringBeanPointer<?> bean) {
        PsiClass targetBeanClass;
        if (bean != null && (targetBeanClass = bean.getBeanClass()) != null && !SpringFactoryBeansManager.getInstance().isFactoryBeanClass(targetBeanClass)) {
            return PsiTypesUtil.getClassType((PsiClass)targetBeanClass);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 11, 13, 14, 17, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaBean";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationMethodScope";
                break;
            }
            case 8: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/factories/resolvers/AbstractTypeResolver";
                break;
            }
            case 12: 
            case 18: 
            case 20: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/factories/resolvers/AbstractTypeResolver";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getListOrSetValues";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypesFromClassArrayProperty";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "splitAndTrim";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectiveTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyValue";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getJavaBeanPropertyValue";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isStringValueSetter";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSetterParamExpression";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findSetterMethod";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getListOrSetValues";
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 25: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getTypesFromClassArrayProperty";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "splitAndTrim";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isBooleanPropertySetAndTrue";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isBooleanPropertySetAndFalse";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromProperty";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getEffectiveTypes";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromBeanName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 11, 13, 14, 17, 25 -> new IllegalStateException(string);
        };
    }
}

