/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.hivebase.types;

import com.intellij.database.dialects.hivebase.types.HiveTypeSystemKt;
import com.intellij.database.dialects.hivebase.types.TypeParser;
import com.intellij.database.model.DataType;
import com.intellij.database.types.DasBuiltinType;
import com.intellij.database.types.DasBuiltinTypeWithLength;
import com.intellij.database.types.DasBuiltinTypeWithLengthImpl;
import com.intellij.database.types.DasBuiltinTypeWithPrecision;
import com.intellij.database.types.DasBuiltinTypeWithPrecisionImpl;
import com.intellij.database.types.DasSimpleBuiltinType;
import com.intellij.database.types.DasSimpleBuiltinTypeClass;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeCategory;
import com.intellij.database.types.DasTypeClass;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u001a\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\tH\u0002\u001a\u001c\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0013*\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\f\u001a\u00020\tH\u0002\u001a$\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0013*\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002\"\u0010\u0010\u0000\u001a\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0002\u001a\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0003\u001a\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0006\u001a\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"M\u0010\u0007\u001aA\u0012*\u0012( \r*\u0013\u0018\u00010\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f0\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\f\u0012\n \r*\u0004\u0018\u00010\u000e0\u000e0\b\u00a2\u0006\u0002\b\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001e\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"INTEGER", "Lcom/intellij/database/types/DasSimpleBuiltinType;", "FLOAT", "DOUBLE", "DECIMAL", "Lcom/intellij/database/types/DasBuiltinTypeWithPrecision;", "TIMESTAMP_WITH_LOCAL_TIME_ZONE", "dasTypes", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/database/model/DataType;", "Lkotlin/ParameterName;", "name", "dataType", "kotlin.jvm.PlatformType", "Lcom/intellij/database/types/DasType;", "Lorg/jetbrains/annotations/NotNull;", "caseInsensitiveTypes", "", "", "Lcom/intellij/database/types/DasBuiltinType;", "parseType", "adjust", "size", "", "scale", "intellij.database.dialects.hivebase"})
@SourceDebugExtension(value={"SMAP\nHiveTypeSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HiveTypeSystem.kt\ncom/intellij/database/dialects/hivebase/types/HiveTypeSystemKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,325:1\n1236#2,4:326\n*S KotlinDebug\n*F\n+ 1 HiveTypeSystem.kt\ncom/intellij/database/dialects/hivebase/types/HiveTypeSystemKt\n*L\n127#1:326,4\n*E\n"})
public final class HiveTypeSystemKt {
    @JvmField
    @NotNull
    public static final DasSimpleBuiltinType INTEGER;
    @JvmField
    @NotNull
    public static final DasSimpleBuiltinType FLOAT;
    @JvmField
    @NotNull
    public static final DasSimpleBuiltinType DOUBLE;
    @JvmField
    @NotNull
    public static final DasBuiltinTypeWithPrecision<?> DECIMAL;
    @JvmField
    @NotNull
    public static final DasSimpleBuiltinType TIMESTAMP_WITH_LOCAL_TIME_ZONE;
    @NotNull
    private static final ConcurrentMap<DataType, DasType> dasTypes;
    @NotNull
    private static final Map<String, DasBuiltinType<?>> caseInsensitiveTypes;

    private static final DasType parseType(DataType dataType) {
        String string = dataType.typeName;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"typeName");
        String typeName = string;
        String string2 = typeName.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        DasBuiltinType<?> builtin = caseInsensitiveTypes.get(string2);
        if (builtin != null) {
            return (DasType)HiveTypeSystemKt.adjust(builtin, dataType);
        }
        return new TypeParser(typeName).parse();
    }

    private static final DasBuiltinType<?> adjust(DasBuiltinType<?> $this$adjust, DataType dataType) {
        int size = dataType.size;
        int scale = dataType.scale;
        return HiveTypeSystemKt.adjust($this$adjust, size, scale);
    }

    private static final DasBuiltinType<?> adjust(DasBuiltinType<?> $this$adjust, int size, int scale) {
        DasBuiltinType dasBuiltinType;
        DasBuiltinType dasBuiltinType2 = $this$adjust;
        if (dasBuiltinType2 instanceof DasBuiltinTypeWithLength && size != -1) {
            DasBuiltinTypeWithLength dasBuiltinTypeWithLength = ((DasBuiltinTypeWithLength)$this$adjust).copy(size);
            Intrinsics.checkNotNull((Object)dasBuiltinTypeWithLength);
            dasBuiltinType = (DasBuiltinType)dasBuiltinTypeWithLength;
        } else if (dasBuiltinType2 instanceof DasBuiltinTypeWithPrecision && (size != -1 || scale != 0)) {
            DasBuiltinTypeWithPrecision dasBuiltinTypeWithPrecision = ((DasBuiltinTypeWithPrecision)$this$adjust).copy(size, scale);
            Intrinsics.checkNotNull((Object)dasBuiltinTypeWithPrecision);
            dasBuiltinType = (DasBuiltinType)dasBuiltinTypeWithPrecision;
        } else {
            dasBuiltinType = $this$adjust;
        }
        return dasBuiltinType;
    }

    private static final DasType dasTypes$lambda$0(Function1 $tmp0, Object p0) {
        return (DasType)$tmp0.invoke(p0);
    }

    private static final ConcurrentMap dasTypes$lambda$1() {
        return ContainerUtil.createConcurrentSoftValueMap();
    }

    public static final /* synthetic */ ConcurrentMap access$getDasTypes$p() {
        return dasTypes;
    }

    public static final /* synthetic */ Map access$getCaseInsensitiveTypes$p() {
        return caseInsensitiveTypes;
    }

    public static final /* synthetic */ DasBuiltinType access$adjust(DasBuiltinType $receiver, int size, int scale) {
        return HiveTypeSystemKt.adjust($receiver, size, scale);
    }

    public static final /* synthetic */ DasType access$parseType(DataType dataType) {
        return HiveTypeSystemKt.parseType(dataType);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var1_1;
        void $this$associateByTo$iv;
        INTEGER = DasSimpleBuiltinType.Companion.of("INTEGER", DasTypeCategory.INTEGER);
        FLOAT = DasSimpleBuiltinType.Companion.of("FLOAT", DasTypeCategory.REAL);
        DOUBLE = DasSimpleBuiltinType.Companion.of("DOUBLE", DasTypeCategory.REAL);
        DECIMAL = (DasBuiltinTypeWithPrecision)DasBuiltinTypeWithPrecisionImpl.Companion.of$default((DasBuiltinTypeWithPrecisionImpl.Companion)DasBuiltinTypeWithPrecisionImpl.Companion, (DasSimpleBuiltinTypeClass)DasSimpleBuiltinTypeClass.Companion.of("DECIMAL", DasTypeCategory.REAL), (int)0, (int)0, (int)6, null);
        TIMESTAMP_WITH_LOCAL_TIME_ZONE = DasSimpleBuiltinType.Companion.of("TIMESTAMP", DasTypeCategory.TIMESTAMP);
        ConcurrentMap concurrentMap = ConcurrentFactoryMap.create(arg_0 -> HiveTypeSystemKt.dasTypes$lambda$0(dasTypes.1.INSTANCE, arg_0), HiveTypeSystemKt::dasTypes$lambda$1);
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"create(...)");
        dasTypes = concurrentMap;
        Object object = new DasBuiltinType[]{DasSimpleBuiltinType.Companion.of("TINYINT", DasTypeCategory.INTEGER), DasSimpleBuiltinType.Companion.of("SMALLINT", DasTypeCategory.INTEGER), INTEGER, DasTypeUtilsKt.withName((DasBuiltinType)((DasBuiltinType)INTEGER), (String)"INT"), DasSimpleBuiltinType.Companion.of("BIGINT", DasTypeCategory.INTEGER), FLOAT, DasTypeUtilsKt.withName((DasBuiltinType)((DasBuiltinType)FLOAT), (String)"REAL"), DOUBLE, DasTypeUtilsKt.withName((DasBuiltinType)((DasBuiltinType)DOUBLE), (String)"DOUBLE PRECISION"), DECIMAL, DasTypeUtilsKt.withName((DasBuiltinType)((DasBuiltinType)DECIMAL), (String)"DEC"), DasTypeUtilsKt.withName((DasBuiltinType)((DasBuiltinType)DECIMAL), (String)"NUMERIC"), DasSimpleBuiltinType.Companion.of("TIMESTAMP", DasTypeCategory.TIMESTAMP), TIMESTAMP_WITH_LOCAL_TIME_ZONE, DasTypeUtilsKt.withName((DasBuiltinType)((DasBuiltinType)TIMESTAMP_WITH_LOCAL_TIME_ZONE), (String)"TIMESTAMP WITH LOCAL TIME ZONE"), DasSimpleBuiltinType.Companion.of("DATE", DasTypeCategory.DATE), DasSimpleBuiltinType.Companion.of("DATE", DasTypeCategory.INTERVAL), DasSimpleBuiltinType.Companion.of("STRING", DasTypeCategory.STRING), DasBuiltinTypeWithLengthImpl.Companion.of$default((DasBuiltinTypeWithLengthImpl.Companion)DasBuiltinTypeWithLengthImpl.Companion, (DasSimpleBuiltinTypeClass)DasSimpleBuiltinTypeClass.Companion.of("VARCHAR", DasTypeCategory.STRING), (int)0, (int)2, null), DasBuiltinTypeWithLengthImpl.Companion.of$default((DasBuiltinTypeWithLengthImpl.Companion)DasBuiltinTypeWithLengthImpl.Companion, (DasSimpleBuiltinTypeClass)DasSimpleBuiltinTypeClass.Companion.of("CHAR", DasTypeCategory.STRING), (int)0, (int)2, null), DasSimpleBuiltinType.Companion.of("BOOLEAN", DasTypeCategory.BOOLEAN), DasSimpleBuiltinType.Companion.of("BINARY", DasTypeCategory.BYTES)};
        object = CollectionsKt.listOf((Object[])object);
        Map destination$iv = new HashMap();
        boolean $i$f$associateByTo = false;
        for (Object element$iv : $this$associateByTo$iv) {
            void it;
            DasBuiltinType dasBuiltinType = (DasBuiltinType)element$iv;
            Map map = destination$iv;
            boolean bl = false;
            map.put(StringUtil.toUpperCase((String)((DasTypeClass)it.getTypeClass()).getName()), element$iv);
        }
        caseInsensitiveTypes = var1_1;
    }
}

