/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.raster.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.geometry.Rectangle;
import org.jetbrains.letsPlot.commons.registration.Disposable;
import org.jetbrains.letsPlot.commons.registration.Registration;
import org.jetbrains.letsPlot.core.canvas.CanvasEventDispatcher;
import org.jetbrains.letsPlot.core.interact.event.ToolEventDispatcher;
import org.jetbrains.letsPlot.core.plot.builder.FigureBuildInfo;
import org.jetbrains.letsPlot.core.plot.builder.FigureSvgRoot;
import org.jetbrains.letsPlot.core.plot.builder.PlotContainer;
import org.jetbrains.letsPlot.core.plot.builder.PlotSvgRoot;
import org.jetbrains.letsPlot.core.plot.builder.interact.CompositeToolEventDispatcher;
import org.jetbrains.letsPlot.core.plot.builder.subPlots.CompositeFigureSvgRoot;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgSvgElement;
import org.jetbrains.letsPlot.raster.builder.CompositeFigureModel;
import org.jetbrains.letsPlot.raster.builder.SinglePlotModel;
import org.jetbrains.letsPlot.raster.builder.ViewModel;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/letsPlot/raster/builder/FigureToViewModel;", "", "()V", "eval", "Lorg/jetbrains/letsPlot/raster/builder/ViewModel;", "buildInfo", "Lorg/jetbrains/letsPlot/core/plot/builder/FigureBuildInfo;", "processCompositeFigure", "Lorg/jetbrains/letsPlot/raster/builder/CompositeFigureModel;", "svgRoot", "Lorg/jetbrains/letsPlot/core/plot/builder/subPlots/CompositeFigureSvgRoot;", "origin", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "processPlotFigure", "Lorg/jetbrains/letsPlot/raster/builder/SinglePlotModel;", "Lorg/jetbrains/letsPlot/core/plot/builder/PlotSvgRoot;", "toModelBounds", "Lorg/jetbrains/letsPlot/commons/geometry/Rectangle;", "from", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "plot-raster"})
@SourceDebugExtension(value={"SMAP\nFigureToViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FigureToViewModel.kt\norg/jetbrains/letsPlot/raster/builder/FigureToViewModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,118:1\n1855#2,2:119\n*S KotlinDebug\n*F\n+ 1 FigureToViewModel.kt\norg/jetbrains/letsPlot/raster/builder/FigureToViewModel\n*L\n83#1:119,2\n*E\n"})
public final class FigureToViewModel {
    @NotNull
    public static final FigureToViewModel INSTANCE = new FigureToViewModel();

    private FigureToViewModel() {
    }

    @NotNull
    public final ViewModel eval(@NotNull FigureBuildInfo buildInfo) {
        ViewModel viewModel;
        Intrinsics.checkNotNullParameter((Object)buildInfo, (String)"buildInfo");
        FigureBuildInfo buildInfo2 = buildInfo.layoutedByOuterSize();
        FigureSvgRoot svgRoot = buildInfo2.createSvgRoot();
        if (svgRoot instanceof CompositeFigureSvgRoot) {
            CompositeFigureModel compositeFigureModel;
            CompositeFigureModel it = compositeFigureModel = this.processCompositeFigure((CompositeFigureSvgRoot)svgRoot, DoubleVector.Companion.getZERO());
            boolean bl = false;
            it.assembleAsRoot();
            viewModel = compositeFigureModel;
        } else if (svgRoot instanceof PlotSvgRoot) {
            viewModel = this.processPlotFigure((PlotSvgRoot)svgRoot, DoubleVector.Companion.getZERO());
        } else {
            throw new IllegalStateException(("Unsupported figure: " + Reflection.getOrCreateKotlinClass(svgRoot.getClass()).getSimpleName()).toString());
        }
        return viewModel;
    }

    private final CompositeFigureModel processCompositeFigure(CompositeFigureSvgRoot svgRoot, DoubleVector origin) {
        DoubleVector elementOrigin;
        FigureSvgRoot element2;
        svgRoot.ensureContentBuilt();
        SvgSvgElement figureSvgSvg = svgRoot.getSvg();
        if (!Intrinsics.areEqual((Object)origin, (Object)DoubleVector.Companion.getZERO())) {
            figureSvgSvg.x().set((Object)origin.getX());
            figureSvgSvg.y().set((Object)origin.getY());
        }
        List subFigures = new ArrayList();
        List subFiguresToolEventDispatchers = new ArrayList();
        for (FigureSvgRoot element2 : svgRoot.getElements()) {
            ViewModel viewModel;
            elementOrigin = element2.getBounds().getOrigin().add(origin);
            FigureSvgRoot figureSvgRoot = element2;
            if (figureSvgRoot instanceof CompositeFigureSvgRoot) {
                viewModel = this.processCompositeFigure((CompositeFigureSvgRoot)element2, elementOrigin);
            } else if (figureSvgRoot instanceof PlotSvgRoot) {
                viewModel = this.processPlotFigure((PlotSvgRoot)element2, elementOrigin);
            } else {
                throw new IllegalStateException(("Unsupported figure: " + Reflection.getOrCreateKotlinClass(svgRoot.getClass()).getSimpleName()).toString());
            }
            ViewModel elementModel = viewModel;
            ((Collection)subFigures).add(elementModel);
            subFiguresToolEventDispatchers.add(elementModel.getToolEventDispatcher());
        }
        element2 = this.toModelBounds(svgRoot.getBounds());
        elementOrigin = new CompositeToolEventDispatcher(subFiguresToolEventDispatchers);
        CompositeFigureModel compositeFigureModel = new CompositeFigureModel(figureSvgSvg, (ToolEventDispatcher)elementOrigin, (Rectangle)element2);
        Iterable $this$forEach$iv = subFigures;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ViewModel p0 = (ViewModel)element$iv;
            boolean bl = false;
            compositeFigureModel.addChildFigure(p0);
        }
        return compositeFigureModel;
    }

    private final SinglePlotModel processPlotFigure(PlotSvgRoot svgRoot, DoubleVector origin) {
        SvgSvgElement figureSvgSvg = svgRoot.getSvg();
        if (!Intrinsics.areEqual((Object)origin, (Object)DoubleVector.Companion.getZERO())) {
            figureSvgSvg.x().set((Object)origin.getX());
            figureSvgSvg.y().set((Object)origin.getY());
        }
        PlotContainer plotContainer = new PlotContainer(svgRoot);
        return new SinglePlotModel(figureSvgSvg, CanvasEventDispatcher.Companion.from(plotContainer.getMouseEventPeer()), plotContainer.getToolEventDispatcher(), this.toModelBounds(svgRoot.getBounds()), Registration.Companion.from((Disposable)plotContainer));
    }

    private final Rectangle toModelBounds(DoubleRectangle from) {
        return new Rectangle((int)from.getOrigin().getX(), (int)from.getOrigin().getY(), (int)(from.getDimension().getX() + 0.5), (int)(from.getDimension().getY() + 0.5));
    }
}

