/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.joinLines;

import com.intellij.codeInsight.editorActions.JoinRawLinesHandlerDelegate;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.joinLines.JoinToStringTemplateHandlerKt;
import org.jetbrains.kotlin.idea.util.FormatterUtilKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\rH\u0002J(\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/joinLines/JoinToStringTemplateHandler;", "Lcom/intellij/codeInsight/editorActions/JoinRawLinesHandlerDelegate;", "<init>", "()V", "tryJoinRawLines", "", "document", "Lcom/intellij/openapi/editor/Document;", "file", "Lcom/intellij/psi/PsiFile;", "start", "end", "unescape", "", "expr", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "createStringTemplate", "left", "rightText", "tryJoinLines", "intellij.kotlin.base.codeInsight.minimal"})
@SourceDebugExtension(value={"SMAP\nJoinToStringTemplateHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JoinToStringTemplateHandler.kt\norg/jetbrains/kotlin/idea/joinLines/JoinToStringTemplateHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,95:1\n1#2:96\n*E\n"})
public final class JoinToStringTemplateHandler
implements JoinRawLinesHandlerDelegate {
    public int tryJoinRawLines(@NotNull Document document, @NotNull PsiFile file, int start, int end) {
        int n;
        KtExpression leftLeft;
        PsiElement psiElement;
        block19: {
            block18: {
                KtBinaryExpression ktBinaryExpression;
                PsiElement it;
                Object object;
                block17: {
                    block16: {
                        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
                        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                        if (!(file.getFileType() instanceof KotlinFileType)) {
                            return -1;
                        }
                        if (start == 0) {
                            return -1;
                        }
                        char c = document.getCharsSequence().charAt(start);
                        int index = c == '\n' ? start - 1 : start;
                        object = file.findElementAt(index);
                        if (object == null) break block16;
                        it = psiElement = object;
                        boolean bl = false;
                        ASTNode aSTNode = it.getNode();
                        object = Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)KtTokens.PLUS) ? psiElement : null;
                        if (object != null) break block17;
                    }
                    return -1;
                }
                PsiElement plus = object;
                PsiElement bl = plus.getParent();
                KtOperationReferenceExpression ktOperationReferenceExpression = bl instanceof KtOperationReferenceExpression ? (KtOperationReferenceExpression)bl : null;
                psiElement = ktOperationReferenceExpression != null ? ktOperationReferenceExpression.getParent() : null;
                KtBinaryExpression ktBinaryExpression2 = ktBinaryExpression = psiElement instanceof KtBinaryExpression ? (KtBinaryExpression)psiElement : null;
                if (ktBinaryExpression == null) break block18;
                PsiElement p0 = it = ktBinaryExpression;
                boolean bl2 = false;
                Object object2 = psiElement = JoinToStringTemplateHandlerKt.access$joinable((KtBinaryExpression)p0) ? it : null;
                if (psiElement != null) break block19;
            }
            return -1;
        }
        PsiElement binaryExpr = psiElement;
        int lineCount = FormatterUtilKt.getLineCount(binaryExpr);
        PsiElement parent = binaryExpr.getParent();
        while (parent instanceof KtBinaryExpression && JoinToStringTemplateHandlerKt.access$joinable((KtBinaryExpression)parent) && FormatterUtilKt.getLineCount(parent) == lineCount) {
            binaryExpr = (KtBinaryExpression)parent;
            parent = ((KtBinaryExpression)parent).getParent();
        }
        KtExpression ktExpression = binaryExpr.getRight();
        Intrinsics.checkNotNull((Object)ktExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtStringTemplateExpression");
        Object rightText = this.unescape((KtStringTemplateExpression)ktExpression);
        KtExpression left = binaryExpr.getLeft();
        while (left instanceof KtBinaryExpression && JoinToStringTemplateHandlerKt.access$joinable((KtBinaryExpression)left) && ((KtBinaryExpression)left).getLeft() != null && FormatterUtilKt.getLineCount((PsiElement)leftLeft) >= lineCount - 1) {
            KtExpression ktExpression2 = ((KtBinaryExpression)left).getRight();
            Intrinsics.checkNotNull((Object)ktExpression2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtStringTemplateExpression");
            rightText = this.unescape((KtStringTemplateExpression)ktExpression2) + (String)rightText;
            left = ((KtBinaryExpression)left).getLeft();
        }
        KtExpression ktExpression3 = left;
        if (ktExpression3 instanceof KtStringTemplateExpression) {
            int offset = PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)left)) - 1;
            binaryExpr.replace((PsiElement)this.createStringTemplate((KtStringTemplateExpression)left, (String)rightText));
            n = offset;
        } else if (ktExpression3 instanceof KtBinaryExpression) {
            KtExpression leftRight = ((KtBinaryExpression)left).getRight();
            if (leftRight instanceof KtStringTemplateExpression) {
                int offset = PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)leftRight)) - 1;
                ((KtStringTemplateExpression)leftRight).replace((PsiElement)this.createStringTemplate((KtStringTemplateExpression)leftRight, (String)rightText));
                binaryExpr.replace((PsiElement)left);
                n = offset;
            } else {
                n = -1;
            }
        } else {
            n = -1;
        }
        return n;
    }

    private final String unescape(KtStringTemplateExpression expr) {
        String string;
        String expressionText = expr.getText();
        Intrinsics.checkNotNull((Object)expressionText);
        if (StringsKt.startsWith$default((String)expressionText, (String)"\"\"\"", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)expressionText, (String)"\"\"\"", (boolean)false, (int)2, null)) {
            String string2 = expressionText.substring(3, expressionText.length() - 3);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String unquoted = string2;
            String string3 = StringUtil.escapeStringCharacters((String)unquoted);
            Intrinsics.checkNotNull((Object)string3);
            string = string3;
        } else {
            String string4 = StringUtil.unquoteString((String)expressionText);
            Intrinsics.checkNotNull((Object)string4);
            string = string4;
        }
        return string;
    }

    private final KtStringTemplateExpression createStringTemplate(KtStringTemplateExpression left, String rightText) {
        String leftText = this.unescape(left);
        Project project = left.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtExpression ktExpression = new KtPsiFactory(project, false, 2, null).createExpression("\"" + leftText + rightText + "\"");
        Intrinsics.checkNotNull((Object)ktExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtStringTemplateExpression");
        return (KtStringTemplateExpression)ktExpression;
    }

    public int tryJoinLines(@NotNull Document document, @NotNull PsiFile file, int start, int end) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return -1;
    }
}

