/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.mongoDB;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.view.DbNavigationUtils;
import com.intellij.icons.AllIcons;
import com.intellij.jpa.jpb.model.orm.ep.OrmSearcher;
import com.intellij.jpa.jpb.model.orm.model.OrmFramework;
import com.intellij.jpa.jpb.model.reference.TemplateHelper;
import com.intellij.jpa.jpb.model.util.SUastUtils;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.spring.data.mongoDB.SpringDataMongoDbUtils;
import com.intellij.spring.data.mongoDB.SpringDataMongodbBundle;
import com.intellij.spring.data.mongoDB.orm.SpringDataMongodbOrmFramework;
import com.intellij.spring.data.utils.SpringDataBundle;
import com.intellij.spring.gutter.groups.SpringGroupMergeableLineMarkerInfo;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.JBUI;
import icons.DatabaseIcons;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u001f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J.\u0010\r\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u00102\u0014\u0010\u0011\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0002\b\u0003\u0018\u00010\n0\u0012H\u0016J&\u0010\u0013\u001a\u00020\u000e2\u0014\u0010\u0011\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0002\b\u0003\u0018\u00010\n0\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J.\u0010\u0016\u001a\u00020\u000e2\u0014\u0010\u0011\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0002\b\u0003\u0018\u00010\n0\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0016\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\n2\u0006\u0010\u001c\u001a\u00020\fJ\"\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\b2\b\u0010 \u001a\u0004\u0018\u00010\fH\u0002J\u0014\u0010!\u001a\u0004\u0018\u00010\f2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0002J\u0010\u0010$\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001f\u0010%\u001a\u00020\u000e2\b\u0010&\u001a\u0004\u0018\u00010'2\u000b\u0010(\u001a\u00070\u0005\u00a2\u0006\u0002\b)H\u0002\u00a8\u0006*"}, d2={"Lcom/intellij/spring/data/mongoDB/SpringDataMongoDbLineMarkerProvider;", "Lcom/intellij/codeInsight/daemon/LineMarkerProviderDescriptor;", "<init>", "()V", "getName", "", "Lcom/intellij/codeInsight/daemon/GutterName;", "getIcon", "Ljavax/swing/Icon;", "getLineMarkerInfo", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "element", "Lcom/intellij/psi/PsiElement;", "collectSlowLineMarkers", "", "elements", "", "result", "", "addMongoDocumentLineMarker", "uClass", "Lorg/jetbrains/uast/UClass;", "addMongoFieldLineMarker", "uDeclaration", "Lorg/jetbrains/uast/UDeclaration;", "isInConstructor", "", "createDocumentLineMarker", "psiElement", "createFieldLineMarker", "Lcom/intellij/spring/gutter/groups/SpringGroupMergeableLineMarkerInfo;", "icon", "dbReferencingElement", "getUastAnchor", "uAnchor", "Lorg/jetbrains/uast/UElement;", "isMongoDbDocument", "showErrorNotification", "e", "Ljava/awt/event/MouseEvent;", "message", "Lorg/jetbrains/annotations/Nls;", "intellij.spring.data.mongodb"})
@SourceDebugExtension(value={"SMAP\nSpringDataMongoDbLineMarkerProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringDataMongoDbLineMarkerProvider.kt\ncom/intellij/spring/data/mongoDB/SpringDataMongoDbLineMarkerProvider\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 UastUtils.kt\norg/jetbrains/uast/UastUtils__UastUtilsKt\n*L\n1#1,189:1\n12970#2,2:190\n12970#2,2:192\n18#3:194\n*S KotlinDebug\n*F\n+ 1 SpringDataMongoDbLineMarkerProvider.kt\ncom/intellij/spring/data/mongoDB/SpringDataMongoDbLineMarkerProvider\n*L\n172#1:190,2\n173#1:192,2\n127#1:194\n*E\n"})
public final class SpringDataMongoDbLineMarkerProvider
extends LineMarkerProviderDescriptor {
    @NotNull
    public String getName() {
        return SpringDataMongodbBundle.message("spring.data.mongodb.gutter.name", new Object[0]);
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Providers.MongoDB;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"MongoDB");
        return icon;
    }

    @Nullable
    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        PsiElement element = (PsiElement)CollectionsKt.firstOrNull(elements);
        if (element == null || !SpringDataMongoDbUtils.hasSpringDataMongoDbSupport(ModuleUtilCore.findModuleForPsiElement((PsiElement)element))) {
            return;
        }
        TemplateHelper templateHelper = (TemplateHelper)TemplateHelper.Companion.getInstance(element);
        if (templateHelper == null) {
            return;
        }
        TemplateHelper templateHelper2 = templateHelper;
        for (PsiElement psiElement : elements) {
            UElement uParent = UastUtils.getUParentForIdentifier((PsiElement)psiElement);
            if (uParent instanceof UClass) {
                this.addMongoDocumentLineMarker(result, (UClass)uParent);
                continue;
            }
            if (uParent instanceof UMethod || uParent instanceof UField) {
                this.addMongoFieldLineMarker(result, (UDeclaration)uParent, false);
                continue;
            }
            if (!(uParent instanceof UVariable) || !templateHelper2.isPrimaryConstructorParameter((UVariable)uParent)) continue;
            this.addMongoFieldLineMarker(result, (UDeclaration)uParent, true);
        }
    }

    private final void addMongoDocumentLineMarker(Collection<? super LineMarkerInfo<?>> result, UClass uClass) {
        if (!this.isMongoDbDocument(uClass)) {
            return;
        }
        PsiElement uastAnchorPsi = this.getUastAnchor(uClass.getUastAnchor());
        if (uastAnchorPsi == null) {
            return;
        }
        result.add(this.createDocumentLineMarker(uastAnchorPsi));
    }

    private final void addMongoFieldLineMarker(Collection<? super LineMarkerInfo<?>> result, UDeclaration uDeclaration, boolean isInConstructor) {
        if (SpringDataMongoDbUtils.isReadonlyProperty(uDeclaration)) {
            return;
        }
        PsiElement anchor = this.getUastAnchor(uDeclaration.getUastAnchor());
        if (anchor == null) {
            return;
        }
        PsiElement sourcePsi = uDeclaration.getJavaPsi();
        if (isInConstructor && sourcePsi instanceof PsiVariable) {
            PsiField psiField;
            PsiClass psiClass = SUastUtils.getContainingClass((PsiElement)sourcePsi);
            if (psiClass != null) {
                String string = ((PsiVariable)sourcePsi).getName();
                if (string == null) {
                    string = "";
                }
                psiField = psiClass.findFieldByName(string, false);
            } else {
                psiField = null;
            }
            sourcePsi = (PsiElement)psiField;
        }
        if (SpringDataMongoDbUtils.getMongoDbDocumentId(sourcePsi) != null) {
            Icon icon = DatabaseIcons.MongoFieldGoldKey;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"MongoFieldGoldKey");
            v4 = result.add((LineMarkerInfo<?>)this.createFieldLineMarker(anchor, icon, sourcePsi));
        } else if (SpringDataMongoDbUtils.getMongoDbDocumentField(sourcePsi) != null) {
            Icon icon = DatabaseIcons.MongoField;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"MongoField");
            v4 = result.add((LineMarkerInfo<?>)this.createFieldLineMarker(anchor, icon, sourcePsi));
        } else {
            if (uDeclaration instanceof UMethod) {
                return;
            }
            UClass uClass = (UClass)UastUtils.getParentOfType$default((UElement)((UElement)uDeclaration), UClass.class, (boolean)false, (int)2, null);
            if (uClass == null || !this.isMongoDbDocument(uClass)) {
                return;
            }
            PsiElement psiElement = sourcePsi;
            if (!(psiElement instanceof PsiMember)) {
                return;
            }
            String string = SpringDataMongoDbUtils.getFieldName((PsiMember)psiElement);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFieldName(...)");
            String fieldName = string;
            if (StringsKt.isBlank((CharSequence)fieldName)) {
                return;
            }
            if (SpringDataMongoDbUtils.isIdFieldName(fieldName)) {
                Icon icon = DatabaseIcons.MongoFieldGoldKey;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"MongoFieldGoldKey");
                v4 = result.add((LineMarkerInfo<?>)this.createFieldLineMarker(anchor, icon, sourcePsi));
            } else {
                Icon icon = DatabaseIcons.MongoField;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"MongoField");
                v4 = result.add((LineMarkerInfo<?>)this.createFieldLineMarker(anchor, icon, sourcePsi));
            }
        }
    }

    @NotNull
    public final LineMarkerInfo<PsiElement> createDocumentLineMarker(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        Project project = psiElement.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        return (LineMarkerInfo)new SpringGroupMergeableLineMarkerInfo(psiElement, psiElement.getTextRange(), AllIcons.Providers.MongoDB, arg_0 -> SpringDataMongoDbLineMarkerProvider.createDocumentLineMarker$lambda$1(SpringDataMongoDbLineMarkerProvider::createDocumentLineMarker$lambda$0, arg_0), (arg_0, arg_1) -> SpringDataMongoDbLineMarkerProvider.createDocumentLineMarker$lambda$2(project2, this, arg_0, arg_1));
    }

    private final SpringGroupMergeableLineMarkerInfo createFieldLineMarker(PsiElement psiElement, Icon icon, PsiElement dbReferencingElement) {
        PsiElement psiElement2 = dbReferencingElement;
        SmartPsiElementPointer dbReferencingElementPointer = psiElement2 != null ? SmartPointersKt.createSmartPointer((PsiElement)psiElement2) : null;
        return new SpringGroupMergeableLineMarkerInfo(psiElement, psiElement.getTextRange(), icon, arg_0 -> SpringDataMongoDbLineMarkerProvider.createFieldLineMarker$lambda$1(SpringDataMongoDbLineMarkerProvider::createFieldLineMarker$lambda$0, arg_0), (arg_0, arg_1) -> SpringDataMongoDbLineMarkerProvider.createFieldLineMarker$lambda$2(dbReferencingElementPointer, this, arg_0, arg_1));
    }

    private final PsiElement getUastAnchor(UElement uAnchor) {
        UElement uElement = uAnchor;
        return uElement != null ? uElement.getSourcePsi() : null;
    }

    private final boolean isMongoDbDocument(UClass uClass) {
        boolean bl;
        block5: {
            boolean bl2;
            UField it;
            UField element$iv;
            int n;
            int n2;
            boolean $i$f$any;
            UField[] $this$any$iv;
            block4: {
                if (OrmSearcher.Companion.getForFramework((OrmFramework)SpringDataMongodbOrmFramework.INSTANCE).isEntity(uClass.getJavaPsi())) {
                    return true;
                }
                $this$any$iv = uClass.getFields();
                $i$f$any = false;
                n2 = $this$any$iv.length;
                for (n = 0; n < n2; ++n) {
                    it = element$iv = $this$any$iv[n];
                    boolean bl3 = false;
                    if (!(it.findAnnotation("org.springframework.data.mongodb.core.mapping.Field") != null)) continue;
                    bl2 = true;
                    break block4;
                }
                bl2 = false;
            }
            if (bl2) {
                return true;
            }
            $this$any$iv = uClass.getMethods();
            $i$f$any = false;
            n2 = $this$any$iv.length;
            for (n = 0; n < n2; ++n) {
                it = element$iv = $this$any$iv[n];
                boolean bl4 = false;
                if (!(it.findAnnotation("org.springframework.data.mongodb.core.mapping.Field") != null)) continue;
                bl = true;
                break block5;
            }
            bl = false;
        }
        return bl;
    }

    private final void showErrorNotification(MouseEvent e, String message) {
        if (e == null) {
            return;
        }
        JComponent jComponent = HintUtil.createErrorLabel((String)message);
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"createErrorLabel(...)");
        JComponent label = jComponent;
        label.setBorder((Border)JBUI.Borders.empty((int)2, (int)7));
        JBPopupFactory.getInstance().createBalloonBuilder(label).setFadeoutTime(3000L).setFillColor(HintUtil.getErrorColor()).createBalloon().show(new RelativePoint(e), Balloon.Position.above);
    }

    private static final String createDocumentLineMarker$lambda$0(PsiElement it) {
        return SpringDataBundle.message((String)"open.in.database.view", (Object[])new Object[0]);
    }

    private static final String createDocumentLineMarker$lambda$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final void createDocumentLineMarker$lambda$2(Project $project, SpringDataMongoDbLineMarkerProvider this$0, MouseEvent e, PsiElement elt) {
        PsiElement psiElement = elt;
        PsiElement psiElement2 = psiElement;
        if (psiElement == null) return;
        UElement uElement = UastContextKt.toUElement((PsiElement)psiElement2);
        psiElement2 = uElement;
        if (uElement == null) return;
        PsiElement $this$getParentOfType_u24default$iv = psiElement2;
        boolean strict$iv = true;
        boolean $i$f$getParentOfType = false;
        UClass uClass = (UClass)UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv, UClass.class, (boolean)strict$iv);
        psiElement2 = uClass;
        if (uClass == null) return;
        PsiClass psiClass = psiElement2.getJavaPsi();
        PsiClass psiClass2 = psiClass;
        if (psiClass2 == null) {
            return;
        }
        String documentName = SpringDataMongoDbUtils.getDocumentName(psiClass2);
        CharSequence charSequence = documentName;
        if (charSequence == null) return;
        if (StringsKt.isBlank((CharSequence)charSequence)) {
            return;
        }
        boolean bl = false;
        if (bl) {
            return;
        }
        DbTable document = SpringDataMongoDbUtils.findDocument($project, documentName);
        if (document == null) {
            this$0.showErrorNotification(e, SpringDataMongodbBundle.message("spring.data.mongodb.document.not.found", new Object[0]));
            return;
        }
        DbNavigationUtils.navigateToDatabaseView((DbElement)((DbElement)document), (boolean)true);
    }

    private static final String createFieldLineMarker$lambda$0(PsiElement it) {
        return SpringDataBundle.message((String)"open.in.database.view", (Object[])new Object[0]);
    }

    private static final String createFieldLineMarker$lambda$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final void createFieldLineMarker$lambda$2(SmartPsiElementPointer $dbReferencingElementPointer, SpringDataMongoDbLineMarkerProvider this$0, MouseEvent e, PsiElement elt) {
        SmartPsiElementPointer parentPsiMember;
        Object object = $dbReferencingElementPointer;
        if (object == null || (object = object.getElement()) == null) {
            PsiElement psiElement = elt;
            object = psiElement != null && (psiElement = UastContextKt.toUElement((PsiElement)psiElement)) != null && (psiElement = psiElement.getUastParent()) != null ? psiElement.getJavaPsi() : null;
        }
        if (!((parentPsiMember = object) instanceof PsiMember)) {
            return;
        }
        DbElement mongoDbField = SpringDataMongoDbUtils.getMongoDbField((PsiMember)parentPsiMember);
        if (mongoDbField == null) {
            this$0.showErrorNotification(e, SpringDataMongodbBundle.message("spring.data.mongodb.field.not.found", new Object[0]));
            return;
        }
        DbNavigationUtils.navigateToDatabaseView((DbElement)mongoDbField, (boolean)true);
    }
}

