/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.code;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.util.InheritanceUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class SpringImplicitUsageProviderBase
implements ImplicitUsageProvider {
    protected static final List<String> WRITE_ANNOTATIONS = List.of("org.springframework.beans.factory.annotation.Autowired", "org.springframework.beans.factory.annotation.Required", "org.springframework.context.annotation.Bean", "org.springframework.beans.factory.annotation.Value", "org.springframework.jmx.export.annotation.ManagedOperation", "org.springframework.jmx.export.annotation.ManagedAttribute", "org.springframework.scheduling.annotation.Scheduled", "org.springframework.scheduling.annotation.Schedules", "org.springframework.test.context.transaction.BeforeTransaction", "org.springframework.test.context.transaction.AfterTransaction");
    protected static final List<String> ENTRY_POINTS = List.of("org.springframework.context.annotation.Bean", "org.springframework.jmx.export.annotation.ManagedOperation", "org.springframework.jmx.export.annotation.ManagedAttribute", "org.springframework.scheduling.annotation.Scheduled", "org.springframework.scheduling.annotation.Schedules", "org.springframework.context.event.EventListener", "javax.annotation.PostConstruct", "jakarta.annotation.PostConstruct", "javax.annotation.PreDestroy", "jakarta.annotation.PreDestroy");
    protected static final List<String> META_ENTRY_POINTS = List.of("org.springframework.context.event.EventListener");
    protected static final List<String> NON_SPRING_WRITE_ANNOTATIONS = List.of("javax.inject.Inject", "jakarta.inject.Inject", "javax.annotation.Resource", "jakarta.annotation.Resource");
    protected static final List<String> READ_ANNOTATIONS = List.of("org.springframework.beans.factory.annotation.Value");
    protected static final List<String> REGULAR_COMPONENT_ANNOTATIONS = List.of("org.springframework.stereotype.Service", "org.springframework.stereotype.Component");
    protected static final List<String> WRITE_META_ANNOTATIONS = List.of("org.springframework.scheduling.annotation.Scheduled", "org.springframework.beans.factory.annotation.Autowired", "org.springframework.context.annotation.Bean", "org.springframework.beans.factory.annotation.Value");

    public boolean isImplicitUsage(@NotNull PsiElement element) {
        if (element == null) {
            SpringImplicitUsageProviderBase.$$$reportNull$$$0(0);
        }
        return this.hasWriteAnnotation(element) || this.isBeanClassOrConstructor(element) || this.isBeanSetterOrLifeCycleMethod(element) || this.isDynamicPropertySource(element);
    }

    public boolean isImplicitRead(@NotNull PsiElement element) {
        if (element == null) {
            SpringImplicitUsageProviderBase.$$$reportNull$$$0(1);
        }
        return element instanceof PsiMethod && AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiMethod)element), READ_ANNOTATIONS, (int)0);
    }

    protected static boolean isMetaAnnotated(@NotNull PsiModifierListOwner element) {
        if (element == null) {
            SpringImplicitUsageProviderBase.$$$reportNull$$$0(2);
        }
        if (element instanceof PsiClass) {
            return false;
        }
        return MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)element, WRITE_META_ANNOTATIONS);
    }

    public boolean isImplicitWrite(@NotNull PsiElement element) {
        if (element == null) {
            SpringImplicitUsageProviderBase.$$$reportNull$$$0(3);
        }
        return this.hasWriteAnnotation(element) || this.isBeanSetterOrLifeCycleMethod(element) || element instanceof PsiModifierListOwner && AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)element), NON_SPRING_WRITE_ANNOTATIONS, (int)0);
    }

    protected boolean hasWriteAnnotation(@NotNull PsiElement element) {
        if (element == null) {
            SpringImplicitUsageProviderBase.$$$reportNull$$$0(4);
        }
        if (!(element instanceof PsiModifierListOwner)) {
            return false;
        }
        PsiModifierListOwner modifierListOwner = (PsiModifierListOwner)element;
        if (element instanceof PsiParameter || element instanceof PsiLocalVariable) {
            return false;
        }
        if (!modifierListOwner.hasAnnotations()) {
            return false;
        }
        if (this.isSpringConfigured(element)) {
            return AnnotationUtil.isAnnotated((PsiModifierListOwner)modifierListOwner, WRITE_ANNOTATIONS, (int)0) || SpringImplicitUsageProviderBase.isMetaAnnotated(modifierListOwner);
        }
        return false;
    }

    protected abstract boolean isBeanClassOrConstructor(PsiElement var1);

    protected abstract boolean isSpringConfigured(@NotNull PsiElement var1);

    protected boolean isBeanSetterOrLifeCycleMethod(@NotNull PsiElement element) {
        if (element == null) {
            SpringImplicitUsageProviderBase.$$$reportNull$$$0(5);
        }
        if (element instanceof PsiMethod) {
            PsiMethod psiMethod = (PsiMethod)element;
            return this.isEntryPoint(psiMethod);
        }
        return false;
    }

    protected boolean isEntryPoint(@NotNull PsiMethod method) {
        if (method == null) {
            SpringImplicitUsageProviderBase.$$$reportNull$$$0(6);
        }
        return !method.hasModifier(JvmModifier.ABSTRACT) && (AnnotationUtil.isAnnotated((PsiModifierListOwner)method, this.getEntryPoints(), (int)0) || MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)method, this.getMetaEntryPoints()));
    }

    @NotNull
    protected List<String> getMetaEntryPoints() {
        List<String> list = META_ENTRY_POINTS;
        if (list == null) {
            SpringImplicitUsageProviderBase.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    protected List<String> getEntryPoints() {
        List<String> list = ENTRY_POINTS;
        if (list == null) {
            SpringImplicitUsageProviderBase.$$$reportNull$$$0(8);
        }
        return list;
    }

    protected boolean isDynamicPropertySource(@NotNull PsiElement element) {
        PsiMethod psiMethod;
        if (element == null) {
            SpringImplicitUsageProviderBase.$$$reportNull$$$0(9);
        }
        return element instanceof PsiMethod && (psiMethod = (PsiMethod)element).hasModifier(JvmModifier.STATIC) && AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, (String)"org.springframework.test.context.DynamicPropertySource", (int)0);
    }

    protected boolean isJsonComponentClass(@NotNull PsiElement element) {
        if (element == null) {
            SpringImplicitUsageProviderBase.$$$reportNull$$$0(10);
        }
        if (!(element instanceof PsiClass)) {
            return false;
        }
        PsiClass psiClass = (PsiClass)element;
        if (psiClass.isAnnotationType() || psiClass.isInterface() || psiClass.isEnum()) {
            return false;
        }
        PsiClass targetClass = psiClass.getContainingClass();
        if (targetClass == null) {
            targetClass = psiClass;
        }
        if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)targetClass, (String)"org.springframework.boot.jackson.JsonComponent", (int)0)) {
            return false;
        }
        return InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"com.fasterxml.jackson.databind.JsonDeserializer") || InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"com.fasterxml.jackson.databind.JsonSerializer");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/code/SpringImplicitUsageProviderBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/code/SpringImplicitUsageProviderBase";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetaEntryPoints";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntryPoints";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isImplicitUsage";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isImplicitRead";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isMetaAnnotated";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isImplicitWrite";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasWriteAnnotation";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isBeanSetterOrLifeCycleMethod";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isEntryPoint";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isDynamicPropertySource";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isJsonComponentClass";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8 -> new IllegalStateException(string);
        };
    }
}

