/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.mappers;

import com.intellij.kubernetes.api.KubernetesApiModelInterface;
import com.intellij.kubernetes.api.KubernetesCustomResource;
import com.intellij.kubernetes.api.KubernetesCustomResourceList;
import com.intellij.kubernetes.api.KubernetesEntity;
import com.intellij.kubernetes.util.KubernetesStateWatcher;
import com.intellij.kubernetes.view.mappers.KubernetesNamespacedResourceMapper;
import com.intellij.kubernetes.view.mappers.KubernetesResourceMapper;
import com.intellij.kubernetes.view.navigation.KubernetesResourceNavigationData;
import io.kubernetes.client.openapi.models.V1CustomResourceDefinition;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0013B)\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0004\b\b\u0010\tJ \u0010\n\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u0002\u0012\u0002\b\u00030\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/kubernetes/view/mappers/KubernetesNamespacedCustomResourceMapper;", "Lcom/intellij/kubernetes/view/mappers/KubernetesNamespacedResourceMapper;", "Lcom/intellij/kubernetes/api/KubernetesCustomResource;", "Lcom/intellij/kubernetes/api/KubernetesCustomResourceList;", "list", "Lcom/intellij/kubernetes/util/KubernetesStateWatcher;", "entity", "Lcom/intellij/kubernetes/api/KubernetesEntity;", "<init>", "(Lcom/intellij/kubernetes/util/KubernetesStateWatcher;Lcom/intellij/kubernetes/api/KubernetesEntity;)V", "getColumnDescriptors", "", "Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper$ColumnDescriptor;", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModelInterface;", "isAccepted", "", "navigationData", "Lcom/intellij/kubernetes/view/navigation/KubernetesResourceNavigationData;", "Companion", "intellij.clouds.kubernetes"})
public final class KubernetesNamespacedCustomResourceMapper
extends KubernetesNamespacedResourceMapper<KubernetesCustomResource, KubernetesCustomResourceList> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KubernetesStateWatcher<KubernetesCustomResource> list;

    public KubernetesNamespacedCustomResourceMapper(@NotNull KubernetesStateWatcher<KubernetesCustomResource> list2, @NotNull KubernetesEntity<KubernetesCustomResource, KubernetesCustomResourceList> entity) {
        Intrinsics.checkNotNullParameter(list2, (String)"list");
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        super(entity);
        this.list = list2;
    }

    @Override
    @NotNull
    public List<KubernetesResourceMapper.ColumnDescriptor<KubernetesCustomResource, ?>> getColumnDescriptors(@NotNull KubernetesApiModelInterface apiModel2) {
        Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
        KubernetesResourceMapper.ColumnDescriptor[] columnDescriptorArray = new KubernetesResourceMapper.ColumnDescriptor[]{this.addNameField(), this.addNamespaceField(apiModel2), this.addAgeField()};
        return CollectionsKt.listOfNotNull((Object[])columnDescriptorArray);
    }

    @Override
    public boolean isAccepted(@NotNull KubernetesResourceNavigationData navigationData) {
        Intrinsics.checkNotNullParameter((Object)navigationData, (String)"navigationData");
        return Intrinsics.areEqual((Object)navigationData.getKind(), (Object)KubernetesEntity.CustomResourceDefinition.getKind()) || super.isAccepted(navigationData);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/intellij/kubernetes/view/mappers/KubernetesNamespacedCustomResourceMapper$Companion;", "", "<init>", "()V", "create", "Lcom/intellij/kubernetes/view/mappers/KubernetesNamespacedCustomResourceMapper;", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModelInterface;", "definition", "Lio/kubernetes/client/openapi/models/V1CustomResourceDefinition;", "intellij.clouds.kubernetes"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KubernetesNamespacedCustomResourceMapper create(@NotNull KubernetesApiModelInterface apiModel2, @NotNull V1CustomResourceDefinition definition) {
            Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
            Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
            KubernetesEntity<KubernetesCustomResource, KubernetesCustomResourceList> entity = KubernetesEntity.Companion.createCustomResource(definition, true);
            KubernetesNamespacedCustomResourceMapper mapper = new KubernetesNamespacedCustomResourceMapper(apiModel2.getResource(entity), entity);
            KubernetesResourceMapper.Companion.registerMapper(entity, () -> Companion.create$lambda$0(mapper));
            return mapper;
        }

        private static final KubernetesResourceMapper create$lambda$0(KubernetesNamespacedCustomResourceMapper $mapper) {
            return $mapper;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

