/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.utils;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiManager;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.facet.SpringFileSetService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpringProfileUtils {
    public static boolean isActiveProfile(@NotNull Beans beans2, @Nullable Set<String> activeProfiles) {
        if (beans2 == null) {
            SpringProfileUtils.$$$reportNull$$$0(0);
        }
        if (SpringProfileUtils.isEmptyOrTestDefault(activeProfiles)) {
            return true;
        }
        if (beans2.getProfile().matches(activeProfiles)) {
            Beans parentBeans = (Beans)DomUtil.getParentOfType((DomElement)beans2, Beans.class, (boolean)true);
            return parentBeans == null || SpringProfileUtils.isActiveProfile(parentBeans, activeProfiles);
        }
        return false;
    }

    @NotNull
    public static String profilesAsString(@Nullable Set<String> activeProfiles) {
        if (ContainerUtil.isEmpty(activeProfiles)) {
            return "";
        }
        TreeSet<String> profiles = new TreeSet<String>();
        for (String activeProfile : activeProfiles) {
            if ("_DEFAULT_PROFILE_NAME_".equals(activeProfile)) continue;
            profiles.add(activeProfile);
        }
        if (profiles.size() > 1) {
            String string = StringUtil.join(profiles, (String)", ");
            if (string == null) {
                SpringProfileUtils.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = (String)ContainerUtil.getFirstItem(profiles, (Object)"");
        if (string == null) {
            SpringProfileUtils.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static Set<String> profilesFromString(@Nullable String text) {
        String[] names;
        if (StringUtil.isEmptyOrSpaces((String)text)) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                SpringProfileUtils.$$$reportNull$$$0(3);
            }
            return set;
        }
        LinkedHashSet<String> activeProfiles = new LinkedHashSet<String>();
        for (String name : names = text.split(",")) {
            if ((name = name.trim()).isEmpty()) continue;
            activeProfiles.add(name);
        }
        LinkedHashSet<String> linkedHashSet = activeProfiles;
        if (linkedHashSet == null) {
            SpringProfileUtils.$$$reportNull$$$0(4);
        }
        return linkedHashSet;
    }

    @NotNull
    public static <T extends CommonSpringBean> List<T> filterBeansInActiveProfiles(@NotNull Collection<? extends T> allBeans, @Nullable Set<String> activeProfiles) {
        if (allBeans == null) {
            SpringProfileUtils.$$$reportNull$$$0(5);
        }
        if (SpringProfileUtils.isEmptyOrTestDefault(activeProfiles)) {
            return new SmartList(allBeans);
        }
        List list = ContainerUtil.filter(allBeans, bean -> bean.isValid() && bean.getProfile().matches(activeProfiles));
        if (list == null) {
            SpringProfileUtils.$$$reportNull$$$0(6);
        }
        return list;
    }

    public static boolean isInActiveProfiles(@NotNull CommonSpringBean bean, @Nullable Set<String> activeProfiles) {
        if (bean == null) {
            SpringProfileUtils.$$$reportNull$$$0(7);
        }
        return SpringProfileUtils.isEmptyOrTestDefault(activeProfiles) || bean.getProfile().matches(activeProfiles);
    }

    public static boolean isEmptyOrTestDefault(@Nullable Set<String> activeProfiles) {
        return activeProfiles == null || activeProfiles.isEmpty() || activeProfiles.size() == 1 && "_DEFAULT_TEST_PROFILE_NAME_".equals(activeProfiles.iterator().next());
    }

    public static void notifyProfilesChanged(@NotNull Project project) {
        if (project == null) {
            SpringProfileUtils.$$$reportNull$$$0(8);
        }
        SpringModificationTrackersManager.getInstance(project).fireActiveProfilesChanged();
        PsiManager.getInstance((Project)project).dropPsiCaches();
        EditorNotifications.getInstance((Project)project).updateAllNotifications();
        ((SpringFileSetService.SpringFileSetListener)project.getMessageBus().syncPublisher(SpringFileSetService.TOPIC)).activeProfilesChanged();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beans";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/utils/SpringProfileUtils";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allBeans";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/utils/SpringProfileUtils";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "profilesAsString";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "profilesFromString";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "filterBeansInActiveProfiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isActiveProfile";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "filterBeansInActiveProfiles";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isInActiveProfiles";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "notifyProfilesChanged";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 6 -> new IllegalStateException(string);
        };
    }
}

