/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdba.jdbc.JdbcConnectionProvider;
import com.intellij.database.remote.jdba.jdbc.JdbcIntermediateFacade;
import com.intellij.database.remote.jdba.jdbc.dialects.RedshiftExceptionRecognizer;
import com.intellij.database.remote.jdba.jdbc.dialects.RsIntermediateFacade;
import com.intellij.database.remote.jdba.util.Version;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.helpers.JdbcSettings;
import com.intellij.database.remote.jdbc.helpers.PgBaseJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.RemoteLogHelper;
import com.intellij.database.remote.jdbc.impl.JdbcRemoteObject;
import java.rmi.RemoteException;
import java.sql.Array;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RsJdbcHelper
extends PgBaseJdbcHelper {
    private static final Pattern RS_VERSION_PATTERN = Pattern.compile("redshift\\s+" + JdbcNativeUtil.DEFAULT_VERSION_PATTERN, 2);

    public RsJdbcHelper(@Nullable String version, @Nullable Connection connection, @Nullable ClassLoader jdbcClassLoader) {
        super("REDSHIFT", version, connection, jdbcClassLoader);
    }

    public RsJdbcHelper() {
        this(null, null, null);
    }

    private RsJdbcHelper(@NotNull RsJdbcHelper helper, @NotNull ClassLoader jdbcClassLoader) {
        if (helper == null) {
            RsJdbcHelper.$$$reportNull$$$0(0);
        }
        if (jdbcClassLoader == null) {
            RsJdbcHelper.$$$reportNull$$$0(1);
        }
        super(helper, jdbcClassLoader);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return RsJdbcHelper.extractVersion(version);
    }

    @Override
    public JdbcHelperImpl create(@Nullable String version, @Nullable Connection connection, @Nullable ClassLoader jdbcClassLoader) {
        return new RsJdbcHelper(version, connection, jdbcClassLoader);
    }

    @Override
    @NotNull
    public JdbcIntermediateFacade createFacade(@NotNull JdbcConnectionProvider ds) {
        if (ds == null) {
            RsJdbcHelper.$$$reportNull$$$0(2);
        }
        return new RsIntermediateFacade(ds, RedshiftExceptionRecognizer.INSTANCE, this);
    }

    @Override
    public JdbcHelper.LikeSupport getLikeSupport() {
        return JdbcHelper.LikeSupport.SELECTS_ONLY;
    }

    @Override
    protected Object wrapIfNeeded(@NotNull JdbcRemoteObject exporter, Array a, @Nullable RemoteResultSet.DataRetrievingOptions options) throws SQLException, RemoteException {
        if (exporter == null) {
            RsJdbcHelper.$$$reportNull$$$0(3);
        }
        try {
            return super.wrapIfNeeded(exporter, a, options);
        }
        catch (SQLException e) {
            if (e.getErrorCode() != 500056) {
                throw e;
            }
            return a.toString();
        }
    }

    @Override
    public void adjustType(@NotNull JdbcHelper.Type e) {
        if (e == null) {
            RsJdbcHelper.$$$reportNull$$$0(4);
        }
        if ("bpchar".equals(e.typeName)) {
            e.typeName = "char";
            return;
        }
        super.adjustType(e);
    }

    @Override
    protected void enableSsl(@NotNull Driver driver, @NotNull Properties properties, @NotNull JdbcSettings.SslMode sslMode) {
        if (driver == null) {
            RsJdbcHelper.$$$reportNull$$$0(5);
        }
        if (properties == null) {
            RsJdbcHelper.$$$reportNull$$$0(6);
        }
        if (sslMode == null) {
            RsJdbcHelper.$$$reportNull$$$0(7);
        }
        RsJdbcHelper.setIfEmpty(properties, "ssl", "true");
        if (sslMode != JdbcSettings.SslMode.REQUIRE) {
            RsJdbcHelper.setIfEmpty(properties, "sslmode", RsJdbcHelper.getSslMode(sslMode));
        }
    }

    @Override
    public boolean detect(@NotNull Driver driver, @Nullable String url) {
        if (driver == null) {
            RsJdbcHelper.$$$reportNull$$$0(8);
        }
        return RsJdbcHelper.classNameContains(driver, "redshift");
    }

    @Override
    protected void setDriverLogLevel(Driver driver, Properties properties, Level level, String logPath) {
        RemoteLogHelper.setDriverManagerLogLevel(level);
        if (level != null && level != Level.OFF) {
            RsJdbcHelper.setIfEmpty(properties, "DSILogLevel", level.intValue() >= Level.SEVERE.intValue() ? "1" : (level.intValue() >= Level.WARNING.intValue() ? "3" : (level.intValue() >= Level.INFO.intValue() ? "4" : (level.intValue() >= Level.FINE.intValue() ? "5" : "6"))));
        }
    }

    @NotNull
    static RsJdbcHelper create(@Nullable Connection delegate, @Nullable String versionStr, @Nullable ClassLoader jdbcClassLoader) {
        String version = RsJdbcHelper.extractVersion(versionStr);
        return new RsJdbcHelper(version, delegate, jdbcClassLoader);
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        return JdbcNativeUtil.findVersion(str, RS_VERSION_PATTERN);
    }

    @Override
    @Nullable
    public Boolean supportsSavepoints() {
        return false;
    }

    @Override
    @Nullable
    protected Object tryGetObject(@NotNull RemoteResultSet.DataRetrievingOptions options, @NotNull ResultSet resultSet, @NotNull ResultSetMetaData metaData, int index) throws SQLException {
        String typeName;
        if (options == null) {
            RsJdbcHelper.$$$reportNull$$$0(9);
        }
        if (resultSet == null) {
            RsJdbcHelper.$$$reportNull$$$0(10);
        }
        if (metaData == null) {
            RsJdbcHelper.$$$reportNull$$$0(11);
        }
        return "interval".equals(typeName = metaData.getColumnTypeName(index)) ? resultSet.getString(index) : ("bit".equals(typeName) && metaData.getPrecision(index) > 1 ? resultSet.getString(index) : super.tryGetObject(options, resultSet, metaData, index));
    }

    @Override
    public void setFetchSize(Statement stmt, int fetchSize) throws SQLException {
        if (!(stmt instanceof PreparedStatement) && this.supportsPreparedStatementsWithFetchSizeToPgCatalog()) {
            super.setFetchSize(stmt, fetchSize);
        }
    }

    @Override
    public void setFetchSize(ResultSet rs, int fetchSize) throws SQLException {
        if (this.supportsPreparedStatementsWithFetchSizeToPgCatalog()) {
            super.setFetchSize(rs, fetchSize);
        }
    }

    @Override
    public JdbcHelperImpl bindClassLoader(@NotNull ClassLoader jdbcClassLoader) {
        if (jdbcClassLoader == null) {
            RsJdbcHelper.$$$reportNull$$$0(12);
        }
        return new RsJdbcHelper(this, jdbcClassLoader);
    }

    private boolean supportsPreparedStatementsWithFetchSizeToPgCatalog() throws SQLException {
        Connection connection = this.getConnection();
        Version version = connection == null ? Version.ZERO : Version.of(connection.getMetaData().getDriverVersion());
        return version.less(2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdbcClassLoader";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exporter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sslMode";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaData";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/RsJdbcHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createFacade";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "wrapIfNeeded";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "adjustType";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "enableSsl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "detect";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "tryGetObject";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "bindClassLoader";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

