/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler;

import com.intellij.codeInsight.navigation.PsiTargetNavigator;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.CommonProfilerUISettings;
import com.intellij.profiler.CommonProfilerUiOptions;
import com.intellij.profiler.ProfilerToolWindowManager;
import com.intellij.profiler.SnapshotFile;
import com.intellij.profiler.UtilsKt;
import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.api.ProfilerDumpWriterBase;
import com.intellij.profiler.ui.MainCallTreeDataComponentKt;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.SystemProperties;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Arrays;
import javax.swing.JComponent;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u00a8\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0002\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0002\u001a\u0006\u0010\u0007\u001a\u00020\b\u001a\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000b2\u0006\u0010\f\u001a\u00020\u0006\u001a\u0016\u0010\u0012\u001a\u00020\u0002*\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u0002H\u0007\u001a&\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0002\u001a\u0006\u0010\u001b\u001a\u00020\u001c\u001a,\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\n\b\u0002\u0010%\u001a\u0004\u0018\u00010&H\u0000\u001a(\u0010'\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020(2\b\b\u0002\u0010)\u001a\u00020\bH\u0082@\u00a2\u0006\u0002\u0010*\u001a\u001e\u0010+\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010,\u001a\u00020-H\u0086@\u00a2\u0006\u0002\u0010.\u001a}\u0010/\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u00100\u001a\u0002012\u001e\b\u0002\u00102\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e04\u0012\u0006\u0012\u0004\u0018\u000105032\b\b\u0002\u00106\u001a\u00020\b2\b\b\u0002\u00107\u001a\u00020\b2$\b\u0002\u00108\u001a\u001e\b\u0001\u0012\u0004\u0012\u00020(\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e04\u0012\u0006\u0012\u0004\u0018\u00010509\u00a2\u0006\u0002\u0010:\u001aI\u0010;\u001a\u00020\u001e2\u000e\u0010<\u001a\n\u0012\u0006\b\u0001\u0012\u00020(0=2\u0006\u00100\u001a\u0002012\"\u00108\u001a\u001e\b\u0001\u0012\u0004\u0012\u00020(\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e04\u0012\u0006\u0012\u0004\u0018\u00010509H\u0002\u00a2\u0006\u0002\u0010>\u001a\u0016\u0010?\u001a\u00020\b2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020A\u001a\u0013\u0010C\u001a\u00070\u0002\u00a2\u0006\u0002\bD2\u0006\u0010E\u001a\u00020F\"\u001b\u0010\r\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000f*\u0016\u0010\u0000\"\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a8\u0006G"}, d2={"StringCallStackElement", "Lcom/intellij/profiler/ValueCallStackElement;", "", "parseHexLong", "", "parseHexInt", "", "keepTempProfilerFiles", "", "dtraceOutputFile", "Ljava/io/File;", "Lorg/jetbrains/annotations/NotNull;", "pid", "profilerDumpsDir", "getProfilerDumpsDir", "()Ljava/io/File;", "profilerDumpsDir$delegate", "Lkotlin/Lazy;", "explain", "", "prefix", "createSnapshotFile", "Lcom/intellij/profiler/SnapshotFile;", "name", "timestamp", "type", "ext", "getDefaultSnapshotFolder", "Ljava/nio/file/Path;", "navigateToSourceWithSingleClick", "", "project", "Lcom/intellij/openapi/project/Project;", "element", "Lcom/intellij/profiler/api/BaseCallStackElement;", "component", "Ljavax/swing/JComponent;", "event", "Ljava/awt/event/MouseEvent;", "performNavigate", "Lcom/intellij/psi/NavigatablePsiElement;", "preview", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/NavigatablePsiElement;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "navigateInEditor", "descriptor", "Lcom/intellij/openapi/fileEditor/OpenFileDescriptor;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/fileEditor/OpenFileDescriptor;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "navigateToSourceInBackground", "popupPoint", "Lcom/intellij/ui/awt/RelativePoint;", "onDumb", "Lkotlin/Function1;", "Lkotlin/coroutines/Continuation;", "", "showWarnings", "openInPreviewTab", "doNavigate", "Lkotlin/Function2;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/profiler/api/BaseCallStackElement;Lcom/intellij/ui/awt/RelativePoint;Lkotlin/jvm/functions/Function1;ZZLkotlin/jvm/functions/Function2;)V", "navigateOrCreatePopup", "navigatables", "", "([Lcom/intellij/psi/NavigatablePsiElement;Lcom/intellij/ui/awt/RelativePoint;Lkotlin/jvm/functions/Function2;)V", "isPrefixTo", "magic", "", "array", "durationToCompactString", "Lcom/intellij/openapi/util/NlsSafe;", "duration", "Ljava/time/Duration;", "intellij.profiler.common"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\ncom/intellij/profiler/UtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,202:1\n1#2:203\n*E\n"})
public final class UtilsKt {
    @NotNull
    private static final Lazy profilerDumpsDir$delegate = LazyKt.lazy(UtilsKt::profilerDumpsDir_delegate$lambda$0);

    public static final long parseHexLong(@NotNull String $this$parseHexLong) {
        Intrinsics.checkNotNullParameter((Object)$this$parseHexLong, (String)"<this>");
        return Long.parseLong(StringsKt.startsWith$default((String)$this$parseHexLong, (String)"0x", (boolean)false, (int)2, null) ? StringsKt.drop((String)$this$parseHexLong, (int)2) : $this$parseHexLong, CharsKt.checkRadix((int)16));
    }

    public static final int parseHexInt(@NotNull String $this$parseHexInt) {
        Intrinsics.checkNotNullParameter((Object)$this$parseHexInt, (String)"<this>");
        return Integer.parseInt(StringsKt.startsWith$default((String)$this$parseHexInt, (String)"0x", (boolean)false, (int)2, null) ? StringsKt.drop((String)$this$parseHexInt, (int)2) : $this$parseHexInt, CharsKt.checkRadix((int)16));
    }

    public static final boolean keepTempProfilerFiles() {
        Application it = ApplicationManager.getApplication();
        boolean bl = false;
        return it.isInternal() || it.isUnitTestMode();
    }

    @NotNull
    public static final File dtraceOutputFile(int pid) {
        File file = FileUtil.createTempFile((File)UtilsKt.getProfilerDumpsDir(), (String)("raw-dtrace-" + pid), (String)".dump", (boolean)true, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempFile(...)");
        return file;
    }

    private static final File getProfilerDumpsDir() {
        Lazy lazy = profilerDumpsDir$delegate;
        return (File)lazy.getValue();
    }

    @NlsSafe
    @NotNull
    public static final String explain(@NotNull Throwable $this$explain, @Nls @NotNull String prefix) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$explain, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        if (!(((CharSequence)prefix).length() > 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        StringBuilder $this$explain_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$explain_u24lambda_u240.append(prefix);
        $this$explain_u24lambda_u240.append(": ");
        $this$explain_u24lambda_u240.append($this$explain.getClass().getCanonicalName());
        if ($this$explain.getMessage() != null) {
            $this$explain_u24lambda_u240.append(": " + $this$explain.getMessage());
        }
        return stringBuilder.toString();
    }

    @NotNull
    public static final SnapshotFile createSnapshotFile(@NotNull String name, long timestamp, @NotNull String type, @NotNull String ext) {
        Object object;
        File dumpFile;
        boolean temp;
        block6: {
            block5: {
                String string;
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                Intrinsics.checkNotNullParameter((Object)ext, (String)"ext");
                temp = false;
                dumpFile = null;
                object = ((CommonProfilerUiOptions)CommonProfilerUISettings.Companion.getInstance().getState()).getSnapshotOptions().getFolder();
                if (object == null) break block5;
                String p0 = string = object;
                boolean bl = false;
                object = !StringsKt.isBlank((CharSequence)p0) ? string : null;
                if (object == null) break block5;
                Object p02 = object;
                boolean bl2 = false;
                Path path = Path.of((String)p02, new String[0]);
                object = path;
                if (path != null) break block6;
            }
            object = UtilsKt.getDefaultSnapshotFolder();
        }
        Object snapshotsFolder = object;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists((Path)snapshotsFolder, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            String dumpFileName2 = new ProfilerDumpWriterBase(name, timestamp){

                public void writeDump(File outputFile, ProgressIndicator indicator) {
                    Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                }
            }.getDumpFileName();
            temp = ApplicationManager.getApplication().isUnitTestMode();
            File file = FileUtil.findSequentNonexistentFile((File)snapshotsFolder.toFile(), (String)FileUtil.sanitizeFileName((String)dumpFileName2), (String)ext);
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"findSequentNonexistentFile(...)");
            dumpFile = file;
        } else {
            temp = true;
            File file = FileUtil.createTempFile((String)type, (String)("." + ext), (boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempFile(...)");
            dumpFile = file;
        }
        return new SnapshotFile(dumpFile, temp);
    }

    @NotNull
    public static final Path getDefaultSnapshotFolder() {
        String custom = System.getProperty("snapshots.path");
        if (custom != null) {
            Path path = Path.of(custom, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
            return path;
        }
        String[] stringArray = new String[]{"IdeaSnapshots"};
        Path path = Path.of(SystemProperties.getUserHome(), stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
        return path;
    }

    public static final void navigateToSourceWithSingleClick(@NotNull Project project, @NotNull BaseCallStackElement element, @NotNull JComponent component, @Nullable MouseEvent event) {
        Serializable serializable;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)component, (String)"component");
                serializable = event;
                if (serializable == null || (serializable = serializable.getLocationOnScreen()) == null) break block2;
                Serializable it = serializable;
                boolean bl = false;
                RelativePoint relativePoint = RelativePoint.fromScreen((Point)it);
                serializable = relativePoint;
                if (relativePoint != null) break block3;
            }
            RelativePoint relativePoint = RelativePoint.getCenterOf((JComponent)component);
            serializable = relativePoint;
            Intrinsics.checkNotNullExpressionValue((Object)relativePoint, (String)"getCenterOf(...)");
        }
        Serializable point = serializable;
        UtilsKt.navigateToSourceInBackground$default(project, element, (RelativePoint)point, null, false, true, null, 72, null);
    }

    public static /* synthetic */ void navigateToSourceWithSingleClick$default(Project project, BaseCallStackElement baseCallStackElement, JComponent jComponent, MouseEvent mouseEvent, int n, Object object) {
        if ((n & 8) != 0) {
            mouseEvent = null;
        }
        UtilsKt.navigateToSourceWithSingleClick(project, baseCallStackElement, jComponent, mouseEvent);
    }

    private static final Object performNavigate(Project project, NavigatablePsiElement element, boolean preview, Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(element, project, preview, null){
            Object L$0;
            int I$0;
            int label;
            final /* synthetic */ NavigatablePsiElement $element;
            final /* synthetic */ Project $project;
            final /* synthetic */ boolean $preview;
            {
                this.$element = $element;
                this.$project = $project;
                this.$preview = $preview;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$0(com.intellij.psi.NavigatablePsiElement ), ()Lcom/intellij/openapi/vfs/VirtualFile;)((NavigatablePsiElement)this.$element), (Continuation)((Continuation)this));
                        if (v0 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        v1 = (VirtualFile)v0;
                        if (v1 == null) {
                            return Unit.INSTANCE;
                        }
                        file = v1;
                        this.L$0 = file;
                        this.label = 2;
                        v2 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$1(com.intellij.psi.NavigatablePsiElement ), ()Ljava/lang/Integer;)((NavigatablePsiElement)this.$element), (Continuation)((Continuation)this));
                        if (v2 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl27
                    }
                    case 2: {
                        file = (VirtualFile)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl27:
                        // 2 sources

                        textOffset = ((Number)v2).intValue();
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)file);
                        this.I$0 = textOffset;
                        this.label = 3;
                        v3 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$project, file, textOffset, this.$preview, null){
                            Object L$0;
                            int label;
                            final /* synthetic */ Project $project;
                            final /* synthetic */ VirtualFile $file;
                            final /* synthetic */ int $textOffset;
                            final /* synthetic */ boolean $preview;
                            {
                                this.$project = $project;
                                this.$file = $file;
                                this.$textOffset = $textOffset;
                                this.$preview = $preview;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        OpenFileDescriptor openFileDescriptor = new OpenFileDescriptor(this.$project, this.$file, this.$textOffset).setUsePreviewTab(this.$preview);
                                        Intrinsics.checkNotNullExpressionValue((Object)openFileDescriptor, (String)"setUsePreviewTab(...)");
                                        OpenFileDescriptor descriptor = openFileDescriptor;
                                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)descriptor);
                                        this.label = 1;
                                        Object object2 = UtilsKt.navigateInEditor(this.$project, descriptor, (Continuation<? super Unit>)((Continuation)this));
                                        if (object2 != object) return Unit.INSTANCE;
                                        return object;
                                    }
                                    case 1: {
                                        OpenFileDescriptor descriptor = (OpenFileDescriptor)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (v3 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl40
                    }
                    case 3: {
                        textOffset = this.I$0;
                        file = (VirtualFile)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl40:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final VirtualFile invokeSuspend$lambda$0(NavigatablePsiElement $element) {
                Object object;
                block3: {
                    block2: {
                        PsiElement psiElement;
                        object = $element.getNavigationElement();
                        if (object == null) break block2;
                        PsiElement it = psiElement = object;
                        boolean bl = false;
                        object = it.isValid() ? psiElement : null;
                        if (object != null) break block3;
                    }
                    return null;
                }
                PsiElement validElement = object;
                return PsiUtilCore.getVirtualFile((PsiElement)validElement);
            }

            private static final int invokeSuspend$lambda$1(NavigatablePsiElement $element) {
                return $element.getNavigationElement().getTextOffset();
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    static /* synthetic */ Object performNavigate$default(Project project, NavigatablePsiElement navigatablePsiElement, boolean bl, Continuation continuation, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return UtilsKt.performNavigate(project, navigatablePsiElement, bl, (Continuation<? super Unit>)continuation);
    }

    @Nullable
    public static final Object navigateInEditor(@NotNull Project project, @NotNull OpenFileDescriptor descriptor, @NotNull Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(descriptor, project, null){
            int label;
            final /* synthetic */ OpenFileDescriptor $descriptor;
            final /* synthetic */ Project $project;
            {
                this.$descriptor = $descriptor;
                this.$project = $project;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        ApplicationManager.getApplication().runReadAction(() -> navigateInEditor.2.invokeSuspend$lambda$0(this.$descriptor, this.$project));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final void invokeSuspend$lambda$0(OpenFileDescriptor $descriptor, Project $project) {
                $descriptor.navigateInEditor($project, false);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static final void navigateToSourceInBackground(@NotNull Project project, @NotNull BaseCallStackElement element, @NotNull RelativePoint popupPoint, @NotNull Function1<? super Continuation<? super Unit>, ? extends Object> onDumb, boolean showWarnings, boolean openInPreviewTab, @NotNull Function2<? super NavigatablePsiElement, ? super Continuation<? super Unit>, ? extends Object> doNavigate) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)popupPoint, (String)"popupPoint");
        Intrinsics.checkNotNullParameter(onDumb, (String)"onDumb");
        Intrinsics.checkNotNullParameter(doNavigate, (String)"doNavigate");
        BuildersKt.launch$default((CoroutineScope)MainCallTreeDataComponentKt.profilerUiScope(project), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(project, onDumb, element, showWarnings, popupPoint, doNavigate, null){
            int label;
            final /* synthetic */ Project $project;
            final /* synthetic */ Function1<Continuation<? super Unit>, Object> $onDumb;
            final /* synthetic */ BaseCallStackElement $element;
            final /* synthetic */ boolean $showWarnings;
            final /* synthetic */ RelativePoint $popupPoint;
            final /* synthetic */ Function2<NavigatablePsiElement, Continuation<? super Unit>, Object> $doNavigate;
            {
                this.$project = $project;
                this.$onDumb = $onDumb;
                this.$element = $element;
                this.$showWarnings = $showWarnings;
                this.$popupPoint = $popupPoint;
                this.$doNavigate = $doNavigate;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = TasksKt.withBackgroundProgress((Project)this.$project, (String)CommonProfilerBundleKt.profilerMessage("ui.action.navigate", new Object[0]), (boolean)true, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$project, this.$onDumb, this.$element, this.$showWarnings, this.$popupPoint, this.$doNavigate, null){
                            Object L$0;
                            int label;
                            final /* synthetic */ Project $project;
                            final /* synthetic */ Function1<Continuation<? super Unit>, Object> $onDumb;
                            final /* synthetic */ BaseCallStackElement $element;
                            final /* synthetic */ boolean $showWarnings;
                            final /* synthetic */ RelativePoint $popupPoint;
                            final /* synthetic */ Function2<NavigatablePsiElement, Continuation<? super Unit>, Object> $doNavigate;
                            {
                                this.$project = $project;
                                this.$onDumb = $onDumb;
                                this.$element = $element;
                                this.$showWarnings = $showWarnings;
                                this.$popupPoint = $popupPoint;
                                this.$doNavigate = $doNavigate;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                             * Unable to fully structure code
                             * Enabled aggressive block sorting
                             * Enabled unnecessary exception pruning
                             * Enabled aggressive exception aggregation
                             */
                            public final Object invokeSuspend(Object $result) {
                                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        if (DumbService.Companion.isDumb(this.$project)) {
                                            this.label = 1;
                                            v0 = this.$onDumb.invoke((Object)this);
                                            v1 = v0;
                                            if (v0 != var3_2) return Unit.INSTANCE;
                                            return var3_2;
                                        }
                                        ** GOTO lbl16
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v1 = $result;
                                        return Unit.INSTANCE;
                                    }
lbl16:
                                    // 1 sources

                                    try {
                                        navigatables = this.$element.calcNavigatables(this.$project);
                                        if (navigatables.length == 0) {
                                            if (this.$showWarnings == false) return Unit.INSTANCE;
                                            ProfilerToolWindowManager.Companion.getInstance(this.$project).showWarningBalloon(CommonProfilerBundleKt.profilerMessage("profiler.declarationNotFound", new Object[0]));
                                            return Unit.INSTANCE;
                                        }
                                        this.L$0 = navigatables;
                                        this.label = 2;
                                        v2 = com.intellij.openapi.progress.CoroutinesKt.checkCanceled((Continuation)((Continuation)this));
                                    }
                                    catch (IndexNotReadyException <unused var>) {
                                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)<unused var>);
                                        this.label = 4;
                                        v3 = this.$onDumb.invoke((Object)this);
                                        v4 = v3;
                                        if (v3 != var3_2) return Unit.INSTANCE;
                                        return var3_2;
                                    }
                                    v5 = v2;
                                    if (v2 == var3_2) {
                                        return var3_2;
                                    }
                                    ** GOTO lbl43
                                    case 2: {
                                        navigatables = (NavigatablePsiElement[])this.L$0;
                                        {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v5 = $result;
lbl43:
                                            // 2 sources

                                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)navigatables);
                                            this.label = 3;
                                            v6 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(navigatables, this.$popupPoint, this.$doNavigate, null){
                                                int label;
                                                final /* synthetic */ NavigatablePsiElement[] $navigatables;
                                                final /* synthetic */ RelativePoint $popupPoint;
                                                final /* synthetic */ Function2<NavigatablePsiElement, Continuation<? super Unit>, Object> $doNavigate;
                                                {
                                                    this.$navigatables = $navigatables;
                                                    this.$popupPoint = $popupPoint;
                                                    this.$doNavigate = $doNavigate;
                                                    super(2, $completion);
                                                }

                                                public final Object invokeSuspend(Object $result) {
                                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                    switch (this.label) {
                                                        case 0: {
                                                            ResultKt.throwOnFailure((Object)$result);
                                                            UtilsKt.access$navigateOrCreatePopup(this.$navigatables, this.$popupPoint, this.$doNavigate);
                                                            return Unit.INSTANCE;
                                                        }
                                                    }
                                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                }

                                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                }

                                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                }
                                            }), (Continuation)((Continuation)this));
                                        }
                                        v7 = v6;
                                        if (v6 != var3_2) return Unit.INSTANCE;
                                        return var3_2;
                                    }
                                    case 3: {
                                        navigatables = (NavigatablePsiElement[])this.L$0;
                                        {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v7 = $result;
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    case 4: {
                                        <unused var> = (IndexNotReadyException)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v4 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public static /* synthetic */ void navigateToSourceInBackground$default(Project project, BaseCallStackElement baseCallStackElement, RelativePoint relativePoint, Function1 function1, boolean bl, boolean bl2, Function2 function2, int n, Object object) {
        if ((n & 8) != 0) {
            function1 = (Function1)new Function1<Continuation<? super Unit>, Object>(null){
                int label;

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(Continuation<? super Unit> p1) {
                    return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                }
            };
        }
        if ((n & 0x10) != 0) {
            bl = true;
        }
        if ((n & 0x20) != 0) {
            bl2 = false;
        }
        if ((n & 0x40) != 0) {
            function2 = (Function2)new Function2<NavigatablePsiElement, Continuation<? super Unit>, Object>(project, bl2, null){
                int label;
                /* synthetic */ Object L$0;
                final /* synthetic */ Project $project;
                final /* synthetic */ boolean $openInPreviewTab;
                {
                    this.$project = $project;
                    this.$openInPreviewTab = $openInPreviewTab;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    NavigatablePsiElement navigatablePsiElement = (NavigatablePsiElement)this.L$0;
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            void it;
                            ResultKt.throwOnFailure((Object)$result);
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)it);
                            this.label = 1;
                            Object object2 = UtilsKt.access$performNavigate(this.$project, (NavigatablePsiElement)it, this.$openInPreviewTab, (Continuation)this);
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(NavigatablePsiElement p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            };
        }
        UtilsKt.navigateToSourceInBackground(project, baseCallStackElement, relativePoint, (Function1<? super Continuation<? super Unit>, ? extends Object>)function1, bl, bl2, (Function2<? super NavigatablePsiElement, ? super Continuation<? super Unit>, ? extends Object>)function2);
    }

    private static final void navigateOrCreatePopup(NavigatablePsiElement[] navigatables, RelativePoint popupPoint, Function2<? super NavigatablePsiElement, ? super Continuation<? super Unit>, ? extends Object> doNavigate) {
        NavigatablePsiElement navigatablePsiElement = (NavigatablePsiElement)ArraysKt.firstOrNull((Object[])navigatables);
        if (navigatablePsiElement == null || (navigatablePsiElement = navigatablePsiElement.getProject()) == null) {
            return;
        }
        NavigatablePsiElement project = navigatablePsiElement;
        new PsiTargetNavigator((PsiElement[])navigatables).navigate(popupPoint, CommonProfilerBundleKt.profilerMessage("profiler.selectOverload", new Object[0]), (Project)project, arg_0 -> UtilsKt.navigateOrCreatePopup$lambda$0((Project)project, doNavigate, arg_0));
    }

    public static final boolean isPrefixTo(@NotNull byte[] magic, @NotNull byte[] array) {
        Intrinsics.checkNotNullParameter((Object)magic, (String)"magic");
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        if (magic.length > array.length) {
            return false;
        }
        int n = magic.length;
        for (int i = 0; i < n; ++i) {
            if (magic[i] == array[i]) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static final String durationToCompactString(@NotNull Duration duration) {
        String string;
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        long hours = duration.toHours();
        int minutes = duration.toMinutesPart();
        int seconds = duration.toSecondsPart();
        if (hours == 0L) {
            String string2 = "%02d:%02d";
            Object[] objectArray = new Object[]{minutes, seconds};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        } else {
            String string4 = "%02d:%02d:%02d";
            Object[] objectArray = new Object[]{hours, minutes, seconds};
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
        }
        return string;
    }

    private static final File profilerDumpsDir_delegate$lambda$0() {
        File file = FileUtil.createTempDirectory((String)"idea-profiler-dumps", (String)"", (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempDirectory(...)");
        return file;
    }

    private static final boolean navigateOrCreatePopup$lambda$0(Project $project, Function2 $doNavigate, NavigatablePsiElement element) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        boolean it = bl = ((PsiElement)element).isValid();
        boolean bl2 = false;
        if (it) {
            BuildersKt.launch$default((CoroutineScope)MainCallTreeDataComponentKt.profilerUiScope($project), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Function2<? super NavigatablePsiElement, ? super Continuation<? super Unit>, ? extends Object>)$doNavigate, element, null){
                int label;
                final /* synthetic */ Function2<NavigatablePsiElement, Continuation<? super Unit>, Object> $doNavigate;
                final /* synthetic */ NavigatablePsiElement $element;
                {
                    this.$doNavigate = $doNavigate;
                    this.$element = $element;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = this.$doNavigate.invoke((Object)this.$element, (Object)((Object)this));
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
        return bl;
    }

    public static final /* synthetic */ Object access$performNavigate(Project project, NavigatablePsiElement element, boolean preview, Continuation $completion) {
        return UtilsKt.performNavigate(project, element, preview, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ void access$navigateOrCreatePopup(NavigatablePsiElement[] navigatables, RelativePoint popupPoint, Function2 doNavigate) {
        UtilsKt.navigateOrCreatePopup(navigatables, popupPoint, (Function2<? super NavigatablePsiElement, ? super Continuation<? super Unit>, ? extends Object>)doNavigate);
    }
}

