/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.calculation;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.nodejs.run.profile.cpu.calculation.V8ProfileLine;
import com.jetbrains.nodejs.run.profile.cpu.calculation.V8ProfileLineFileDescriptor;
import com.jetbrains.nodejs.run.profile.cpu.v8log.data.CodeState;
import com.jetbrains.nodejs.run.profile.cpu.v8log.data.V8CpuLogCall;
import com.jetbrains.nodejs.run.profile.heap.io.RawSerializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CallTreesSerializer
implements RawSerializer<V8ProfileLine> {
    @Override
    public long getRecordSize() {
        return -1L;
    }

    @Override
    public void write(@NotNull DataOutput os, @NotNull V8ProfileLine line) throws IOException {
        if (os == null) {
            CallTreesSerializer.$$$reportNull$$$0(0);
        }
        if (line == null) {
            CallTreesSerializer.$$$reportNull$$$0(1);
        }
        ArrayDeque<V8ProfileLine> queue = new ArrayDeque<V8ProfileLine>();
        queue.add(line);
        while (!queue.isEmpty()) {
            V8ProfileLine current = (V8ProfileLine)queue.removeFirst();
            CallTreesSerializer.writeLine(os, current);
            os.writeInt(current.getChildren().size());
            ArrayList<V8ProfileLine> children = new ArrayList<V8ProfileLine>(current.getChildren());
            Collections.reverse(children);
            for (V8ProfileLine child : children) {
                queue.addFirst(child);
            }
        }
    }

    @Override
    public V8ProfileLine read(@NotNull DataInput is) throws IOException {
        if (is == null) {
            CallTreesSerializer.$$$reportNull$$$0(2);
        }
        V8ProfileLine root = null;
        ArrayDeque<V8ProfileLine> queue = new ArrayDeque<V8ProfileLine>();
        queue.add(new V8ProfileLine(0, 0, 0, 0, null, 0, "", -1L));
        while (!queue.isEmpty()) {
            V8ProfileLine parent = (V8ProfileLine)queue.removeFirst();
            V8ProfileLine line = CallTreesSerializer.readLine(is, parent);
            if (root == null) {
                root = line;
            } else {
                parent.getChildren().add(line);
            }
            int numChildren = is.readInt();
            for (int i = 0; i < numChildren; ++i) {
                queue.addFirst(line);
            }
        }
        return root;
    }

    public static void writeLine(@NotNull DataOutput os, @NotNull V8ProfileLine line) throws IOException {
        if (os == null) {
            CallTreesSerializer.$$$reportNull$$$0(3);
        }
        if (line == null) {
            CallTreesSerializer.$$$reportNull$$$0(4);
        }
        V8CpuLogCall call = line.getCall();
        CallTreesSerializer.writeCall(os, call);
        os.writeInt(line.getTotalTicks());
        os.writeInt(line.getTotalTensPercent());
        os.writeInt(line.getSelfTicks());
        os.writeInt(line.getSelfTensPercent());
    }

    public static void writeCall(@NotNull DataOutput os, V8CpuLogCall call) throws IOException {
        if (os == null) {
            CallTreesSerializer.$$$reportNull$$$0(5);
        }
        os.writeLong(call.getStringId());
        os.writeUTF(call.getExecKind().name());
        os.writeUTF(StringUtil.notNullize((String)call.getFunctionName()));
        os.writeBoolean(call.isNative());
        os.writeBoolean(call.isNotNavigatable());
        V8ProfileLineFileDescriptor descriptor = call.getDescriptor();
        os.writeBoolean(descriptor != null);
        if (descriptor != null) {
            os.writeUTF(descriptor.getName());
            os.writeUTF(StringUtil.notNullize((String)descriptor.getPath()));
            os.writeInt(descriptor.getRow());
            os.writeInt(descriptor.getCol());
        }
        os.writeUTF(StringUtil.notNullize((String)call.getNotParsedCallable()));
        os.writeUTF(call.getCodeState().name());
    }

    public static V8ProfileLine readLine(@NotNull DataInput is, @Nullable V8ProfileLine parent) throws IOException {
        if (is == null) {
            CallTreesSerializer.$$$reportNull$$$0(6);
        }
        V8CpuLogCall call = CallTreesSerializer.readCall(is);
        int totalTicks = is.readInt();
        int totalPercent = is.readInt();
        int selfTicks = is.readInt();
        int selfPercent = is.readInt();
        return new V8ProfileLine(totalTicks, totalPercent, selfTicks, selfPercent, parent, 0, call);
    }

    @NotNull
    public static V8CpuLogCall readCall(@NotNull DataInput is) throws IOException {
        if (is == null) {
            CallTreesSerializer.$$$reportNull$$$0(7);
        }
        long stringId = is.readLong();
        V8ProfileLine.ExecKind execKind = V8ProfileLine.ExecKind.safeValueOf(is.readUTF());
        String functionName = CallTreesSerializer.readNullize(is);
        boolean isNative = is.readBoolean();
        boolean isNotNavigable = is.readBoolean();
        boolean haveDescriptor = is.readBoolean();
        V8ProfileLineFileDescriptor descriptor = null;
        if (haveDescriptor) {
            String fileName = is.readUTF();
            String path = CallTreesSerializer.readNullize(is);
            int row = is.readInt();
            int col = is.readInt();
            descriptor = new V8ProfileLineFileDescriptor(fileName, path, row, col);
        }
        @NlsSafe String nonParsedCallable = is.readUTF();
        String codeStateName = is.readUTF();
        CodeState codeState = CodeState.safeValueOf(codeStateName);
        if (codeState == null) {
            throw new IOException("Wrong code state: " + codeStateName);
        }
        return new V8CpuLogCall(execKind, functionName, isNative, isNotNavigable, descriptor, nonParsedCallable, codeState, stringId);
    }

    private static String readNullize(@NotNull DataInput is) throws IOException {
        String s;
        if (is == null) {
            CallTreesSerializer.$$$reportNull$$$0(8);
        }
        return StringUtil.isEmptyOrSpaces((String)(s = is.readUTF())) ? null : s;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "os";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "is";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/nodejs/run/profile/cpu/calculation/CallTreesSerializer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "write";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "read";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "writeLine";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "writeCall";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "readLine";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "readCall";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "readNullize";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

