/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.beanValidation.highlighting.checkers;

import com.intellij.beanValidation.constants.BvAnnoConstants;
import com.intellij.beanValidation.highlighting.checkers.BvChecker;
import com.intellij.beanValidation.resources.BVBundle;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;

public class CheckClassIsConstraintAnnotation
implements BvChecker {
    @Override
    public void check(GenericDomValue<?> value, DomElementAnnotationHolder holder) {
        Object psiClass = value.getValue();
        if (psiClass instanceof PsiClass) {
            PsiClass anno = (PsiClass)psiClass;
            if (!anno.isAnnotationType()) {
                holder.createProblem(value, BVBundle.message("is.not.an.annotation", anno.getQualifiedName()), new LocalQuickFix[0]);
            } else if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)anno, (String)BvAnnoConstants.CONSTRAINT.fqn((PsiElement)anno), (int)1)) {
                holder.createProblem(value, BVBundle.message("is.not.a.constraint", anno.getQualifiedName()), new LocalQuickFix[0]);
            }
        }
    }
}

