/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.mongodb.json.psi;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.persistence.mongodb.json.psi.MongoDBJsonElementGenerator;
import com.intellij.persistence.mongodb.json.psi.MongoDBJsonStringLiteral;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/persistence/mongodb/json/psi/MongoDBJsonStringLiteralManipulator;", "Lcom/intellij/psi/AbstractElementManipulator;", "Lcom/intellij/persistence/mongodb/json/psi/MongoDBJsonStringLiteral;", "<init>", "()V", "handleContentChange", "element", "range", "Lcom/intellij/openapi/util/TextRange;", "newContent", "", "getRangeInElement", "intellij.javaee.persistence.impl"})
public final class MongoDBJsonStringLiteralManipulator
extends AbstractElementManipulator<MongoDBJsonStringLiteral> {
    @NotNull
    public MongoDBJsonStringLiteral handleContentChange(@NotNull MongoDBJsonStringLiteral element, @NotNull TextRange range, @NotNull String newContent) throws IncorrectOperationException {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)newContent, (String)"newContent");
        boolean bl = new TextRange(0, element.getTextLength()).contains(range);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        String originalContent = element.getText();
        TextRange withoutQuotes = this.getRangeInElement(element);
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        FileType fileType = element.getContainingFile().getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
        MongoDBJsonElementGenerator generator = new MongoDBJsonElementGenerator(project, fileType);
        Intrinsics.checkNotNull((Object)originalContent);
        String string = originalContent.substring(withoutQuotes.getStartOffset(), range.getStartOffset());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String string2 = originalContent.substring(range.getEndOffset(), withoutQuotes.getEndOffset());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String replacement = string + newContent + string2;
        PsiElement psiElement = element.replace(generator.createStringLiteral(replacement));
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.persistence.mongodb.json.psi.MongoDBJsonStringLiteral");
        return (MongoDBJsonStringLiteral)psiElement;
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull MongoDBJsonStringLiteral element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String content = element.getText();
        Intrinsics.checkNotNull((Object)content);
        int startOffset = StringsKt.startsWith$default((String)content, (String)"'", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)content, (String)"\"", (boolean)false, (int)2, null) ? 1 : 0;
        int endOffset = content.length() > 1 && (StringsKt.endsWith$default((String)content, (String)"'", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)content, (String)"\"", (boolean)false, (int)2, null)) ? -1 : 0;
        return new TextRange(startOffset, content.length() + endOffset);
    }
}

