/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.jfr;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.profiler.UtilsKt;
import com.intellij.profiler.api.Failure;
import com.intellij.profiler.api.ProfilerData;
import com.intellij.profiler.api.ProfilerDumpFileParser;
import com.intellij.profiler.api.ProfilerDumpFileParsingResult;
import com.intellij.profiler.api.Success;
import com.intellij.profiler.compressed.CompressedDumpsAwareFileParser;
import com.intellij.profiler.ultimate.UltimateProfilerBundleKt;
import com.intellij.profiler.ultimate.jfr.BuildingModelProgressStep;
import com.intellij.profiler.ultimate.jfr.ByteBufferTrackingWrapper;
import com.intellij.profiler.ultimate.jfr.ByteBufferTrackingWrapperKt;
import com.intellij.profiler.ultimate.jfr.DllDebugInfo;
import com.intellij.profiler.ultimate.jfr.JFRDumpParserProviderKt;
import com.intellij.profiler.ultimate.jfr.JFRProfilerData;
import com.intellij.profiler.ultimate.jfr.JfrContentsDescriptor;
import com.intellij.profiler.ultimate.jfr.MultipleStepsProgressTracker;
import com.intellij.profiler.ultimate.jfr.ProgressTrackerStep;
import com.intellij.profiler.ultimate.jfr.ReadingJfrProgressStep;
import com.intellij.profiler.ultimate.jfr.ResolvingNativeSymbolsProgressStep;
import com.intellij.profiler.ultimate.jfr.events.JfrEvent;
import com.intellij.profiler.ultimate.jfr.events.JfrEventTypesBuilder;
import com.intellij.profiler.ultimate.jfr.events.PossiblyUnknownJfrEvent;
import com.intellij.profiler.ultimate.jfr.jmc.StreamModel;
import com.intellij.profiler.ultimate.jfr.metadata.CustomJfrIdentifier;
import com.intellij.util.ArrayUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.ByteBufferUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.Grouping;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openjdk.jmc.common.io.IOToolkit;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.ITypedQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.flightrecorder.CouldNotLoadRecordingException;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.internal.EventArrays;
import org.openjdk.jmc.flightrecorder.internal.FlightRecordingLoader;
import org.openjdk.jmc.flightrecorder.internal.IChunkLoader;
import org.openjdk.jmc.flightrecorder.internal.IChunkSupplier;
import org.openjdk.jmc.flightrecorder.internal.InvalidJfrFileException;
import org.openjdk.jmc.flightrecorder.internal.parser.Chunk;
import org.openjdk.jmc.flightrecorder.internal.parser.LoaderContext;
import org.openjdk.jmc.flightrecorder.parser.IEventSink;
import org.openjdk.jmc.flightrecorder.parser.IEventSinkFactory;
import org.openjdk.jmc.flightrecorder.parser.IParserExtension;
import org.openjdk.jmc.flightrecorder.parser.ParserExtensionRegistry;
import org.openjdk.jmc.flightrecorder.parser.ValueField;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002:\u0001'B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016J,\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012H\u0002J&\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J(\u0010!\u001a\u00020\"2\u000e\u0010#\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010%0$2\u0006\u0010&\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u001eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006("}, d2={"Lcom/intellij/profiler/ultimate/jfr/JFRFileParser;", "Lcom/intellij/profiler/api/ProfilerDumpFileParser;", "Lcom/intellij/profiler/compressed/CompressedDumpsAwareFileParser;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "parse", "Lcom/intellij/profiler/api/ProfilerDumpFileParsingResult;", "file", "Ljava/io/File;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "inputStream", "Ljava/io/InputStream;", "isCompressed", "", "chunkSupplierProvider", "Lkotlin/Function1;", "Lcom/intellij/profiler/ultimate/jfr/MultipleStepsProgressTracker;", "Lorg/openjdk/jmc/flightrecorder/internal/IChunkSupplier;", "createChunkSupplier", "fileChannel", "Ljava/nio/channels/FileChannel;", "byteBuffers", "", "Lcom/intellij/profiler/ultimate/jfr/ByteBufferTrackingWrapper;", "progressTracker", "Lcom/intellij/profiler/ultimate/jfr/ReadingJfrProgressStep;", "helpId", "", "getHelpId", "()Ljava/lang/String;", "readChunks", "Lorg/openjdk/jmc/flightrecorder/internal/EventArrays;", "extensions", "", "Lorg/openjdk/jmc/flightrecorder/parser/IParserExtension;", "chunkSupplier", "ProfilerDataBuilder", "intellij.profiler.ultimate"})
@SourceDebugExtension(value={"SMAP\nJFRDumpParserProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JFRDumpParserProvider.kt\ncom/intellij/profiler/ultimate/jfr/JFRFileParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,473:1\n1869#2,2:474\n1869#2,2:477\n1#3:476\n*S KotlinDebug\n*F\n+ 1 JFRDumpParserProvider.kt\ncom/intellij/profiler/ultimate/jfr/JFRFileParser\n*L\n83#1:474,2\n440#1:477,2\n*E\n"})
public final class JFRFileParser
implements ProfilerDumpFileParser,
CompressedDumpsAwareFileParser {
    @Nullable
    private final Project project;
    @NotNull
    private final String helpId;

    public JFRFileParser(@Nullable Project project) {
        this.project = project;
        this.helpId = "procedures.profiler";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ProfilerDumpFileParsingResult parse(@NotNull File file, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Failure error2 = ProfilerDumpFileParser.Companion.validate(file);
        if (error2 != null) {
            return (ProfilerDumpFileParsingResult)error2;
        }
        Ref.ObjectRef fileChannel = new Ref.ObjectRef();
        List byteBuffers = new ArrayList();
        try {
            OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.READ};
            fileChannel.element = FileChannel.open(file.toPath(), openOptionArray);
            openOptionArray = this.parse(indicator, false, (Function1<? super MultipleStepsProgressTracker, ? extends IChunkSupplier>)((Function1)arg_0 -> JFRFileParser.parse$lambda$0(fileChannel, this, byteBuffers, arg_0)));
            return openOptionArray;
        }
        finally {
            IOToolkit.closeSilently((Closeable)fileChannel.element);
            Iterable $this$forEach$iv = byteBuffers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ByteBufferTrackingWrapper it = (ByteBufferTrackingWrapper)element$iv;
                boolean bl = false;
                ByteBufferUtil.cleanBuffer((ByteBuffer)it.getBuffer());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ProfilerDumpFileParsingResult parse(@NotNull InputStream inputStream, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        try {
            ProfilerDumpFileParsingResult profilerDumpFileParsingResult = this.parse(indicator, true, (Function1<? super MultipleStepsProgressTracker, ? extends IChunkSupplier>)((Function1)arg_0 -> JFRFileParser.parse$lambda$2(inputStream, arg_0)));
            return profilerDumpFileParsingResult;
        }
        finally {
            IOToolkit.closeSilently(inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ProfilerDumpFileParsingResult parse(ProgressIndicator indicator, boolean isCompressed, Function1<? super MultipleStepsProgressTracker, ? extends IChunkSupplier> chunkSupplierProvider) {
        ProfilerDumpFileParsingResult profilerDumpFileParsingResult;
        List list;
        EventArrays events = null;
        List $this$parse_u24lambda_u243 = list = (List)new ArrayList();
        boolean bl = false;
        if (!isCompressed) {
            $this$parse_u24lambda_u243.add(new ReadingJfrProgressStep());
        }
        if (ProfilerDataBuilder.Companion.maybeNeedToResolveNativeSymbols()) {
            $this$parse_u24lambda_u243.add(new ResolvingNativeSymbolsProgressStep());
        }
        $this$parse_u24lambda_u243.add(new BuildingModelProgressStep());
        List progressSteps = list;
        MultipleStepsProgressTracker progressTracker = new MultipleStepsProgressTracker(progressSteps, indicator);
        ProfilerDataBuilder profilerDataBuilder = new ProfilerDataBuilder(this.project, progressTracker);
        try {
            List<IParserExtension> list2 = ParserExtensionRegistry.getParserExtensions();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getParserExtensions(...)");
            List extensions = CollectionsKt.plus((Collection)list2, (Object)profilerDataBuilder);
            events = this.readChunks(extensions, (IChunkSupplier)chunkSupplierProvider.invoke((Object)progressTracker), indicator);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (OutOfMemoryError e) {
            return (ProfilerDumpFileParsingResult)new Failure(UltimateProfilerBundleKt.profilerMessage("jfr.parser.result.failure.memory", new Object[0]));
        }
        catch (Throwable e) {
            if (e instanceof InvalidJfrFileException) {
                return (ProfilerDumpFileParsingResult)new Failure(UtilsKt.explain((Throwable)e, (String)UltimateProfilerBundleKt.profilerMessage("jfr.parser.result.failure.file.invalid.format", new Object[0])));
            }
            JFRDumpParserProviderKt.access$getLOG$p().error(e);
            return (ProfilerDumpFileParsingResult)new Failure(UtilsKt.explain((Throwable)e, (String)UltimateProfilerBundleKt.profilerMessage("jfr.parser.result.failure.cant.parse", new Object[0])));
        }
        progressTracker.checkCanceled();
        try {
            profilerDumpFileParsingResult = (ProfilerDumpFileParsingResult)new Success(profilerDataBuilder.create(new StreamModel(events.getArrays())));
        }
        finally {
            profilerDataBuilder.finish();
        }
        return profilerDumpFileParsingResult;
    }

    private final IChunkSupplier createChunkSupplier(FileChannel fileChannel, List<ByteBufferTrackingWrapper> byteBuffers, ReadingJfrProgressStep progressTracker) {
        ByteBufferTrackingWrapper byteBufferTrackingWrapper;
        long maxChunkSize;
        long size = fileChannel.size();
        if (size <= (maxChunkSize = Integer.MAX_VALUE)) {
            ByteBufferTrackingWrapper byteBufferTrackingWrapper2;
            MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, size);
            Intrinsics.checkNotNullExpressionValue((Object)mappedByteBuffer, (String)"map(...)");
            ByteBufferTrackingWrapper p0 = byteBufferTrackingWrapper2 = ByteBufferTrackingWrapperKt.withTracking(mappedByteBuffer, progressTracker);
            boolean bl = false;
            byteBuffers.add(p0);
            byteBufferTrackingWrapper = byteBufferTrackingWrapper2;
        } else {
            byteBufferTrackingWrapper = null;
        }
        ByteBufferTrackingWrapper singleBuffer = byteBufferTrackingWrapper;
        return new IChunkSupplier(size, singleBuffer, fileChannel, maxChunkSize, progressTracker, byteBuffers){
            private long position;
            final /* synthetic */ long $size;
            final /* synthetic */ ByteBufferTrackingWrapper $singleBuffer;
            final /* synthetic */ FileChannel $fileChannel;
            final /* synthetic */ long $maxChunkSize;
            final /* synthetic */ ReadingJfrProgressStep $progressTracker;
            final /* synthetic */ List<ByteBufferTrackingWrapper> $byteBuffers;
            {
                this.$size = $size;
                this.$singleBuffer = $singleBuffer;
                this.$fileChannel = $fileChannel;
                this.$maxChunkSize = $maxChunkSize;
                this.$progressTracker = $progressTracker;
                this.$byteBuffers = $byteBuffers;
            }

            public final long getPosition() {
                return this.position;
            }

            public final void setPosition(long l) {
                this.position = l;
            }

            public Chunk getNextChunk(byte[] reusableBuffer) throws CouldNotLoadRecordingException, IOException {
                Chunk chunk;
                long chunkSize;
                Intrinsics.checkNotNullParameter((Object)reusableBuffer, (String)"reusableBuffer");
                if (this.position >= this.$size) {
                    return null;
                }
                ByteBufferTrackingWrapper buffer = this.$singleBuffer;
                long start2 = this.position;
                if (this.$singleBuffer == null) {
                    MappedByteBuffer mappedByteBuffer = this.$fileChannel.map(FileChannel.MapMode.READ_ONLY, this.position, RangesKt.coerceAtMost((long)(this.$size - this.position), (long)this.$maxChunkSize));
                    Intrinsics.checkNotNullExpressionValue((Object)mappedByteBuffer, (String)"map(...)");
                    buffer = ByteBufferTrackingWrapperKt.withTracking(mappedByteBuffer, this.$progressTracker);
                    ((Collection)this.$byteBuffers).add(buffer);
                    start2 = 0L;
                }
                if ((chunkSize = FlightRecordingLoader.getChunkInfo(chunk = FlightRecordingLoader.createChunkInput(buffer, (int)start2), this.position).getChunkSize()) == 0L) {
                    throw new InvalidJfrFileException("Empty chunk");
                }
                this.position += chunkSize;
                return chunk;
            }
        };
    }

    @NotNull
    public String getHelpId() {
        return this.helpId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final EventArrays readChunks(List<? extends IParserExtension> extensions, IChunkSupplier chunkSupplier, ProgressIndicator indicator) {
        LoaderContext context2 = new LoaderContext(extensions, indicator){
            final /* synthetic */ ProgressIndicator $indicator;
            {
                this.$indicator = $indicator;
                super($extensions, true);
            }

            public void updateEventStats(String eventTypeName, long size) {
                this.$indicator.checkCanceled();
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                super.updateEventStats(eventTypeName, size);
            }
        };
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"JFR Loader", (int)4);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createBoundedApplicationPoolExecutor(...)");
        ExecutorService threadPool = executorService;
        try {
            List loaders = new ArrayList();
            Set loadedChunkTimestamps = new HashSet();
            while (FlightRecordingLoader.createChunkLoader(chunkSupplier, context2, ArrayUtil.EMPTY_BYTE_ARRAY, true) != null) {
                IChunkLoader chunkLoader;
                if (!loadedChunkTimestamps.add(chunkLoader.getTimestamp())) continue;
                Future future = threadPool.submit(chunkLoader);
                Intrinsics.checkNotNullExpressionValue(future, (String)"submit(...)");
                loaders.add(future);
            }
            if (loaders.isEmpty()) {
                throw new InvalidJfrFileException("No readable chunks in recording");
            }
            Iterable $this$forEach$iv = loaders;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Future it = (Future)element$iv;
                boolean bl = false;
                it.get();
            }
        }
        catch (InterruptedException e) {
            throw new CouldNotLoadRecordingException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Error) {
                throw cause;
            }
            if (cause instanceof RuntimeException) {
                throw cause;
            }
            if (cause instanceof IOException) {
                throw cause;
            }
            if (cause instanceof CouldNotLoadRecordingException) {
                throw cause;
            }
            throw new CouldNotLoadRecordingException(cause);
        }
        finally {
            threadPool.shutdownNow();
            threadPool.awaitTermination(1L, TimeUnit.MINUTES);
        }
        EventArrays eventArrays = context2.buildEventArrays();
        Intrinsics.checkNotNullExpressionValue((Object)eventArrays, (String)"buildEventArrays(...)");
        return eventArrays;
    }

    private static final IChunkSupplier parse$lambda$0(Ref.ObjectRef $fileChannel, JFRFileParser this$0, List $byteBuffers, MultipleStepsProgressTracker progressTracker) {
        Intrinsics.checkNotNullParameter((Object)progressTracker, (String)"progressTracker");
        ProgressTrackerStep progressTrackerStep = progressTracker.switchToStep("ReadingJfrStep", ((FileChannel)$fileChannel.element).size());
        Intrinsics.checkNotNull((Object)progressTrackerStep, (String)"null cannot be cast to non-null type com.intellij.profiler.ultimate.jfr.ReadingJfrProgressStep");
        ReadingJfrProgressStep readingJfrProgress = (ReadingJfrProgressStep)progressTrackerStep;
        Object object = $fileChannel.element;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"element");
        return this$0.createChunkSupplier((FileChannel)object, $byteBuffers, readingJfrProgress);
    }

    private static final IChunkSupplier parse$lambda$2(InputStream $inputStream, MultipleStepsProgressTracker it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        IChunkSupplier iChunkSupplier = FlightRecordingLoader.createChunkSupplier($inputStream);
        Intrinsics.checkNotNullExpressionValue((Object)iChunkSupplier, (String)"createChunkSupplier(...)");
        return iChunkSupplier;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 72\u00020\u0001:\n./01234567B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001e\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010#\u001a\u0004\u0018\u00010\u00172\b\u0010$\u001a\u0004\u0018\u00010\u0017H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&H\u0016J\u0006\u0010(\u001a\u00020)J\u000e\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\f\u001a\u001d\u0012\u0014\u0012\u0012 \u000f*\b\u0018\u00010\u000eR\u00020\u00000\u000eR\u00020\u00000\r\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0015\u001a\u001e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016j\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0018`\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001a\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u0012\u0010\u001c\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/intellij/profiler/ultimate/jfr/JFRFileParser$ProfilerDataBuilder;", "Lorg/openjdk/jmc/flightrecorder/parser/IParserExtension;", "project", "Lcom/intellij/openapi/project/Project;", "progressTracker", "Lcom/intellij/profiler/ultimate/jfr/MultipleStepsProgressTracker;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/profiler/ultimate/jfr/MultipleStepsProgressTracker;)V", "limit", "", "builder", "Lcom/intellij/profiler/ultimate/jfr/JFRProfilerData$Builder;", "limitingSinks", "Lcom/intellij/util/containers/ConcurrentList;", "Lcom/intellij/profiler/ultimate/jfr/JFRFileParser$ProfilerDataBuilder$LimitingEventSink;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "devaluedNativeStacks", "", "isWinAsyncDump", "isJetBrainsRuntime", "unresolvedWinDlls", "Ljava/util/HashMap;", "", "Lcom/intellij/profiler/ultimate/jfr/DllDebugInfo;", "Lkotlin/collections/HashMap;", "intervalFromIntervalFieldMs", "Ljava/lang/Integer;", "usedWallSamplingIntervalMs", "samplingMode", "recordingStartTimeMs", "", "hasFakeNativeEvents", "getValueInterpretation", "", "eventTypeId", "fieldId", "getEventSinkFactory", "Lorg/openjdk/jmc/flightrecorder/parser/IEventSinkFactory;", "subFactory", "finish", "", "create", "Lcom/intellij/profiler/api/ProfilerData;", "model", "Lcom/intellij/profiler/ultimate/jfr/jmc/StreamModel;", "LimitingEventSink", "BaseSink", "WinAsyncDetectorSink", "JetBrainsRuntimeVendorDetectorSink", "JetBrainsRuntimeWindowsNativeSymbolsSink", "ActiveRecordingSink", "RecordingStartSink", "NoCStackDetectorSink", "WallClockIntervalDetectorSink", "Companion", "intellij.profiler.ultimate"})
    @SourceDebugExtension(value={"SMAP\nJFRDumpParserProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JFRDumpParserProvider.kt\ncom/intellij/profiler/ultimate/jfr/JFRFileParser$ProfilerDataBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Grouping.kt\nkotlin/collections/GroupingKt__GroupingKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,473:1\n1550#2:474\n164#3:475\n53#3:476\n80#3,6:477\n216#4,2:483\n*S KotlinDebug\n*F\n+ 1 JFRDumpParserProvider.kt\ncom/intellij/profiler/ultimate/jfr/JFRFileParser$ProfilerDataBuilder\n*L\n382#1:474\n382#1:475\n382#1:476\n382#1:477,6\n386#1:483,2\n*E\n"})
    public static final class ProfilerDataBuilder
    implements IParserExtension {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final MultipleStepsProgressTracker progressTracker;
        private final int limit;
        @NotNull
        private final JFRProfilerData.Builder builder;
        @NotNull
        private final ConcurrentList<LimitingEventSink> limitingSinks;
        private boolean devaluedNativeStacks;
        private boolean isWinAsyncDump;
        private boolean isJetBrainsRuntime;
        @NotNull
        private final HashMap<String, DllDebugInfo> unresolvedWinDlls;
        @Nullable
        private Integer intervalFromIntervalFieldMs;
        @Nullable
        private Integer usedWallSamplingIntervalMs;
        @Nullable
        private String samplingMode;
        private long recordingStartTimeMs;
        private boolean hasFakeNativeEvents;
        @NotNull
        private static final String WIN_ASYNC_MARKER = "win-async-profiler";
        @NotNull
        private static final String JAVA_VM_VENDOR = "java.vm.vendor";
        @NotNull
        private static final String JETBRAINS_RUNTIME_VENDOR = "JetBrains s.r.o.";
        @NotNull
        private static final String WIN_NATIVE_SYMBOL_INFO_ID = "profiler.Windows.NativeSymbols.DbgInfo";

        public ProfilerDataBuilder(@Nullable Project project, @NotNull MultipleStepsProgressTracker progressTracker) {
            Intrinsics.checkNotNullParameter((Object)progressTracker, (String)"progressTracker");
            this.progressTracker = progressTracker;
            this.limit = Registry.Companion.intValue("idea.profiler.jfr.max.events.of.type.per.chunk", 10000);
            this.builder = new JFRProfilerData.Builder(project);
            ConcurrentList concurrentList = ContainerUtil.createConcurrentList();
            Intrinsics.checkNotNullExpressionValue((Object)concurrentList, (String)"createConcurrentList(...)");
            this.limitingSinks = concurrentList;
            this.unresolvedWinDlls = new HashMap();
            this.recordingStartTimeMs = Long.MAX_VALUE;
        }

        @Nullable
        public Void getValueInterpretation(@Nullable String eventTypeId, @Nullable String fieldId) {
            return null;
        }

        @Override
        @NotNull
        public IEventSinkFactory getEventSinkFactory(@NotNull IEventSinkFactory subFactory) {
            Intrinsics.checkNotNullParameter((Object)subFactory, (String)"subFactory");
            return new IEventSinkFactory(subFactory, this){
                private final /* synthetic */ IEventSinkFactory $$delegate_0;
                final /* synthetic */ IEventSinkFactory $subFactory;
                final /* synthetic */ ProfilerDataBuilder this$0;
                {
                    this.$subFactory = $subFactory;
                    this.this$0 = $receiver;
                    this.$$delegate_0 = $subFactory;
                }

                public IEventSink create(String identifier, String label2, String[] category, String description, List<ValueField> dataStructure) {
                    String string;
                    IEventSink sink = this.$subFactory.create(identifier, label2, category, description, dataStructure);
                    JfrEvent knownEvent = JfrEvent.Companion.fromIdentifier(identifier);
                    if (knownEvent != null) {
                        ProfilerDataBuilder.access$getBuilder$p(this.this$0).setDataStructure(knownEvent, dataStructure);
                        PossiblyUnknownJfrEvent possiblyUnknownJfrEvent = new PossiblyUnknownJfrEvent.Known(knownEvent);
                        Intrinsics.checkNotNull((Object)sink);
                        LimitingEventSink limitingEventSink = this.this$0.new LimitingEventSink(possiblyUnknownJfrEvent, sink);
                        ProfilerDataBuilder profilerDataBuilder = this.this$0;
                        LimitingEventSink it = limitingEventSink;
                        boolean bl = false;
                        ProfilerDataBuilder.access$getLimitingSinks$p(profilerDataBuilder).add((Object)it);
                        return limitingEventSink;
                    }
                    if (dataStructure != null) {
                        if (Intrinsics.areEqual((Object)"jdk.ActiveRecording", (Object)identifier)) {
                            Intrinsics.checkNotNull((Object)sink);
                            return this.this$0.new WinAsyncDetectorSink(sink, dataStructure);
                        }
                        if (Intrinsics.areEqual((Object)"jdk.ActiveSetting", (Object)identifier)) {
                            Intrinsics.checkNotNull((Object)sink);
                            return this.this$0.new RecordingStartSink(this.this$0.new NoCStackDetectorSink(this.this$0.new WallClockIntervalDetectorSink(sink, dataStructure), dataStructure), dataStructure);
                        }
                        if (Intrinsics.areEqual((Object)"jdk.InitialSystemProperty", (Object)identifier)) {
                            Intrinsics.checkNotNull((Object)sink);
                            return this.this$0.new JetBrainsRuntimeVendorDetectorSink(sink, dataStructure);
                        }
                        if (Intrinsics.areEqual((Object)"profiler.Windows.NativeSymbols.DbgInfo", (Object)identifier)) {
                            Intrinsics.checkNotNull((Object)sink);
                            return this.this$0.new JetBrainsRuntimeWindowsNativeSymbolsSink(sink, dataStructure);
                        }
                        if (Intrinsics.areEqual((Object)"jdk.CPULoad", (Object)identifier) || this.isSupportedGCEvent(identifier)) {
                            Intrinsics.checkNotNull((Object)sink);
                            return sink;
                        }
                    }
                    if ((string = identifier) == null) {
                        string = "";
                    }
                    PossiblyUnknownJfrEvent possiblyUnknownJfrEvent = new PossiblyUnknownJfrEvent.Unknown(string);
                    Intrinsics.checkNotNull((Object)sink);
                    LimitingEventSink limitingEventSink = this.this$0.new LimitingEventSink(possiblyUnknownJfrEvent, sink);
                    ProfilerDataBuilder profilerDataBuilder = this.this$0;
                    LimitingEventSink it = limitingEventSink;
                    boolean bl = false;
                    ProfilerDataBuilder.access$getLimitingSinks$p(profilerDataBuilder).add((Object)it);
                    return limitingEventSink;
                }

                private final boolean isSupportedGCEvent(String identifier) {
                    return Intrinsics.areEqual((Object)identifier, (Object)CustomJfrIdentifier.INSTANCE.getGC_HEAP_MEMORY_USAGE()) || Intrinsics.areEqual((Object)identifier, (Object)CustomJfrIdentifier.INSTANCE.getG1_HEAP_SUMMARY()) || Intrinsics.areEqual((Object)identifier, (Object)"jdk.GCHeapSummary");
                }

                public void flush() {
                    this.$$delegate_0.flush();
                }
            };
        }

        public final void finish() {
            this.progressTracker.stop();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ProfilerData create(@NotNull StreamModel model2) {
            Integer n;
            void destination$iv$iv$iv;
            void $this$aggregateTo$iv$iv$iv;
            StreamModel $this$fold$iv;
            Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
            Iterable $this$groupingBy$iv = (Iterable)this.limitingSinks;
            boolean $i$f$groupingBy = false;
            $this$groupingBy$iv = (Grouping)new Grouping<LimitingEventSink, PossiblyUnknownJfrEvent>($this$groupingBy$iv){
                final /* synthetic */ Iterable $this_groupingBy;
                {
                    this.$this_groupingBy = $receiver;
                }

                public Iterator<LimitingEventSink> sourceIterator() {
                    return this.$this_groupingBy.iterator();
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public Object keyOf(Object element) {
                    LimitingEventSink it = (LimitingEventSink)element;
                    boolean bl = false;
                    return it.getEvent();
                }
            };
            Long initialValue$iv = 0L;
            boolean $i$f$fold = false;
            void $this$aggregate$iv$iv = $this$fold$iv;
            boolean $i$f$aggregate = false;
            Iterator iterator2 = $this$aggregate$iv$iv;
            Map map2 = new LinkedHashMap();
            boolean $i$f$aggregateTo = false;
            Iterator iterator3 = $this$aggregateTo$iv$iv$iv.sourceIterator();
            while (iterator3.hasNext()) {
                void element;
                void acc$iv;
                void first$iv;
                void e$iv;
                Object e$iv$iv$iv = iterator3.next();
                Object key$iv$iv$iv = $this$aggregateTo$iv$iv$iv.keyOf(e$iv$iv$iv);
                Object accumulator$iv$iv$iv = destination$iv$iv$iv.get(key$iv$iv$iv);
                boolean bl = accumulator$iv$iv$iv == null && !destination$iv$iv$iv.containsKey(key$iv$iv$iv);
                Object e = e$iv$iv$iv;
                Object v = accumulator$iv$iv$iv;
                Object object = key$iv$iv$iv;
                void var19_22 = destination$iv$iv$iv;
                boolean bl2 = false;
                LimitingEventSink limitingEventSink = (LimitingEventSink)e$iv;
                long accumulator = ((Number)(first$iv != false ? initialValue$iv : acc$iv)).longValue();
                boolean bl3 = false;
                Long l = accumulator + element.getSize();
                var19_22.put(object, l);
            }
            void realCount = destination$iv$iv$iv;
            StreamModel $this$create_u24lambda_u242 = $this$fold$iv = model2;
            boolean bl = false;
            void $this$forEach$iv = realCount;
            boolean $i$f$forEach = false;
            iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator2.next();
                boolean bl4 = false;
                PossiblyUnknownJfrEvent event = (PossiblyUnknownJfrEvent)entry.getKey();
                long count = ((Number)entry.getValue()).longValue();
                $this$create_u24lambda_u242.setRealEventCount(event.getIdentifier(), count);
            }
            if (Intrinsics.areEqual((Object)this.samplingMode, (Object)"wall")) {
                n = this.usedWallSamplingIntervalMs;
                if (n == null) {
                    n = this.intervalFromIntervalFieldMs;
                }
            } else {
                n = null;
            }
            Integer wallClockInterval = n;
            Collection<DllDebugInfo> collection = this.unresolvedWinDlls.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            JfrContentsDescriptor contentsDescriptor = new JfrContentsDescriptor(this.devaluedNativeStacks, this.isWinAsyncDump, this.isJetBrainsRuntime, wallClockInterval, this.hasFakeNativeEvents, this.recordingStartTimeMs, CollectionsKt.toList((Iterable)collection));
            return this.builder.create$intellij_profiler_ultimate(model2, this.progressTracker, contentsDescriptor);
        }

        public static final /* synthetic */ ConcurrentList access$getLimitingSinks$p(ProfilerDataBuilder $this) {
            return $this.limitingSinks;
        }

        public static final /* synthetic */ HashMap access$getUnresolvedWinDlls$p(ProfilerDataBuilder $this) {
            return $this.unresolvedWinDlls;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00a2\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u001b\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H&\u00a8\u0006\u0014"}, d2={"Lcom/intellij/profiler/ultimate/jfr/JFRFileParser$ProfilerDataBuilder$ActiveRecordingSink;", "Lcom/intellij/profiler/ultimate/jfr/JFRFileParser$ProfilerDataBuilder$BaseSink;", "Lcom/intellij/profiler/ultimate/jfr/JFRFileParser$ProfilerDataBuilder;", "sink", "Lorg/openjdk/jmc/flightrecorder/parser/IEventSink;", "dataStructure", "", "Lorg/openjdk/jmc/flightrecorder/parser/ValueField;", "<init>", "(Lcom/intellij/profiler/ultimate/jfr/JFRFileParser$ProfilerDataBuilder;Lorg/openjdk/jmc/flightrecorder/parser/IEventSink;Ljava/util/List;)V", "processEvent", "", "values", "", "", "([Ljava/lang/Object;)V", "doProcessEvent", "name", "", "value", "intellij.profiler.ultimate"})
        private abstract class ActiveRecordingSink
        extends BaseSink {
            public ActiveRecordingSink(@NotNull IEventSink sink, List<ValueField> dataStructure) {
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                Intrinsics.checkNotNullParameter(dataStructure, (String)"dataStructure");
                super(sink, dataStructure);
            }

            @Override
            public final void processEvent(@NotNull Object[] values) {
                Intrinsics.checkNotNullParameter((Object)values, (String)"values");
                String string = this.getStringField("Setting Name", values);
                if (string == null) {
                    return;
                }
                String name = string;
                String string2 = this.getStringField("Setting Value", values);
                if (string2 == null) {
                    return;
                }
                String value = string2;
                this.doProcessEvent(name, value);
            }

            public abstract void doProcessEvent(@NotNull String var1, @NotNull String var2);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0005\b\u00a2\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001f\u0010\f\u001a\u00020\r2\u0010\u0010\u000e\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0010\u0018\u00010\u000fH\u0016\u00a2\u0006\u0002\u0010\u0011J\u001d\u0010\u0012\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000fH&\u00a2\u0006\u0002\u0010\u0011J\u0017\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a2\u0006\u0002\u0010\u0017J%\u0010\u0018\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0015\u001a\u00020\u00162\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f\u00a2\u0006\u0002\u0010\u0019J%\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0015\u001a\u00020\u00162\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f\u00a2\u0006\u0002\u0010\u001cJ0\u0010\u001d\u001a\u0004\u0018\u0001H\u001e\"\u0006\b\u0000\u0010\u001e\u0018\u00012\u0006\u0010\u0015\u001a\u00020\u00162\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000fH\u0086\b\u00a2\u0006\u0002\u0010\u001fR\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006 "}, d2={"Lcom/intellij/profiler/ultimate/jfr/JFRFileParser$ProfilerDataBuilder$BaseSink;", "Lorg/openjdk/jmc/flightrecorder/parser/IEventSink;", "sink", "dataStructure", "", "Lorg/openjdk/jmc/flightrecorder/parser/ValueField;", "<init>", "(Lcom/intellij/profiler/ultimate/jfr/JFRFileParser$ProfilerDataBuilder;Lorg/openjdk/jmc/flightrecorder/parser/IEventSink;Ljava/util/List;)V", "getSink", "()Lorg/openjdk/jmc/flightrecorder/parser/IEventSink;", "getDataStructure", "()Ljava/util/List;", "addEvent", "", "values", "", "", "([Ljava/lang/Object;)V", "processEvent", "getFieldId", "", "fieldName", "", "(Ljava/lang/String;)Ljava/lang/Integer;", "getStringField", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "getLongField", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/Long;", "getField", "T", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/Object;", "intellij.profiler.ultimate"})
        @SourceDebugExtension(value={"SMAP\nJFRDumpParserProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JFRDumpParserProvider.kt\ncom/intellij/profiler/ultimate/jfr/JFRFileParser$ProfilerDataBuilder$BaseSink\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,473:1\n280#1,2:482\n280#1,2:484\n360#2,7:474\n1#3:481\n*S KotlinDebug\n*F\n+ 1 JFRDumpParserProvider.kt\ncom/intellij/profiler/ultimate/jfr/JFRFileParser$ProfilerDataBuilder$BaseSink\n*L\n277#1:482,2\n278#1:484,2\n276#1:474,7\n*E\n"})
        private abstract class BaseSink
        implements IEventSink {
            @NotNull
            private final IEventSink sink;
            @NotNull
            private final List<ValueField> dataStructure;

            public BaseSink(@NotNull IEventSink sink, List<ValueField> dataStructure) {
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                Intrinsics.checkNotNullParameter(dataStructure, (String)"dataStructure");
                this.sink = sink;
                this.dataStructure = dataStructure;
            }

            @NotNull
            public final IEventSink getSink() {
                return this.sink;
            }

            @NotNull
            public final List<ValueField> getDataStructure() {
                return this.dataStructure;
            }

            @Override
            public void addEvent(@Nullable Object[] values) {
                this.sink.addEvent(values);
                if (values != null) {
                    this.processEvent(values);
                }
            }

            public abstract void processEvent(@NotNull Object[] var1);

            private final Integer getFieldId(String fieldName) {
                int n;
                block2: {
                    List<ValueField> $this$indexOfFirst$iv = this.dataStructure;
                    boolean $i$f$indexOfFirst = false;
                    int index$iv = 0;
                    Iterator<ValueField> iterator2 = $this$indexOfFirst$iv.iterator();
                    while (iterator2.hasNext()) {
                        ValueField item$iv;
                        ValueField it = item$iv = iterator2.next();
                        boolean bl = false;
                        if (Intrinsics.areEqual((Object)it.getName(), (Object)fieldName)) {
                            n = index$iv;
                            break block2;
                        }
                        ++index$iv;
                    }
                    n = -1;
                }
                Integer n2 = n;
                int it = ((Number)n2).intValue();
                boolean bl = false;
                return it >= 0 ? n2 : null;
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final String getStringField(@NotNull String fieldName, @NotNull Object[] values) {
                String string;
                void fieldName$iv;
                void this_$iv;
                Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
                Intrinsics.checkNotNullParameter((Object)values, (String)"values");
                BaseSink baseSink = this;
                String string2 = fieldName;
                Object[] values$iv = values;
                boolean $i$f$getField = false;
                Integer n = ((BaseSink)this_$iv).getFieldId((String)fieldName$iv);
                if (n == null) {
                    string = null;
                } else {
                    int idx$iv = n;
                    Object object = values$iv[idx$iv];
                    if (!(object instanceof String)) {
                        object = null;
                    }
                    string = (String)object;
                }
                return string;
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Long getLongField(@NotNull String fieldName, @NotNull Object[] values) {
                IQuantity iQuantity;
                void fieldName$iv;
                void this_$iv;
                Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
                Intrinsics.checkNotNullParameter((Object)values, (String)"values");
                BaseSink baseSink = this;
                String string = fieldName;
                Object[] values$iv = values;
                boolean $i$f$getField = false;
                Integer n = ((BaseSink)this_$iv).getFieldId((String)fieldName$iv);
                if (n == null) {
                    iQuantity = null;
                } else {
                    int idx$iv = n;
                    Object object = values$iv[idx$iv];
                    if (!(object instanceof IQuantity)) {
                        object = null;
                    }
                    iQuantity = (IQuantity)object;
                }
                return iQuantity != null ? Long.valueOf(iQuantity.longValue()) : null;
            }

            public final /* synthetic */ <T> T getField(String fieldName, Object[] values) {
                Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
                Intrinsics.checkNotNullParameter((Object)values, (String)"values");
                boolean $i$f$getField = false;
                Integer n = this.getFieldId(fieldName);
                if (n == null) {
                    return null;
                }
                int idx = n;
                Object object = values[idx];
                Intrinsics.reifiedOperationMarker((int)2, (String)"T");
                return (T)object;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/profiler/ultimate/jfr/JFRFileParser$ProfilerDataBuilder$Companion;", "", "<init>", "()V", "maybeNeedToResolveNativeSymbols", "", "WIN_ASYNC_MARKER", "", "JAVA_VM_VENDOR", "JETBRAINS_RUNTIME_VENDOR", "WIN_NATIVE_SYMBOL_INFO_ID", "intellij.profiler.ultimate"})
        public static final class Companion {
            private Companion() {
            }

            public final boolean maybeNeedToResolveNativeSymbols() {
                return SystemInfo.isWindows;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\rH\u0016\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/profiler/ultimate/jfr/JFRFileParser$ProfilerDataBuilder$JetBrainsRuntimeVendorDetectorSink;", "Lcom/intellij/profiler/ultimate/jfr/JFRFileParser$ProfilerDataBuilder$BaseSink;", "Lcom/intellij/profiler/ultimate/jfr/JFRFileParser$ProfilerDataBuilder;", "sink", "Lorg/openjdk/jmc/flightrecorder/parser/IEventSink;", "dataStructure", "", "Lorg/openjdk/jmc/flightrecorder/parser/ValueField;", "<init>", "(Lcom/intellij/profiler/ultimate/jfr/JFRFileParser$ProfilerDataBuilder;Lorg/openjdk/jmc/flightrecorder/parser/IEventSink;Ljava/util/List;)V", "processEvent", "", "values", "", "", "([Ljava/lang/Object;)V", "intellij.profiler.ultimate"})
        private final class JetBrainsRuntimeVendorDetectorSink
        extends BaseSink {
            public JetBrainsRuntimeVendorDetectorSink(@NotNull IEventSink sink, List<ValueField> dataStructure) {
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                Intrinsics.checkNotNullParameter(dataStructure, (String)"dataStructure");
                super(sink, dataStructure);
            }

            @Override
            public void processEvent(@NotNull Object[] values) {
                Intrinsics.checkNotNullParameter((Object)values, (String)"values");
                String string = this.getStringField("Key", values);
                if (string == null) {
                    return;
                }
                String keyField = string;
                String string2 = this.getStringField("Value", values);
                if (string2 == null) {
                    return;
                }
                String valueField = string2;
                if (Intrinsics.areEqual((Object)keyField, (Object)ProfilerDataBuilder.JAVA_VM_VENDOR) && Intrinsics.areEqual((Object)valueField, (Object)ProfilerDataBuilder.JETBRAINS_RUNTIME_VENDOR)) {
                    ProfilerDataBuilder.this.isJetBrainsRuntime = true;
                }
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\rH\u0016\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/profiler/ultimate/jfr/JFRFileParser$ProfilerDataBuilder$JetBrainsRuntimeWindowsNativeSymbolsSink;", "Lcom/intellij/profiler/ultimate/jfr/JFRFileParser$ProfilerDataBuilder$BaseSink;", "Lcom/intellij/profiler/ultimate/jfr/JFRFileParser$ProfilerDataBuilder;", "sink", "Lorg/openjdk/jmc/flightrecorder/parser/IEventSink;", "dataStructure", "", "Lorg/openjdk/jmc/flightrecorder/parser/ValueField;", "<init>", "(Lcom/intellij/profiler/ultimate/jfr/JFRFileParser$ProfilerDataBuilder;Lorg/openjdk/jmc/flightrecorder/parser/IEventSink;Ljava/util/List;)V", "processEvent", "", "values", "", "", "([Ljava/lang/Object;)V", "intellij.profiler.ultimate"})
        @SourceDebugExtension(value={"SMAP\nJFRDumpParserProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JFRDumpParserProvider.kt\ncom/intellij/profiler/ultimate/jfr/JFRFileParser$ProfilerDataBuilder$JetBrainsRuntimeWindowsNativeSymbolsSink\n+ 2 JFRDumpParserProvider.kt\ncom/intellij/profiler/ultimate/jfr/JFRFileParser$ProfilerDataBuilder$BaseSink\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,473:1\n280#2,2:474\n1#3:476\n12767#4,2:477\n11561#4:479\n11896#4,3:480\n*S KotlinDebug\n*F\n+ 1 JFRDumpParserProvider.kt\ncom/intellij/profiler/ultimate/jfr/JFRFileParser$ProfilerDataBuilder$JetBrainsRuntimeWindowsNativeSymbolsSink\n*L\n312#1:474,2\n313#1:477,2\n314#1:479\n314#1:480,3\n*E\n"})
        private final class JetBrainsRuntimeWindowsNativeSymbolsSink
        extends BaseSink {
            public JetBrainsRuntimeWindowsNativeSymbolsSink(@NotNull IEventSink sink, List<ValueField> dataStructure) {
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                Intrinsics.checkNotNullParameter(dataStructure, (String)"dataStructure");
                super(sink, dataStructure);
            }

            /*
             * Unable to fully structure code
             */
            @Override
            public void processEvent(@NotNull Object[] values) {
                block10: {
                    Intrinsics.checkNotNullParameter((Object)values, (String)"values");
                    v0 = this.getStringField("Module path", values);
                    if (v0 == null) {
                        return;
                    }
                    dllPath = v0;
                    if (((Map)ProfilerDataBuilder.access$getUnresolvedWinDlls$p(ProfilerDataBuilder.this)).containsKey(dllPath) || ((CharSequence)dllPath).length() == 0) {
                        return;
                    }
                    v1 = this.getLongField("Size of module", values);
                    if (v1 == null) {
                        return;
                    }
                    size = v1;
                    var7_4 = this;
                    var8_5 = "Debug Info";
                    values$iv = values;
                    $i$f$getField = false;
                    v2 = BaseSink.access$getFieldId((BaseSink)this_$iv, (String)fieldName$iv);
                    if (v2 == null) {
                        v3 = null;
                    } else {
                        idx$iv = v2;
                        v4 = values$iv[idx$iv];
                        if (!(v4 instanceof Object[])) {
                            v4 = null;
                        }
                        v3 = var6_10 = (Object[])v4;
                    }
                    if (var6_10 == null) ** GOTO lbl-1000
                    var8_5 = var6_10;
                    array = var8_5;
                    $i$a$-takeIf-JFRFileParser$ProfilerDataBuilder$JetBrainsRuntimeWindowsNativeSymbolsSink$processEvent$dbgInfo$1 = false;
                    $this$all$iv = array;
                    $i$f$all = false;
                    var14_14 = ((String)$this$all$iv).length;
                    for (var13_13 = 0; var13_13 < var14_14; ++var13_13) {
                        it = element$iv = $this$all$iv[var13_13];
                        $i$a$-all-JFRFileParser$ProfilerDataBuilder$JetBrainsRuntimeWindowsNativeSymbolsSink$processEvent$dbgInfo$1$1 = false;
                        if (it instanceof IQuantity) continue;
                        v5 = false;
                        break block10;
                    }
                    v5 = true;
                }
                v6 = var7_4 = v5 != false ? var8_5 : null;
                if (var7_4 == null) ** GOTO lbl-1000
                array = var7_4;
                $i$f$map = false;
                $this$all$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(((void)$this$map$iv).length);
                $i$f$mapTo = false;
                var15_16 = ((void)$this$mapTo$iv$iv).length;
                for (var14_14 = 0; var14_14 < var15_16; ++var14_14) {
                    $i$a$-all-JFRFileParser$ProfilerDataBuilder$JetBrainsRuntimeWindowsNativeSymbolsSink$processEvent$dbgInfo$1$1 = item$iv$iv = $this$mapTo$iv$iv[var14_14];
                    var19_21 = destination$iv$iv;
                    $i$a$-map-JFRFileParser$ProfilerDataBuilder$JetBrainsRuntimeWindowsNativeSymbolsSink$processEvent$dbgInfo$2 = false;
                    Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.openjdk.jmc.common.unit.IQuantity");
                    var19_21.add(((IQuantity)it).numberValue().byteValue());
                }
                var9_6 = CollectionsKt.toByteArray((Collection)((List)destination$iv$iv));
                if (var9_6 != null) {
                    v7 = var9_6;
                } else lbl-1000:
                // 3 sources

                {
                    v7 = new byte[]{};
                }
                dbgInfo = v7;
                ((Map)ProfilerDataBuilder.access$getUnresolvedWinDlls$p(ProfilerDataBuilder.this)).put(dllPath, new DllDebugInfo(dllPath, size, dbgInfo));
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001d\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0011H\u0016\u00a2\u0006\u0002\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/intellij/profiler/ultimate/jfr/JFRFileParser$ProfilerDataBuilder$LimitingEventSink;", "Lorg/openjdk/jmc/flightrecorder/parser/IEventSink;", "event", "Lcom/intellij/profiler/ultimate/jfr/events/PossiblyUnknownJfrEvent;", "sink", "<init>", "(Lcom/intellij/profiler/ultimate/jfr/JFRFileParser$ProfilerDataBuilder;Lcom/intellij/profiler/ultimate/jfr/events/PossiblyUnknownJfrEvent;Lorg/openjdk/jmc/flightrecorder/parser/IEventSink;)V", "getEvent", "()Lcom/intellij/profiler/ultimate/jfr/events/PossiblyUnknownJfrEvent;", "value", "", "size", "getSize", "()J", "addEvent", "", "values", "", "", "([Ljava/lang/Object;)V", "intellij.profiler.ultimate"})
        private final class LimitingEventSink
        implements IEventSink {
            @NotNull
            private final PossiblyUnknownJfrEvent event;
            @NotNull
            private final IEventSink sink;
            private long size;

            public LimitingEventSink(@NotNull PossiblyUnknownJfrEvent event, IEventSink sink) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                this.event = event;
                this.sink = sink;
            }

            @NotNull
            public final PossiblyUnknownJfrEvent getEvent() {
                return this.event;
            }

            public final long getSize() {
                return this.size;
            }

            @Override
            public void addEvent(@NotNull Object[] values) {
                Intrinsics.checkNotNullParameter((Object)values, (String)"values");
                if (this.event instanceof PossiblyUnknownJfrEvent.Known) {
                    ProfilerDataBuilder.this.builder.addEvent(((PossiblyUnknownJfrEvent.Known)this.event).getJfrEvent(), values);
                }
                if (this.size < (long)ProfilerDataBuilder.this.limit) {
                    this.sink.addEvent(values);
                }
                long l = this.size;
                this.size = l + 1L;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/profiler/ultimate/jfr/JFRFileParser$ProfilerDataBuilder$NoCStackDetectorSink;", "Lcom/intellij/profiler/ultimate/jfr/JFRFileParser$ProfilerDataBuilder$ActiveRecordingSink;", "Lcom/intellij/profiler/ultimate/jfr/JFRFileParser$ProfilerDataBuilder;", "sink", "Lorg/openjdk/jmc/flightrecorder/parser/IEventSink;", "dataStructure", "", "Lorg/openjdk/jmc/flightrecorder/parser/ValueField;", "<init>", "(Lcom/intellij/profiler/ultimate/jfr/JFRFileParser$ProfilerDataBuilder;Lorg/openjdk/jmc/flightrecorder/parser/IEventSink;Ljava/util/List;)V", "doProcessEvent", "", "name", "", "value", "intellij.profiler.ultimate"})
        private final class NoCStackDetectorSink
        extends ActiveRecordingSink {
            public NoCStackDetectorSink(@NotNull IEventSink sink, List<ValueField> dataStructure) {
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                Intrinsics.checkNotNullParameter(dataStructure, (String)"dataStructure");
                super(sink, dataStructure);
            }

            @Override
            public void doProcessEvent(@NotNull String name, @NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                if (Intrinsics.areEqual((Object)name, (Object)"cstack") && Intrinsics.areEqual((Object)value, (Object)"no")) {
                    ProfilerDataBuilder.this.devaluedNativeStacks = true;
                }
                if (Intrinsics.areEqual((Object)name, (Object)"keepFakeEventsCStackNo") && Intrinsics.areEqual((Object)value, (Object)"true")) {
                    ProfilerDataBuilder.this.hasFakeNativeEvents = true;
                }
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\r\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0010H\u0016\u00a2\u0006\u0002\u0010\u0012R\u0018\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/profiler/ultimate/jfr/JFRFileParser$ProfilerDataBuilder$RecordingStartSink;", "Lcom/intellij/profiler/ultimate/jfr/JFRFileParser$ProfilerDataBuilder$BaseSink;", "Lcom/intellij/profiler/ultimate/jfr/JFRFileParser$ProfilerDataBuilder;", "sink", "Lorg/openjdk/jmc/flightrecorder/parser/IEventSink;", "dataStructure", "", "Lorg/openjdk/jmc/flightrecorder/parser/ValueField;", "<init>", "(Lcom/intellij/profiler/ultimate/jfr/JFRFileParser$ProfilerDataBuilder;Lorg/openjdk/jmc/flightrecorder/parser/IEventSink;Ljava/util/List;)V", "accessor", "Lcom/intellij/profiler/ultimate/jfr/events/JfrEventTypesBuilder$DataStructureAccessor;", "Lorg/openjdk/jmc/common/unit/ITypedQuantity;", "processEvent", "", "values", "", "", "([Ljava/lang/Object;)V", "intellij.profiler.ultimate"})
        private final class RecordingStartSink
        extends BaseSink {
            @NotNull
            private final JfrEventTypesBuilder.DataStructureAccessor<ITypedQuantity<?>> accessor;

            public RecordingStartSink(@NotNull IEventSink sink, List<ValueField> dataStructure) {
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                Intrinsics.checkNotNullParameter(dataStructure, (String)"dataStructure");
                super(sink, dataStructure);
                this.accessor = new JfrEventTypesBuilder.DataStructureAccessor<ITypedQuantity>(ITypedQuantity.class, dataStructure, CollectionsKt.listOf(RecordingStartSink::accessor$lambda$0));
            }

            @Override
            public void processEvent(@NotNull Object[] values) {
                Intrinsics.checkNotNullParameter((Object)values, (String)"values");
                ITypedQuantity<?> iTypedQuantity = this.accessor.get(values);
                if (iTypedQuantity == null) {
                    return;
                }
                long startTime = iTypedQuantity.clampedLongValueIn(UnitLookup.EPOCH_MS);
                ProfilerDataBuilder.this.recordingStartTimeMs = Math.min(ProfilerDataBuilder.this.recordingStartTimeMs, startTime);
            }

            private static final boolean accessor$lambda$0(ValueField it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.matches(JfrAttributes.START_TIME);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0017\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/profiler/ultimate/jfr/JFRFileParser$ProfilerDataBuilder$WallClockIntervalDetectorSink;", "Lcom/intellij/profiler/ultimate/jfr/JFRFileParser$ProfilerDataBuilder$ActiveRecordingSink;", "Lcom/intellij/profiler/ultimate/jfr/JFRFileParser$ProfilerDataBuilder;", "sink", "Lorg/openjdk/jmc/flightrecorder/parser/IEventSink;", "dataStructure", "", "Lorg/openjdk/jmc/flightrecorder/parser/ValueField;", "<init>", "(Lcom/intellij/profiler/ultimate/jfr/JFRFileParser$ProfilerDataBuilder;Lorg/openjdk/jmc/flightrecorder/parser/IEventSink;Ljava/util/List;)V", "doProcessEvent", "", "name", "", "value", "valueToMs", "", "(Ljava/lang/String;)Ljava/lang/Integer;", "intellij.profiler.ultimate"})
        private final class WallClockIntervalDetectorSink
        extends ActiveRecordingSink {
            public WallClockIntervalDetectorSink(@NotNull IEventSink sink, List<ValueField> dataStructure) {
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                Intrinsics.checkNotNullParameter(dataStructure, (String)"dataStructure");
                super(sink, dataStructure);
            }

            @Override
            public void doProcessEvent(@NotNull String name, @NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                if (ProfilerDataBuilder.this.samplingMode == null && Intrinsics.areEqual((Object)name, (Object)"event")) {
                    ProfilerDataBuilder.this.samplingMode = value;
                }
                if (ProfilerDataBuilder.this.intervalFromIntervalFieldMs == null && Intrinsics.areEqual((Object)name, (Object)"interval")) {
                    ProfilerDataBuilder.this.intervalFromIntervalFieldMs = this.valueToMs(value);
                }
                if (ProfilerDataBuilder.this.usedWallSamplingIntervalMs == null && Intrinsics.areEqual((Object)name, (Object)"usedWallInterval")) {
                    ProfilerDataBuilder.this.usedWallSamplingIntervalMs = this.valueToMs(value);
                }
            }

            private final Integer valueToMs(String value) {
                Integer n = StringsKt.toIntOrNull((String)value);
                int intValue = (n != null ? n : 0) / 1000000;
                if (intValue != 0) {
                    return intValue;
                }
                return null;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\rH\u0016\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/profiler/ultimate/jfr/JFRFileParser$ProfilerDataBuilder$WinAsyncDetectorSink;", "Lcom/intellij/profiler/ultimate/jfr/JFRFileParser$ProfilerDataBuilder$BaseSink;", "Lcom/intellij/profiler/ultimate/jfr/JFRFileParser$ProfilerDataBuilder;", "sink", "Lorg/openjdk/jmc/flightrecorder/parser/IEventSink;", "dataStructure", "", "Lorg/openjdk/jmc/flightrecorder/parser/ValueField;", "<init>", "(Lcom/intellij/profiler/ultimate/jfr/JFRFileParser$ProfilerDataBuilder;Lorg/openjdk/jmc/flightrecorder/parser/IEventSink;Ljava/util/List;)V", "processEvent", "", "values", "", "", "([Ljava/lang/Object;)V", "intellij.profiler.ultimate"})
        private final class WinAsyncDetectorSink
        extends BaseSink {
            public WinAsyncDetectorSink(@NotNull IEventSink sink, List<ValueField> dataStructure) {
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                Intrinsics.checkNotNullParameter(dataStructure, (String)"dataStructure");
                super(sink, dataStructure);
            }

            @Override
            public void processEvent(@NotNull Object[] values) {
                Intrinsics.checkNotNullParameter((Object)values, (String)"values");
                String string = this.getStringField("Name", values);
                if (string == null) {
                    return;
                }
                String nameField = string;
                if (StringsKt.startsWith$default((String)nameField, (String)ProfilerDataBuilder.WIN_ASYNC_MARKER, (boolean)false, (int)2, null)) {
                    ProfilerDataBuilder.this.isWinAsyncDump = true;
                }
            }
        }
    }
}

