/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mongo.translator.tree_creator.builder;

import com.intellij.database.dialects.mongo.translator.MongoColumnReference;
import com.intellij.database.dialects.mongo.translator.MongoToDatabaseScriptTranslator;
import com.intellij.database.dialects.mongo.translator.tree.expression.hard.IMongoHardExpr;
import com.intellij.database.dialects.mongo.translator.tree.expression.hard.MongoHardBetweenExpr;
import com.intellij.database.dialects.mongo.translator.tree.expression.literal.IMongoLiteralExpr;
import com.intellij.database.dialects.mongo.translator.tree.expression.simple.MongoSimpleBetweenExpr;
import com.intellij.database.dialects.mongo.translator.tree_creator.builder.IMongoBetweenBuilder;
import com.intellij.psi.PsiElement;
import com.intellij.sql.psi.SqlBetweenExpression;
import com.intellij.sql.psi.SqlElement;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/dialects/mongo/translator/tree_creator/builder/MongoBetweenBuilder;", "Lcom/intellij/database/dialects/mongo/translator/tree_creator/builder/IMongoBetweenBuilder;", "o", "Lcom/intellij/sql/psi/SqlBetweenExpression;", "root", "Lcom/intellij/sql/psi/SqlElement;", "<init>", "(Lcom/intellij/sql/psi/SqlBetweenExpression;Lcom/intellij/sql/psi/SqlElement;)V", "getO", "()Lcom/intellij/sql/psi/SqlBetweenExpression;", "getRoot", "()Lcom/intellij/sql/psi/SqlElement;", "subjectExpr", "Lcom/intellij/database/dialects/mongo/translator/tree/expression/hard/IMongoHardExpr;", "leftRangeExpr", "rightRangeExpr", "build", "Lcom/intellij/database/dialects/mongo/translator/tree/expression/hard/MongoHardBetweenExpr;", "expr", "v", "intellij.database.dialects.mongo"})
public final class MongoBetweenBuilder
implements IMongoBetweenBuilder {
    @NotNull
    private final SqlBetweenExpression o;
    @NotNull
    private final SqlElement root;
    @Nullable
    private IMongoHardExpr subjectExpr;
    @Nullable
    private IMongoHardExpr leftRangeExpr;
    @Nullable
    private IMongoHardExpr rightRangeExpr;

    public MongoBetweenBuilder(@NotNull SqlBetweenExpression o, @NotNull SqlElement root) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.o = o;
        this.root = root;
    }

    @NotNull
    public final SqlBetweenExpression getO() {
        return this.o;
    }

    @NotNull
    public final SqlElement getRoot() {
        return this.root;
    }

    @Override
    @NotNull
    public MongoHardBetweenExpr build() {
        IMongoHardExpr iMongoHardExpr = this.subjectExpr;
        if (iMongoHardExpr == null) {
            throw MongoToDatabaseScriptTranslator.Companion.createTranslationPSIStructureException((PsiElement)this.o, (PsiElement)this.root);
        }
        IMongoHardExpr subjectExpr = iMongoHardExpr;
        IMongoHardExpr iMongoHardExpr2 = this.leftRangeExpr;
        if (iMongoHardExpr2 == null) {
            throw MongoToDatabaseScriptTranslator.Companion.createTranslationPSIStructureException((PsiElement)this.o, (PsiElement)this.root);
        }
        IMongoHardExpr leftRangeExpr = iMongoHardExpr2;
        IMongoHardExpr iMongoHardExpr3 = this.rightRangeExpr;
        if (iMongoHardExpr3 == null) {
            throw MongoToDatabaseScriptTranslator.Companion.createTranslationPSIStructureException((PsiElement)this.o, (PsiElement)this.root);
        }
        IMongoHardExpr rightRangeExpr = iMongoHardExpr3;
        String string = this.o.getOperation().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = string;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string3 = string2.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
        String operator = string3;
        if (!Intrinsics.areEqual((Object)operator, (Object)"NOT BETWEEN") && !Intrinsics.areEqual((Object)operator, (Object)"BETWEEN")) {
            throw MongoToDatabaseScriptTranslator.Companion.createTranslationPSIStructureException((PsiElement)this.o, (PsiElement)this.root);
        }
        boolean isNot = Intrinsics.areEqual((Object)operator, (Object)"NOT BETWEEN");
        if (subjectExpr instanceof MongoColumnReference && leftRangeExpr instanceof IMongoLiteralExpr && rightRangeExpr instanceof IMongoLiteralExpr) {
            MongoColumnReference mongoColumnReference = (MongoColumnReference)subjectExpr;
            IMongoLiteralExpr iMongoLiteralExpr = (IMongoLiteralExpr)leftRangeExpr;
            IMongoLiteralExpr iMongoLiteralExpr2 = (IMongoLiteralExpr)rightRangeExpr;
            String string4 = this.o.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getText(...)");
            return new MongoSimpleBetweenExpr(mongoColumnReference, isNot, iMongoLiteralExpr, iMongoLiteralExpr2, string4);
        }
        String string5 = this.o.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getText(...)");
        return new MongoHardBetweenExpr(subjectExpr, isNot, leftRangeExpr, rightRangeExpr, string5);
    }

    @Override
    @NotNull
    public MongoBetweenBuilder expr(@NotNull IMongoHardExpr v) {
        MongoBetweenBuilder mongoBetweenBuilder;
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        MongoBetweenBuilder $this$expr_u24lambda_u240 = mongoBetweenBuilder = this;
        boolean bl = false;
        if ($this$expr_u24lambda_u240.subjectExpr == null) {
            $this$expr_u24lambda_u240.subjectExpr = v;
        } else if ($this$expr_u24lambda_u240.leftRangeExpr == null) {
            $this$expr_u24lambda_u240.leftRangeExpr = v;
        } else if ($this$expr_u24lambda_u240.rightRangeExpr == null) {
            $this$expr_u24lambda_u240.rightRangeExpr = v;
        } else {
            throw MongoToDatabaseScriptTranslator.Companion.createTranslationPSIStructureException((PsiElement)$this$expr_u24lambda_u240.o, (PsiElement)$this$expr_u24lambda_u240.root);
        }
        return mongoBetweenBuilder;
    }
}

