/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.push;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.push.ui.VcsPushDialog;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.VcsRepositoryManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class VcsPushAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            VcsPushAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            VcsPushAction.$$$reportNull$$$0(1);
        }
        if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        VcsRepositoryManager manager = VcsRepositoryManager.getInstance(project);
        List repositories = e.getData(CommonDataKeys.EDITOR) != null ? ContainerUtil.emptyList() : VcsPushAction.collectRepositories(manager, (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY));
        Repository selectedRepo = DvcsUtil.guessRepositoryForOperation(project, e.getDataContext());
        new VcsPushDialog(project, DvcsUtil.sortRepositories(repositories), selectedRepo).show();
    }

    @NotNull
    private static Collection<Repository> collectRepositories(@NotNull VcsRepositoryManager vcsRepositoryManager, VirtualFile @Nullable [] files) {
        if (vcsRepositoryManager == null) {
            VcsPushAction.$$$reportNull$$$0(2);
        }
        if (files == null) {
            List<Repository> list = Collections.emptyList();
            if (list == null) {
                VcsPushAction.$$$reportNull$$$0(3);
            }
            return list;
        }
        HashSet<Repository> repositories = new HashSet<Repository>();
        for (VirtualFile file : files) {
            Repository repo = vcsRepositoryManager.getRepositoryForFileQuick(file);
            if (repo == null) continue;
            repositories.add(repo);
        }
        HashSet<Repository> hashSet = repositories;
        if (hashSet == null) {
            VcsPushAction.$$$reportNull$$$0(4);
        }
        return hashSet;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            VcsPushAction.$$$reportNull$$$0(5);
        }
        Project project = e.getProject();
        e.getPresentation().setEnabledAndVisible(project != null && !VcsRepositoryManager.getInstance(project).getRepositories().isEmpty());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dvcs/push/VcsPushAction";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsRepositoryManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dvcs/push/VcsPushAction";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "collectRepositories";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectRepositories";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 5 -> new IllegalArgumentException(string);
        };
    }
}

