/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.code.provenance.core.events.storage.mvstore;

import com.intellij.code.provenance.core.events.storage.mvstore.ProvenanceKeyUtilKt;
import kotlin.Metadata;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u000e\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fJ\u001e\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000fJ\u0016\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000fJ\u0016\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000fJ9\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00052\b\u0010\u0018\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0013\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u000fH\u0002J\u0010\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/code/provenance/core/events/storage/mvstore/ProvenanceKeyUtil;", "", "<init>", "()V", "KEY_SEPARATOR", "", "TIMESTAMP_PAD_LENGTH", "", "ENTRY_ID_PAD_LENGTH", "NS_FILE", "NS_TS_ASC", "NS_TS_DESC", "NS_LOOKUP", "prefixFile", "fileHash", "", "prefixLookup", "keyForFile", "timestamp", "entryId", "keyForTimestampAsc", "keyForTimestampDesc", "keyForFileTypeHash", "type", "oldHash", "newHash", "(JLjava/lang/String;Ljava/lang/Long;Ljava/lang/Long;J)Ljava/lang/String;", "padTimestamp", "padEntryId", "intellij.code.provenance.core"})
public final class ProvenanceKeyUtil {
    @NotNull
    public static final ProvenanceKeyUtil INSTANCE = new ProvenanceKeyUtil();
    @NotNull
    public static final String KEY_SEPARATOR = ":";
    private static final int TIMESTAMP_PAD_LENGTH = 19;
    private static final int ENTRY_ID_PAD_LENGTH = 20;
    @NotNull
    private static final String NS_FILE = "file";
    @NotNull
    public static final String NS_TS_ASC = "ts";
    @NotNull
    public static final String NS_TS_DESC = "tsd";
    @NotNull
    private static final String NS_LOOKUP = "lk";

    private ProvenanceKeyUtil() {
    }

    @NotNull
    public final String prefixFile(long fileHash) {
        return "file:" + fileHash + KEY_SEPARATOR;
    }

    @NotNull
    public final String prefixLookup(long fileHash) {
        return "lk:" + fileHash + KEY_SEPARATOR;
    }

    @NotNull
    public final String keyForFile(long fileHash, long timestamp, long entryId) {
        return "file:" + fileHash + KEY_SEPARATOR + this.padTimestamp(timestamp) + KEY_SEPARATOR + this.padEntryId(entryId);
    }

    @NotNull
    public final String keyForTimestampAsc(long timestamp, long entryId) {
        return "ts:" + this.padTimestamp(timestamp) + KEY_SEPARATOR + this.padEntryId(entryId);
    }

    @NotNull
    public final String keyForTimestampDesc(long timestamp, long entryId) {
        long invertedTimestamp = Long.MAX_VALUE - timestamp;
        long invertedEntryId = Long.MAX_VALUE - entryId;
        return "tsd:" + this.padTimestamp(invertedTimestamp) + KEY_SEPARATOR + this.padEntryId(invertedEntryId);
    }

    @NotNull
    public final String keyForFileTypeHash(long fileHash, @Nullable String type, @Nullable Long oldHash, @Nullable Long newHash, long entryId) {
        String string = type;
        if (string == null) {
            string = "";
        }
        return "lk:" + fileHash + KEY_SEPARATOR + string + KEY_SEPARATOR + ProvenanceKeyUtilKt.hashToString(oldHash) + KEY_SEPARATOR + ProvenanceKeyUtilKt.hashToString(newHash) + KEY_SEPARATOR + this.padEntryId(entryId);
    }

    private final String padTimestamp(long timestamp) {
        return StringsKt.padStart((String)String.valueOf(timestamp), (int)19, (char)'0');
    }

    private final String padEntryId(long entryId) {
        return StringsKt.padStart((String)String.valueOf(entryId), (int)20, (char)'0');
    }
}

