/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.re.reference;

import com.intellij.jpa.jpb.model.backend.ed.EntityWriter;
import com.intellij.jpa.jpb.model.model.Entity;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.jpa.jpb.model.model.EntityAttributeModel;
import com.intellij.jpa.jpb.model.model.EntityPsi;
import com.intellij.jpa.jpb.model.reference.TemplateHelper;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.re.reference.CommentHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0004J\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\tH\u0004\u00a8\u0006\u000e"}, d2={"Lcom/intellij/re/reference/EntityAttrCommentHandler;", "Lcom/intellij/re/reference/CommentHandler;", "<init>", "()V", "getCommentedField", "Lcom/intellij/psi/PsiMember;", "entityClass", "Lcom/intellij/psi/PsiClass;", "psiComment", "Lcom/intellij/psi/PsiComment;", "addEntityAttributeAndDeleteComment", "", "modelAttr", "Lcom/intellij/jpa/jpb/model/model/EntityAttributeModel;", "intellij.javaee.reverseEngineering"})
public abstract class EntityAttrCommentHandler
extends CommentHandler {
    @NotNull
    protected final PsiMember getCommentedField(@NotNull PsiClass entityClass, @NotNull PsiComment psiComment) {
        Intrinsics.checkNotNullParameter((Object)entityClass, (String)"entityClass");
        Intrinsics.checkNotNullParameter((Object)psiComment, (String)"psiComment");
        String commentText = psiComment.getText();
        String[] stringArray = StringUtil.splitByLines((String)commentText, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"splitByLines(...)");
        String[] lines = stringArray;
        StringBuilder fieldSource = new StringBuilder();
        boolean foundActionsLine = false;
        for (String line : lines) {
            if (foundActionsLine) {
                Intrinsics.checkNotNull((Object)line);
                fieldSource.append(StringsKt.substringBefore$default((String)line, (String)"*/", null, (int)2, null)).append("\n");
                continue;
            }
            Intrinsics.checkNotNull((Object)line);
            if (!StringsKt.startsWith((String)((Object)StringsKt.trim((CharSequence)line)).toString(), (String)"Available actions:", (boolean)true)) continue;
            foundActionsLine = true;
        }
        TemplateHelper templateHelper = (TemplateHelper)TemplateHelper.Companion.getInstance((PsiElement)entityClass);
        if (templateHelper == null) {
            throw new IllegalStateException("Unsupported entity class language: " + entityClass.getLanguage());
        }
        TemplateHelper templateHelper2 = templateHelper;
        String string = fieldSource.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return templateHelper2.createFieldFromText(string, (PsiElement)entityClass);
    }

    protected final void addEntityAttributeAndDeleteComment(@NotNull PsiClass entityClass, @Nullable EntityAttributeModel modelAttr, @NotNull PsiComment psiComment) {
        Intrinsics.checkNotNullParameter((Object)entityClass, (String)"entityClass");
        Intrinsics.checkNotNullParameter((Object)psiComment, (String)"psiComment");
        Project project = entityClass.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        EntityPsi entityPsi = EntityPsi.getInstance((PsiClass)entityClass);
        Intrinsics.checkNotNullExpressionValue((Object)entityPsi, (String)"getInstance(...)");
        EntityPsi entity = entityPsi;
        WriteCommandAction.runWriteCommandAction((Project)project2, () -> EntityAttrCommentHandler.addEntityAttributeAndDeleteComment$lambda$0(entityClass, entity, modelAttr, psiComment));
    }

    private static final void addEntityAttributeAndDeleteComment$lambda$0(PsiClass $entityClass, EntityPsi $entity, EntityAttributeModel $modelAttr, PsiComment $psiComment) {
        EntityWriter.getInstance((PsiElement)((PsiElement)$entityClass)).addAttribute((Entity)$entity.getModel(), $entityClass, (EntityAttribute)$modelAttr, -1);
        $psiComment.delete();
    }
}

