/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.engine;

import com.intellij.database.DataBus;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.jpa.engine.JakartaConnectionManager;
import com.intellij.jpa.engine.JpaEngine;
import com.intellij.jpa.jakarta.remote.JakartaFacade;
import com.intellij.jpa.remote.RemoteEntityManagerFactory;
import com.intellij.openapi.module.Module;
import com.intellij.persistence.model.PersistencePackagePointer;

public class JakartaEngine
extends JpaEngine {
    private JakartaFacade myFacade;

    public static boolean isAvailable(Module module) {
        return JavaLibraryUtil.hasLibraryClass((Module)module, (String)"jakarta.persistence.EntityManager");
    }

    public JakartaEngine(DataBus.Producing messageBus, PersistencePackagePointer unitFile, ConsoleRunConfiguration configuration) {
        super(messageBus, unitFile, configuration);
    }

    @Override
    protected void createConnection() throws Exception {
        LocalDataSource dataSource = JakartaEngine.findDataSource(this.getProject(), this.myUnitFile);
        this.setRunConfigurationOptionsForDataSource(dataSource);
        this.myFacade = JakartaConnectionManager.getInstance(this.getProject()).getConnection(this.myUnitFile, this.myConfiguration);
        this.createTemporaryConfig(this.myFacade.getPersistenceRoot(), dataSource);
        RemoteEntityManagerFactory entityManagerFactory = this.myFacade.createEntityManagerFactory(this.myUnitFile.getElementName());
        this.myEntityManager = entityManagerFactory.createEntityManager();
    }

    @Override
    protected void releaseConnection() {
        this.myFacade = null;
        JakartaConnectionManager.getInstance(this.getProject()).releaseConnection(this.myUnitFile, this.myConfiguration);
        this.removeTemporaryFiles();
    }
}

