/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.qute.lang.highlighting;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.quarkus.qute.lang.highlighting.QuteHighlighterColorsKt;
import com.intellij.quarkus.qute.lang.psi.QuteLexer;
import com.intellij.quarkus.qute.lang.psi.tree.QuteElementTypes;
import com.intellij.quarkus.qute.lang.psi.tree.QuteElementTypesGenerated;
import com.intellij.quarkus.qute.lang.psi.tree.QuteTokenSetsKt;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000b\u001a\u00020\fH\u0016J\u001b\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000e\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\bH\u0002J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\bH\u0002J\u001b\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0013\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010\u0018R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u0019"}, d2={"Lcom/intellij/quarkus/qute/lang/highlighting/QuteSyntaxHighlighter;", "Lcom/intellij/openapi/fileTypes/SyntaxHighlighterBase;", "<init>", "()V", "ATTRIBUTES", "", "Lcom/intellij/psi/tree/IElementType;", "", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "BACKGROUND_ONLY", "[Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "getHighlightingLexer", "Lcom/intellij/lexer/Lexer;", "getTokenHighlights", "tokenType", "(Lcom/intellij/psi/tree/IElementType;)[Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "addTokenType", "", "type", "key", "addTokenSet", "tokenSet", "Lcom/intellij/psi/tree/TokenSet;", "withBackground", "(Lcom/intellij/openapi/editor/colors/TextAttributesKey;)[Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "intellij.quarkus"})
public final class QuteSyntaxHighlighter
extends SyntaxHighlighterBase {
    @NotNull
    private final Map<IElementType, TextAttributesKey[]> ATTRIBUTES = new HashMap();
    @NotNull
    private final TextAttributesKey[] BACKGROUND_ONLY;

    public QuteSyntaxHighlighter() {
        TextAttributesKey[] textAttributesKeyArray = new TextAttributesKey[]{QuteHighlighterColorsKt.getBACKGROUND()};
        this.BACKGROUND_ONLY = textAttributesKeyArray;
        this.addTokenSet(QuteTokenSetsKt.getSECTION_TAG_NAMES(), QuteHighlighterColorsKt.getTAG_NAME());
        this.addTokenSet(QuteTokenSetsKt.getBOOLEAN_TOKENS(), QuteHighlighterColorsKt.getBOOLEAN());
        this.addTokenSet(QuteTokenSetsKt.getBOOLEAN_OPERATORS(), QuteHighlighterColorsKt.getOPERATOR_SIGN());
        this.addTokenSet(QuteTokenSetsKt.getCOMPARISON_OPERATORS(), QuteHighlighterColorsKt.getOPERATOR_SIGN());
        this.addTokenSet(QuteTokenSetsKt.getSTRING_PART_TOKENS(), QuteHighlighterColorsKt.getSTRING());
        this.addTokenSet(QuteTokenSetsKt.getLITERALS(), QuteHighlighterColorsKt.getSTRING());
        this.addTokenSet(QuteTokenSetsKt.getEXPRESSION_BRACES(), QuteHighlighterColorsKt.getTAG_BRACE());
        this.addTokenSet(QuteTokenSetsKt.getNUMBER_TOKENS(), QuteHighlighterColorsKt.getNUMBER());
        this.addTokenSet(QuteTokenSetsKt.getSECONDARY_KEYWORDS(), QuteHighlighterColorsKt.getSECONDARY_KEYWORD());
        this.addTokenSet(QuteTokenSetsKt.getBRACKET_TOKENS(), QuteHighlighterColorsKt.getBRACKETS());
        this.addTokenSet(QuteTokenSetsKt.getPARENTHESIS_TOKENS(), QuteHighlighterColorsKt.getPARENTHESES());
        IElementType iElementType = QuteElementTypesGenerated.DOT;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"DOT");
        this.addTokenType(iElementType, QuteHighlighterColorsKt.getDOT());
        IElementType iElementType2 = QuteElementTypesGenerated.COMMA;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"COMMA");
        this.addTokenType(iElementType2, QuteHighlighterColorsKt.getCOMMA());
        IElementType iElementType3 = QuteElementTypes.QUTE_COMMENT;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType3, (String)"QUTE_COMMENT");
        this.addTokenType(iElementType3, QuteHighlighterColorsKt.getCOMMENT());
        IElementType iElementType4 = QuteElementTypesGenerated.IDENTIFIER;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType4, (String)"IDENTIFIER");
        this.addTokenType(iElementType4, QuteHighlighterColorsKt.getIDENTIFIER());
        IElementType iElementType5 = QuteElementTypesGenerated.ASSIGN;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType5, (String)"ASSIGN");
        this.addTokenType(iElementType5, QuteHighlighterColorsKt.getOPERATOR_SIGN());
    }

    @NotNull
    public Lexer getHighlightingLexer() {
        return (Lexer)new QuteLexer();
    }

    @NotNull
    public TextAttributesKey[] getTokenHighlights(@NotNull IElementType tokenType) {
        Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
        return this.ATTRIBUTES.getOrDefault(tokenType, this.BACKGROUND_ONLY);
    }

    private final void addTokenType(IElementType type, TextAttributesKey key) {
        this.ATTRIBUTES.put(type, this.withBackground(key));
    }

    private final void addTokenSet(TokenSet tokenSet, TextAttributesKey key) {
        IElementType[] iElementTypeArray = tokenSet.getTypes();
        Intrinsics.checkNotNullExpressionValue((Object)iElementTypeArray, (String)"getTypes(...)");
        for (IElementType type : iElementTypeArray) {
            this.ATTRIBUTES.put(type, this.withBackground(key));
        }
    }

    private final TextAttributesKey[] withBackground(TextAttributesKey key) {
        TextAttributesKey[] textAttributesKeyArray = new TextAttributesKey[]{QuteHighlighterColorsKt.getBACKGROUND(), key};
        return textAttributesKeyArray;
    }
}

