/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.tasks.provider.schema.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.PathType;
import com.networknt.schema.SchemaValidatorsConfig;
import com.networknt.schema.SpecVersion;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J:\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0014\b\u0002\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012J.\u0010\u0015\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012H\u0002J\u0018\u0010\u0016\u001a\u00020\u0010*\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000e0\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\u0017"}, d2={"Lai/grazie/tasks/provider/schema/json/JsonSchemaValidator;", "", "<init>", "()V", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "config", "Lcom/networknt/schema/SchemaValidatorsConfig;", "kotlin.jvm.PlatformType", "Lcom/networknt/schema/SchemaValidatorsConfig;", "verify", "", "parameters", "", "Lkotlinx/serialization/json/JsonElement;", "taskSchema", "Lcom/fasterxml/jackson/databind/JsonNode;", "customizer", "Lkotlin/Function1;", "Lcom/networknt/schema/JsonSchemaFactory$Builder;", "", "doVerify", "toJson", "tasks-provider-task-schema"})
@SourceDebugExtension(value={"SMAP\nJsonSchemaValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonSchemaValidator.kt\nai/grazie/tasks/provider/schema/json/JsonSchemaValidator\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n*L\n1#1,50:1\n216#2:51\n217#2:53\n113#3:52\n*S KotlinDebug\n*F\n+ 1 JsonSchemaValidator.kt\nai/grazie/tasks/provider/schema/json/JsonSchemaValidator\n*L\n44#1:51\n44#1:53\n45#1:52\n*E\n"})
public final class JsonSchemaValidator {
    @NotNull
    public static final JsonSchemaValidator INSTANCE = new JsonSchemaValidator();
    @NotNull
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final SchemaValidatorsConfig config = SchemaValidatorsConfig.builder().failFast(true).pathType(PathType.LEGACY).build();

    private JsonSchemaValidator() {
    }

    @Nullable
    public final String verify(@NotNull Map<String, ? extends JsonElement> parameters, @NotNull JsonNode taskSchema, @NotNull Function1<? super JsonSchemaFactory.Builder, Unit> customizer) {
        JsonNode jsonNode;
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)taskSchema, (String)"taskSchema");
        Intrinsics.checkNotNullParameter(customizer, (String)"customizer");
        try {
            jsonNode = this.toJson(parameters);
        }
        catch (Exception e) {
            return ": Malformed task parameters";
        }
        JsonNode jsonParameters = jsonNode;
        return this.doVerify(jsonParameters, taskSchema, customizer);
    }

    public static /* synthetic */ String verify$default(JsonSchemaValidator jsonSchemaValidator, Map map2, JsonNode jsonNode, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = JsonSchemaValidator::verify$lambda$0;
        }
        return jsonSchemaValidator.verify(map2, jsonNode, (Function1<? super JsonSchemaFactory.Builder, Unit>)function1);
    }

    private final String doVerify(JsonNode parameters, JsonNode taskSchema, Function1<? super JsonSchemaFactory.Builder, Unit> customizer) {
        JsonSchemaFactory jsonSchemaFactory = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V202012, arg_0 -> JsonSchemaValidator.doVerify$lambda$1(customizer, arg_0));
        JsonSchema jsonSchema = jsonSchemaFactory.getSchema(taskSchema, config);
        Set validationMessages = jsonSchema.validate(parameters);
        Intrinsics.checkNotNull((Object)validationMessages);
        String errorMessage = CollectionsKt.joinToString$default((Iterable)validationMessages, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        if (((CharSequence)errorMessage).length() > 0) {
            return StringsKt.removePrefix((String)errorMessage, (CharSequence)"$");
        }
        return null;
    }

    private final JsonNode toJson(Map<String, ? extends JsonElement> $this$toJson) {
        ObjectNode result2 = mapper.createObjectNode();
        Map<String, ? extends JsonElement> $this$forEach$iv = $this$toJson;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, ? extends JsonElement>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ? extends JsonElement> element$iv;
            Map.Entry<String, ? extends JsonElement> entry2 = element$iv = iterator.next();
            boolean bl = false;
            String key = entry2.getKey();
            JsonElement value = entry2.getValue();
            StringFormat $this$encodeToString$iv = (StringFormat)Json.Default;
            boolean $i$f$encodeToString = false;
            $this$encodeToString$iv.getSerializersModule();
            result2.replace(key, mapper.readTree($this$encodeToString$iv.encodeToString((SerializationStrategy)JsonElement.Companion.serializer(), (Object)value)));
        }
        Intrinsics.checkNotNull((Object)result2);
        return (JsonNode)result2;
    }

    private static final Unit verify$lambda$0(JsonSchemaFactory.Builder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final void doVerify$lambda$1(Function1 $tmp0, JsonSchemaFactory.Builder p0) {
        $tmp0.invoke((Object)p0);
    }
}

